/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing;

import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TipListCellRenderer
extends DefaultListCellRenderer {
    private JComboBox combo;
    private int lastIndex;
    private Popup popup;
    private JLabel tip;
    private FontMetrics fm;
    private boolean shouldPaint;

    public TipListCellRenderer(JComboBox combo) {
        this.combo = combo;
        this.tip = new JLabel();
        this.tip.setBackground(Color.decode("#f5f5b5"));
        this.tip.setOpaque(true);
        this.tip.setBorder((Border)new DashedBorder().dashInterval("1.2, 1.2").lineColor("#baba45").lineThickness(1.0f));
        this.lastIndex = -1;
        PopupMenuListener pml = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                TipListCellRenderer.this.hideToolTip();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                TipListCellRenderer.this.hideToolTip();
                TipListCellRenderer.this.combo.setSelectedIndex(TipListCellRenderer.this.lastIndex);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                TipListCellRenderer.this.hideToolTip();
            }
        };
        combo.addPopupMenuListener(pml);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.shouldPaint = true;
        if (isSelected && value != null && index != this.lastIndex) {
            int width;
            this.hideToolTip();
            if (this.fm == null) {
                this.fm = this.getFontMetrics(this.getFont());
            }
            if ((width = this.fm.stringWidth(value.toString())) > list.getVisibleRect().width) {
                this.tip.setText(value.toString());
                Rectangle rect = list.getCellBounds(index, index);
                Point pt = list.getLocationOnScreen();
                this.popup = PopupFactory.getSharedInstance().getPopup(list, this.tip, pt.x + rect.x, pt.y + rect.y);
                this.popup.show();
                this.shouldPaint = false;
            }
            this.lastIndex = index;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    @Override
    public void paint(Graphics g) {
        if (this.shouldPaint) {
            super.paint(g);
        }
    }

    private void hideToolTip() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }
}

