/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

public class ToggleButtonAssociation {
    private List<JComponent> enableList;
    private List<JComponent> disableList;
    private List<JComponent> visibleList;
    private List<JComponent> hiddenList;
    private List<AbstractButton> selectedList;
    private List<AbstractButton> deselectedList;
    private List<JComponent> resetList = new ArrayList<JComponent>();
    private AbstractButton togBut;
    private ActionListener butHandler;
    private boolean bothStatesFlag = false;

    public ToggleButtonAssociation() {
        this.enableList = new ArrayList<JComponent>();
        this.disableList = new ArrayList<JComponent>();
        this.visibleList = new ArrayList<JComponent>();
        this.hiddenList = new ArrayList<JComponent>();
        this.selectedList = new ArrayList<AbstractButton>();
        this.deselectedList = new ArrayList<AbstractButton>();
        this.butHandler = new ButtonHandler();
    }

    public ToggleButtonAssociation(AbstractButton button) {
        this();
        this.forButton(button);
    }

    public ToggleButtonAssociation(JToggleButton button, boolean bothStates) {
        this();
        this.forButton(button, bothStates);
    }

    public ToggleButtonAssociation enable(JComponent ... comp) {
        this.enableList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation disable(JComponent ... comp) {
        this.disableList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation show(JComponent ... comp) {
        this.visibleList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation hide(JComponent ... comp) {
        this.hiddenList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation reset(JComponent ... comp) {
        this.resetList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation select(AbstractButton ... comp) {
        this.selectedList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation deselect(AbstractButton ... comp) {
        this.deselectedList.addAll(Arrays.asList(comp));
        return this;
    }

    public ToggleButtonAssociation forButton(AbstractButton button) {
        return this.forButton(button, false);
    }

    public ToggleButtonAssociation forButton(AbstractButton button, boolean bothStates) {
        if (this.togBut != null) {
            this.togBut.removeActionListener(this.butHandler);
        }
        this.togBut = button;
        this.bothStatesFlag = bothStates;
        this.togBut.addActionListener(this.butHandler);
        return this;
    }

    class ButtonHandler
    implements ActionListener {
        ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            block17: {
                block16: {
                    if (!ToggleButtonAssociation.this.togBut.isSelected()) break block16;
                    for (JComponent comp : ToggleButtonAssociation.this.enableList) {
                        comp.setEnabled(true);
                    }
                    for (JComponent comp : ToggleButtonAssociation.this.disableList) {
                        comp.setEnabled(false);
                    }
                    for (JComponent comp : ToggleButtonAssociation.this.resetList) {
                        JComboBox combo;
                        if (!ToggleButtonAssociation.this.disableList.contains(comp)) continue;
                        if (comp instanceof JTextComponent) {
                            JTextComponent tComp = (JTextComponent)comp;
                            tComp.setText("");
                        }
                        if (!(comp instanceof JComboBox) || (combo = (JComboBox)comp).getModel().getSize() <= 0) continue;
                        combo.setSelectedIndex(0);
                    }
                    for (JComponent comp : ToggleButtonAssociation.this.visibleList) {
                        comp.setVisible(true);
                    }
                    for (JComponent comp : ToggleButtonAssociation.this.hiddenList) {
                        comp.setVisible(false);
                    }
                    for (AbstractButton button : ToggleButtonAssociation.this.selectedList) {
                        button.setSelected(true);
                    }
                    for (AbstractButton button : ToggleButtonAssociation.this.deselectedList) {
                        button.setSelected(false);
                    }
                    break block17;
                }
                if (!ToggleButtonAssociation.this.bothStatesFlag) break block17;
                for (JComponent comp : ToggleButtonAssociation.this.enableList) {
                    comp.setEnabled(false);
                }
                for (JComponent comp : ToggleButtonAssociation.this.disableList) {
                    comp.setEnabled(true);
                }
                for (JComponent comp : ToggleButtonAssociation.this.resetList) {
                    JComboBox combo;
                    if (!ToggleButtonAssociation.this.enableList.contains(comp)) continue;
                    if (comp instanceof JTextComponent) {
                        JTextComponent tComp = (JTextComponent)comp;
                        tComp.setText("");
                    }
                    if (!(comp instanceof JComboBox) || (combo = (JComboBox)comp).getModel().getSize() <= 0) continue;
                    combo.setSelectedIndex(0);
                }
                for (JComponent comp : ToggleButtonAssociation.this.visibleList) {
                    comp.setVisible(false);
                }
                for (JComponent comp : ToggleButtonAssociation.this.hiddenList) {
                    comp.setVisible(true);
                }
                for (AbstractButton button : ToggleButtonAssociation.this.selectedList) {
                    button.setSelected(false);
                }
                for (AbstractButton button : ToggleButtonAssociation.this.deselectedList) {
                    button.setSelected(true);
                }
            }
        }
    }
}

