/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.combo;

import in.gov.uidai.ec.swing.combo.IOptionHandler;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class OptionsListModel
extends AbstractListModel {
    private List<Object> listData = new ArrayList<Object>();
    private IOptionHandler optHandler;

    OptionsListModel() {
    }

    public void setItems(List<Object> items) {
        int chngSize = this.listData.size();
        this.listData.clear();
        if (items != null) {
            this.listData.addAll(items);
        }
        this.fireContentsChanged(this, 0, Math.max(chngSize, this.listData.size()));
    }

    public void setOptionHandler(IOptionHandler handler) {
        this.optHandler = handler;
    }

    public int getOptionIndex(String text) {
        if (this.optHandler == null) {
            return -1;
        }
        for (int i = 0; i < this.listData.size(); ++i) {
            if (!this.optHandler.matches(text, this.listData.get(i))) continue;
            return i;
        }
        return -1;
    }

    List<Object> getOptions() {
        return this.listData;
    }

    @Override
    public Object getElementAt(int pos) {
        if (pos < 0 || pos >= this.listData.size()) {
            return null;
        }
        return this.listData.get(pos);
    }

    @Override
    public int getSize() {
        return this.listData.size();
    }
}

