/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.combo;

import in.gov.uidai.ec.swing.combo.IOptionHandler;
import in.gov.uidai.ec.swing.combo.OptionsListModel;
import in.gov.uidai.ec.ui.shared.IValueChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;

public class UidComboField
extends JTextField {
    private JPopupMenu optionsPopup;
    private JList<OptionsListModel> optionsList;
    private OptionsListModel optionsListModel;
    private IOptionHandler optHandler;
    private DocumentListener docListener;
    private int minTextLengthForPopup;
    private Object selectedOption;
    private Timer autoPopupTimer;
    private List<IValueChangeListener> valueChangeListeners = new ArrayList<IValueChangeListener>();

    public UidComboField() {
        this.optionsListModel = new OptionsListModel();
        this.optionsList = new JList(this.optionsListModel);
        this.optionsList.getSelectionModel().setSelectionMode(1);
        this.optionsPopup = new JPopupMenu();
        this.optionsPopup.setLayout(new BorderLayout(0, 0));
        this.optionsPopup.add((Component)new JScrollPane(this.optionsList), "Center");
        this.getActionMap().put("DownArrow", new DownArrowAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "DownArrow");
        MouseAdapter mouseClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UidComboField.this.validateList();
                if (!UidComboField.this.getText().isEmpty() && UidComboField.this.optionsList.getModel().getSize() > 0) {
                    UidComboField.this.optionsPopup.show(UidComboField.this, 0, UidComboField.this.getHeight());
                }
            }
        };
        this.addMouseListener(mouseClick);
        this.optionsList.getActionMap().put("ListEnter", new ListEnterAction());
        this.optionsList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "ListEnter");
        this.optionsList.getActionMap().put("ListTab", new ListTabAction());
        this.optionsList.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "ListTab");
        this.optionsList.setFocusTraversalKeysEnabled(false);
        this.optionsList.addMouseListener(new ListMouseHandler());
        this.optionsList.addKeyListener(new ListKeyHandler());
        this.optionsList.setFocusCycleRoot(true);
        this.docListener = new TextFieldTextHandler();
        this.getDocument().addDocumentListener(this.docListener);
        this.addKeyListener(new TextKeyHandler());
        this.validateList();
    }

    public void setOptionHandler(IOptionHandler handler) {
        this.optHandler = handler;
        this.optionsListModel.setOptionHandler(this.optHandler);
    }

    public void enableAutoPopup(int delay) {
        this.disableAutoPopup();
        AutoPopupHandler aph = new AutoPopupHandler();
        this.autoPopupTimer = new Timer(delay, aph);
        this.autoPopupTimer.setRepeats(false);
        this.addKeyListener(aph);
    }

    private void disableAutoPopup() {
        if (this.autoPopupTimer != null) {
            this.autoPopupTimer.stop();
            this.autoPopupTimer = null;
        }
    }

    @Override
    public void setDocument(Document doc) {
        Document oldDoc = this.getDocument();
        if (oldDoc != null) {
            oldDoc.removeDocumentListener(this.docListener);
        }
        super.setDocument(doc);
        doc.addDocumentListener(this.docListener);
    }

    public void setMinTextLengthForPopup(int length) {
        this.minTextLengthForPopup = length;
    }

    public void setOptions(List<Object> options) {
        this.optionsListModel.setItems(options);
        if (options == null || options.isEmpty()) {
            this.optionsList.setVisibleRowCount(1);
        } else {
            this.optionsList.setVisibleRowCount(Math.min(8, options.size()));
        }
        this.validateList();
    }

    public List<Object> getOptions() {
        return this.optionsListModel.getOptions();
    }

    public boolean hasOptions() {
        return this.optionsListModel.getSize() > 0;
    }

    public void setSelectedOption(Object option) {
        this.selectedOption = option;
    }

    public Object getSelectedOption() {
        return this.selectedOption;
    }

    public int getSelectedIndex() {
        return this.optionsList.getSelectedIndex();
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.optionsPopup.addPopupMenuListener(l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.optionsPopup.removePopupMenuListener(l);
    }

    public void addValueChangeListener(IValueChangeListener l) {
        this.valueChangeListeners.add(l);
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.optionsList.setCellRenderer(renderer);
    }

    private void populateWithListSelection() {
        OptionsListModel selOpt;
        if (this.optionsPopup.isVisible()) {
            this.optionsPopup.setVisible(false);
        }
        if ((selOpt = this.optionsList.getSelectedValue()) != null) {
            if (this.optHandler == null) {
                this.setText("");
            } else {
                this.setText(this.optHandler.toString(selOpt));
            }
            this.selectedOption = selOpt;
        }
    }

    private void updateListSelection() {
        if (!this.optionsPopup.isVisible()) {
            return;
        }
        int index = this.optionsListModel.getOptionIndex(this.getText());
        this.optionsList.setSelectedIndex(index);
        this.optionsList.ensureIndexIsVisible(index);
    }

    private void validateList() {
        Runnable runnable = () -> {
            this.optionsList.setSelectedIndex(0);
            this.optionsList.setSelectionInterval(0, 0);
            Dimension popDim = this.optionsList.getPreferredScrollableViewportSize();
            Insets insets = this.optionsPopup.getInsets(new Insets(0, 0, 0, 0));
            popDim.width += insets.left + insets.right;
            popDim.height += insets.top + insets.bottom;
            this.optionsPopup.setPopupSize(popDim);
            this.optionsPopup.validate();
            this.optionsList.validate();
            this.optionsList.grabFocus();
        };
        SwingUtilities.invokeLater(runnable);
    }

    public Object getElements() {
        ArrayList<OptionsListModel> options = new ArrayList<OptionsListModel>();
        int size = this.optionsList.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            options.add(this.optionsList.getModel().getElementAt(i));
        }
        return options;
    }

    class TextFieldTextHandler
    implements DocumentListener {
        TextFieldTextHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UidComboField.this.updateListSelection();
            UidComboField.this.valueChangeListeners.forEach(l -> l.changed(e));
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UidComboField.this.updateListSelection();
            UidComboField.this.selectedOption = null;
            UidComboField.this.valueChangeListeners.forEach(l -> l.changed(e));
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UidComboField.this.updateListSelection();
            UidComboField.this.selectedOption = null;
            UidComboField.this.valueChangeListeners.forEach(l -> l.changed(e));
        }
    }

    class ListKeyHandler
    extends KeyAdapter {
        ListKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            int code = evt.getKeyCode();
            if (code == 10) {
                UidComboField.this.populateWithListSelection();
            } else if (code == 8) {
                UidComboField.this.processKeyEvent(evt);
            }
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            UidComboField.this.processKeyEvent(evt);
        }
    }

    class TextKeyHandler
    extends KeyAdapter {
        TextKeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            UidComboField.this.selectedOption = null;
        }
    }

    class ListMouseHandler
    extends MouseAdapter {
        ListMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            UidComboField.this.populateWithListSelection();
        }
    }

    private class AutoPopupHandler
    extends KeyAdapter
    implements ActionListener {
        private AutoPopupHandler() {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (UidComboField.this.autoPopupTimer != null) {
                UidComboField.this.autoPopupTimer.restart();
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!UidComboField.this.hasFocus()) {
                UidComboField.this.optionsPopup.setVisible(false);
                return;
            }
            if (UidComboField.this.getText().length() < UidComboField.this.minTextLengthForPopup) {
                UidComboField.this.optionsPopup.setVisible(false);
                return;
            }
            if (UidComboField.this.optionsPopup.isVisible()) {
                return;
            }
            UidComboField.this.validateList();
            UidComboField.this.optionsPopup.show(UidComboField.this, 0, UidComboField.this.getHeight());
        }
    }

    class ListTabAction
    extends AbstractAction {
        ListTabAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            UidComboField.this.populateWithListSelection();
            UidComboField.this.transferFocus();
        }
    }

    class ListEnterAction
    extends AbstractAction {
        ListEnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            UidComboField.this.populateWithListSelection();
        }
    }

    class DownArrowAction
    extends AbstractAction {
        DownArrowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            UidComboField.this.validateList();
            UidComboField.this.optionsPopup.show(UidComboField.this, 0, UidComboField.this.getHeight());
        }
    }
}

