/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.date;

import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class DateTranslitField
extends DirectTranslitField {
    private SimpleDateFormat formatter;

    public void setDateFormat(String format) {
        this.formatter = new SimpleDateFormat(format, Locale.getDefault());
    }

    public void setDate(String dayStr, String monthStr, String yearStr) {
        if (this.formatter == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)dayStr) && StringUtils.isNotBlank((String)monthStr) && StringUtils.isNotBlank((String)yearStr)) {
            int dobDay = Integer.parseInt(dayStr);
            int dobMonth = Integer.parseInt(monthStr);
            int dobYear = Integer.parseInt(yearStr);
            if (dobDay <= 0 || dobMonth <= 0 || dobYear <= 0) {
                return;
            }
            GregorianCalendar cal = new GregorianCalendar(dobYear, --dobMonth, dobDay);
            this.setText(this.formatter.format(cal.getTime()));
        }
    }

    public void setDate(String ageStr) {
        if (this.formatter == null) {
            return;
        }
        if (StringUtils.isNotBlank((String)ageStr)) {
            int age = Integer.parseInt(ageStr);
            if (age <= 0) {
                return;
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(1, -age);
            this.setText(this.formatter.format(cal.getTime()));
        }
    }
}

