/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.documentimageview;

import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.service.document.BoundingBox;
import in.gov.uidai.ec.swing.documentimageview.DocumentAnnotationsListener;
import in.gov.uidai.ec.swing.documentimageview.PageWiseAnnotations;
import in.gov.uidai.ec.swing.documentimageview.RoiState;
import in.gov.uidai.ec.swing.imgvu.CanvasIndex;
import in.gov.uidai.ec.swing.imgvu.roi.CanvasInfo;
import in.gov.uidai.ec.swing.imgvu.roi.RectangularBoundingBox;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JToolTip;

public class AnnotationsInfo
extends CanvasInfo
implements RoiState {
    private final DocumentAnnotationsListener documentAnnotationsListener;
    private final PageWiseAnnotations pageWiseAnnotationsShapes;
    private JToolTip tooltip;

    public AnnotationsInfo(DocumentAnnotationsListener documentAnnotationsListener, CanvasIndex observer) {
        super(observer);
        this.documentAnnotationsListener = documentAnnotationsListener;
        this.documentAnnotationsListener.add(this);
        this.pageWiseAnnotationsShapes = new PageWiseAnnotations(observer);
    }

    @Override
    public void resetRoi(Annotation annotation) {
        this.pageWiseAnnotationsShapes.clear(annotation);
        this.documentAnnotationsListener.reset(annotation);
        this.documentAnnotationsListener.validateAndTriggerFullCapture(this.pageWiseAnnotationsShapes.getAllBoundedBoxes());
        this.canvasIndex.getActiveCanvas().repaint();
    }

    @Override
    public void resetRoiInCurrentPage() {
        List<Annotation> dimensions = this.pageWiseAnnotationsShapes.getAnnotationsInCurrentPage();
        this.pageWiseAnnotationsShapes.clearCurrentPage();
        dimensions.forEach(this.documentAnnotationsListener::reset);
        this.documentAnnotationsListener.validateAndTriggerFullCapture(this.pageWiseAnnotationsShapes.getAllBoundedBoxes());
        this.canvasIndex.getActiveCanvas().repaint();
    }

    @Override
    public int getRoiCaptureCount() {
        return this.pageWiseAnnotationsShapes.getRoiCaptureCount();
    }

    @Override
    public boolean isRoiCaptured(Annotation annotation) {
        return this.pageWiseAnnotationsShapes.isRoiCaptured(annotation);
    }

    public synchronized void clearCurrentPage() {
        this.resetImageDetails();
        this.imageChanged();
        this.pageWiseAnnotationsShapes.getAnnotationsInCurrentPage().forEach(this.documentAnnotationsListener::reset);
        this.pageWiseAnnotationsShapes.clearCurrentPage();
        this.documentAnnotationsListener.validateAndTriggerFullCapture(this.pageWiseAnnotationsShapes.getAllBoundedBoxes());
        this.canvasIndex.getActiveCanvas().repaint();
    }

    public boolean isInImageAndHasASelection(Point point) {
        if (this.documentAnnotationsListener.isFieldSelectedNotDrawn()) {
            return this.isInImage(point);
        }
        return false;
    }

    public Annotation getAnnotation(Point start, Point end) {
        Annotation annotation = this.documentAnnotationsListener.getSelectedField();
        int MAX_WIDTH = 1500;
        int MAX_HEIGHT = 800;
        int startX = (int)((start.getX() - (double)this.xDirectionImageShift) / this.scaledImageInfo.getScaleFactor());
        int startY = (int)((start.getY() - (double)this.yDirectionImageShift) / this.scaledImageInfo.getScaleFactor());
        int endX = (int)((end.getX() - start.getX()) / this.scaledImageInfo.getScaleFactor());
        int endY = (int)((end.getY() - start.getY()) / this.scaledImageInfo.getScaleFactor());
        int width = Math.abs(endX);
        int height = Math.abs(endY);
        if (width > 1500) {
            endX = endX > startX ? startX + 1500 : startX - 1500;
        }
        if (height > 800) {
            endY = endY > startY ? startY + 800 : startY - 800;
        }
        boolean exceedsLimit = Math.abs(endX) >= 1000 || Math.abs(endY) >= 400;
        endX = Math.min(endX, 1500);
        endY = Math.min(endY, 800);
        if (exceedsLimit) {
            this.showTooltipAtCursor(start);
        }
        RectangularBoundingBox box = RectangularBoundingBox.getInstance(startX, startY, endX, endY);
        annotation.setBoundingBox((BoundingBox)box);
        return annotation;
    }

    private void showTooltipAtCursor(Point cursorPosition) {
        if (this.tooltip == null) {
            this.tooltip = new JToolTip();
            this.tooltip.setTipText("Please select the only desired ROI");
        }
        this.tooltip.setLocation(cursorPosition);
        this.tooltip.setVisible(true);
    }

    public void addInProgressShape(Point start, Point end) {
        this.scaledImageInfo.setAnnotationInProgress(this.getAnnotation(start, end));
    }

    @Override
    public synchronized BufferedImage composeDocumentAndShapes() {
        this.setRequiredScale();
        BufferedImage drawnShapesImage = new BufferedImage((int)this.canvasDimensions.getWidth(), (int)this.canvasDimensions.getHeight(), 2);
        List<Annotation> annotationsInCurrentPage = this.pageWiseAnnotationsShapes.getAnnotationsInCurrentPage();
        this.scaledImageInfo.redraw(annotationsInCurrentPage, (Graphics2D)drawnShapesImage.getGraphics(), this.xDirectionImageShift, this.yDirectionImageShift);
        BufferedImage finalImage = new BufferedImage((int)this.canvasDimensions.getWidth(), (int)this.canvasDimensions.getHeight(), 2);
        finalImage.getGraphics().drawImage(this.canvasImage, 0, 0, null);
        finalImage.getGraphics().drawImage(drawnShapesImage, 0, 0, null);
        return finalImage;
    }

    public void commit() {
        Annotation annotation = this.scaledImageInfo.annotationInProgress;
        this.pageWiseAnnotationsShapes.addToCurrentPage(annotation);
        this.scaledImageInfo.annotationInProgress = null;
        this.documentAnnotationsListener.selectionCaptured();
        this.documentAnnotationsListener.validateAndTriggerFullCapture(this.pageWiseAnnotationsShapes.getAllBoundedBoxes());
    }
}

