/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.documentimageview;

import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.swing.documentimageview.FullCaptureCallBack;
import in.gov.uidai.ec.swing.documentimageview.RoiState;
import in.gov.uidai.ec.swing.imgvu.roi.DocumentAnnotationCaptureCallBack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAnnotationsListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentAnnotationsListener.class);
    private final Map<Annotation, DocumentAnnotationCaptureCallBack> captureCallBackMapping = new HashMap<Annotation, DocumentAnnotationCaptureCallBack>();
    private final Map<String, DocumentAnnotationCaptureCallBack> temp = new HashMap<String, DocumentAnnotationCaptureCallBack>();
    private Annotation selectedField;
    private RoiState roiState;
    private FullCaptureCallBack fullCaptureCallBack;

    public void registerCallback(Annotation annotation, DocumentAnnotationCaptureCallBack captureCallBack) {
        if (!this.captureCallBackMapping.containsKey(annotation)) {
            this.captureCallBackMapping.put(annotation, captureCallBack);
            this.temp.put(annotation.getPartLabel(), captureCallBack);
        } else {
            String error = annotation.getLabel() + ", annotation is already present";
            LOGGER.error(error);
        }
    }

    void add(RoiState roiState) {
        this.roiState = roiState;
    }

    public void add(FullCaptureCallBack captureCallBack) {
        this.fullCaptureCallBack = captureCallBack;
    }

    private boolean validateFullCapture(List<Annotation> boxes) {
        Set capturedFields;
        Set registeredFields = this.captureCallBackMapping.keySet().stream().filter(Annotation::isMandatory).collect(Collectors.toSet());
        return registeredFields.containsAll(capturedFields = boxes.stream().filter(Annotation::isMandatory).collect(Collectors.toSet())) && registeredFields.size() == capturedFields.size();
    }

    void selectionCaptured() {
        if (this.selectedField != null) {
            this.temp.get(this.selectedField.getPartLabel()).onSuccessCapture();
        }
        this.selectedField = null;
    }

    void validateAndTriggerFullCapture(List<Annotation> boxes) {
        if (this.fullCaptureCallBack != null && this.validateFullCapture(boxes)) {
            this.fullCaptureCallBack.onFullCapture(boxes);
        }
    }

    public void resetCurrentPage() {
        this.roiState.resetRoiInCurrentPage();
    }

    public int getRoiCaptureCount() {
        if (this.roiState == null) {
            return 0;
        }
        return this.roiState.getRoiCaptureCount();
    }

    void reset(Annotation annotation) {
        if (this.captureCallBackMapping.get(annotation) != null) {
            this.captureCallBackMapping.get(annotation).onResetCapture();
        } else {
            this.temp.get(annotation.getPartLabel()).onResetCapture();
        }
        this.fullCaptureCallBack.resetFullCapture();
    }

    boolean isRoiCaptured(Annotation annotation) {
        return this.roiState.isRoiCaptured(annotation);
    }

    public void select(Annotation annotation) {
        if (this.roiState != null) {
            if (this.captureCallBackMapping.get(annotation) != null || this.temp.get(annotation.getPartLabel()) != null) {
                this.roiState.resetRoi(annotation);
            }
            this.selectedField = annotation;
        }
    }

    boolean isFieldSelectedNotDrawn() {
        return this.selectedField != null && !this.isRoiCaptured(this.selectedField);
    }

    Annotation getSelectedField() {
        return this.selectedField;
    }
}

