/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.documentimageview;

import in.gov.uidai.ec.swing.documentimageview.AnnotationsInfo;
import in.gov.uidai.ec.swing.imgvu._AutoFitImageCanvas;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class DocumentImageAutoFitCanvas
extends _AutoFitImageCanvas {
    AnnotationsInfo annotationsInfo;

    public DocumentImageAutoFitCanvas(AnnotationsInfo annotationsInfo) {
        super(annotationsInfo);
        this.annotationsInfo = annotationsInfo;
        MouseAdapter adapter = this.getMouseAdapter(annotationsInfo);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    private MouseAdapter getMouseAdapter(final AnnotationsInfo annotationsInfo) {
        return new MouseAdapter(){
            Point lastClickedPointOnImage;

            @Override
            public void mousePressed(MouseEvent e) {
                if (annotationsInfo.isInImageAndHasASelection(e.getPoint())) {
                    if (annotationsInfo.isCurrentImageEmpty()) {
                        DocumentImageAutoFitCanvas.this.repaint();
                    }
                    this.lastClickedPointOnImage = e.getPoint();
                } else {
                    this.lastClickedPointOnImage = null;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (annotationsInfo.isInImageAndHasASelection(e.getPoint()) && this.lastClickedPointOnImage != null) {
                    annotationsInfo.addInProgressShape(this.lastClickedPointOnImage, e.getPoint());
                    DocumentImageAutoFitCanvas.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (annotationsInfo.isInImageAndHasASelection(e.getPoint()) && this.lastClickedPointOnImage != null && !this.lastClickedPointOnImage.equals(e.getPoint())) {
                    annotationsInfo.addInProgressShape(this.lastClickedPointOnImage, e.getPoint());
                    annotationsInfo.commit();
                    DocumentImageAutoFitCanvas.this.repaint();
                }
                this.lastClickedPointOnImage = null;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!annotationsInfo.isCurrentImageEmpty() && annotationsInfo.isInImage(e.getPoint())) {
                    DocumentImageAutoFitCanvas.this.setCursor(new Cursor(1));
                } else {
                    DocumentImageAutoFitCanvas.this.setCursor(Cursor.getDefaultCursor());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (annotationsInfo.isInImage(e.getPoint())) {
                    DocumentImageAutoFitCanvas.this.setCursor(new Cursor(1));
                } else {
                    DocumentImageAutoFitCanvas.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
    }

    @Override
    public void setImage(Image image, boolean isImageChanged) {
        super.setImage(image, isImageChanged);
        if (this.isThisLayerActive()) {
            if (isImageChanged) {
                this.annotationsInfo.clearCurrentPage();
            } else {
                this.annotationsInfo.reset();
            }
        }
    }
}

