/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.documentimageview;

import in.gov.uidai.ec.swing.documentimageview.AnnotationsInfo;
import in.gov.uidai.ec.swing.imgvu._NormalSizeImageCanvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class DocumentImageNormalSizeCanvas
extends _NormalSizeImageCanvas {
    private final AnnotationsInfo annotationInfo;

    public DocumentImageNormalSizeCanvas(AnnotationsInfo canvasInfo) {
        super(canvasInfo);
        this.annotationInfo = canvasInfo;
        MouseAdapter adapter = this.getMouseAdapter(canvasInfo);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
    }

    private MouseAdapter getMouseAdapter(final AnnotationsInfo canvasInfo) {
        return new MouseAdapter(){
            Point lastClickedPointOnImage;

            @Override
            public void mousePressed(MouseEvent e) {
                this.lastClickedPointOnImage = canvasInfo.isInImageAndHasASelection(e.getPoint()) ? e.getPoint() : null;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (canvasInfo.isInImageAndHasASelection(e.getPoint()) && this.lastClickedPointOnImage != null) {
                    Point recentVisitedPointOnImage = e.getPoint();
                    canvasInfo.addInProgressShape(this.lastClickedPointOnImage, recentVisitedPointOnImage);
                    DocumentImageNormalSizeCanvas.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (canvasInfo.isInImageAndHasASelection(e.getPoint())) {
                    canvasInfo.commit();
                }
                DocumentImageNormalSizeCanvas.this.repaint();
                this.lastClickedPointOnImage = null;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (canvasInfo.isInImage(e.getPoint())) {
                    DocumentImageNormalSizeCanvas.this.setCursor(new Cursor(1));
                } else {
                    DocumentImageNormalSizeCanvas.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        };
    }

    @Override
    public void setImage(Image image, boolean isImageChanged) {
        super.setImage(image, isImageChanged);
        Dimension prefSize = new Dimension(0, 0);
        if (this.theImage != null) {
            prefSize = new Dimension(this.theImage.getWidth(this), this.theImage.getHeight(this));
        }
        this.setPreferredSize(prefSize);
        this.revalidate();
        if (this.isThisLayerActive()) {
            if (isImageChanged) {
                this.annotationInfo.clearCurrentPage();
            } else {
                this.annotationInfo.reset();
            }
        }
    }
}

