/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.documentimageview;

import in.gov.uidai.ec.swing.documentimageview.AnnotationsInfo;
import in.gov.uidai.ec.swing.documentimageview.DocumentAnnotationsListener;
import in.gov.uidai.ec.swing.documentimageview.DocumentImageAutoFitCanvas;
import in.gov.uidai.ec.swing.documentimageview.DocumentImageNormalSizeCanvas;
import in.gov.uidai.ec.swing.imgvu.CanvasIndex;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.swing.imgvu.ImageCanvas;
import in.gov.uidai.ec.swing.imgvu.ImageViewer;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class DocumentImageViewer
extends ImageViewer {
    public DocumentImageViewer(DocumentAnnotationsListener documentAnnotationsListener) {
        CanvasIndex canvasIndex = new CanvasIndex(){

            @Override
            public int getPageNumber() {
                if (DocumentImageViewer.this.pageIndex != null) {
                    return DocumentImageViewer.this.pageIndex.getPageNumber();
                }
                return 0;
            }

            @Override
            public ImageCanvas getActiveCanvas() {
                if (DocumentImageViewer.this.autoFitBut.isSelected()) {
                    return DocumentImageViewer.this.afLayer;
                }
                if (DocumentImageViewer.this.normSizeBut.isSelected()) {
                    return DocumentImageViewer.this.nsLayer;
                }
                return null;
            }
        };
        AnnotationsInfo canvasInfo = new AnnotationsInfo(documentAnnotationsListener, canvasIndex);
        this.cardl = new CardLayout();
        this.afLayer = new DocumentImageAutoFitCanvas(canvasInfo);
        this.nsLayer = new DocumentImageNormalSizeCanvas(canvasInfo);
        this.setLayout(this.cardl);
        this.setBorder((Border)new SingleLineBorder().dashInterval("1, 2").drawEdges(true, false, false, false).lineColor("#bbbbbb").lineThickness(1.0f));
        JScrollPane scroll = new JScrollPane(this.nsLayer);
        this.add((Component)this.afLayer, "af");
        this.add((Component)scroll, "ns");
        this.autoFitBut = new JToggleButton("Autofit", ImageIconCache.getInst().getIcon("autoFitIcon"));
        this.normSizeBut = new JToggleButton("Normal", ImageIconCache.getInst().getIcon("normalIcon"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.autoFitBut);
        bg.add(this.normSizeBut);
        ActionListener butAxn = evt -> {
            if (this.autoFitBut.isSelected()) {
                this.dispMode = DisplayMode.AUTO_FIT;
                this.cardl.show(this, "af");
                this.afLayer.validate();
                this.afLayer.repaint();
            } else if (this.normSizeBut.isSelected()) {
                this.dispMode = DisplayMode.ORIGINAL_SIZE;
                this.cardl.show(this, "ns");
                this.nsLayer.repaint();
                this.afLayer.repaint();
            }
        };
        this.autoFitBut.addActionListener(butAxn);
        this.normSizeBut.addActionListener(butAxn);
        this.autoFitBut.doClick();
    }
}

