/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.documentimageview;

import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.swing.imgvu.PageIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PageWiseAnnotations {
    private final PageIndex observer;
    private List<Annotation> rectangularAnnotationBoundedBoxes = new ArrayList<Annotation>();

    PageWiseAnnotations(PageIndex observer) {
        this.observer = observer;
    }

    List<Annotation> getAnnotationsInCurrentPage() {
        return this.getRectangularAnnotationBoundedBoxes(this.observer.getPageNumber());
    }

    void clearCurrentPage() {
        int pageNumber = this.observer.getPageNumber();
        List<Annotation> list = this.getRectangularAnnotationBoundedBoxes(pageNumber);
        this.rectangularAnnotationBoundedBoxes.removeAll(list);
    }

    public int getRoiCaptureCount() {
        return this.getRectangularAnnotationBoundedBoxes(this.observer.getPageNumber()).size();
    }

    public boolean isRoiCaptured(Annotation annotation) {
        return this.rectangularAnnotationBoundedBoxes.stream().filter(b -> b.equals((Object)annotation)).count() != 0L;
    }

    public List<Annotation> getAllBoundedBoxes() {
        return this.rectangularAnnotationBoundedBoxes;
    }

    private List<Annotation> getRectangularAnnotationBoundedBoxes(int pageNumber) {
        return this.rectangularAnnotationBoundedBoxes.stream().filter(box -> box.getPageIndex() != null && box.getPageIndex().equals(pageNumber)).collect(Collectors.toList());
    }

    void addToCurrentPage(Annotation dimension) {
        this.rectangularAnnotationBoundedBoxes.remove(dimension);
        dimension.setPageIndex(Integer.valueOf(this.observer.getPageNumber()));
        this.rectangularAnnotationBoundedBoxes.add(dimension);
    }

    void clear(Annotation annotation) {
        this.rectangularAnnotationBoundedBoxes.removeIf(box -> box.equals((Object)annotation));
    }
}

