/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.imgvu;

import in.gov.uidai.ec.swing.imgvu.CanvasIndex;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.swing.imgvu.ImageCanvas;
import in.gov.uidai.ec.swing.imgvu.PageIndex;
import in.gov.uidai.ec.swing.imgvu._AutoFitImageCanvas;
import in.gov.uidai.ec.swing.imgvu._NormalSizeImageCanvas;
import in.gov.uidai.ec.swing.imgvu.roi.CanvasInfo;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class ImageViewer
extends JComponent {
    protected static final String ICON_NORMAL = "normalIcon";
    protected static final String ICON_AUTOFIT = "autoFitIcon";
    protected JToggleButton autoFitBut;
    protected JToggleButton normSizeBut;
    protected CardLayout cardl;
    protected _AutoFitImageCanvas afLayer;
    protected _NormalSizeImageCanvas nsLayer;
    protected DisplayMode dispMode;
    protected PageIndex pageIndex;

    public ImageViewer() {
        CanvasIndex canvasIndex = new CanvasIndex(){

            @Override
            public int getPageNumber() {
                if (ImageViewer.this.pageIndex != null) {
                    return ImageViewer.this.pageIndex.getPageNumber();
                }
                return 0;
            }

            @Override
            public ImageCanvas getActiveCanvas() {
                if (ImageViewer.this.autoFitBut.isSelected()) {
                    return ImageViewer.this.afLayer;
                }
                if (ImageViewer.this.normSizeBut.isSelected()) {
                    return ImageViewer.this.nsLayer;
                }
                return null;
            }
        };
        CanvasInfo canvasInfo = new CanvasInfo(canvasIndex);
        this.afLayer = new _AutoFitImageCanvas(canvasInfo);
        this.nsLayer = new _NormalSizeImageCanvas(canvasInfo);
        this.cardl = new CardLayout();
        this.setLayout(this.cardl);
        this.setBorder((Border)new SingleLineBorder().dashInterval("1, 2").drawEdges(true, false, false, false).lineColor("#bbbbbb").lineThickness(1.0f));
        JScrollPane scroll = new JScrollPane(this.nsLayer);
        this.add((Component)this.afLayer, "af");
        this.add((Component)scroll, "ns");
        this.autoFitBut = new JToggleButton("Autofit", ImageIconCache.getInst().getIcon(ICON_AUTOFIT));
        this.normSizeBut = new JToggleButton("Normal", ImageIconCache.getInst().getIcon(ICON_NORMAL));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.autoFitBut);
        bg.add(this.normSizeBut);
        ActionListener butAxn = evt -> {
            if (this.autoFitBut.isSelected()) {
                this.dispMode = DisplayMode.AUTO_FIT;
                this.cardl.show(this, "af");
                this.afLayer.validate();
            } else if (this.normSizeBut.isSelected()) {
                this.dispMode = DisplayMode.ORIGINAL_SIZE;
                this.cardl.show(this, "ns");
            }
        };
        this.autoFitBut.addActionListener(butAxn);
        this.normSizeBut.addActionListener(butAxn);
        this.autoFitBut.doClick();
    }

    public void setDisplayMode(DisplayMode mode) {
        this.dispMode = mode;
        if (this.dispMode.equals((Object)DisplayMode.AUTO_FIT)) {
            this.cardl.show(this, "af");
            this.autoFitBut.setSelected(true);
            this.afLayer.validate();
        } else if (this.dispMode.equals((Object)DisplayMode.ORIGINAL_SIZE)) {
            this.cardl.show(this, "ns");
            this.normSizeBut.setSelected(true);
            this.nsLayer.validate();
        }
    }

    public void setImage(byte[] data) {
        BufferedImage img = null;
        try {
            if (data == null) {
                return;
            }
            img = ImageIO.read(new ByteArrayInputStream(data));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.afLayer.setImage(img, true);
        this.nsLayer.setImage(img, true);
    }

    public void setImage(Image img) {
        if (img == null) {
            return;
        }
        this.afLayer.setImage(img, false);
        this.nsLayer.setImage(img, false);
    }

    public void setImage(Image img, boolean isImageChanged) {
        if (img == null) {
            return;
        }
        this.afLayer.setImage(img, isImageChanged);
        this.nsLayer.setImage(img, isImageChanged);
    }

    public AbstractButton getAutoFitButton() {
        return this.autoFitBut;
    }

    public AbstractButton getNormalSizeButton() {
        return this.normSizeBut;
    }

    public void setPageIndex(PageIndex pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void clear() {
        this.autoFitBut.removeActionListener(this.autoFitBut.getActionListeners()[0]);
        this.normSizeBut.removeActionListener(this.normSizeBut.getActionListeners()[0]);
        this.cardl = null;
        this.afLayer = null;
        this.nsLayer = null;
        this.dispMode = null;
        this.pageIndex = null;
    }

    static {
        ImageIconCache.getInst().addIcon(ICON_NORMAL, "res/ecmp/images/imgvu/ns.png");
        ImageIconCache.getInst().addIcon(ICON_AUTOFIT, "res/ecmp/images/imgvu/af.png");
    }
}

