/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.imgvu;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;

class _AutoFitLayer
extends JComponent {
    private Image theImage;
    private Image scaledImage;
    private int scaledX;
    private int scaledY;

    public _AutoFitLayer() {
        ComponentAdapter ca = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                _AutoFitLayer.this.resetScale();
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
                _AutoFitLayer.this.resetScale();
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                _AutoFitLayer.this.resetScale();
                _AutoFitLayer.this.repaint();
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                _AutoFitLayer.this.resetScale();
                _AutoFitLayer.this.repaint();
            }
        };
        this.addComponentListener(ca);
    }

    public void setImage(Image image) {
        this.resetScale();
        this.theImage = image;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.theImage == null) {
            return;
        }
        if (this.scaledImage == null) {
            int iwidth = this.theImage.getWidth(this);
            int iheight = this.theImage.getHeight(this);
            int width = this.getWidth();
            int height = this.getHeight();
            double xratio = (double)iwidth * 1.0 / ((double)width * 1.0);
            double yratio = (double)iheight * 1.0 / ((double)height * 1.0);
            double ratio = Math.max(xratio, yratio);
            int rwidth = (int)((double)iwidth / ratio);
            int rheight = (int)((double)iheight / ratio);
            this.scaledX = width / 2 - rwidth / 2;
            if (this.scaledX < 0) {
                this.scaledX = 0;
            }
            this.scaledY = height / 2 - rheight / 2;
            if (this.scaledY < 0) {
                this.scaledY = 0;
            }
            this.scaledImage = this.theImage.getScaledInstance(rwidth, rheight, 4);
        }
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.scaledImage, this.scaledX, this.scaledY, this);
    }

    private void resetScale() {
        this.scaledImage = null;
        this.scaledX = 0;
        this.scaledY = 0;
    }
}

