/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.imgvu;

import in.gov.uidai.ec.swing.imgvu.ImageCanvas;
import in.gov.uidai.ec.swing.imgvu.roi.CanvasInfo;
import in.gov.uidai.ec.swing.imgvu.roi.SCALING_TYPE;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.Scrollable;

public class _NormalSizeImageCanvas
extends JComponent
implements Scrollable,
ImageCanvas {
    private static final int BLOCK_INCREMENT_SIZE = 10;
    private final CanvasInfo canvasInfo;
    protected Image theImage;

    public _NormalSizeImageCanvas(CanvasInfo canvasInfo) {
        this.canvasInfo = canvasInfo;
        this.setPreferredSize(new Dimension(0, 0));
    }

    public void setImage(Image image, boolean isImageChanged) {
        this.theImage = image;
        Dimension prefSize = new Dimension(0, 0);
        if (this.theImage != null) {
            prefSize = new Dimension(this.theImage.getWidth(this), this.theImage.getHeight(this));
        }
        this.setPreferredSize(prefSize);
        this.revalidate();
        if (this.isThisLayerActive()) {
            this.canvasInfo.reset();
        }
    }

    protected boolean isThisLayerActive() {
        return this == this.canvasInfo.getCanvas();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.theImage == null) {
            return;
        }
        this.getScaleType();
        BufferedImage image = this.canvasInfo.composeDocumentAndShapes();
        g.drawImage(image, 0, 0, null);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Container parent = this.getParent();
        Dimension dim = this.getPreferredSize();
        if (parent != null) {
            Dimension pdim = parent.getSize();
            dim.width = Math.max(dim.width, pdim.width);
            dim.height = Math.max(dim.height, pdim.height);
        }
        return dim;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public SCALING_TYPE getScaleType() {
        return SCALING_TYPE.ORIGINAL_IMAGE;
    }

    @Override
    public Image getImage() {
        return this.theImage;
    }
}

