/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.imgvu.roi;

import in.gov.uidai.ec.swing.imgvu.CanvasIndex;
import in.gov.uidai.ec.swing.imgvu.ImageCanvas;
import in.gov.uidai.ec.swing.imgvu.roi.SCALING_TYPE;
import in.gov.uidai.ec.swing.imgvu.roi.ScaledImageInfo;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class CanvasInfo {
    protected final CanvasIndex canvasIndex;
    protected Rectangle2D.Double canvasDimensions;
    protected ScaledImageInfo scaledImageInfo;
    protected int xDirectionImageShift;
    protected int yDirectionImageShift;
    private double previousScale;
    protected BufferedImage canvasImage;
    private boolean imageChange;
    private boolean redrawCanvas;

    public CanvasInfo(CanvasIndex observer) {
        this.canvasIndex = observer;
    }

    public synchronized void reset() {
        this.resetImageDetails();
        this.canvasIndex.getActiveCanvas().repaint();
    }

    protected void resetImageDetails() {
        this.scaledImageInfo = null;
        this.redrawCanvas = true;
    }

    protected void imageChanged() {
        this.imageChange = true;
    }

    private void setCanvasDimensions(int x, int y, int width, int height) {
        this.canvasDimensions = new Rectangle2D.Double(x, y, width, height);
    }

    public boolean isCurrentImageEmpty() {
        return this.scaledImageInfo == null;
    }

    public ImageCanvas getCanvas() {
        return this.canvasIndex.getActiveCanvas();
    }

    private void setCanvasDimensions() {
        this.setCanvasDimensions(0, 0, this.canvasIndex.getActiveCanvas().getWidth(), this.canvasIndex.getActiveCanvas().getHeight());
    }

    private void setImageScaleToMinHeightOrMinWidthOfCanvas() {
        this.setCanvasDimensions();
        ScaledImageInfo scaledImageInfo = this.createScaledImageInfo(this.canvasIndex.getActiveCanvas().getImage());
        double imageWidth = scaledImageInfo.getOriginalWidth();
        double imageHeight = scaledImageInfo.getOriginalHeight();
        scaledImageInfo.setScaleFactor(Math.min(this.canvasDimensions.getHeight() / imageHeight, this.canvasDimensions.getWidth() / imageWidth));
        if (this.scaledImageInfo == null || scaledImageInfo.scaleFactor != this.scaledImageInfo.scaleFactor || this.imageChange) {
            this.scaledImageInfo = scaledImageInfo;
        }
        this.xDirectionImageShift = (int)(this.canvasDimensions.getWidth() / 2.0 - scaledImageInfo.getWidth() / 2.0);
        if (this.xDirectionImageShift < 0) {
            this.xDirectionImageShift = 0;
        }
        this.yDirectionImageShift = (int)(this.canvasDimensions.getHeight() / 2.0 - scaledImageInfo.getHeight() / 2.0);
        if (this.yDirectionImageShift < 0) {
            this.yDirectionImageShift = 0;
        }
        this.setCanvasImage();
        this.previousScale = scaledImageInfo.scaleFactor;
        this.imageChange = false;
    }

    private void resetScale() {
        this.setCanvasDimensions();
        ScaledImageInfo scaledImageInfo = this.createScaledImageInfo(this.canvasIndex.getActiveCanvas().getImage());
        if (this.scaledImageInfo == null || scaledImageInfo.scaleFactor != this.scaledImageInfo.scaleFactor || this.imageChange) {
            this.scaledImageInfo = scaledImageInfo;
        }
        this.xDirectionImageShift = 0;
        this.yDirectionImageShift = 0;
        this.setCanvasImage();
        this.previousScale = scaledImageInfo.scaleFactor;
        this.imageChange = false;
    }

    public ScaledImageInfo createScaledImageInfo(Image originalImage) {
        return new ScaledImageInfo(new Rectangle2D.Double(0.0, 0.0, originalImage.getWidth(null), originalImage.getHeight(null)), originalImage);
    }

    private void setCanvasImage() {
        if (this.isScaleChanged()) {
            BufferedImage bufferedImage = new BufferedImage((int)this.canvasDimensions.getWidth(), (int)this.canvasDimensions.getHeight(), 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawImage(this.scaledImageInfo.getScaledImage(), this.xDirectionImageShift, this.yDirectionImageShift, null);
            graphics2D.dispose();
            bufferedImage.flush();
            this.canvasImage = bufferedImage;
            this.redrawCanvas = false;
        }
    }

    public synchronized BufferedImage composeDocumentAndShapes() {
        this.setRequiredScale();
        BufferedImage finalImage = new BufferedImage((int)this.canvasDimensions.getWidth(), (int)this.canvasDimensions.getHeight(), 2);
        finalImage.getGraphics().drawImage(this.canvasImage, 0, 0, null);
        return finalImage;
    }

    protected synchronized void setRequiredScale() {
        SCALING_TYPE scalingType = this.canvasIndex.getActiveCanvas().getScaleType();
        if (scalingType == SCALING_TYPE.ORIGINAL_IMAGE) {
            this.resetScale();
        } else if (scalingType == SCALING_TYPE.FIT_TO_MIN_WIDTH_OR_MIN_HEIGHT) {
            this.setImageScaleToMinHeightOrMinWidthOfCanvas();
        } else {
            throw new RuntimeException("unknown scale selection");
        }
    }

    private boolean isScaleChanged() {
        return this.previousScale != this.scaledImageInfo.scaleFactor || this.imageChange || this.redrawCanvas;
    }

    public boolean isInImage(Point point) {
        return this.scaledImageInfo.isWithInOrOnBoundaries((point.getX() - (double)this.xDirectionImageShift) / this.scaledImageInfo.scaleFactor, (point.getY() - (double)this.yDirectionImageShift) / this.scaledImageInfo.scaleFactor);
    }
}

