/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.imgvu.roi;

import in.gov.uidai.ec.service.document.BoundingBox;
import in.gov.uidai.ec.service.document.roi.RoiCoordinate;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;

public class RectangularBoundingBox
extends Rectangle
implements BoundingBox {
    protected final Point topRight;
    protected final Point topLeft;
    protected final Point bottomRight;
    protected final Point bottomLeft;

    public static RectangularBoundingBox getInstance(int x, int y, int width, int height) {
        Point bottomLeft;
        Point bottomRight;
        Point topLeft;
        Point topRight;
        if (height <= 0 && width <= 0) {
            topRight = new Point(x, y + height);
            topLeft = new Point(x + width, y + height);
            bottomRight = new Point(x, y);
            bottomLeft = new Point(x + width, y);
        } else if (height >= 0 && width <= 0) {
            bottomRight = new Point(x, y + height);
            bottomLeft = new Point(x + width, y + height);
            topRight = new Point(x, y);
            topLeft = new Point(x + width, y);
        } else if (height <= 0) {
            topLeft = new Point(x, y + height);
            topRight = new Point(x + width, y + height);
            bottomLeft = new Point(x, y);
            bottomRight = new Point(x + width, y);
        } else {
            bottomLeft = new Point(x, y + height);
            bottomRight = new Point(x + width, y + height);
            topLeft = new Point(x, y);
            topRight = new Point(x + width, y);
        }
        return new RectangularBoundingBox(topRight, topLeft, bottomRight, bottomLeft, Math.abs(width), Math.abs(height));
    }

    private RectangularBoundingBox(Point topRight, Point topLeft, Point bottomRight, Point bottomLeft, int width, int height) {
        super(topLeft.x, topLeft.y, width, height);
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
        this.topRight = topRight;
        this.topLeft = topLeft;
    }

    public List<RoiCoordinate> getCoordinates() {
        return Arrays.asList(new RoiCoordinate(this.topLeft.x, this.topLeft.y), new RoiCoordinate(this.bottomRight.x, this.bottomRight.y));
    }
}

