/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.imgvu.roi;

import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.swing.imgvu.roi.RectangularBoundingBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class ScaledImageInfo {
    private static final String FONT_NAME = "Dialog";
    private final Rectangle2D.Double originalImageDimensions;
    protected double scaleFactor;
    public Annotation annotationInProgress;
    Image originalImage;
    Image scaledImage;

    public ScaledImageInfo(Rectangle2D.Double originalImageDimensions, Image originalImage) {
        this.originalImageDimensions = originalImageDimensions;
        this.originalImage = originalImage;
        this.setScaleFactor(1.0);
    }

    public double getHeight() {
        return this.originalImageDimensions.getHeight() * this.scaleFactor;
    }

    public double getWidth() {
        return this.originalImageDimensions.getWidth() * this.scaleFactor;
    }

    public double getOriginalHeight() {
        return this.originalImageDimensions.getHeight();
    }

    public double getOriginalWidth() {
        return this.originalImageDimensions.getWidth();
    }

    public void redraw(List<Annotation> drawnShapes, Graphics2D graphics2D, double xDirectionImageShift, double yDirectionImageShift) {
        Font font = new Font(FONT_NAME, 1, (int)Math.min(10.0 * this.scaleFactor, 10.0));
        graphics2D.setFont(font);
        for (Annotation annotation : drawnShapes) {
            RectangularBoundingBox boundingBox = (RectangularBoundingBox)annotation.getBoundingBox();
            this.drawRoiShape(graphics2D, Color.GREEN, xDirectionImageShift, yDirectionImageShift, annotation, boundingBox);
        }
        if (this.annotationInProgress != null) {
            this.drawRoiShape(graphics2D, Color.RED, xDirectionImageShift, yDirectionImageShift, this.annotationInProgress, (RectangularBoundingBox)this.annotationInProgress.getBoundingBox());
        }
    }

    private void drawRoiShape(Graphics2D graphics2D, Color rectangleColor, double xDirectionImageShift, double yDirectionImageShift, Annotation annotation, RectangularBoundingBox boundingBox) {
        BasicStroke stroke = new BasicStroke((float)(2.0 / this.scaleFactor));
        graphics2D.setStroke(stroke);
        AffineTransform defaultTransform = graphics2D.getTransform();
        AffineTransform shift = new AffineTransform();
        shift.translate(xDirectionImageShift, yDirectionImageShift);
        AffineTransform shiftAndScale = new AffineTransform(shift);
        shiftAndScale.scale(this.scaleFactor, this.scaleFactor);
        graphics2D.setTransform(shiftAndScale);
        graphics2D.setColor(rectangleColor);
        graphics2D.draw(boundingBox);
        Rectangle2D transformedBox = shiftAndScale.createTransformedShape(boundingBox).getBounds2D();
        graphics2D.setTransform(defaultTransform);
        this.drawLabel(graphics2D, annotation, transformedBox);
        this.debugCoOrdinates(graphics2D, boundingBox, xDirectionImageShift, yDirectionImageShift);
    }

    private void drawLabel(Graphics2D graphics2D, Annotation annotation, Rectangle2D transformedBox) {
        Font font = new Font(FONT_NAME, 1, (int)Math.min(10.0 * this.scaleFactor, 10.0));
        graphics2D.setFont(font);
        Rectangle2D rec = graphics2D.getFontMetrics().getStringBounds(annotation.getDisplayName(), graphics2D);
        double labelWidth = rec.getWidth();
        double labelHeight = rec.getHeight();
        double labelStartX = transformedBox.getX() + (transformedBox.getWidth() - labelWidth) / 2.0;
        double labelStartXRec = transformedBox.getX() + (transformedBox.getWidth() - labelWidth * 1.2) / 2.0;
        double labelStartY = transformedBox.getY() - labelHeight / 2.0;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(new Rectangle2D.Double(labelStartXRec, labelStartY, labelWidth * 1.2, labelHeight));
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(annotation.getDisplayName(), (float)labelStartX, (float)transformedBox.getY());
    }

    public void debugCoOrdinates(Graphics2D graphics2D, RectangularBoundingBox rectangleDimensions, double xShift, double yShift) {
        graphics2D.setColor(Color.RED);
        int x = (int)(xShift + rectangleDimensions.topLeft.getX() * this.scaleFactor);
        int y = (int)(yShift + rectangleDimensions.topLeft.getY() * this.scaleFactor);
        String dsisplayCordinate = String.format("{TL(x=%s,y=%s)}", x, y);
        int width = graphics2D.getFontMetrics().stringWidth(dsisplayCordinate);
        graphics2D.drawString(dsisplayCordinate, (float)x - (float)width, (float)y);
        x = (int)(xShift + rectangleDimensions.bottomLeft.getX() * this.scaleFactor);
        y = (int)(yShift + rectangleDimensions.bottomLeft.getY() * this.scaleFactor);
        dsisplayCordinate = String.format("{BL(x=%s,y=%s)}", x, y);
        width = graphics2D.getFontMetrics().stringWidth(dsisplayCordinate);
        graphics2D.drawString(dsisplayCordinate, (float)x - (float)width, (float)y);
        x = (int)(xShift + rectangleDimensions.topRight.getX() * this.scaleFactor);
        y = (int)(yShift + rectangleDimensions.topRight.getY() * this.scaleFactor);
        dsisplayCordinate = String.format("{TR(x=%s,y=%s)}", x, y);
        width = graphics2D.getFontMetrics().stringWidth(dsisplayCordinate);
        graphics2D.drawString(dsisplayCordinate, (float)x, (float)y);
        x = (int)(xShift + rectangleDimensions.bottomRight.getX() * this.scaleFactor);
        y = (int)(yShift + rectangleDimensions.bottomRight.getY() * this.scaleFactor);
        dsisplayCordinate = String.format("{BR(x=%s,y=%s)}", x, y);
        width = graphics2D.getFontMetrics().stringWidth(dsisplayCordinate);
        graphics2D.drawString(dsisplayCordinate, (float)x, (float)y);
    }

    public void setAnnotationInProgress(Annotation annotationInProgress) {
        this.annotationInProgress = annotationInProgress;
    }

    void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.scaledImage = this.originalImage.getScaledInstance((int)this.getWidth(), (int)this.getHeight(), 4);
    }

    public boolean isWithInOrOnBoundaries(double x, double y) {
        return this.originalImageDimensions.contains((int)x, (int)y);
    }

    public Image getScaledImage() {
        return this.scaledImage;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }
}

