/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.shared;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.commons.lang.StringUtils;

public class SectionHeader
extends JComponent {
    private final JLabel headText;
    private final TransparentBox leftPanel;
    private final TransparentBox rightPanel;
    private LinearGradientBackground background;
    private final IResourceBundleContext rbCtxt;
    private final L10nDecorator ldeco;
    private boolean isOnline;

    public SectionHeader() {
        this(null, null);
    }

    public SectionHeader(L10nDecorator deco, IResourceBundleContext ctxt) {
        this.ldeco = deco;
        this.rbCtxt = ctxt;
        this.leftPanel = new TransparentBox();
        BoxLayout bl1 = new BoxLayout((Container)this.leftPanel, 0);
        this.leftPanel.setLayout((LayoutManager)bl1);
        this.rightPanel = new TransparentBox();
        BoxLayout bl2 = new BoxLayout((Container)this.rightPanel, 0);
        this.rightPanel.setLayout((LayoutManager)bl2);
        this.setLayout(new BorderLayout(0, 0));
        super.add((Component)this.leftPanel, "West");
        super.add((Component)this.rightPanel, "East");
        this.setBorder(new CompoundBorder(new LineBorder(Color.decode("#D2D2D2"), 1), new EmptyBorder(3, 3, 3, 3)));
        this.headText = new JLabel();
        this.add(this.headText);
        this.headText.setFont(this.headText.getFont().deriveFont(1, 12.0f));
    }

    public final void setText(String text) {
        if (this.ldeco != null) {
            this.ldeco.localize(this.headText, (Object)text, new Object[0]);
            this.headText.setFont(this.headText.getFont().deriveFont(1, 12.0f));
        }
        if (StringUtils.isBlank((String)this.headText.getText())) {
            if (this.rbCtxt != null) {
                this.headText.setText(this.rbCtxt.getMessage((Object)text, new Object[0]));
            } else {
                this.headText.setText(text);
            }
        }
    }

    @Override
    public final Component add(Component comp) {
        return this.leftPanel.add(comp);
    }

    @Override
    public final void add(Component comp, Object constraints) {
        if (constraints == null) {
            this.leftPanel.add(comp);
        } else if (constraints.toString().equalsIgnoreCase("right")) {
            this.rightPanel.add(comp);
        } else {
            this.leftPanel.add(comp);
        }
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void setOnline(boolean online) {
        this.isOnline = online;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.background = this.isOnline ? new LinearGradientBackground().direction(1).borderSize(1.0f).roundingSize(0, 0).gradientColors("#FFFFFF, #e3f3fa, #e3f3fa, #cceeff").gradientStops("0, 0.7, 0.8, 1") : new LinearGradientBackground().direction(1).borderSize(1.0f).roundingSize(0, 0).gradientColors("#E8E8E8, #E6E6E6, #E6E6E6, #FFFFFF").gradientStops("0, 0.5, 0.51, 1");
        this.background.doPaint((Component)this, g, 0, 0, this.getWidth(), this.getHeight());
    }
}

