/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.shared;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.thumb.CaptureThumbnail;
import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class ViewUtils {
    public static final String DEFAULT_TLIT_LOCALE = "hi_IN";
    public static final String HTML_PREFIX = "<html>";
    public static final double[] COLS_STD = new double[]{-1.0, 470.0, 5.0, 520.0, -1.0};
    public static final double[] COLS_STD_FORM = new double[]{-1.0, 5.0, 315.0};
    private static final String KEY_EDIT_OFF_ICON = "KEY_EDIT_OFF_ICON";
    private static final String KEY_EDIT_ON_ICON = "KEY_EDIT_ON_ICON";
    private static final Cursor HAND_CURSOR = new Cursor(12);

    public static JCheckBox createEditLabel(String text, int pos, IResourceBundleContext rbCtxt) {
        JCheckBox result = new JCheckBox();
        if (StringUtils.isBlank((String)text)) {
            result.setText("");
        } else {
            result.setText(rbCtxt.getMessage((Object)text, new Object[0]));
        }
        result.setIcon(ImageIconCache.getInst().getIcon(KEY_EDIT_OFF_ICON));
        result.setRolloverIcon(ImageIconCache.getInst().getIcon(KEY_EDIT_OFF_ICON));
        result.setSelectedIcon(ImageIconCache.getInst().getIcon(KEY_EDIT_ON_ICON));
        result.setHorizontalTextPosition(pos);
        result.setIconTextGap(0);
        result.setCursor(HAND_CURSOR);
        return result;
    }

    public static CaptureThumbnail createThumbnail() {
        CaptureThumbnail capt = new CaptureThumbnail();
        capt.setBackground(Color.decode("#ffffff"));
        capt.setOpaque(true);
        capt.setBorder((Border)new DashedBorder().dashInterval("6, 3").lineColor("#cccccc").lineThickness(1.0f));
        return capt;
    }

    public static ImageIcon getImageIcon(Class<?> k, String iconPath) {
        ImageIcon errIcon = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = k.getClassLoader();
            }
            errIcon = new ImageIcon(Objects.requireNonNull(cl.getResource(iconPath)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return errIcon;
    }

    static {
        ImageIconCache.getInst().addIcon(KEY_EDIT_OFF_ICON, "res/images/check-icon-edit-off.png");
        ImageIconCache.getInst().addIcon(KEY_EDIT_ON_ICON, "res/images/check-icon-edit-on.png");
    }

    public static class ClearOnDisableHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JComboBox cb;
            JComponent comp = (JComponent)evt.getSource();
            if (comp.isEnabled()) {
                return;
            }
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText("");
            } else if (comp instanceof JComboBox && (cb = (JComboBox)comp).getModel().getSize() > 0) {
                cb.setSelectedIndex(0);
            }
        }
    }
}

