/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.tlit;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.Font;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class DirectTranslitField
extends JLabel {
    private IResourceBundleContext resBundleCtxt;

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resBundleCtxt = ctxt;
    }

    public void setLocale(String code) {
        Font font = FontManager.getInst().getScreenFontForLocale(code);
        if (font != null) {
            this.setFont(font);
        }
    }

    @Override
    public void setText(String text) {
        if (text.isEmpty()) {
            super.setText("");
            return;
        }
        StringBuilder tlitText = new StringBuilder();
        StringTokenizer strtok = new StringTokenizer(text, "0123456789 \t:+-/\\!@#$%^&*()={}[]<>,.?", true);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            String transTok = this.resBundleCtxt.getLocaleMessage((Object)("tlit-map:" + token.toLowerCase()), new Object[0]);
            if (transTok.charAt(0) == '!') {
                tlitText.append(token);
                continue;
            }
            tlitText.append(transTok);
        }
        super.setText(tlitText.toString());
    }
}

