/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.swing.tlit;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.tlit.IMTranslitAssociation;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.swing.translit.IMType;
import in.gov.uidai.swing.translit.NativeXIMTranslitField;
import in.gov.uidai.swing.translit.SIMTranslitField;
import in.gov.uidai.swing.translit.TransliterationSetup;
import in.gov.uidai.swing.translit.XIMTranslitField;
import in.gov.uidai.translit.spi.TransliterationHints;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public final class IMTranslitFieldBuilder {
    private IUIPreference uiPref;
    private String translationLocale;
    EnrollmentService enrollmentService;

    public IMTranslitFieldBuilder(IUIPreference pref, String translationLocale) {
        this.uiPref = pref;
        this.translationLocale = translationLocale;
    }

    public IMTranslitFieldBuilder(IUIPreference pref, String translationLocale, EnrollmentService enrollmentService) {
        this.uiPref = pref;
        this.translationLocale = translationLocale;
        this.enrollmentService = enrollmentService;
    }

    public AbstractIMTranslitField createIMField(JTextField associatedField, TransliterationHints ... hints) {
        SIMTranslitField result;
        IMType imType = new TransliterationSetup().getIMType();
        switch (imType) {
            case SYSTEM: {
                result = new SIMTranslitField();
                break;
            }
            case SWING: {
                XIMTranslitField ximField = new XIMTranslitField();
                ximField.setTransliterationHints(hints);
                result = ximField;
                break;
            }
            case AWT: {
                NativeXIMTranslitField nimField = new NativeXIMTranslitField();
                nimField.setTransliterationHints(hints);
                result = nimField;
                break;
            }
            default: {
                XIMTranslitField ximField1 = new XIMTranslitField();
                ximField1.setTransliterationHints(hints);
                result = ximField1;
            }
        }
        String localeStr = this.uiPref.getTransliterationLocale("hi_IN");
        if (StringUtils.isNotEmpty((String)this.translationLocale)) {
            localeStr = this.translationLocale;
        }
        if (localeStr.equalsIgnoreCase("en_in")) {
            new IMTranslitAssociation((JTextComponent)result, associatedField);
            result.setPermanentDisabled(true);
        } else {
            result.associate(associatedField);
            result.setLocale(localeStr);
            result.setEnrollmentService(this.enrollmentService);
        }
        return result;
    }
}

