/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui;

import in.gov.uidai.ec.swing.TransparentToggleButton;
import in.gov.uidai.ec.ui.shared.IBiometricReceivedListener;
import in.gov.uidai.ec.ui.shared.IFocusLostListener;
import in.gov.uidai.ec.ui.shared.IKeyboardListener;
import in.gov.uidai.ec.ui.shared.IPopupMenuListener;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.bio.BiometricsEvent;
import in.gov.uidai.swing.bio.DefaultBiometricsListener;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import in.gov.uidai.swing.bio.confirm.IStartCaptureListener;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.notify.NotificationLocation;
import in.gov.uidai.swing.notify.NotificationOverlay;
import in.gov.uidai.swing.notify.NotificationPopup;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang.StringUtils;

public class ControllerBase {
    protected ILiteView view;

    public ControllerBase(ILiteView view) {
        this.view = view;
    }

    protected void addActionListener(JButton component, ActionListener l) {
        if (component != null) {
            component.addActionListener(l);
        }
    }

    protected void addActionListener(JTextField component, ActionListener l) {
        if (component != null) {
            component.addActionListener(l);
        }
    }

    protected void addActionListener(JRadioButton component, ActionListener l) {
        if (component != null) {
            component.addActionListener(l);
        }
    }

    protected void addActionListener(JCheckBox component, ActionListener l) {
        if (component != null) {
            component.addActionListener(l);
        }
    }

    protected void addActionListener(JComboBox component, ActionListener l) {
        if (component != null) {
            component.addActionListener(l);
        }
    }

    protected void addStartCaptureListener(BiometricsNonRDField component, IStartCaptureListener l) {
        if (component != null) {
            component.addStartCaptureListener(l);
        }
    }

    protected void addBiometricsListener(BiometricsNonRDField component, final IBiometricReceivedListener l) {
        if (component != null) {
            component.addBiometricsListener((IBiometricsListener)new DefaultBiometricsListener(){

                public void sampleReceived(BiometricsEvent evt) {
                    l.sampleReceived(evt);
                }
            });
        }
    }

    protected void addRDBiometricsListener(BiometricsRDField component, final IBiometricReceivedListener l) {
        if (component != null) {
            component.addBiometricsListener((IBiometricsListener)new DefaultBiometricsListener(){

                public void sampleReceived(BiometricsEvent evt) {
                    l.sampleReceived(evt);
                }
            });
        }
    }

    protected void addItemListener(JComboBox component, ItemListener al) {
        if (component != null) {
            component.addItemListener(al);
        }
    }

    protected void addChangeListener(JList component, ListSelectionListener al) {
        if (component != null) {
            component.addListSelectionListener(al);
        }
    }

    protected void addToggleBoxChangeListener(JToggleButton component, ChangeListener al) {
        if (component != null) {
            component.addChangeListener(al);
        }
    }

    protected void addChangeListener(JCheckBox component, ItemListener al) {
        if (component != null) {
            component.addItemListener(al);
        }
    }

    protected void addFocusListener(JTextField component, final IFocusLostListener l) {
        if (component != null) {
            component.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    l.focusLost(e);
                }
            });
        }
    }

    protected void addKeyListener(JComboBox component, final List<Character> keyList, final IKeyboardListener l) {
        if (component != null) {
            component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (keyList.stream().anyMatch(k -> Character.toLowerCase(k.charValue()) == Character.toLowerCase(e.getKeyChar()))) {
                        l.keyTyped(e);
                    }
                }
            });
        }
    }

    protected void addPopupMenuListener(JComboBox component, final IPopupMenuListener l) {
        if (component != null) {
            component.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    l.popupMenuWillBecomeInvisible(e);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    protected void addItemListener(JCheckBox component, ItemListener ie) {
        if (component != null) {
            component.addItemListener(ie);
        }
    }

    protected void addMouseListener(JList component, MouseListener listener) {
        if (component != null) {
            component.addMouseListener(listener);
        }
    }

    protected void addItemListener(TransparentToggleButton component, ItemListener ie) {
        if (component != null) {
            component.addItemListener(ie);
        }
    }

    protected void showFieldError(JComponent theComp, String message) {
        if (theComp == null || StringUtils.isBlank((String)message)) {
            return;
        }
        NotificationOverlay.setError((JComponent)theComp);
        NotificationPopup toolTip = NotificationPopup.getToolTip((JComponent)theComp);
        toolTip.setToolTipText(message, false);
        toolTip.setLocation(NotificationLocation.BOTTOM);
        theComp.repaint();
    }

    protected void clearFieldError(JComponent theComp) {
        if (theComp == null) {
            return;
        }
        NotificationOverlay.clear((JComponent)theComp);
        NotificationPopup.getToolTip((JComponent)theComp).setToolTipText(null, false);
        theComp.repaint();
    }

    protected void showWarning(JComponent component, Object message) {
        L10nOptionPaneBuilder.getInstance().showWarning(message, (Component)component.getRootPane());
    }

    protected void showWarningUC(Object message, JComponent parent) {
        L10nOptionPaneBuilder.getInstance().showWarningUC(message, (Component)parent);
    }

    protected void showError(JComponent component, Object message) {
        L10nOptionPaneBuilder.getInstance().showError(message, (Component)component.getRootPane(), new Object[0]);
    }

    protected void showSimpleError(JComponent component, String message, Object ... args) {
        L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)message, (Component)component.getRootPane(), args);
    }

    protected void showErrorUC(JComponent component, String message, String errorCode, String txnId, Object ... args) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(message, (Component)component.getRootPane(), errorCode, txnId, args);
    }

    protected void showInfo(JComponent component, Object message) {
        L10nOptionPaneBuilder.getInstance().showInfo(message, (Component)component.getRootPane(), new Object[0]);
    }

    protected void showInfoUC(JComponent component, Object message) {
        L10nOptionPaneBuilder.getInstance().showInfoUC(message);
    }
}

