/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.appointment;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.scan.ScanMode;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.service.appointment.IAppointmentService;
import in.gov.uidai.ec.service.appointment.model.Address;
import in.gov.uidai.ec.service.appointment.model.AppointmentTypeEnum;
import in.gov.uidai.ec.service.appointment.model.HeadOfFamily;
import in.gov.uidai.ec.service.appointment.model.IAppointment;
import in.gov.uidai.ec.service.appointment.model.NewEnrolAppointment;
import in.gov.uidai.ec.service.appointment.model.NewEnrolment;
import in.gov.uidai.ec.service.appointment.model.UpdateEnrolAppointment;
import in.gov.uidai.ec.service.appointment.model.UpdateEnrolment;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.ui.appointment.IAppointmentConstants;
import in.gov.uidai.ec.ui.enrol.ControlMembers;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.VerificationGuard;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysDocuments;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentScanControl
implements IOnScreenDisplayAware,
IEventContextAware,
IAppointmentConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppointmentScanControl.class);
    private final ControlMembers members = new ControlMembers();
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private IUIPreference uiPref;
    private IAppointmentService appointmentService;
    private UnsavedTracker tracker;
    private EnrollmentService enrollmentService;
    private ITransliterationProvider tlitProv;
    private String localeSpec;
    private IPinCodeService postOfficeDataService;
    private VerificationGuard verificationGuard;
    private IOucDataStore oucDataStore;

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
        this.members.setEnrollmentService(enrollmentService);
    }

    public void setPostOfficeDataService(IPinCodeService _postOfficeDataService) {
        this.postOfficeDataService = _postOfficeDataService;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
        this.members.setOSD(osd);
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
        this.members.setEventContext(ctxt);
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
        this.localeSpec = this.uiPref.getTransliterationLocale("hi_in");
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
    }

    public void setAppointmentService(IAppointmentService appointmentService) {
        this.appointmentService = appointmentService;
    }

    public void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    @EventHandler(name="hID_Appointment_ScanButSel", method="actionPerformed")
    public void onAppointmentScanSelect(ILiteEvent evt) {
        LOGGER.debug("appointment scan tab selected");
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.StartUp, evt)) {
                return;
            }
            if (!this.tracker.selectAppointment(evt)) {
                return;
            }
        }
        LOGGER.info("Starting Appointment based Enrollment");
        if (this.enrollmentService.isSessionInitialed()) {
            this.enrollmentService.setOnlineUpdate(false);
        }
        String scafId = this.members.getOSD().recompose(evt.getScaffoldId(), "appointmentScanViewPeer");
        ILiteScaffold scaffold = this.members.getOSD().getScaffold(scafId);
        this.members.updateViewId(scaffold.getViewId());
        ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)LabelKeysMainWin.APPOINTMENT_SCAN);
    }

    @EventHandler(name="hID_Appointment_Slip_Attach", method="actionPerformed")
    public void onDocAttach(ILiteEvent evt) {
        LOGGER.debug("Appointment Slip Attachment");
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        File file = DocumentUtils.getInstance().selectPdfFileFromBrowser(parent);
        if (file != null) {
            IVisualExecutionContext veCtxt = this.osd.getView(evt.getViewId()).getVisualExecutionContext();
            Map eMap = this.members.getView().getElementMap();
            if (veCtxt != null) {
                veCtxt.reset();
                veCtxt.setMessage("Scanning QR Code. Please wait.");
            }
            this.scanAppointmentSlip(veCtxt, eMap, file, evt);
        }
    }

    @EventHandler(name="hID_Appointment_SlipScan", method="actionPerformed")
    public void onDocScan(ILiteEvent evt) {
        Map eMap = this.members.getView().getElementMap();
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        IVisualExecutionContext veCtxt = this.osd.getView(evt.getViewId()).getVisualExecutionContext();
        try {
            ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
            if (StringUtils.isBlank((String)scannerInfo.getLastScanner()) || scannerInfo.getLastScanner().equalsIgnoreCase("Select")) {
                L10nOptionPaneBuilder.getInstance().showError((Object)"Scanner selection is mandatory to scan the document", (Component)parent, new Object[0]);
                return;
            }
            if (veCtxt != null) {
                veCtxt.reset();
                veCtxt.setMessage("Scanning Appointment Slip.Please Wait.");
            }
            DocumentUtils.getInstance().acquireImage(ScanMode.BLACK, "scannedImage", this.enrollmentService);
            File scannedFile = new File("scannedImage.jpg");
            if (!scannedFile.exists()) {
                throw new Exception("No scanned Image found");
            }
            LOGGER.debug("Image size of scanned document: " + scannedFile.length() / 1024L);
            this.showPreview(this.osd.getView(evt.getViewId()), scannedFile);
            this.scanAppointmentSlip(veCtxt, eMap, scannedFile, evt);
        }
        catch (Exception e) {
            LOGGER.error("Establishing connection with scanner failed", (Throwable)e);
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showError((Object)"Error connecting with scanner", (Component)parent, new Object[0]);
        }
    }

    private void scanAppointmentSlip(IVisualExecutionContext veCtxt, Map<String, IViewElement> eMap, File file, ILiteEvent evt) {
        Runnable runnable = () -> {
            try {
                ((IViewElement)eMap.get("eID_Appointment_SlipFileName")).set("text", (Object)file.getName());
                IAppointment appointment = this.appointmentService.scanAppointmentSlip(file);
                ((IViewElement)eMap.get("eID_Appointment_Status")).set("text", (Object)"Successfully scanned appointment QR data");
                ((IViewElement)eMap.get("eID_Appointment_ContinueBtn")).set("enable", (Object)true);
                ((IViewElement)eMap.get("eID_Appointment_Id")).set("text", (Object)appointment.getAppointmentId());
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error reading QR Code.", (Throwable)e);
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                ((IViewElement)eMap.get("eID_Appointment_SlipFileName")).set("text", (Object)"");
                ((IViewElement)eMap.get("eID_Appointment_Status")).set("text", (Object)"");
                ((IViewElement)eMap.get("eID_Appointment_Id")).set("text", (Object)"");
                ((IViewElement)eMap.get("eID_Appointment_ContinueBtn")).set("enable", (Object)false);
                L10nOptionPaneBuilder.getInstance().showError((Object)"Error reading QR Code. Attached file does not contain correct QR Code", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            }
        };
        runnable.run();
    }

    private void showPreview(ILiteView view, File scannedDoc) {
        block6: {
            if (scannedDoc == null || !scannedDoc.exists()) {
                return;
            }
            IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
            if (veCtxt != null) {
                veCtxt.reset();
                veCtxt.setMessage(MsgKeysDocuments.VEX_SCAN_PREVIEW.toString());
            }
            try {
                String scafID = this.osd.compose(this.osd.getScaffoldForView(view.getId()).getId(), "scanPreviewWin", "scanPreview");
                ILiteView previewView = this.osd.getView(this.osd.getScaffold(scafID).getViewId());
                Map osiMap = previewView.getElementMap();
                byte[] image = FileUtils.readFileToByteArray((File)scannedDoc);
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                if (image != null) {
                    IViewElement previewLabel = (IViewElement)osiMap.get("eID_Scan_ImageView");
                    previewLabel.set("image", (Object)image);
                    previewLabel.set("displayMode", (Object)DisplayMode.AUTO_FIT);
                    this.osd.display(scafID, ScaffoldPlacement.CENTERED);
                }
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
                if (veCtxt == null) break block6;
                veCtxt.cancel();
            }
        }
    }

    @EventHandler(name="hID_Appointment_Continue", method="actionPerformed")
    public void onContinue(ILiteEvent evt) {
        IAppointment appointment = this.appointmentService.getAppointmentDetails();
        if (appointment.getAppointmentType() == AppointmentTypeEnum.NEW) {
            if (!this.enrollmentService.isUniversalClientTrnx()) {
                this.enrollmentService.initiateNewEnrollment();
            } else {
                this.enrollmentService.initiateUcEnrollment(this.enrollmentService.isPACValidationRequired());
            }
            NewEnrolment newEnrolment = ((NewEnrolAppointment)appointment).getNewEnrolment();
            PersonalDetail personalDetails = this.enrollmentService.getDemoPersonalDetails();
            Contact demoContactDetails = this.enrollmentService.getDemoContactDetails();
            this.enrollmentService.getDemographics().getResidentialStatus().setNRI(newEnrolment.isNRI());
            personalDetails.setFullName(newEnrolment.getFullName());
            personalDetails.setFullNameLocal(this.getTransliteratedText(newEnrolment.getFullName()));
            this.enrollmentService.setAppointment(appointment);
            personalDetails.setApplicantGender(newEnrolment.getGender());
            boolean dobVerified = StringUtils.isNotBlank((String)newEnrolment.getDob());
            personalDetails.getAgeDob().setDobSelected(dobVerified);
            personalDetails.getAgeDob().setVerified(dobVerified);
            this.enrollmentService.getReferences().getPob().setMandatory(dobVerified);
            personalDetails.getAgeDob().setDob(newEnrolment.getDob());
            personalDetails.getAgeDob().setAge(String.valueOf(newEnrolment.getAge()));
            demoContactDetails.getMobile().setNumber(newEnrolment.getMobileNo());
            demoContactDetails.getMobile().setIsdCode(newEnrolment.getIsdCode());
            demoContactDetails.getEmail().setEmail(newEnrolment.getEmail());
            this.populateAddress(newEnrolment.getAddress());
            this.populateHofDetails(newEnrolment.getHeadOfFamily());
            boolean child = personalDetails.getAgeDob().isChild();
            this.enrollmentService.setChildEnrollment(child);
            this.enrollmentService.getFingerPrint().setMandatory(!child);
            this.enrollmentService.getIris().setMandatory(!child);
            if (this.enrollmentService.isUniversalClientTrnx()) {
                this.evtCtxt.fireGenericEvent("hID_Online_Enrol", new Object[]{evt});
            } else {
                this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{evt, false, false, false, false});
            }
        } else if (appointment.getAppointmentType() == AppointmentTypeEnum.UPDATE) {
            Address newAddress;
            this.enrollmentService.initiateUpdateEnrollment(false, false, false);
            UpdateEnrolment updateEnrolment = ((UpdateEnrolAppointment)appointment).getUpdateEnrolment();
            PersonalDetail personalDetails = this.enrollmentService.getDemoPersonalDetails();
            Contact demoContactDetails = this.enrollmentService.getDemoContactDetails();
            this.enrollmentService.setAppointment(appointment);
            personalDetails.setFullName(updateEnrolment.getFullName());
            personalDetails.setFullNameLocal(this.getTransliteratedText(updateEnrolment.getFullName()));
            personalDetails.getAadhaarNumber().setAadhaarNumber(updateEnrolment.getAadhaarId());
            this.enrollmentService.getDemographics().getResidentialStatus().setNRI(updateEnrolment.isNRI());
            boolean isChild = "resident less than 5 years old".equals(updateEnrolment.getBiometricUpdate());
            boolean isBiometric = "biometric update".equals(updateEnrolment.getBiometricUpdate());
            boolean isMandatoryBiometric = "mandatory biometric update".equals(updateEnrolment.getBiometricUpdate());
            this.enrollmentService.setChildEnrollment(isChild);
            this.enrollmentService.setBiometricUpdate(isBiometric);
            this.enrollmentService.setMandatoryBiometricUpdate(isMandatoryBiometric);
            this.enrollmentService.getFingerPrint().setMandatory(!isChild && (isBiometric || isMandatoryBiometric));
            this.enrollmentService.getIris().setMandatory(!isChild && (isBiometric || isMandatoryBiometric));
            if (updateEnrolment.isNameUpdated()) {
                personalDetails.getName().setUpdated(true);
                personalDetails.setNewName(updateEnrolment.getNewName());
                this.enrollmentService.getReferences().getPoi().setMandatory(true);
            }
            if (updateEnrolment.isDobUpdated()) {
                AgeDob ageDob = personalDetails.getAgeDob();
                ageDob.setUpdated(true);
                ageDob.setDobSelected(true);
                ageDob.setDob(updateEnrolment.getNewDob());
                ageDob.setVerified(true);
                this.enrollmentService.getReferences().getPob().setMandatory(true);
                boolean child = ageDob.isChild();
                this.enrollmentService.getFingerPrint().setMandatory(!child && (isBiometric || isMandatoryBiometric));
                this.enrollmentService.getIris().setMandatory(!child && (isBiometric || isMandatoryBiometric));
            }
            if (updateEnrolment.isMobileNumberUpdated()) {
                demoContactDetails.getMobile().setUpdated(true);
                demoContactDetails.getMobile().setNumber(updateEnrolment.getNewMobile());
                demoContactDetails.getMobile().setIsdCode(updateEnrolment.getNewIsdCode());
            }
            if (updateEnrolment.isEmailUpdated()) {
                demoContactDetails.getEmail().setUpdated(true);
                demoContactDetails.getEmail().setEmail(updateEnrolment.getNewEmail());
            }
            if (updateEnrolment.isGenderUpdated()) {
                personalDetails.getApplicantGender().setUpdated(true);
                personalDetails.setApplicantGender(updateEnrolment.getNewGender());
            }
            if ((newAddress = updateEnrolment.getNewAddress()) != null) {
                this.populateAddress(newAddress);
                this.enrollmentService.getDemoContactDetails().getAddress().setUpdated(true);
                this.enrollmentService.getReferences().getPoa().setMandatory(true);
            }
            this.populateHofDetails(updateEnrolment.getHeadOfFamily());
            this.evtCtxt.fireGenericEvent("hID_Enrol", new Object[]{evt, false, true, false, false});
        } else {
            L10nOptionPaneBuilder.getInstance().showError((Object)"Invalid QR code. Please check your appointment slip.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
    }

    private void populateHofDetails(HeadOfFamily hof) {
        if (hof != null) {
            ReferenceRelative relativeDetails = this.enrollmentService.getRelativeDetails();
            relativeDetails.setMandatory(true);
            relativeDetails.setRelationshipType(RelationshipType.fromMnemonic((String)hof.getType()));
            relativeDetails.setName(hof.getName());
            String aadhaarId = hof.getAadhaarId();
            String enrolmentId = hof.getEnrolmentId();
            if (StringUtils.isNotBlank((String)aadhaarId)) {
                relativeDetails.setAadhaarNumberSelected(true);
                relativeDetails.setAadhaarNumber(aadhaarId);
            } else if (StringUtils.isNotBlank((String)enrolmentId) && enrolmentId.length() == 28) {
                relativeDetails.setEnrolmentIdSelected(true);
                relativeDetails.setEnrolmentId(enrolmentId.substring(0, 14));
                relativeDetails.setEnrolmentDateTime(enrolmentId.substring(14));
            }
        }
    }

    private void populateAddress(Address newAddress) {
        PostalAddress locPOA;
        in.gov.uidai.ec.service.enrollment.model.Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        address.setCareOfName(newAddress.getCareOfName());
        address.setCareOfNameLocal(this.getTransliteratedText(newAddress.getCareOfName()));
        address.setBuilding(newAddress.getHouseNo());
        address.setBuildingLocal(this.getTransliteratedText(newAddress.getHouseNo()));
        address.setStreet(newAddress.getStreet());
        address.setStreetLocal(this.getTransliteratedText(newAddress.getStreet()));
        address.setLandmark(newAddress.getLandmark());
        address.setLandmarkLocal(this.getTransliteratedText(newAddress.getLandmark()));
        address.setLocality(newAddress.getArea());
        address.setLocalityLocal(this.getTransliteratedText(newAddress.getArea()));
        address.setDistrict(newAddress.getDistrictPostalAddress());
        address.setState(newAddress.getStatePostalAddress());
        address.setPinCode(newAddress.getPincodePostalAddress());
        address.setVTC(newAddress.getVtcPostalAddress());
        address.getPinCodeDetail().getSubDistrict().setAddressValue(newAddress.getPostOfficeNamePostalAddress());
        address.getPinCodeDetail().getSubDistrict().setAddressValueLocal(this.getTransliteratedText(newAddress.getPostOfficeNamePostalAddress().getAddressValue()));
        PostOffice postOffice = new PostOffice();
        postOffice.setVTCCode(newAddress.getVtcCode());
        postOffice.setPincode(newAddress.getPincode());
        postOffice.setVTCName(newAddress.getVtc());
        List options = this.postOfficeDataService.findPostOffices(Integer.parseInt(newAddress.getPincode()), newAddress.getVtcPostalAddress());
        String languageCode = UidLocaleUtils.getLangCodeFrmLocaleStr((String)this.uiPref.getTransliterationLocale("hi_IN"));
        if (options != null && !options.isEmpty()) {
            if (options.size() > 1) {
                PostOffice select = new PostOffice();
                select.setName("Select");
                options.add(0, select);
            } else {
                postOffice.setName(((PostOffice)options.get(0)).getName());
                postOffice.setLocaleName(this.getTransliteratedText(((PostOffice)options.get(0)).getName()));
                address.getPinCodeDetail().setDefaultPoName(((PostOffice)options.get(0)).getName());
                PostOffice locPO = this.postOfficeDataService.findLocalePostOffice(newAddress.getPincode(), newAddress.getVtcPostalAddress().getAddressCode(), ((PostOffice)options.get(0)).getName(), languageCode);
                postOffice.setLocaleName(locPO != null ? locPO.getLocaleName() : this.getTransliteratedText(((PostOffice)options.get(0)).getName()));
            }
            address.getPinCodeDetail().setPostOfficeList(options);
        }
        if ((locPOA = this.postOfficeDataService.findLocalePostalAddress(newAddress.getPincode(), newAddress.getVtcPostalAddress().getAddressCode(), newAddress.getPostOfficeNamePostalAddress().getAddressCode(), newAddress.getDistrictPostalAddress().getAddressCode(), newAddress.getStatePostalAddress().getAddressCode(), languageCode)) != null) {
            address.setDistrictLocal(locPOA.getDistrict().getAddressValue());
            address.setStateLocal(locPOA.getState().getAddressValue());
            address.setPinCodeLocal(locPOA.getPincode());
            address.setVTCLocal(locPOA.getVtc().getAddressValue());
            address.setSubDistrictLocal(locPOA.getSubDistrict().getAddressValue());
        } else {
            address.setDistrictLocal(this.getTransliteratedText(newAddress.getDistrictPostalAddress().getAddressValue()));
            address.setStateLocal(this.getTransliteratedText(newAddress.getStatePostalAddress().getAddressValue()));
            address.setPinCodeLocal(this.getTransliteratedText(newAddress.getPincodePostalAddress().getAddressValue()));
            address.setVTCLocal(this.getTransliteratedText(newAddress.getVtcPostalAddress().getAddressValue()));
        }
        address.setPostOffice(postOffice);
    }

    private String getTransliteratedText(String text) {
        if (this.localeSpec.equalsIgnoreCase("en_in")) {
            return text;
        }
        return this.tlitProv.transliterate(text, this.localeSpec, new TransliterationHints[0]).trim();
    }

    public void setVerificationGuard(VerificationGuard verificationGuard) {
        this.verificationGuard = verificationGuard;
    }
}

