/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.biologin;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.json.bioauth.BioAuthTokenData;
import in.gov.uidai.ec.rd.device.xml.PidData;
import in.gov.uidai.ec.rd.device.xml.additional_info;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.ConfirmerDetails;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.session.IOAuthSessionService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.biologin.AuthWrapper25Request;
import in.gov.uidai.ec.ui.biologin.AuthWrapperRequest;
import in.gov.uidai.ec.ui.biologin.BioAuthResponse;
import in.gov.uidai.ec.ui.biologin.BioLoginViewPeer;
import in.gov.uidai.ec.ui.biologin.BiometricType;
import in.gov.uidai.ec.ui.biologin.UserType;
import in.gov.uidai.ec.ui.biologin.pid.AdditionalInfo;
import in.gov.uidai.ec.ui.biologin.pid.Data;
import in.gov.uidai.ec.ui.biologin.pid.DeviceInfo;
import in.gov.uidai.ec.ui.biologin.pid.Info;
import in.gov.uidai.ec.ui.biologin.pid.PidAuthWrapper;
import in.gov.uidai.ec.ui.biologin.pid.Resp;
import in.gov.uidai.ec.ui.biologin.pid.Skey;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioLoginController
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioLoginController.class);
    private final BioLoginViewPeer view;
    private final IOAuthSessionService sessionService;
    private final boolean isEnrolmentWithRdBiometric;
    private final ConfirmerDetails confirmerDetails;
    private final Map<RDCaptureType, Boolean> isSignatureVerified = new HashMap<RDCaptureType, Boolean>();
    private static final String TID = "registered";
    private boolean isBioSuccess;

    BioLoginController(BioLoginViewPeer viewElements) {
        super(viewElements.getView(), viewElements.enrollmentService, -1, -1);
        this.view = viewElements;
        this.sessionService = viewElements.sessionService;
        this.isEnrolmentWithRdBiometric = viewElements.isRDBasedUpdate;
        this.confirmerDetails = this.enrollmentService.getConfirmerDetails();
        this.initView();
    }

    private void initView() {
        this.addStartCaptureListener(this.view.fingerField, this::onStartCapture);
        this.addStartCaptureListener(this.view.irisField, this::onStartCapture);
        this.addBiometricsListener(this.view.fingerField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.irisField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        if (this.isEnrolmentWithRdBiometric) {
            AuthParamType authParamType = this.getAuthType(this.view.bioDataTokenManager.getUserType());
            this.addRDBiometricsListener(this.view.bioPanel.getRDBioField(authParamType, this.view.authTypeIsFinger() ? DeviceType.FINGERPRINT_AUTH : DeviceType.IRIS_AUTH), e -> this.enableSaveButton());
            this.view.bioPanel.getVerifyButton().entrySet().iterator().next().getValue().setVisible(false);
            this.view.biometricsAuthService.addBiometricsVerifiedListener(this::onRDSignatureCapture);
        }
        this.addActionListener(this.view.saveButton, this::onSaveButtonClick);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!BioLoginController.this.isBioSuccess) {
                    LOGGER.info("Closing Biometric Panel Now after waiting for 2 minutes");
                    ((BioLoginController)BioLoginController.this).view.closeButton.doClick();
                }
            }
        }, 120000L);
    }

    private void onStartCapture(String fieldLabel) {
        LOGGER.info("Started new biometric capture for " + fieldLabel);
        this.view.saveButton.setEnabled(false);
    }

    private AuthParamType getAuthType(UserType type) {
        if (UserType.OPERATOR.equals((Object)type)) {
            return AuthParamType.OPERATOR;
        }
        if (UserType.RESIDENT.equals((Object)type)) {
            return AuthParamType.RESIDENT;
        }
        return AuthParamType.HOF;
    }

    private void onSaveButtonClick(ActionEvent evt) {
        IVisualExecutionContext veCtxt = this.view.getView().getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage("Authenticating, please wait.");
        }
        ThreadPool.commonPool().submit(() -> {
            try {
                boolean isOperator = this.view.bioDataTokenManager.getUserType().equals((Object)UserType.OPERATOR);
                BioAuthResponse response = null;
                if (this.isEnrolmentWithRdBiometric) {
                    AuthWrapper25Request rdRequest = this.prepareAuth25Request();
                    this.enableBiometricFields(false);
                    response = this.enrollmentService.bioRDAuth(rdRequest, isOperator);
                } else {
                    AuthWrapperRequest request = this.prepareAuthRequest();
                    this.enableBiometricFields(false);
                    response = this.enrollmentService.bioAuth(request, isOperator);
                }
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                if (response.failure()) {
                    if (!response.isOpSessionActive()) {
                        L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_OP_001.getReason(), (Component)this.view.getContentPane(), ErrorCodes.UC_OP_001.getErrorCode(), this.view.bioDataTokenManager.getBioLoginTransactionId(), new Object[0]);
                        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientExceptionFromEnum((ErrorCodes)ErrorCodes.UC_OP_001, (String)this.view.bioDataTokenManager.getBioLoginTransactionId(), (Exception)new Exception(ErrorCodes.UC_OP_001.getReason()))), ErrorCodes.UC_OP_001.getErrorCode(), new String[0]);
                    } else {
                        LOGGER.error("Error connecting to BioAuth server while Initial Login : {}, Error code: {}", (Object)CommonUtilsUC.getErrorMessage((UosResponse)response), (Object)CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()));
                        L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage((UosResponse)response), (Component)this.view.getContentPane(), CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), this.view.bioDataTokenManager.getBioLoginTransactionId(), new Object[0]);
                        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), (String)CommonUtilsUC.getErrorMessage((UosResponse)response), (String)this.view.bioDataTokenManager.getBioLoginTransactionId(), (Exception)new Exception(CommonUtilsUC.getErrorMessage((UosResponse)response)))), CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), new String[0]);
                    }
                    this.enrollmentService.fireBioLoginFailure();
                }
                this.isBioSuccess = true;
            }
            catch (OnlineGatewayException e) {
                LOGGER.error("Failed while calling bioAuth Api: {}", (Object)e.getMessage());
                if (veCtxt != null) {
                    veCtxt.cancel();
                }
                L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)this.view.getContentPane(), e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
                this.enrollmentService.fireBioLoginFailure();
                this.enableBiometricFields(true);
            }
            finally {
                this.view.closeButton.doClick();
            }
        });
    }

    private void enableBiometricFields(boolean enable) {
        this.enableBioField(this.view.fingerField, enable);
        this.enableBioField(this.view.irisField, enable);
    }

    private void enableBioField(BiometricsNonRDField biometricsNonRDField, boolean enable) {
        if (biometricsNonRDField != null) {
            biometricsNonRDField.setEnabled(enable);
        }
    }

    private void onRDSignatureCapture(RDCaptureType captureType, Signature signature, CaptureAttempt captureAttempt) {
        this.isSignatureVerified.putIfAbsent(captureType, true);
        BodyPart bodyPart = captureType.getDeviceType() == DeviceType.FINGERPRINT_AUTH ? BodyPart.THUMB_LEFT : BodyPart.IRIS_LEFT;
        BiometricsCapture bioCapture = this.confirmerDetails.getBioCapture(captureAttempt, bodyPart);
        if (captureType.getUserType() == AuthParamType.OPERATOR) {
            UserDetails userDetails = this.populateOperatorDemoDetails();
            userDetails.setSignature(signature);
            userDetails.setBiometrics(bioCapture);
            this.confirmerDetails.setOperator(userDetails);
        }
        boolean isOperatorBioVerified = this.confirmerDetails.getOperator().getSignature() != null;
        AuthParamType authParamType = this.getAuthType(this.view.bioDataTokenManager.getUserType());
        if (this.view.authTypeIsFinger()) {
            isOperatorBioVerified = isOperatorBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(authParamType, DeviceType.FINGERPRINT_AUTH), false) != false;
        } else {
            boolean bl = isOperatorBioVerified = isOperatorBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(authParamType, DeviceType.IRIS_AUTH), false) != false;
            if (!isOperatorBioVerified) {
                // empty if block
            }
            this.view.saveButton.setEnabled(true);
        }
    }

    private void enableSaveButton() {
        this.view.saveButton.setEnabled(true);
        this.view.savePanel.setBackground(new Color(19, 126, 178));
        this.view.enable = true;
    }

    private boolean validateBiometrics() {
        boolean status = true;
        status = this.view.authTypeIsFinger() ? this.validateBiometrics(this.view.fingerField) : (status &= this.validateBiometrics(this.view.irisField));
        if (status) {
            this.view.savePanel.setBackground(new Color(19, 126, 178));
            this.view.enable = true;
        }
        return status;
    }

    private boolean isBioCapturedAndValid(BiometricsNonRDField confirmField) {
        return true;
    }

    private CaptureAttempt getCaptureAttempt(BiometricsNonRDField biometricsNonRDField) {
        CaptureAttempt captureAttempt = biometricsNonRDField.getCaptureAttempt();
        if (!this.isBioCapturedAndValid(biometricsNonRDField)) {
            String message = "Failed to process " + biometricsNonRDField.getLabel() + " data. Please capture again.";
            this.showError((JComponent)biometricsNonRDField, message);
        }
        return captureAttempt;
    }

    private boolean validateBiometrics(BiometricsNonRDField opConfirmField) {
        return this.isBioCapturedAndValid(opConfirmField);
    }

    private void populateOperatorDetails() {
        UserDetails userDetails = this.populateOperatorDemoDetails();
        if (this.view.authTypeIsFinger()) {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.fingerField), BodyPart.THUMB_LEFT));
        } else {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.irisField), BodyPart.IRIS_LEFT));
        }
        this.populateLVSDetails(userDetails, false);
        this.confirmerDetails.setOperator(userDetails);
    }

    private UserDetails populateOperatorDemoDetails() {
        UserDetails userDetails = new UserDetails(this.enrollmentService);
        userDetails.setUserId(this.sessionService.getOperatorDetails().getOpUid());
        userDetails.setUid(this.sessionService.getOperatorDetails().getOpUid());
        userDetails.setFullName(this.sessionService.getOperatorDetails().getOpName());
        return userDetails;
    }

    public void populateLVSDetails(UserDetails ud, boolean isIntroducer) {
        try {
            OnBoardingStatus obStat = LVSLocator.instance().getStatus(ud.getUid());
            String allowedStatus = OnBoardingStatus.ONBOARD.name() + "|" + OnBoardingStatus.PARTIALLY_BOARDED + "|" + OnBoardingStatus.NOT_BOARDED;
            ud.setAllowedLvsStatus(isIntroducer ? allowedStatus : OnBoardingStatus.ONBOARD.name());
            ud.setCurrentLvsStatus(obStat == null ? OnBoardingStatus.NOT_BOARDED.name() : obStat.name());
            ud.setLvsCheck(true);
        }
        catch (Exception e) {
            ud.setLvsCheck(false);
        }
    }

    private AuthWrapperRequest prepareAuthRequest() {
        AuthWrapperRequest request = new AuthWrapperRequest();
        BioAuthTokenData bioAuthTokenData = this.view.getTokenData();
        request.setUid(bioAuthTokenData.getUser_id());
        request.setOauthSessionId(bioAuthTokenData.getSessionId());
        request.setOauthTxnId(bioAuthTokenData.getTxn());
        byte[] data = null;
        if (this.view.authTypeIsFinger()) {
            data = this.view.fingerField.getCaptureAttempt().getImage().getOriginalData();
            this.view.fingerField.getCaptureAttempt().delete();
            request.setBiometricType(BiometricType.FIR);
        } else {
            data = this.view.irisField.getCaptureAttempt().getImage().getOriginalData();
            this.view.irisField.getCaptureAttempt().delete();
            request.setBiometricType(BiometricType.IIR);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
        try {
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        request.setBiometricData(Base64.getEncoder().encodeToString(encData));
        return request;
    }

    private AuthWrapper25Request prepareAuth25Request() {
        AuthParamType authParamType = this.getAuthType(this.view.bioDataTokenManager.getUserType());
        PidData pidData = this.view.bioPanel.getRDBioField(authParamType, this.view.authTypeIsFinger() ? DeviceType.FINGERPRINT_AUTH : DeviceType.IRIS_AUTH).getPidData();
        this.view.bioPanel.getRDBioField(authParamType, this.view.authTypeIsFinger() ? DeviceType.FINGERPRINT_AUTH : DeviceType.IRIS_AUTH).getCaptureAttempt().delete();
        BioAuthTokenData bioAuthTokenData = this.view.getTokenData();
        PidAuthWrapper pidAuthWrapper = new PidAuthWrapper();
        Data data = new Data();
        data.setType(this.view.authTypeIsFinger() ? "FMR" : "IIR");
        data.setValue(Base64.getEncoder().encodeToString(pidData.getData()));
        Resp resp = new Resp();
        resp.setErrorCode(this.stringToInt(pidData.getResp().getErrCode()));
        resp.setErrorInfo(pidData.getResp().getErrInfo());
        resp.setfCount(this.stringToInt(pidData.getResp().getfCount()));
        resp.setfType(this.stringToInt(pidData.getResp().getfType()));
        resp.setiCount(this.stringToInt(pidData.getResp().getiCount()));
        resp.setiType(0);
        resp.setpCount(this.stringToInt(pidData.getResp().getpCount()));
        resp.setpType(0);
        resp.setNmPoints(this.stringToInt(pidData.getResp().getNmPoints()));
        resp.setqScore(this.stringToInt(pidData.getResp().getqScore()));
        Skey skey = new Skey();
        skey.setCi(pidData.getSkey().getCi());
        skey.setValue(Base64.getEncoder().encodeToString(pidData.getSkey().getValue()));
        List infoList = ((additional_info)pidData.getDeviceInfo().getAdditional_info().get(0)).getParam().stream().map(o -> new Info(o.getName())).collect(Collectors.toList());
        AdditionalInfo additionalInfo = new AdditionalInfo();
        additionalInfo.setInfo(infoList);
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDc(pidData.getDeviceInfo().getDc());
        deviceInfo.setDpId(pidData.getDeviceInfo().getDpId());
        deviceInfo.setMc(pidData.getDeviceInfo().getMc());
        deviceInfo.setMi(pidData.getDeviceInfo().getMi());
        deviceInfo.setRdsId(pidData.getDeviceInfo().getRdsId());
        deviceInfo.setRdsVer(pidData.getDeviceInfo().getRdsVer());
        deviceInfo.setAdditionalInfo(additionalInfo);
        pidAuthWrapper.setData(data);
        pidAuthWrapper.setResp(resp);
        pidAuthWrapper.setHmac(Base64.getEncoder().encodeToString(pidData.getHmac()));
        pidAuthWrapper.setsKey(skey);
        pidAuthWrapper.setDeviceInfo(deviceInfo);
        AuthWrapper25Request request = new AuthWrapper25Request();
        request.setUid(bioAuthTokenData.getUser_id());
        request.setTid(TID);
        request.setRdPidData(pidAuthWrapper);
        request.setOauthTxnId(bioAuthTokenData.getTxn());
        request.setOauthSessionId(bioAuthTokenData.getSessionId());
        return request;
    }

    private int stringToInt(String num) {
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

