/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.biologin;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.json.bioauth.BioAuthTokenData;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.session.IOAuthSessionService;
import in.gov.uidai.ec.ui.biologin.BioAuthType;
import in.gov.uidai.ec.ui.biologin.BioLoginController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.enrol.osi.IEnrolOsiConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysBio;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import in.gov.uidai.swing.bio.confirm.DefaultConfirmPositions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class BioLoginViewPeer
extends StandardViewPeer
implements IEnrolOsiConstants {
    private ActionListener cancelListener;
    @ExportViewElement(as="eID_OSI_Finger_OpLoginBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField fingerField;
    @ExportViewElement(as="eID_OSI_Iris_OpBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField irisField;
    protected IOAuthSessionService sessionService;
    protected EnrollmentService enrollmentService;
    protected JButton saveButton;
    protected JButton closeButton;
    protected BiometricsRDAuthPanel bioPanel;
    protected boolean isRDBasedUpdate;
    protected BiometricsAuthService biometricsAuthService;
    protected IResourceBundleContext rbCtxt;
    private IUIPreference uiPref;
    private IClientDeviceManager cdm;
    private IPreSyncPreference preSyncPref;
    private L10nDecorator ldeco;
    protected TokenManager bioDataTokenManager;
    private static final Color customBlue = new Color(19, 126, 178);
    protected JPanel savePanel;
    private JLabel saveLabel;
    private JPanel closePanel;
    private JLabel closeLabel;
    protected boolean enable;

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.cdm = cdm;
    }

    public void setSessionService(IOAuthSessionService iSessionService) {
        this.sessionService = iSessionService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public void setBioDataTokenManager(TokenManager bioDataTokenManager) {
        this.bioDataTokenManager = bioDataTokenManager;
    }

    public IEventContext getEventCtx() {
        return super.getEventContext();
    }

    protected void enableImpl(boolean flag) {
        this.getContentPane().setCursor(flag ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(3));
    }

    protected void prepareImpl() {
        this.setMenuBar(null);
        if (this.cdm.getRegisteredDeviceManager().getDeviceContext(DeviceType.FINGERPRINT_AUTH) != null) {
            this.isRDBasedUpdate = true;
        }
        this.ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        this.bioPanel = new BiometricsRDAuthPanel(this.rbCtxt, this.uiPref, this.cdm);
        this.savePanel = new JPanel();
        this.saveLabel = new JLabel("Authenticate");
        this.saveLabel.setFont(new Font("Segoe UI", 1, 14));
        this.saveLabel.setForeground(Color.white);
        this.saveLabel.setHorizontalAlignment(0);
        this.closePanel = new JPanel();
        this.closeLabel = new JLabel("Close");
        this.closeLabel.setFont(new Font("Segoe UI", 1, 14));
        this.closeLabel.setForeground(Color.white);
        this.closeLabel.setHorizontalAlignment(0);
        this.addListener(this.savePanel);
        this.addListener(this.closePanel);
        TransparentBox cntPane = new TransparentBox();
        cntPane.setLayout((LayoutManager)new BoxLayout((Container)cntPane, 1));
        cntPane.add((Component)this.createConfirmArea());
        cntPane.add((Component)this.createNavArea());
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false, this.ldeco));
        super.setContentPane((JComponent)cntPane);
        new BioLoginController(this);
        if (this.isRDBasedUpdate) {
            new BiometricsRDAuthController(this.getView(), this.bioPanel, this.biometricsAuthService);
        }
    }

    protected void disposeImpl() {
        if (this.fingerField != null) {
            this.fingerField.removeAll();
            this.fingerField = null;
        }
        if (this.irisField != null) {
            this.irisField.removeAll();
        }
        if (this.saveButton != null) {
            this.saveButton.removeAll();
        }
        if (this.closeButton != null) {
            this.closeButton.removeAll();
        }
        if (this.savePanel != null) {
            this.savePanel.removeAll();
        }
        if (this.closePanel != null) {
            this.closePanel.removeAll();
        }
    }

    private BiometricsNonRDField createConfirmField(LabelKeysBio labelKeysBio, String exportName, BiometricPosition position) {
        BiometricsNonRDField result = new BiometricsNonRDField(labelKeysBio.toString());
        result.allowForcedCapture(false);
        result.setClientDeviceManager(this.cdm);
        result.localize(this.ldeco);
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", exportName);
        result.hidePositionSelector();
        result.setConfirmPositions((IConfirmPositions)new DefaultConfirmPositions(Collections.singletonList(position)));
        return result;
    }

    private JComponent createConfirmArea() {
        double[][] guides = new double[][]{{55.0, 170.0}, {5.0, 22.0, 5.0, 250.0, 5.0, 0.0, 22.0, 250.0, 5.0, 0.0, 5.0, 22.0}};
        if (this.isRDBasedUpdate) {
            guides[1][11] = 0.0;
        }
        if (this.isRDBasedUpdate) {
            guides[1][5] = 22.0;
            guides[1][9] = 22.0;
        }
        if (this.authTypeIsFinger()) {
            guides[1][3] = 0.0;
            guides[1][6] = 0.0;
            if (this.isRDBasedUpdate) {
                guides[1][9] = 22.0;
            }
        } else {
            guides[1][6] = 0.0;
            guides[1][7] = 0.0;
            if (this.isRDBasedUpdate) {
                guides[1][5] = 22.0;
            }
        }
        TransparentBox confirmArea = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        confirmArea.setBorder((Border)new EmptyBorder(0, 5, 0, 5));
        if (this.authTypeIsFinger()) {
            if (this.isRDBasedUpdate) {
                AuthParamType authParamType = this.getAuthParamType();
                BiometricsRDField biometricsRDField = this.bioPanel.createRDFingerArea(authParamType);
                biometricsRDField.hidePositionSelector();
                confirmArea.add((Component)biometricsRDField, (Object)"0, 7, 1, 6, full, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(authParamType, DeviceType.FINGERPRINT_AUTH), (Object)"0, 9, 1, 9, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(authParamType, DeviceType.FINGERPRINT_AUTH), (Object)"0, 9, 1, 9, center, full");
            } else {
                LabelKeysBio labelKeysBio = this.getLabelKeys();
                this.fingerField = this.createConfirmField(labelKeysBio, "eID_OSI_Finger_OpLoginBio", BiometricPosition.UNKNOWN);
                this.fingerField.setConfirmUid(this.getOpUid());
                confirmArea.add((Component)this.fingerField, (Object)"0, 7, 1, 6, full, full");
            }
        } else if (this.isRDBasedUpdate) {
            AuthParamType authParamType = this.getAuthParamType();
            BiometricsRDField biometricsRDField = this.bioPanel.createRDIrisArea(authParamType);
            biometricsRDField.hidePositionSelector();
            confirmArea.add((Component)biometricsRDField, (Object)"0, 3, 1, 2, full, full");
            confirmArea.add((Component)this.bioPanel.createVerifyButton(authParamType, DeviceType.IRIS_AUTH), (Object)"0, 5, 1, 5, center, full");
            confirmArea.add((Component)this.bioPanel.createVerifyLabel(authParamType, DeviceType.IRIS_AUTH), (Object)"0, 5, 1, 5, center, full");
        } else {
            LabelKeysBio labelKeysBio = this.getLabelKeys();
            this.irisField = this.createConfirmField(labelKeysBio, "eID_OSI_Iris_OpBio", BiometricPosition.LEFT_IRIS);
            this.irisField.setConfirmUid(this.getOpUid());
            confirmArea.add((Component)this.irisField, (Object)"0, 3, 1, 2, full, full");
        }
        return confirmArea;
    }

    private AuthParamType getAuthParamType() {
        switch (this.bioDataTokenManager.getUserType()) {
            case OPERATOR: {
                return AuthParamType.OPERATOR;
            }
            case RESIDENT: {
                return AuthParamType.RESIDENT;
            }
            case HOF: {
                return AuthParamType.HOF;
            }
        }
        return null;
    }

    private LabelKeysBio getLabelKeys() {
        boolean isFinger = this.authTypeIsFinger();
        switch (this.bioDataTokenManager.getUserType()) {
            case OPERATOR: {
                return isFinger ? LabelKeysBio.OPERATOR_FINGER : LabelKeysBio.OPERATOR_IRIS;
            }
            case RESIDENT: {
                return isFinger ? LabelKeysBio.RESIDENT_FINGER : LabelKeysBio.RESIDENT_IRIS;
            }
            case HOF: {
                return isFinger ? LabelKeysBio.HOF_FINGER : LabelKeysBio.HOF_IRIS;
            }
        }
        return null;
    }

    private JComponent createNavArea() {
        this.saveButton = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.SAVE, new Object[0]));
        this.ldeco.localize((AbstractButton)this.saveButton, (Object)LabelKeysAction.SAVE, new Object[0]);
        this.saveButton.setEnabled(false);
        this.savePanel.setBackground(Color.gray);
        this.closePanel.setBackground(customBlue);
        this.buttonViewPeer(this.savePanel, this.saveLabel);
        this.buttonViewPeer(this.closePanel, this.closeLabel);
        this.closeButton = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.CANCEL, new Object[0]));
        this.ldeco.localize((AbstractButton)this.closeButton, (Object)LabelKeysAction.CANCEL, new Object[0]);
        this.cancelListener = (ActionListener)this.evtCtxt.getEventListener("closeWin", ActionListener.class);
        this.closeButton.addActionListener(b -> {
            this.disposeImpl();
            this.cancelListener.actionPerformed(b);
        });
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 5, 0, 5), (Border)new SingleLineBorder().drawEdges(true, false, false, false).lineColor("#999999").dashInterval("1, 1"));
        TransparentBox navArea = new TransparentBox((LayoutManager)new FlowLayout(1, 5, 10));
        navArea.setBorder((Border)border);
        navArea.add((Component)this.savePanel);
        navArea.add((Component)this.closePanel);
        return navArea;
    }

    private void addListener(final JPanel panel) {
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (panel == BioLoginViewPeer.this.savePanel && !BioLoginViewPeer.this.enable) {
                    return;
                }
                BioLoginViewPeer.this.selectPanel(panel);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (panel == BioLoginViewPeer.this.savePanel && BioLoginViewPeer.this.enable) {
                    BioLoginViewPeer.this.saveButton.doClick();
                } else if (panel == BioLoginViewPeer.this.closePanel) {
                    BioLoginViewPeer.this.closeButton.doClick();
                } else {
                    return;
                }
                BioLoginViewPeer.this.unSelectPanel(panel);
            }
        });
    }

    private void selectPanel(JPanel panel) {
        panel.setBackground(Color.white);
        panel.getComponent(0).setForeground(customBlue);
    }

    private void unSelectPanel(JPanel panel) {
        panel.setBackground(customBlue);
        panel.getComponent(0).setForeground(Color.white);
    }

    private void buttonViewPeer(JPanel panel, JLabel label) {
        GroupLayout savePanelLayout = new GroupLayout(panel);
        panel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label, GroupLayout.Alignment.TRAILING, -1, 100, Short.MAX_VALUE));
        savePanelLayout.setVerticalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label, GroupLayout.Alignment.TRAILING, -1, 31, Short.MAX_VALUE));
    }

    protected boolean authTypeIsFinger() {
        return this.bioDataTokenManager.getBioAuthType().equals((Object)BioAuthType.finger);
    }

    protected String getOpUid() {
        return this.getTokenData().getUser_id();
    }

    protected BioAuthTokenData getTokenData() {
        String authToken = this.bioDataTokenManager.getBioAuthToken();
        return this.bioDataTokenManager.extractTokenFields(authToken);
    }
}

