/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.biometricsauth;

import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.biometricsauth.model.LeftIrisAuth;
import in.gov.uidai.ec.service.biometricsauth.model.SingleFingerAuth;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsNonRDAuthPanel;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import javax.swing.JComponent;

public class BiometricsNonRDAuthController
extends ControllerBase {
    private final BiometricsNonRDAuthPanel bioPanel;
    private final BiometricsAuthService biometricsAuthService;
    private boolean enableAuthentication;

    public BiometricsNonRDAuthController(ILiteView view, BiometricsNonRDAuthPanel bioPanel, BiometricsAuthService biometricsAuthService) {
        super(view);
        this.bioPanel = bioPanel;
        this.biometricsAuthService = biometricsAuthService;
        this.enableAuthentication = true;
        this.initView();
    }

    private void initView() {
        if (this.bioPanel.fingerAuthField != null) {
            this.bioPanel.fingerAuthField.addCaptureAttemptChangeListeners(this::onFingerCaptureAttempt);
        }
        if (this.bioPanel.irisConfirmField != null) {
            this.bioPanel.irisConfirmField.addCaptureAttemptChangeListeners(this::onIrisCaptureAttempt);
        }
    }

    public void setEnableAuthentication(boolean enableAuthentication) {
        this.enableAuthentication = enableAuthentication;
    }

    private void onFingerCaptureAttempt(CaptureAttempt captureAttempt, BiometricPosition biometricPosition) {
        if (captureAttempt == null) {
            return;
        }
        BiometricsNonRDField fingerAuthField = this.bioPanel.fingerAuthField;
        SingleFingerAuth fingerAuth = this.biometricsAuthService.getSingleFingerAuth();
        fingerAuth.setCaptureAttempt(captureAttempt, biometricPosition);
        if (this.enableAuthentication) {
            fingerAuth.setAuthValid(fingerAuthField.authenticate());
        } else {
            fingerAuth.setAuthValid(true);
        }
        if (!fingerAuth.isValid()) {
            this.showError((JComponent)fingerAuthField, fingerAuth.getAuthError());
            fingerAuthField.clearCaptureAttempt();
        }
    }

    private void onIrisCaptureAttempt(CaptureAttempt captureAttempt, BiometricPosition biometricPosition) {
        if (captureAttempt == null) {
            return;
        }
        BiometricsNonRDField irisConfirmField = this.bioPanel.irisConfirmField;
        LeftIrisAuth leftIrisAuth = this.biometricsAuthService.getLeftIrisAuth();
        leftIrisAuth.setCaptureAttempt(captureAttempt, biometricPosition);
        if (this.enableAuthentication) {
            leftIrisAuth.setAuthValid(irisConfirmField.authenticate());
        } else {
            leftIrisAuth.setAuthValid(true);
        }
        if (!leftIrisAuth.isValid()) {
            this.showError((JComponent)irisConfirmField, leftIrisAuth.getAuthError());
            irisConfirmField.clearCaptureAttempt();
        }
    }
}

