/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.biometricsauth;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.ui.biometricsauth.IBioAuthConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysLogin;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.confirm.BiometricFieldControlBarType;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.DefaultConfirmPositions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class BiometricsNonRDAuthPanel
implements IViewElementComposite,
IBioAuthConstants {
    private final L10nDecorator ldeco;
    private final IEventContext evtCtxt;
    private final IPreSyncPreference preSyncPref;
    private final IClientDeviceManager devMgr;
    @ExportViewElement(as="eID_LeftIrisBioConf", using=BiometricsElementFactory.class)
    public BiometricsNonRDField irisConfirmField;
    @ExportViewElement(as="eID_SingleFingerBioConf", using=BiometricsElementFactory.class)
    public BiometricsNonRDField fingerAuthField;

    public BiometricsNonRDAuthPanel(IResourceBundleContext rbCtxt, IUIPreference uiPref, DeviceLifeCycleListener deviceLifeCycleListener, IClientDeviceManager devMgr, IPreSyncPreference preSyncPref, IEventContext evtCtxt) {
        this.devMgr = devMgr;
        this.evtCtxt = evtCtxt;
        this.ldeco = new L10nDecorator(rbCtxt, uiPref.getApplicationLocalize(false));
        this.preSyncPref = preSyncPref;
        this.fingerAuthField = new BiometricsNonRDField(rbCtxt.getMessage((Object)LabelKeysLogin.FINGER_VERIFICATION, new Object[0]), BiometricFieldControlBarType.FingerSlabBar);
        this.irisConfirmField = new BiometricsNonRDField(rbCtxt.getMessage((Object)LabelKeysLogin.IRIS_VERIFICATION, new Object[0]), BiometricFieldControlBarType.IrisBar);
        this.fingerAuthField.setDeviceLifeCycleListener(deviceLifeCycleListener, DeviceType.FINGERPRINT);
        this.irisConfirmField.setDeviceLifeCycleListener(deviceLifeCycleListener, DeviceType.IRIS);
        this.fingerAuthField.setEnabled(false);
        this.irisConfirmField.setEnabled(false);
    }

    public JComponent createNonRDFingerArea() {
        this.fingerAuthField.allowForcedCapture(false);
        this.fingerAuthField.setClientDeviceManager(this.devMgr);
        this.fingerAuthField.localize(this.ldeco);
        this.fingerAuthField.hidePositionSelector();
        HashMap<String, Object> evtParams = new HashMap<String, Object>(){
            {
                this.put("prm_BioFieldName", "eID_SingleFingerBioConf");
            }
        };
        this.fingerAuthField.addQSSActionListener((ActionListener)this.evtCtxt.getEventListener("hID_QSS_Cfm", ActionListener.class, (Map)evtParams));
        this.fingerAuthField.setConfirmPositions((IConfirmPositions)new DefaultConfirmPositions(Collections.singletonList(BiometricPosition.UNKNOWN)));
        return this.fingerAuthField;
    }

    public JComponent createNonRDIrisArea() {
        this.irisConfirmField.allowForcedCapture(false);
        this.irisConfirmField.setClientDeviceManager(this.devMgr);
        this.irisConfirmField.localize(this.ldeco);
        this.irisConfirmField.hidePositionSelector();
        HashMap<String, Object> evtParams = new HashMap<String, Object>(){
            {
                this.put("prm_BioFieldName", "eID_LeftIrisBioConf");
            }
        };
        this.irisConfirmField.addQSSActionListener((ActionListener)this.evtCtxt.getEventListener("hID_QSS_Cfm", ActionListener.class, (Map)evtParams));
        this.irisConfirmField.setConfirmPositions((IConfirmPositions)new DefaultConfirmPositions(Collections.singletonList(BiometricPosition.LEFT_IRIS)));
        return this.irisConfirmField;
    }

    public boolean authTypeIsBoth() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.BOTH.toString());
    }

    public boolean authTypeIsIris() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.IRIS.toString());
    }

    public boolean authTypeIsFinger() {
        String authType = this.preSyncPref.getFingerIrisAuthType("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.FINGER.toString());
    }
}

