/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.biometricsauth;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BioVerificationException;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.biometricsauth.model.RDAuthBiometrics;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiometricsRDAuthController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiometricsRDAuthController.class);
    private final BiometricsRDAuthPanel bioPanel;
    private final BiometricsAuthService biometricsAuthService;
    private final IVisualExecutionContext veCtxt;

    public BiometricsRDAuthController(ILiteView view, BiometricsRDAuthPanel bioPanel, BiometricsAuthService biometricsAuthService) {
        super(view);
        this.bioPanel = bioPanel;
        this.biometricsAuthService = biometricsAuthService;
        this.veCtxt = view.getVisualExecutionContext();
        this.initView();
    }

    private void initView() {
        this.addListenerToRDBioCapture(AuthParamType.RESIDENT, DeviceType.FINGERPRINT_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.RESIDENT, DeviceType.IRIS_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS);
        this.addListenerToRDBioCapture(AuthParamType.OPERATOR, DeviceType.FINGERPRINT_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.OPERATOR, DeviceType.IRIS_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.OPERATOR, DeviceType.FINGER_OR_IRIS);
        this.addListenerToRDBioCapture(AuthParamType.SUPERVISOR, DeviceType.FINGERPRINT_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.SUPERVISOR, DeviceType.IRIS_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH);
        this.addListenerToRDBioCapture(AuthParamType.HOF, DeviceType.IRIS_AUTH);
    }

    private void addListenerToRDBioCapture(AuthParamType userType, DeviceType deviceType) {
        BiometricsRDField biometricsRdField = this.bioPanel.getRDBioField(userType, deviceType);
        if (biometricsRdField != null) {
            this.biometricsAuthService.getRdAuthBiometrics().clear(userType, deviceType);
            biometricsRdField.addCaptureAttemptChangeListeners((captureAttempt, capRdPid) -> this.onRdCaptureAttempt((CaptureAttempt)captureAttempt, (String)capRdPid, userType, deviceType));
        }
        this.addActionListener(this.bioPanel.getRDVerifyButton(userType, deviceType), (ActionEvent actionEvent) -> this.verifyRDBiometrics(userType, deviceType));
    }

    private void onRdCaptureAttempt(CaptureAttempt captureAttempt, String capRdPid, AuthParamType userType, DeviceType deviceType) {
        RDAuthBiometrics rdAuth = this.biometricsAuthService.getRdAuthBiometrics();
        if (captureAttempt == null) {
            rdAuth.clear(userType, deviceType);
            return;
        }
        rdAuth.setCapturedAttempt(userType, deviceType, captureAttempt, capRdPid);
    }

    public void verifyRDBiometrics(AuthParamType userType, DeviceType deviceType) {
        LOGGER.info("Initiated " + userType.toString() + " RD biometrics verification with server");
        if (this.veCtxt != null) {
            this.veCtxt.reset();
            this.veCtxt.setMessage("Verifying biometrics with server. Please wait.");
        }
        new Thread(() -> {
            JButton rdVerifyButton = this.bioPanel.getRDVerifyButton(userType, deviceType);
            BiometricsRDField rdBioField = this.bioPanel.getRDBioField(userType, deviceType);
            try {
                this.biometricsAuthService.verifyRDBiometricsAndUpdateSignature(userType, deviceType);
                rdVerifyButton.setVisible(false);
                this.bioPanel.getRDVerifyLabel(userType, deviceType).setVisible(true);
                rdBioField.enableStartButton(false);
                return;
            }
            catch (BioVerificationException e) {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
                switch (e.getBioExceptionType()) {
                    case NetworkError: {
                        this.showError((JComponent)rdBioField, "Biometric Verification failed. Please check your internet connection and try again.");
                        LOGGER.error("Biometric Verification failed." + e.getMessage());
                        rdVerifyButton.setText("Try Again");
                        return;
                    }
                    case BiometricsNotProvided: {
                        this.showError((JComponent)rdBioField, "Please provide biometrics and try again.");
                        return;
                    }
                    case AuthFailed: 
                    case InvalidBiometrics: {
                        this.showError((JComponent)rdBioField, e.getMessage());
                        rdVerifyButton.setText("Try Again");
                        this.biometricsAuthService.getRdAuthBiometrics().clear(userType, deviceType);
                        LOGGER.error("Biometric Verification failed." + e.getMessage());
                        rdBioField.clearCaptureAttempt();
                        return;
                    }
                    case ServerError: {
                        this.showError((JComponent)rdBioField, "Internal Server Error. Please try again.");
                        rdVerifyButton.setText("Try Again");
                        return;
                    }
                }
                return;
            }
            finally {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
            }
        }).start();
    }
}

