/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.biometricsauth;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.impl.DeviceLifeCycleListener;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.ui.biometricsauth.IBioAuthConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysLogin;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.confirm.BiometricFieldControlBarType;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import in.gov.uidai.swing.bio.confirm.DefaultConfirmPositions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;

public class BiometricsRDAuthPanel
implements IViewElementComposite,
IBioAuthConstants {
    private static final String ICON_PATH_OK = "res/ecmp/images/compliance-ok.png";
    private final IResourceBundleContext rbCtxt;
    private final IClientDeviceManager devMgr;
    private final IUIPreference uiPref;
    private final Map<RDCaptureType, BiometricsRDField> rdAuthField = new HashMap<RDCaptureType, BiometricsRDField>();
    private final Map<RDCaptureType, JButton> verifyButton = new HashMap<RDCaptureType, JButton>();
    private final Map<RDCaptureType, JLabel> verifyLabel = new HashMap<RDCaptureType, JLabel>();
    private final DeviceLifeCycleListener deviceLifeCycleListener;

    public BiometricsRDAuthPanel(IResourceBundleContext rbCtxt, IUIPreference uiPref, IClientDeviceManager devMgr) {
        this(rbCtxt, uiPref, null, devMgr);
    }

    public BiometricsRDAuthPanel(IResourceBundleContext rbCtxt, IUIPreference uiPref, DeviceLifeCycleListener deviceLifeCycleListener, IClientDeviceManager devMgr) {
        this.rbCtxt = rbCtxt;
        this.uiPref = uiPref;
        this.devMgr = devMgr;
        this.deviceLifeCycleListener = deviceLifeCycleListener;
    }

    public BiometricsRDField createOpSyncFingerArea(AuthParamType userType) {
        return this.createSingleBodyPartView(userType, BiometricFieldControlBarType.FingerSlabBar, LabelKeysLogin.FINGER_VERIFICATION, DeviceType.FINGERPRINT_AUTH, BiometricPosition.PLACE_ANY_FINGER);
    }

    public BiometricsRDField createOpSyncIrisArea(AuthParamType userType) {
        return this.createSingleBodyPartView(userType, BiometricFieldControlBarType.IrisBar, LabelKeysLogin.IRIS_VERIFICATION, DeviceType.IRIS_AUTH, BiometricPosition.CAPTURE_ANY_IRIS);
    }

    private BiometricsRDField createSingleBodyPartView(AuthParamType authParamType, BiometricFieldControlBarType biometricFieldControlBarType, LabelKeysLogin label, DeviceType deviceType, BiometricPosition confirmPos) {
        BiometricsRDField authField = new BiometricsRDField(this.rbCtxt.getMessage((Object)label, new Object[0]), biometricFieldControlBarType);
        authField.setClientDeviceManager(this.devMgr);
        authField.setDeviceLifeCycleListener(this.deviceLifeCycleListener, deviceType);
        authField.setConfirmPositions((IConfirmPositions)new DefaultConfirmPositions(Collections.singletonList(confirmPos)));
        RDCaptureType dataType = new RDCaptureType(authParamType, deviceType);
        authField.setName("RD");
        this.rdAuthField.putIfAbsent(dataType, authField);
        return this.rdAuthField.get(dataType);
    }

    public BiometricsRDField createRDFingerArea(AuthParamType userType) {
        BiometricsRDField authField = new BiometricsRDField(userType + " " + AuthParamType.FINGER);
        return this.getBiometricsRDField(userType, authField, Collections.singletonList(BiometricPosition.PLACE_ANY_FINGER), DeviceType.FINGERPRINT_AUTH);
    }

    public BiometricsRDField createRDIrisArea(AuthParamType userType) {
        BiometricsRDField authField = new BiometricsRDField(userType + " " + AuthParamType.IRIS);
        return this.getBiometricsRDField(userType, authField, Collections.singletonList(BiometricPosition.CAPTURE_ANY_IRIS), DeviceType.IRIS_AUTH);
    }

    public BiometricsRDField createRDFingerAndIrisBioAreaWithKycCheck(AuthParamType userType) {
        BiometricsRDField authField = new BiometricsRDField("Capture " + userType);
        authField.enableKyc();
        return this.getBiometricsRDField(userType, authField, Arrays.asList(BiometricPosition.PLACE_ANY_FINGER, BiometricPosition.CAPTURE_ANY_IRIS), DeviceType.FINGER_OR_IRIS);
    }

    public BiometricsRDField createRDFingerAndIrisBioVerifyArea(AuthParamType userType) {
        BiometricsRDField authField = new BiometricsRDField("Capture " + userType, this.createVerifyButton(userType, DeviceType.FINGER_OR_IRIS), this.createVerifyLabel(userType, DeviceType.FINGER_OR_IRIS), BiometricFieldControlBarType.ActionBar);
        return this.getBiometricsRDField(userType, authField, Arrays.asList(BiometricPosition.PLACE_ANY_FINGER, BiometricPosition.CAPTURE_ANY_IRIS), DeviceType.FINGER_OR_IRIS);
    }

    private BiometricsRDField getBiometricsRDField(AuthParamType userType, BiometricsRDField authField, List<BiometricPosition> biometricPositions, DeviceType deviceType) {
        authField.setClientDeviceManager(this.devMgr);
        authField.localize(new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false)));
        authField.setConfirmPositions((IConfirmPositions)new DefaultConfirmPositions(biometricPositions));
        authField.setName("RD");
        RDCaptureType dataType = new RDCaptureType(userType, deviceType);
        this.rdAuthField.putIfAbsent(dataType, authField);
        return this.rdAuthField.get(dataType);
    }

    public JButton createVerifyButton(AuthParamType userType, DeviceType deviceType) {
        RDCaptureType dataType = new RDCaptureType(userType, deviceType);
        this.verifyButton.putIfAbsent(dataType, new JButton("Verify Biometrics"));
        return this.verifyButton.get(dataType);
    }

    public JLabel createVerifyLabel(AuthParamType userType, DeviceType deviceType) {
        RDCaptureType dataType = new RDCaptureType(userType, deviceType);
        JLabel label = new JLabel(ImageIconCache.getInst().getIcon(ICON_PATH_OK));
        label.setText("Verified");
        label.setVisible(false);
        this.verifyLabel.putIfAbsent(dataType, label);
        return this.verifyLabel.get(dataType);
    }

    public BiometricsRDField getRDBioField(AuthParamType userType, DeviceType deviceType) {
        return this.rdAuthField.get(new RDCaptureType(userType, deviceType));
    }

    public JButton getRDVerifyButton(AuthParamType userType, DeviceType deviceType) {
        return this.verifyButton.get(new RDCaptureType(userType, deviceType));
    }

    public JLabel getRDVerifyLabel(AuthParamType userType, DeviceType deviceType) {
        return this.verifyLabel.get(new RDCaptureType(userType, deviceType));
    }

    public Map<RDCaptureType, JButton> getVerifyButton() {
        return this.verifyButton;
    }
}

