/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol;

import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlMembers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControlMembers.class);
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private IBioxDataProvider bioxProv;
    private EnrollmentService enrollmentService;
    private int lastTabIndex;
    private String currentViewId;

    public void updateViewId(String viewId) {
        if (!StringUtils.equalsIgnoreCase((String)viewId, (String)this.currentViewId)) {
            this.lastTabIndex = 0;
            this.currentViewId = viewId;
        }
    }

    void updateViewId(ILiteEvent evt) {
        this.updateViewId(evt.getViewId());
    }

    public EnrollmentService getEnrollmentService() {
        return this.enrollmentService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    int getLastTabIndex() {
        return this.lastTabIndex;
    }

    void setLastTabIndex(int index) {
        this.lastTabIndex = index;
    }

    public ILiteView getView() {
        if (this.osd == null) {
            LOGGER.debug("Could not obtain view, OSD is null");
            return null;
        }
        if (this.currentViewId == null) {
            LOGGER.debug("Could not obtain view, id is null");
            return null;
        }
        ILiteView view = this.osd.getView(this.currentViewId);
        if (view == null) {
            LOGGER.debug("Could not obtain view for id " + this.currentViewId);
            return null;
        }
        return view;
    }

    public IOnScreenDisplay getOSD() {
        return this.osd;
    }

    public void setOSD(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    void setBioxProvider(IBioxDataProvider prov) {
        this.bioxProv = prov;
    }

    void resetBioxProvider() {
        if (this.bioxProv != null) {
            this.bioxProv.resetData();
        }
    }

    public IEventContext getEventContext() {
        return this.evtCtxt;
    }

    public void setEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }
}

