/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol;

import com.google.common.base.Strings;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.biometrics.rddup.IResidentDedupAnalyzer;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.receipt.ReceiptService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.service.verification.VerificationService;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.ControlMembers;
import in.gov.uidai.ec.ui.main.UnsavedTracker;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.VerificationGuard;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysMainWin;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysEnrol;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.litef.widgets.TabbedPaneElement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.io.IOException;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolControl
implements IOnScreenDisplayAware,
IEventContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrolControl.class);
    private final ControlMembers members = new ControlMembers();
    private UnsavedTracker tracker;
    private IResidentDedupAnalyzer rddup;
    private VerificationGuard verificationGuard;
    private EnrollmentService enrollmentService;
    private ReceiptService receiptService;
    private boolean userAcceptedChanges;
    private IResourceBundleContext enrolRbCtxt;

    public void setResourceBundleContext(IResourceBundleContext rbCtxt) {
        this.enrolRbCtxt = rbCtxt;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.members.setOSD(osd);
    }

    public void populateEventContext(IEventContext ctxt) {
        this.members.setEventContext(ctxt);
    }

    public void setVerificationGuard(VerificationGuard verificationGuard) {
        this.verificationGuard = verificationGuard;
    }

    public void setUnsavedTracker(UnsavedTracker tracker) {
        this.tracker = tracker;
    }

    public final void setBioxDataProvider(IBioxDataProvider provider) {
        this.members.setBioxProvider(provider);
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
        this.members.setEnrollmentService(enrollmentService);
    }

    public void setResidentDedupAnalyzer(IResidentDedupAnalyzer rddup) {
        this.rddup = rddup;
    }

    public void setReceiptService(ReceiptService receiptService) {
        this.receiptService = receiptService;
    }

    public void setUIPreference(IUIPreference pref) throws StationInfoStoreException {
        String localeStr = pref.getTransliterationLocale("hi_in");
        String langCode = UidLocaleUtils.getLangCodeFrmLocaleStr((String)localeStr);
        if (StringUtils.isNotBlank((String)langCode)) {
            this.enrollmentService.setClientLangCode(langCode);
        } else {
            LOGGER.info("Please select the Language from the ECA");
            this.showPopupMessageLangCodeMissing();
        }
    }

    @EventHandler(name="hID_New_Enrol", method="actionPerformed")
    public void onEnrolSelectNewEnrollment(ILiteEvent evt) {
        if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.StartUp, evt)) {
            return;
        }
        if (!this.tracker.selectEnrol(evt)) {
            this.userAcceptedChanges = false;
            return;
        }
        this.userAcceptedChanges = true;
        this.openEnrol(evt, true, false, false, false);
    }

    @EventHandler(name="hID_Update_Enrol", method="actionPerformed")
    public void onEnrolSelectUpdateEnrollment(ILiteEvent evt) {
        this.enrollmentService.clearEnrollmentState();
        if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.StartUp, evt)) {
            return;
        }
        if (!this.tracker.selectEnrol(evt)) {
            this.userAcceptedChanges = false;
            return;
        }
        this.userAcceptedChanges = true;
        this.openEnrol(evt, true, true, false, false);
    }

    @EventHandler(name="hID_ODUpdate_Enrol", method="actionPerformed")
    public void onEnrolSelectOffDocUpdateEnrollment(ILiteEvent evt) {
        this.enrollmentService.clearEnrollmentState();
        if (!this.verificationGuard.verifyOnStartUp(VerificationService.Type.StartUp, evt)) {
            return;
        }
        if (!this.tracker.selectEnrol(evt)) {
            this.userAcceptedChanges = false;
            return;
        }
        this.userAcceptedChanges = true;
        this.showOffDocUpdatePopupMessage();
        this.openEnrol(evt, true, true, false, true);
    }

    @GenericEventHandler(value="start update enrollment")
    public void startEnrol(ILiteEvent evt) {
        if (this.enrollmentService.isForeignResident() || this.enrollmentService.doesNriHaveForeignAddress()) {
            this.populateNationalities(evt);
        }
        if (!this.enrollmentService.isForeignResident()) {
            this.populateProofDocumentList("INDIAN", false);
        }
        if (this.enrollmentService.isHofEnrollment() && (this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment())) {
            this.populateBrnStates(evt);
        }
        ModalVisualExecutionContext veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
        Utils.showProgressBar((IVisualExecutionContext)veCtxt, "Loading next page, please wait");
        ThreadPool.commonPool().submit(() -> this.lambda$startEnrol$0(evt, (IVisualExecutionContext)veCtxt));
    }

    @GenericEventHandler(value="hID_Enrol")
    public void openEnrol(ILiteEvent evt, boolean createNewSession, boolean isUpdateEnrollment, boolean isOnlineUpdate, boolean isOffLineDocumentUpdate) {
        LOGGER.info("Starting {} Enrollment", (Object)(isUpdateEnrollment ? (!isOnlineUpdate ? "Offline Update" : "Online Update") : "New"));
        if (isOnlineUpdate && !isUpdateEnrollment && createNewSession) {
            this.userAcceptedChanges = true;
        }
        if (createNewSession && !this.userAcceptedChanges && !isOnlineUpdate && this.tracker.selectEnrol(evt)) {
            return;
        }
        this.userAcceptedChanges = false;
        if (!isOnlineUpdate) {
            if (createNewSession && isUpdateEnrollment && isOffLineDocumentUpdate) {
                this.enrollmentService.initiateUpdateEnrollment(false, false, true);
            } else if (createNewSession && isUpdateEnrollment) {
                this.enrollmentService.initiateUpdateEnrollment(false, false, false);
            } else if (createNewSession) {
                this.enrollmentService.initiateNewEnrollment();
            }
        }
        if (this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_UPDATE) || this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_ENROLLMENT)) {
            if (!this.enrollmentService.isForeignResident()) {
                this.populateProofDocumentList("INDIAN", false);
            }
            if (this.enrollmentService.isForeignResident() || this.enrollmentService.doesNriHaveForeignAddress()) {
                this.populateNationalities(evt);
            }
            if (this.enrollmentService.isHofEnrollment() && (this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment())) {
                this.populateBrnStates(evt);
            }
        }
        ModalVisualExecutionContext veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
        Utils.showProgressBar((IVisualExecutionContext)veCtxt, "Loading next page, please wait");
        ThreadPool.commonPool().submit(() -> this.lambda$openEnrol$1(evt, (IVisualExecutionContext)veCtxt, isUpdateEnrollment, isOnlineUpdate));
    }

    @GenericEventHandler(value="UC_Docs")
    public void populateProofDocumentList(String foreignType, boolean refresh) {
        ThreadPool.commonPool().submit(() -> {
            boolean isRefrequired;
            boolean bl = isRefrequired = this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isReferenceTabRequired();
            if (isRefrequired) {
                try {
                    this.enrollmentService.populateProofDocuments(foreignType, this.enrollmentService.isUpdateUC() ? "UPDATE" : "NEW", this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup().toString());
                    this.enrollmentService.getReferences().setAllowedDocuments(this.enrollmentService.getReferences().getAllowedDocuments());
                    if (refresh) {
                        this.enrollmentService.getReferences().reEvaluateReferences(this.enrollmentService.isNRIEnrolment(), this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup(), this.enrollmentService.getDemographics().getHofRelationType());
                    }
                }
                catch (OnlineGatewayException ex) {
                    TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)ex), ex.getErrorCode(), new String[0]);
                    L10nOptionPaneBuilder.getInstance().showErrorUC("Error fetching proof documents: " + ex.getDisplayMessage(), null, ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                }
            }
        });
    }

    @EventHandler(name="UC_Brn", method="actionPerformed")
    public void populateBrnStates(ILiteEvent evt) {
        ThreadPool.commonPool().submit(() -> {
            if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.isHofEnrollment() && (this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment())) {
                try {
                    this.enrollmentService.populateBrnStates();
                }
                catch (OnlineGatewayException ex) {
                    L10nOptionPaneBuilder.getInstance().showErrorUC("Error fetching brn states: " + ex.getDisplayMessage(), null, ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                }
            }
        });
    }

    @EventHandler(name="UC_Nationality", method="actionPerformed")
    public void populateNationalities(ILiteEvent evt) {
        ThreadPool.commonPool().submit(() -> {
            try {
                this.enrollmentService.populateNationalities();
            }
            catch (OnlineGatewayException ex) {
                L10nOptionPaneBuilder.getInstance().showErrorUC("Error fetching nationalities: " + ex.getDisplayMessage(), null, ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
            this.enrollmentService.fireForeignTypeSuccess();
        });
    }

    @EventHandler(name="hID_Enrol_TabSwitch", method="stateChanged")
    public void onEnrolTabSwitch(ILiteEvent evt) {
        TabbedPaneElement tabElement;
        IViewElement bothEyes;
        IViewElement rightEye;
        IViewElement leftEye;
        IViewElement thumbSlap;
        IViewElement rightSlap;
        IViewElement leftSlap;
        IViewElement residentField;
        IViewElement bioxField;
        this.members.updateViewId(evt);
        ILiteView view = this.members.getView();
        if (view == null || !view.isValid()) {
            return;
        }
        Map eMap = view.getElementMap();
        if (eMap == null || eMap.isEmpty()) {
            return;
        }
        if (eMap.get("eID_PhotoTab_Face") != null) {
            ((IViewElement)eMap.get("eID_PhotoTab_Face")).call("stopCapture");
        }
        if ((bioxField = (IViewElement)eMap.get("eID_PhotoTab_Biox")) != null) {
            bioxField.call("stopCapture");
        }
        if ((residentField = (IViewElement)eMap.get("eID_PhotoTab_ResidentConfirm")) != null) {
            residentField.call("stopCapture");
        }
        if ((leftSlap = (IViewElement)eMap.get("eID_FingerTab_LeftSlap")) != null) {
            leftSlap.call("stopCapture");
        }
        if ((rightSlap = (IViewElement)eMap.get("eID_FingerTab_RightSlap")) != null) {
            rightSlap.call("stopCapture");
        }
        if ((thumbSlap = (IViewElement)eMap.get("eID_FingerTab_ThumbSlap")) != null) {
            thumbSlap.call("stopCapture");
        }
        if ((leftEye = (IViewElement)eMap.get("eID_IrisTab_LeftEye")) != null) {
            leftEye.call("stopCapture");
        }
        if ((rightEye = (IViewElement)eMap.get("eID_IrisTab_RightEye")) != null) {
            rightEye.call("stopCapture");
        }
        if ((bothEyes = (IViewElement)eMap.get("eID_IrisTab_BothEyes")) != null) {
            bothEyes.call("stopCapture");
        }
        if ((tabElement = (TabbedPaneElement)eMap.get("hID_Enrol_TabPane")) == null) {
            return;
        }
        int tabIndex = (Integer)tabElement.get("selected-index");
        if (this.members.getLastTabIndex() == tabIndex) {
            return;
        }
        int fromStep = this.members.getLastTabIndex();
        this.enrollmentService.recordTabChanged(fromStep, tabIndex);
        this.members.setLastTabIndex(tabIndex);
        this.enrollmentService.fireTabTransition(Integer.valueOf(fromStep));
    }

    @EventHandler(name="hID_Enrol_Preview", method="actionPerformed")
    public void onPrintPreview(ILiteEvent evt) {
        ILiteView view = this.members.getOSD().getView(evt.getViewId());
        IVisualExecutionContext veCtxt = view.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(MsgKeysEnrol.VEX_PREVIEW.toString());
        }
        try {
            IOnScreenDisplay osd = this.members.getOSD();
            String scafID = osd.compose(evt.getScaffoldId(), "printPreviewWin", "printPreview");
            ILiteView osiView = osd.getView(osd.getScaffold(scafID).getViewId());
            Map osiMap = osiView.getElementMap();
            byte[] image = this.receiptService.getEnrolmentReceiptPreview();
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            if (image != null) {
                IViewElement previewLabel = (IViewElement)osiMap.get("eID_Prnprvu_ImageView");
                previewLabel.set("image", (Object)image);
                previewLabel.set("displayMode", (Object)DisplayMode.ORIGINAL_SIZE);
                osd.display(scafID, ScaffoldPlacement.CENTERED);
            }
        }
        catch (IOException e) {
            LOGGER.info("Failed to connect to Enrol Service Client!!!", (Object[])e.getStackTrace());
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to connect to Enrol Service Client. Make sure it is running.", (Component)this.members.getOSD().getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (StationInfoStoreException e) {
            LOGGER.info("Failed to store/retrieve information from Enrol Service Client!!!", (Throwable)e);
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to store/retrieve information from Enrol Service Client. Please try again.", (Component)this.members.getOSD().getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while receipt preview", (Throwable)e);
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysEnrol.ERROR_PREVIEW, (Component)this.members.getOSD().getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
    }

    @EventHandler(name="hID_Osi_Confirm", method="actionPerformed")
    public void onOSIConfirm(ILiteEvent evt) {
        LOGGER.info("Completed OSI verification");
        ILiteView view = this.members.getOSD().getView(evt.getViewId());
        ILiteScaffold pScaf = this.members.getOSD().getScaffold(evt.getScaffoldId());
        if (pScaf == null) {
            return;
        }
        view.setEnabled(false);
        this.members.getOSD().dispose(evt.getScaffoldId());
        this.enrollmentService.fireDisableAllTabs();
        this.tracker.reset();
        String scafId = this.members.getOSD().compose(pScaf.getParentId(), "packetConfirmWin", "packetConfirmView");
        this.members.getOSD().display(scafId, ScaffoldPlacement.CENTERED);
        LOGGER.info("Launching Document Attachment & Packet Confirm View");
    }

    @EventHandler(name="hID_ShowPreview", method="actionPerformed")
    public void showPreview(ILiteEvent evt) {
        String scafID = this.members.getOSD().compose(evt.getScaffoldId(), "docScanPreviewWin", "docScanPreview");
        this.members.getOSD().display(scafID, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_ScanPreview_Close", method="windowClosing")
    public void onScanPreviewCloseButton(ILiteEvent evt) {
        this.members.getOSD().dispose(evt.getScaffoldId());
        this.enrollmentService.getDocManager().resetDocument();
    }

    private void showOffDocUpdatePopupMessage() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Dear Operator if you have Single Finger/ Iris (RD) device,<br> Please use the Online Document Update feature.<br>This feature will only allow Document Update.<br> No changes to aadhaar account will be possible.<br> To update Aadhaar, please use Update Flow.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 2);
    }

    private void showPopupMessageLangCodeMissing() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Language code is missing for the current enrolment packet. Please do the enrolment again");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 2);
    }

    private /* synthetic */ void lambda$openEnrol$1(ILiteEvent evt, IVisualExecutionContext veCtxt, boolean isUpdateEnrollment, boolean isOnlineUpdate) {
        try {
            String scafId = this.members.getOSD().recompose(evt.getScaffoldId(), "enrolView");
            ILiteScaffold scaffold = this.members.getOSD().getScaffold(scafId);
            Utils.cancelProgressBar(veCtxt);
            LabelKeysMainWin label = LabelKeysMainWin.ENROL_NEW;
            if (isUpdateEnrollment) {
                label = this.enrollmentService.isUniversalClientTrnx() ? LabelKeysMainWin.LIFECYCLE_UPDATE_ONLINE : (this.enrollmentService.isDocumentUpdate() ? LabelKeysMainWin.LIFECYCLE_UPDATE_DOCUMENT_ONLINE : (isOnlineUpdate ? LabelKeysMainWin.LIFECYCLE_UPDATE_ONLINE : (this.enrollmentService.isOffLineDocumentUpdate() ? LabelKeysMainWin.LIFECYCLE_UPDATE_DOCUMENT_OFFLINE : LabelKeysMainWin.LIFECYCLE_UPDATE_OFFLINE)));
            } else if (this.enrollmentService.isUniversalClientTrnx()) {
                label = this.enrollmentService.isForeignResident() ? LabelKeysMainWin.ENROL_NEW_FOREIGN_UC : (this.enrollmentService.isNRIEnrolment() ? LabelKeysMainWin.ENROL_NEW_NRI_UC : (this.enrollmentService.isMinorEnrollment() ? LabelKeysMainWin.ENROL_NEW_CHILDABOVE5_UC : (this.enrollmentService.isChildEnrollment() ? LabelKeysMainWin.ENROL_NEW_CHILDBELOW5_UC : LabelKeysMainWin.ENROL_NEW_ADULT_UC)));
            }
            ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)label);
            this.members.updateViewId(scaffold.getViewId());
            if (this.enrollmentService.isUniversalClientTrnx() && !this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
                this.members.resetBioxProvider();
            }
            this.rddup.reset();
        }
        catch (Exception e) {
            LOGGER.error(ErrorCodes.UC_GEN_114.getReason(), (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_114.getReason(), null, ErrorCodes.UC_GEN_114.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
    }

    private /* synthetic */ void lambda$startEnrol$0(ILiteEvent evt, IVisualExecutionContext veCtxt) {
        try {
            String scafId = this.members.getOSD().recompose(evt.getScaffoldId(), "enrolView");
            ILiteScaffold scaffold = this.members.getOSD().getScaffold(scafId);
            Utils.cancelProgressBar(veCtxt);
            LabelKeysMainWin label = this.enrollmentService.isUpdateUC() && !this.enrollmentService.isAadhaarActive() ? (Strings.isNullOrEmpty((String)this.enrollmentService.getGrievanceId()) ? LabelKeysMainWin.LIFECYCLE_REACTIVATE : LabelKeysMainWin.LIFECYCLE_UPDATE_ONLINE) : (this.enrollmentService.isUpdateUC() ? LabelKeysMainWin.LIFECYCLE_UPDATE_ONLINE : (this.enrollmentService.isForeignResident() ? LabelKeysMainWin.ENROL_NEW_FOREIGN_UC : (this.enrollmentService.isNRIEnrolment() ? LabelKeysMainWin.ENROL_NEW_NRI_UC : (this.enrollmentService.isMinorEnrollment() ? LabelKeysMainWin.ENROL_NEW_CHILDABOVE5_UC : (this.enrollmentService.isChildEnrollment() ? LabelKeysMainWin.ENROL_NEW_CHILDBELOW5_UC : LabelKeysMainWin.ENROL_NEW_ADULT_UC)))));
            ((IViewElement)scaffold.getElementMap().get("hID_MainWin_Header")).set("text", (Object)label);
            this.members.updateViewId(scaffold.getViewId());
            if (!this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied()) {
                this.members.resetBioxProvider();
            }
            this.rddup.reset();
        }
        catch (Exception e) {
            Utils.cancelProgressBar(veCtxt);
            LOGGER.error(ErrorCodes.UC_GEN_114.getReason(), (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(ErrorCodes.UC_GEN_114.getReason(), null, ErrorCodes.UC_GEN_114.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_114.getErrorCode(), new String[0]);
        }
    }
}

