/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.service.IStandardViewLoadListener;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.enrol.dynaddr.IDynaddrTemplateManager;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.packet.IEnrolVerifyDAO;
import in.gov.uidai.ec.service.packet.IUCPacketSummaryDAO;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.demographics.DemographicsTabViewPeer;
import in.gov.uidai.ec.ui.enrol.document.IDocumentsPreference;
import in.gov.uidai.ec.ui.enrol.fingerprint.FingerPrintTabViewPeer;
import in.gov.uidai.ec.ui.enrol.iris.IrisTabViewPeer;
import in.gov.uidai.ec.ui.enrol.photograph.PhotographTabViewPeer;
import in.gov.uidai.ec.ui.enrol.references.ReferenceTabViewPeer;
import in.gov.uidai.ec.ui.enrol.review.ReviewTabViewPeer;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.DemographicsTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.FingerPrintTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.IrisTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.PhotographTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReferenceTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReviewTabViewPeerUC;
import in.gov.uidai.ec.ui.enrol.updatecount.UpdateCountTabViewPeer;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.ElementMapBuilder;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolViewPeer
extends StandardViewPeer
implements IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrolViewPeer.class);
    private static final String ICON_PATH_ERROR = "res/images/tab-error.png";
    private static final String ICON_PATH_OK_DISABLE = "res/images/tab-ok-disable.png";
    public IResourceBundleContext clientRbCtxt;
    public IResourceBundleContext enrolRbCtxt;
    public IUIPreference uiPref;
    public IClientDeviceManager cdm;
    public IBioxDataProvider bdp;
    public IDynaddrTemplateManager daTplMgr;
    public EnrollmentService enrollmentService;
    public BiometricsAuthService biometricsAuthService;
    public IDocumentsPreference docPref;
    public IPreferenceStore prefStore;
    public IOucDataStore oucDataStore;
    public IPinCodeService postOfficeDataService;
    @ExportViewElement(as="hID_Enrol_TabPane", using=StandardSwingElementFactory.class)
    private JTabbedPane tabbedPane;
    private UpdateCountTabViewPeer updateCountTab;
    private DemographicsTabViewPeer demoTab;
    private DemographicsTabViewPeerUC demoTabUC;
    private ReferenceTabViewPeerUC refTabUC;
    private ReviewTabViewPeerUC reviewTabUC;
    private ReferenceTabViewPeer refTab;
    private PhotographTabViewPeer photoTab;
    private PhotographTabViewPeerUC photoTabUC;
    private FingerPrintTabViewPeer fingerTab;
    private FingerPrintTabViewPeerUC fingerTabUC;
    private IrisTabViewPeer irisTab;
    private IrisTabViewPeerUC irisTabUC;
    private ReviewTabViewPeer reviewTab;
    private TokenManager opTokenManager;
    private TokenManager supTokenManager;
    private IEnrolVerifyDAO enrolVerifyDAO;
    private IUCPacketSummaryDAO ucPacketSummaryDAO;

    public IUCPacketSummaryDAO getUcPacketSummaryDAO() {
        return this.ucPacketSummaryDAO;
    }

    public void setUcPacketSummaryDAO(IUCPacketSummaryDAO ucPacketSummaryDAO) {
        this.ucPacketSummaryDAO = ucPacketSummaryDAO;
    }

    public IEnrolVerifyDAO getEnrolVerifyDAO() {
        return this.enrolVerifyDAO;
    }

    public void setEnrolVerifyDAO(IEnrolVerifyDAO enrolVerifyDAO) {
        this.enrolVerifyDAO = enrolVerifyDAO;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
    }

    public void setDocumentsPreference(IDocumentsPreference docPref) {
        this.docPref = docPref;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.clientRbCtxt = ctxt;
    }

    public void setEnrollmentResourceBundleContext(IResourceBundleContext ctxt) {
        this.enrolRbCtxt = ctxt;
    }

    public void setDynaAddrTemplateManager(IDynaddrTemplateManager mgr) {
        this.daTplMgr = mgr;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.cdm = cdm;
    }

    public void setBioxDataProvider(IBioxDataProvider provider) {
        this.bdp = provider;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
        super.setStandardViewListener((IStandardViewLoadListener)enrollmentService);
    }

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setBioDataTokenManager(TokenManager bioDataTokenManager) {
        this.opTokenManager = bioDataTokenManager;
    }

    public void setPostOfficeDataService(IPinCodeService postOfficeDataService) {
        this.postOfficeDataService = postOfficeDataService;
    }

    protected void prepareImpl() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setPreferredSize(new Dimension(1000, 650));
        this.tabbedPane.addChangeListener((ChangeListener)this.getEventContext().getEventListener("hID_Enrol_TabSwitch", ChangeListener.class));
        SoftReference<ChangeListener> tabbedPaneCLSoftReference = new SoftReference<ChangeListener>(evt -> {
            JTabbedPane tabPane = (JTabbedPane)evt.getSource();
            SwingUtilities.invokeLater(tabPane.getSelectedComponent()::transferFocus);
        });
        this.tabbedPane.addChangeListener(evt -> {
            ChangeListener cl = (ChangeListener)tabbedPaneCLSoftReference.get();
            if (cl != null) {
                cl.stateChanged(evt);
            }
        });
        super.setDefaultComponent((JComponent)this.tabbedPane);
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)this.tabbedPane, false, new L10nDecorator(this.clientRbCtxt, this.uiPref.getApplicationLocalize(false))));
        ImageIcon errIcon = ViewUtils.getImageIcon(((Object)((Object)this)).getClass(), ICON_PATH_ERROR);
        ImageIcon disableIcon = ViewUtils.getImageIcon(((Object)((Object)this)).getClass(), ICON_PATH_OK_DISABLE);
        boolean isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
        boolean isOnlineUpdate = this.enrollmentService.isUniversalClientTrnx();
        int tabCount = 0;
        this.opTokenManager.setUniversalClientTransaction(isOnlineUpdate);
        if (isOnlineUpdate) {
            try {
                this.reviewTabUC = new ReviewTabViewPeerUC(this, this.getEventContext(), this.supTokenManager);
                this.fingerTabUC = new FingerPrintTabViewPeerUC(this);
                this.irisTabUC = new IrisTabViewPeerUC(this);
                this.photoTabUC = new PhotographTabViewPeerUC(this);
                this.refTabUC = new ReferenceTabViewPeerUC(this, this.getEventContext(), this.enrollmentService);
                this.demoTabUC = new DemographicsTabViewPeerUC(this, this.getEventContext());
                this.demoTabUC.prepare();
                this.demoTabUC.setTabIndex(tabCount);
                this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.DEMO, new Object[0]), this.demoTabUC.toSwing());
                this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(errIcon, LabelKeysTab.DEMO, tabCount++, true));
                this.prepareTabs();
            }
            catch (Exception e) {
                LOGGER.error(ErrorCodes.UC_GEN_114.getReason(), (Throwable)e);
                TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_114.getErrorCode(), new String[0]);
                return;
            }
        } else {
            this.reviewTab = new ReviewTabViewPeer(this);
            this.irisTab = new IrisTabViewPeer(this);
            this.fingerTab = new FingerPrintTabViewPeer(this);
            this.photoTab = new PhotographTabViewPeer(this);
            this.refTab = new ReferenceTabViewPeer(this, this.getEventContext());
            this.demoTab = new DemographicsTabViewPeer(this, this.getEventContext());
            this.demoTab.setTabIndex(tabCount);
            this.demoTab.prepare();
            this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.DEMO, new Object[0]), this.demoTab.toSwing());
            this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(errIcon, LabelKeysTab.DEMO, tabCount++, true));
            this.refTab.setTabIndex(tabCount);
            this.refTab.prepare();
            this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.REF, new Object[0]), this.refTab.toSwing());
            this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(errIcon, LabelKeysTab.REF, tabCount++, true));
            this.photoTab.setTabIndex(tabCount);
            this.photoTab.prepare();
            this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.PHOTO, new Object[0]), this.photoTab.toSwing());
            this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(errIcon, LabelKeysTab.PHOTO, tabCount++, true));
            this.fingerTab.setTabIndex(tabCount);
            this.fingerTab.prepare();
            this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.FINGER, new Object[0]), this.fingerTab.toSwing());
            this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(isUpdateEnrollment ? disableIcon : errIcon, LabelKeysTab.FINGER, tabCount++, !isUpdateEnrollment));
            this.irisTab.setTabIndex(tabCount);
            this.irisTab.prepare();
            this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.IRIS, new Object[0]), this.irisTab.toSwing());
            this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(isUpdateEnrollment ? disableIcon : errIcon, LabelKeysTab.IRIS, tabCount++, !isUpdateEnrollment));
            this.reviewTab.setTabIndex(tabCount);
            this.reviewTab.prepare();
            this.tabbedPane.addTab(this.enrolRbCtxt.getMessage((Object)LabelKeysTab.REVIEW, new Object[0]), this.reviewTab.toSwing());
            this.tabbedPane.setTabComponentAt(tabCount, this.createLabel(null, LabelKeysTab.REVIEW, tabCount, true));
        }
        this.tabbedPane.setSelectedIndex(0);
        super.setContentPane((JComponent)this.tabbedPane);
        this.enableTabNavigationViaKeyboard();
    }

    private void prepareTabs() {
        boolean isRefrequired;
        int tabIndex = this.demoTabUC.getTabIndex() + 1;
        boolean bl = isRefrequired = this.enrollmentService.isNewEnrollmentUC() || FieldInfoUtils.isReferenceTabRequired();
        if (isRefrequired) {
            this.refTabUC.setTabIndex(tabIndex++);
            this.refTabUC.prepare();
        }
        if (this.enrollmentService.isNewEnrollmentUC()) {
            this.photoTabUC.setTabIndex(tabIndex++);
            this.photoTabUC.prepare();
            if (!this.enrollmentService.isChildEnrollment()) {
                this.fingerTabUC.setTabIndex(tabIndex++);
                this.fingerTabUC.prepare();
                this.irisTabUC.setTabIndex(tabIndex++);
                this.irisTabUC.prepare();
            }
        } else if (this.enrollmentService.isUpdateUC()) {
            boolean isPhotoRequired = FieldInfoUtils.isPhotoTabRequired();
            boolean isFingerRequired = FieldInfoUtils.isFingerTabRequired();
            boolean isIrisRequired = FieldInfoUtils.isIrisTabRequired();
            if (isPhotoRequired) {
                this.photoTabUC.setTabIndex(tabIndex++);
                this.photoTabUC.prepare();
            }
            if (isFingerRequired) {
                this.fingerTabUC.setTabIndex(tabIndex++);
                this.fingerTabUC.prepare();
            }
            if (isIrisRequired) {
                this.irisTabUC.setTabIndex(tabIndex++);
                this.irisTabUC.prepare();
            }
        }
        this.reviewTabUC.setTabIndex(tabIndex);
        this.reviewTabUC.prepare();
    }

    private void addToElementMap(IViewElementComposite target) {
        ElementMapBuilder emb = new ElementMapBuilder(target);
        if (!this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isHofEnrollment()) {
            emb.getElementMap().forEach((key, element) -> this.getView().getElementMap().put(key, element));
        }
    }

    private void enableTabNavigationViaKeyboard() {
        InputMap inputMap = this.tabbedPane.getInputMap(1);
        ActionMap axnMap = this.tabbedPane.getActionMap();
        AbstractAction nextTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int tabNum = EnrolViewPeer.this.tabbedPane.getSelectedIndex();
                EnrollmentControllerBase enrollmentControllerBase = new EnrollmentControllerBase(EnrolViewPeer.this.getView(), EnrolViewPeer.this.enrollmentService, tabNum, tabNum);
                enrollmentControllerBase.onNextButtonClick(null);
            }
        };
        inputMap.put(KeyStroke.getKeyStroke("alt RIGHT"), "navigateToNextTab");
        axnMap.put("navigateToNextTab", nextTabAction);
        AbstractAction previousTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int tabNum = EnrolViewPeer.this.tabbedPane.getSelectedIndex();
                EnrollmentControllerBase enrollmentControllerBase = new EnrollmentControllerBase(EnrolViewPeer.this.getView(), EnrolViewPeer.this.enrollmentService, tabNum, tabNum);
                enrollmentControllerBase.onPrevButtonClick(null);
            }
        };
        inputMap.put(KeyStroke.getKeyStroke("alt LEFT"), "navigateToPreviousTab");
        axnMap.put("navigateToPreviousTab", previousTabAction);
    }

    protected void enableImpl(boolean flag) {
    }

    private JLabel createLabel(ImageIcon icon, LabelKeysTab tab, int tabId, boolean enable) {
        JLabel label = new JLabel(this.enrolRbCtxt.getMessage((Object)tab, new Object[0]));
        new L10nDecorator(this.enrolRbCtxt, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)tab, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(enable ? Color.WHITE : Color.GRAY);
        this.tabbedPane.setEnabledAt(tabId, enable);
        return label;
    }

    protected void disposeImpl() {
        Arrays.stream(this.tabbedPane.getChangeListeners()).forEach(cl -> this.tabbedPane.removeChangeListener((ChangeListener)cl));
        this.tabbedPane.removeAll();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (this.demoTabUC != null && this.demoTabUC.toSwing() != null) {
                LOGGER.info("Cleared demotab");
                this.demoTabUC.toSwing().removeAll();
                this.demoTabUC = null;
            }
            if (this.refTabUC != null && this.refTabUC.toSwing() != null) {
                this.refTabUC.toSwing().removeAll();
                this.refTabUC = null;
            }
            if (this.photoTabUC != null && this.photoTabUC.toSwing() != null) {
                this.photoTabUC.toSwing().removeAll();
                this.photoTabUC = null;
            }
            if (this.fingerTabUC != null && this.fingerTabUC.toSwing() != null) {
                this.fingerTabUC.toSwing().removeAll();
                this.fingerTabUC = null;
            }
            if (this.irisTabUC != null && this.irisTabUC.toSwing() != null) {
                this.irisTabUC.toSwing().removeAll();
                this.irisTabUC = null;
            }
            if (this.reviewTabUC != null && this.reviewTabUC.toSwing() != null) {
                this.reviewTabUC.toSwing().removeAll();
                this.reviewTabUC = null;
            }
        } else {
            if (this.demoTab.toSwing() != null) {
                this.demoTab.toSwing().removeAll();
            }
            if (this.refTab != null && this.refTab.toSwing() != null) {
                this.refTab.toSwing().removeAll();
            }
            if (this.photoTab.toSwing() != null) {
                this.photoTab.toSwing().removeAll();
            }
            if (this.fingerTab.toSwing() != null) {
                this.fingerTab.toSwing().removeAll();
            }
            if (this.irisTab.toSwing() != null) {
                this.irisTab.toSwing().removeAll();
            }
            if (this.reviewTab.toSwing() != null) {
                this.reviewTab.toSwing().removeAll();
            }
        }
    }

    public UpdateCountTabViewPeer getUpdateCountTab() {
        return this.updateCountTab;
    }

    public DemographicsTabViewPeer getDemoTab() {
        return this.demoTab;
    }

    public ReferenceTabViewPeer getRefTab() {
        return this.refTab;
    }

    public ReferenceTabViewPeerUC getRefTabUC() {
        return this.refTabUC;
    }

    public ReviewTabViewPeer getReviewTab() {
        return this.reviewTab;
    }

    public ReviewTabViewPeerUC getReviewTabUC() {
        return this.reviewTabUC;
    }

    public PhotographTabViewPeer getPhotoTab() {
        return this.photoTab;
    }

    public PhotographTabViewPeerUC getPhotoTabUC() {
        return this.photoTabUC;
    }

    public FingerPrintTabViewPeer getFingerTab() {
        return this.fingerTab;
    }

    public FingerPrintTabViewPeerUC getFingerTabUC() {
        return this.fingerTabUC;
    }

    public IrisTabViewPeer getIrisTab() {
        return this.irisTab;
    }

    public IrisTabViewPeerUC getIrisTabUC() {
        return this.irisTabUC;
    }

    public TokenManager getOpTokenManager() {
        return this.opTokenManager;
    }

    public void setSupTokenManager(TokenManager supTokenManager) {
        this.supTokenManager = supTokenManager;
    }
}

