/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysEnrol;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.swing.l10n.L10nOptionPane;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.commons.lang.StringUtils;

public class EnrollmentControllerBase
extends ControllerBase
implements INavigationConstants {
    private static final String ICON_PATH_OK = "res/images/tab-ok.png";
    private static final String ICON_PATH_OK_DISABLE = "res/images/tab-ok-disable.png";
    private static final String ICON_PATH_ERROR = "res/images/tab-error.png";
    private final int tabId;
    private final int tabIndex;
    protected EnrollmentService enrollmentService;
    private boolean tabEnabled;

    public EnrollmentControllerBase(ILiteView view, EnrollmentService enrollmentService, int tabId, int tabIndex) {
        super(view);
        this.tabId = tabId;
        this.enrollmentService = enrollmentService;
        this.tabEnabled = true;
        this.enrollmentService.updateTabState(this.tabId, true);
        this.tabIndex = tabIndex;
    }

    protected void updateTabValidityState(boolean valid) {
        if (this.view == null || this.view.getElementMap() == null) {
            return;
        }
        this.updateTabState();
    }

    protected void updateTabInteractionState(boolean enable) {
        this.tabEnabled = enable;
        this.enrollmentService.updateTabState(this.tabId, this.tabEnabled);
        if (this.view == null || this.view.getElementMap() == null) {
            return;
        }
        IViewElement tabPane = (IViewElement)this.view.getElementMap().get("hID_Enrol_TabPane");
        this.updateTabState();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            tabPane.mset("foreground-at", new Object[]{this.tabIndex, this.tabEnabled ? Color.WHITE : Color.GRAY});
            tabPane.mset("enable-at", new Object[]{this.tabIndex, this.tabEnabled});
        } else {
            tabPane.mset("foreground-at", new Object[]{this.tabId, this.tabEnabled ? Color.WHITE : Color.GRAY});
            tabPane.mset("enable-at", new Object[]{this.tabId, this.tabEnabled});
        }
    }

    private void updateTabState() {
        IViewElement tabPane = (IViewElement)this.view.getElementMap().get("hID_Enrol_TabPane");
        boolean valid = this.isCurrentTabValid();
        boolean tabEnabled = this.isTabEnabled();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (valid && tabEnabled) {
                tabPane.mset("icon", new Object[]{this.tabIndex, ICON_PATH_OK});
            } else if (tabEnabled) {
                tabPane.mset("icon", new Object[]{this.tabIndex, ICON_PATH_ERROR});
            } else {
                tabPane.mset("icon", new Object[]{this.tabIndex, ICON_PATH_OK_DISABLE});
            }
        } else if (valid && tabEnabled) {
            tabPane.mset("icon", new Object[]{this.tabId, ICON_PATH_OK});
        } else if (tabEnabled) {
            tabPane.mset("icon", new Object[]{this.tabId, ICON_PATH_ERROR});
        } else {
            tabPane.mset("icon", new Object[]{this.tabId, ICON_PATH_OK_DISABLE});
        }
    }

    private boolean isCurrentTabValid() {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            switch (this.tabId) {
                case 0: {
                    return this.enrollmentService.getDemographics().isValid();
                }
                case 1: {
                    return this.enrollmentService.getReferences().isValid();
                }
                case 2: {
                    return this.enrollmentService.getPhotograph().isValid();
                }
                case 3: {
                    return this.enrollmentService.getFingerPrint().isValid();
                }
                case 4: {
                    return this.enrollmentService.getIris().isValid();
                }
                case 6: {
                    return this.isSelectedAnyUpdateUC();
                }
            }
        } else {
            switch (this.tabId) {
                case 0: {
                    return this.enrollmentService.getDemographics().isValid();
                }
                case 1: {
                    return this.enrollmentService.getReferences().isValid();
                }
                case 2: {
                    return this.enrollmentService.getPhotograph().isValid();
                }
                case 3: {
                    return this.enrollmentService.getFingerPrint().isValid();
                }
                case 4: {
                    return this.enrollmentService.getIris().isValid();
                }
            }
        }
        return false;
    }

    protected boolean isTabEnabled() {
        return this.tabEnabled;
    }

    private boolean isSelectedAnyUpdateUC() {
        FieldsUpdateCount fieldUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        return fieldUpdateCount.getName().hasToBeUpdated() || fieldUpdateCount.getDob().hasToBeUpdated() || fieldUpdateCount.getGender().hasToBeUpdated() || fieldUpdateCount.getAddress().hasToBeUpdated() || fieldUpdateCount.getMobile().hasToBeUpdated() || fieldUpdateCount.getEmail().hasToBeUpdated() || fieldUpdateCount.getBio().hasToBeUpdated() || fieldUpdateCount.getActivationAadhaar().hasToBeUpdated();
    }

    protected void onPrevButtonClick(ActionEvent event) {
        this.navigateToPreviousTab(this.tabId);
    }

    protected void onNextButtonClick(ActionEvent event) {
        this.navigateToNextTab(this.tabId);
    }

    protected void onNextButtonClickForeign(ActionEvent event, int foreignDemoTab, int size, String tabbedPaneName) {
        if (foreignDemoTab < size - 1) {
            IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get(tabbedPaneName);
            tabbedPaneElement.set("selected-index", (Object)(++foreignDemoTab));
        } else {
            this.navigateToNextTab(this.tabId);
        }
    }

    protected void onPrevButtonClickForeign(ActionEvent event, int foreignDemoTab) {
        if (foreignDemoTab > 0) {
            IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get("hID_Foreign_TabPane");
            tabbedPaneElement.set("selected-index", (Object)(--foreignDemoTab));
        }
    }

    protected void onPrevButtonClickReference(ActionEvent event, int foreignDemoTab) {
        if (foreignDemoTab > 0) {
            IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get("hID_Reference_TabPane");
            tabbedPaneElement.set("selected-index", (Object)(--foreignDemoTab));
        }
    }

    private void navigateToNextTab(int tabId) {
        IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get("hID_Enrol_TabPane");
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (tabId != 5) {
                tabbedPaneElement.set("selected-index", (Object)(this.tabIndex + 1));
            }
        } else {
            switch (tabId) {
                case 0: {
                    if (this.enrollmentService.isTabEnabled(tabId + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)1);
                        break;
                    }
                    this.navigateToNextTab(tabId + 1);
                    break;
                }
                case 1: {
                    if (this.enrollmentService.isTabEnabled(tabId + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)2);
                        break;
                    }
                    this.navigateToNextTab(tabId + 1);
                    break;
                }
                case 2: {
                    if (this.enrollmentService.isTabEnabled(tabId + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)3);
                        break;
                    }
                    this.navigateToNextTab(tabId + 1);
                    break;
                }
                case 3: {
                    if (this.enrollmentService.isTabEnabled(tabId + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)4);
                        break;
                    }
                    this.navigateToNextTab(tabId + 1);
                    break;
                }
                case 4: {
                    if (this.enrollmentService.isTabEnabled(tabId + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)5);
                        break;
                    }
                    this.navigateToNextTab(tabId + 1);
                    break;
                }
            }
        }
    }

    private void navigateToNextTabForUC(int tabIdd) {
        IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get("hID_Enrol_TabPane");
        if (this.enrollmentService.isOnlineUpdate()) {
            if (tabIdd != 5) {
                tabbedPaneElement.set("selected-index", (Object)(this.tabIndex + 1));
            }
        } else {
            switch (tabIdd) {
                case 0: {
                    if (this.enrollmentService.isTabEnabled(tabIdd + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)0);
                        break;
                    }
                    this.navigateToNextTab(tabIdd + 1);
                    break;
                }
                case 1: {
                    if (this.enrollmentService.isTabEnabled(tabIdd + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)1);
                        break;
                    }
                    this.navigateToNextTab(tabIdd + 1);
                    break;
                }
                case 2: {
                    if (this.enrollmentService.isTabEnabled(tabIdd + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)2);
                        break;
                    }
                    this.navigateToNextTab(tabIdd + 1);
                    break;
                }
                case 3: {
                    if (this.enrollmentService.isTabEnabled(tabIdd + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)3);
                        break;
                    }
                    this.navigateToNextTab(tabIdd + 1);
                    break;
                }
                case 4: {
                    if (this.enrollmentService.isTabEnabled(tabIdd + 1)) {
                        tabbedPaneElement.set("selected-index", (Object)4);
                        break;
                    }
                    this.navigateToNextTab(tabIdd + 1);
                    break;
                }
            }
        }
    }

    private void navigateToPreviousTab(int tabId) {
        IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get("hID_Enrol_TabPane");
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (tabId != 6) {
                tabbedPaneElement.set("selected-index", (Object)(this.tabIndex - 1));
            }
        } else {
            switch (tabId) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.enrollmentService.isTabEnabled(tabId - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)0);
                        break;
                    }
                    this.navigateToPreviousTab(tabId - 1);
                    break;
                }
                case 2: {
                    if (this.enrollmentService.isTabEnabled(tabId - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)1);
                        break;
                    }
                    this.navigateToPreviousTab(tabId - 1);
                    break;
                }
                case 3: {
                    if (this.enrollmentService.isTabEnabled(tabId - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)2);
                        break;
                    }
                    this.navigateToPreviousTab(tabId - 1);
                    break;
                }
                case 4: {
                    if (this.enrollmentService.isTabEnabled(tabId - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)3);
                        break;
                    }
                    this.navigateToPreviousTab(tabId - 1);
                    break;
                }
                case 5: {
                    if (this.enrollmentService.isTabEnabled(tabId - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)4);
                        break;
                    }
                    this.navigateToPreviousTab(tabId - 1);
                }
            }
        }
    }

    private void navigateToPreviousTabForUC(int tabIdd) {
        IViewElement tabbedPaneElement = (IViewElement)this.view.getElementMap().get("hID_Enrol_TabPane");
        if (this.enrollmentService.isOnlineUpdate()) {
            if (tabIdd != 6) {
                tabbedPaneElement.set("selected-index", (Object)(this.tabIndex - 1));
            }
        } else {
            switch (tabIdd) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.enrollmentService.isTabEnabled(tabIdd - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)-1);
                        break;
                    }
                    this.navigateToPreviousTab(tabIdd - 1);
                    break;
                }
                case 2: {
                    if (this.enrollmentService.isTabEnabled(tabIdd - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)0);
                        break;
                    }
                    this.navigateToPreviousTab(tabIdd - 1);
                    break;
                }
                case 3: {
                    if (this.enrollmentService.isTabEnabled(tabIdd - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)1);
                        break;
                    }
                    this.navigateToPreviousTab(tabIdd - 1);
                    break;
                }
                case 4: {
                    if (this.enrollmentService.isTabEnabled(tabIdd - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)2);
                        break;
                    }
                    this.navigateToPreviousTab(tabIdd - 1);
                    break;
                }
                case 5: {
                    if (this.enrollmentService.isTabEnabled(tabIdd - 1)) {
                        tabbedPaneElement.set("selected-index", (Object)3);
                        break;
                    }
                    this.navigateToPreviousTab(tabIdd - 1);
                }
            }
        }
    }

    protected boolean showTransliterationDiffWarning(String title, Component parent) {
        String demographicsOverride = this.enrollmentService.getDemographicsOverride();
        if (StringUtils.isNotBlank((String)demographicsOverride)) {
            Object response = L10nOptionPaneBuilder.getInstance().createWarningPane().message((Object)MsgKeysEnrol.WARN_EDITDIST, new Object[]{demographicsOverride + "<br>Do you wish to continue?"}).messageType(3).title(title).optionType(0).options(new Object[]{"Yes", "No"}).show(parent);
            return !response.equals("No");
        }
        return true;
    }

    protected boolean showTransliterationDiffWarningUC(String title, Component parent) {
        String demographicsOverride = this.enrollmentService.getDemographicsOverride();
        if (StringUtils.isNotBlank((String)demographicsOverride)) {
            String message = "Input in English does not match that in local language for the following field(s)";
            L10nOptionPane optionPane = L10nOptionPaneBuilder.getInstance().createYesNoPane().message((Object)(message + demographicsOverride + ".Do you wish to continue?"), new Object[0]).title(title).options(new Object[]{MsgKeysCommon.YES, MsgKeysCommon.NO});
            Object option = optionPane.showInfoPopupUCTest(parent, message + demographicsOverride + ".Do you wish to continue?");
            return option.equals(MsgKeysCommon.YES);
        }
        return true;
    }
}

