/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.biox;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.biox.BioxControl;
import in.gov.uidai.ec.ui.enrol.biox.BioxViewPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

class BiometricsExceptionController
extends EnrollmentControllerBase {
    private final BioxControl bioxControl;
    private final BioxViewPeer viewElement;

    BiometricsExceptionController(BioxViewPeer viewElement, EnrollmentService enrollmentService) {
        super(viewElement.getView(), enrollmentService, -1, -1);
        this.viewElement = viewElement;
        this.bioxControl = viewElement.getBioxControl();
        this.initView();
    }

    private void initView() {
        this.addActionListener(this.viewElement.cancelButton, this::onCancelClick);
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.addActionListener(this.viewElement.okButton, (ActionListener)this.viewElement.getEventCtx().getEventListener("UC_hID_BioxOk", ActionListener.class));
        } else {
            this.addActionListener(this.viewElement.okButton, (ActionListener)this.viewElement.getEventCtx().getEventListener("hID_BioxOk", ActionListener.class));
        }
        this.bioxControl.addBiometricExceptionDetailChangeListener(this::onBiometricsDetailChange);
    }

    private void onCancelClick(ActionEvent event) {
        JButton button = (JButton)event.getSource();
        SwingUtilities.getWindowAncestor(button).setVisible(false);
    }

    private void onBiometricsDetailChange(BiometricsExceptionDetail biometricsExceptionDetail) {
        this.enrollmentService.getBiometricsException().setExceptionDetail(biometricsExceptionDetail);
    }
}

