/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.biox;

import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.biometrics.rddup.IResidentDedupAnalyzer;
import in.gov.uidai.ec.security.sapi.SecurityProvider;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.ui.enrol.biox.IBioxConstants;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysEnrol;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BioxControl
implements IOnScreenDisplayAware,
IBioxDataProvider,
IBioxConstants,
IEventContextAware {
    private final List<Consumer<BiometricsExceptionDetail>> detailChangeListeners = new ArrayList<Consumer<BiometricsExceptionDetail>>();
    private IOnScreenDisplay osd;
    private IResidentDedupAnalyzer rddup;
    private IPreSyncPreference preSyncPref;
    private EnrollmentService enrollmentService;
    private BiometricsExceptionDetail biometricsExceptionDetail = new BiometricsExceptionDetail();
    private IEventContext evtCtx;

    public BioxControl() {
        this.resetData();
    }

    public final void setPreSyncPreference(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
        SecurityProvider.getInst().setKeySize(this.preSyncPref.getKeySize());
    }

    public void setResidentDedupAnalyzer(IResidentDedupAnalyzer rddup) {
        this.rddup = rddup;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public List<BiometricPosition> getAvailableEyes() {
        return this.biometricsExceptionDetail.getAvailableEyes();
    }

    public List<BiometricPosition> getAvailableFingers() {
        return this.biometricsExceptionDetail.getAvailableFingers();
    }

    public List<BiometricPosition> getMissingEyes() {
        return this.biometricsExceptionDetail.getMissingEyes();
    }

    public List<BiometricPosition> getMissingFingers() {
        return this.biometricsExceptionDetail.getMissingFingers();
    }

    public final void resetData() {
        this.biometricsExceptionDetail = new BiometricsExceptionDetail();
    }

    @EventHandler(name="hID_Enrol_ShowBiox", method="actionPerformed")
    public void onShowBioxWin(ILiteEvent evt) {
        String pScafId = evt.getScaffoldId();
        AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
        boolean isChild = ageDob.isChild();
        if (!ageDob.isValid() || isChild) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysEnrol.BIOX_MINOR, (Component)this.osd.getWindowForScaffold(pScafId), new Object[0]);
            return;
        }
        String scafId = this.osd.compose(pScafId, "bioxWin", "bioxView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="UC_hID_Enrol_ShowBiox", method="actionPerformed")
    public void onShowBioxWinUC(ILiteEvent evt) {
        String pScafId = evt.getScaffoldId();
        String scafId = this.osd.compose(pScafId, "bioxWin", "bioxView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_Uenrol_ShowBiox", method="actionPerformed")
    public void onUenrolShowBioxWin(ILiteEvent evt) {
        boolean minorFlag;
        String pScafId = evt.getScaffoldId();
        ILiteView view = this.osd.getView(evt.getViewId());
        Map eMap = view.getElementMap();
        boolean adobFlag = (Boolean)((IViewElement)eMap.get("eID_DemoTab_AdobOpt")).get("isSelected");
        if (adobFlag && (minorFlag = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isChild())) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysEnrol.BIOX_MINOR, (Component)this.osd.getWindowForScaffold(pScafId), new Object[0]);
            return;
        }
        String scafId = this.osd.compose(pScafId, "bioxWin", "bioxView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="UC_hID_Uenrol_ShowBiox", method="actionPerformed")
    public void onUenrolShowBioxWinUC(ILiteEvent evt) {
        String pScafId = evt.getScaffoldId();
        String scafId = this.osd.compose(pScafId, "bioxWin", "bioxView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_BioxWinHandler", method="windowOpened")
    public void onBioxWinOpened(ILiteEvent evt) {
        String viewId = this.osd.getScaffold(evt.getScaffoldId()).getViewId();
        ILiteView view = this.osd.getView(viewId);
        Map eMap = view.getElementMap();
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            ((IViewElement)eMap.get("eID_Biox_LeftHand")).set("missing", (Object)this.biometricsExceptionDetail.getMissingFingers());
            ((IViewElement)eMap.get("eID_Biox_RightHand")).set("missing", (Object)this.biometricsExceptionDetail.getMissingFingers());
            ((IViewElement)eMap.get("eID_Biox_LeftEye")).set("missing", (Object)this.biometricsExceptionDetail.getMissingEyes());
            ((IViewElement)eMap.get("eID_Biox_RightEye")).set("missing", (Object)this.biometricsExceptionDetail.getMissingEyes());
        }
    }

    @EventHandler(name="hID_BioxOk", method="actionPerformed")
    public void onBioxOk(ILiteEvent evt) {
        String scafId = evt.getScaffoldId();
        ILiteView view = this.osd.getView(evt.getViewId());
        if (view == null) {
            this.osd.dispose(scafId);
            return;
        }
        IViewElement leftHand = (IViewElement)view.getElementMap().get("eID_Biox_LeftHand");
        IViewElement rightHand = (IViewElement)view.getElementMap().get("eID_Biox_RightHand");
        IViewElement leftEye = (IViewElement)view.getElementMap().get("eID_Biox_LeftEye");
        IViewElement rightEye = (IViewElement)view.getElementMap().get("eID_Biox_RightEye");
        this.biometricsExceptionDetail.reset();
        this.biometricsExceptionDetail.addLeftSlapFingers((List)leftHand.get("available"), (List)leftHand.get("missing"));
        this.biometricsExceptionDetail.addRightSlapFingers((List)rightHand.get("available"), (List)rightHand.get("missing"));
        ArrayList availableEyes = new ArrayList();
        availableEyes.addAll((List)leftEye.get("available"));
        availableEyes.addAll((List)rightEye.get("available"));
        ArrayList missingEyes = new ArrayList();
        missingEyes.addAll((List)leftEye.get("missing"));
        missingEyes.addAll((List)rightEye.get("missing"));
        this.biometricsExceptionDetail.addEyes(availableEyes, missingEyes);
        if (!this.preSyncPref.getAllowFullBe() && this.biometricsExceptionDetail.getAvailableFingers().size() == 0 && this.biometricsExceptionDetail.getAvailableEyes().size() == 0) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"100% biometric exception enrollment is not supported by the application", null, new Object[0]);
            this.resetData();
            return;
        }
        String pScafId = this.osd.getScaffold(scafId).getParentId();
        String pViewId = this.osd.getScaffold(pScafId).getViewId();
        ILiteView pView = this.osd.getView(pViewId);
        Map peMap = pView.getElementMap();
        ((IViewElement)peMap.get("eID_FingerTab_LeftSlap")).call("clear");
        ((IViewElement)peMap.get("eID_FingerTab_RightSlap")).call("clear");
        ((IViewElement)peMap.get("eID_FingerTab_ThumbSlap")).call("clear");
        ((IViewElement)peMap.get("eID_IrisTab_BothEyes")).call("clear");
        ((IViewElement)peMap.get("eID_IrisTab_LeftEye")).call("clear");
        ((IViewElement)peMap.get("eID_IrisTab_RightEye")).call("clear");
        this.rddup.reset();
        this.fireDetailChangeListeners(this.biometricsExceptionDetail);
        this.osd.dispose(scafId);
    }

    @EventHandler(name="UC_hID_BioxOk", method="actionPerformed")
    public void onBioxOkUC(ILiteEvent evt) {
        String scafId = evt.getScaffoldId();
        ILiteView view = this.osd.getView(evt.getViewId());
        if (view == null) {
            this.osd.dispose(scafId);
            return;
        }
        IViewElement leftHand = (IViewElement)view.getElementMap().get("eID_Biox_LeftHand");
        IViewElement rightHand = (IViewElement)view.getElementMap().get("eID_Biox_RightHand");
        IViewElement leftEye = (IViewElement)view.getElementMap().get("eID_Biox_LeftEye");
        IViewElement rightEye = (IViewElement)view.getElementMap().get("eID_Biox_RightEye");
        this.biometricsExceptionDetail.reset();
        this.biometricsExceptionDetail.addLeftSlapFingers((List)leftHand.get("available"), (List)leftHand.get("missing"));
        this.biometricsExceptionDetail.addRightSlapFingers((List)rightHand.get("available"), (List)rightHand.get("missing"));
        ArrayList availableEyes = new ArrayList();
        availableEyes.addAll((List)leftEye.get("available"));
        availableEyes.addAll((List)rightEye.get("available"));
        ArrayList missingEyes = new ArrayList();
        missingEyes.addAll((List)leftEye.get("missing"));
        missingEyes.addAll((List)rightEye.get("missing"));
        this.biometricsExceptionDetail.addEyes(availableEyes, missingEyes);
        if (!this.preSyncPref.getAllowFullBe() && this.biometricsExceptionDetail.getAvailableFingers().size() == 0 && this.biometricsExceptionDetail.getAvailableEyes().size() == 0) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"100% biometric exception enrollment is not supported by the application", null, new Object[0]);
            this.resetData();
            return;
        }
        this.fireDetailChangeListeners(this.biometricsExceptionDetail);
        this.osd.dispose(scafId);
        if (this.enrollmentService.isUpdateUC()) {
            ActionEvent updateEvent = new ActionEvent(evt.getEvent().getSource(), 1, "actionPerformed");
            this.renderConsentPageForUpdate(updateEvent);
        }
    }

    private void renderConsentPageForUpdate(ActionEvent updateEvent) {
        ((ActionListener)this.evtCtx.getEventListener("renderConsent", ActionListener.class)).actionPerformed(updateEvent);
    }

    @GenericEventHandler(value="eID_Biox_Reset")
    public void onBioxReset() {
        this.resetData();
    }

    void addBiometricExceptionDetailChangeListener(Consumer<BiometricsExceptionDetail> delegate) {
        if (this.detailChangeListeners.stream().noneMatch(t -> t.getClass().getCanonicalName().startsWith(delegate.getClass().getCanonicalName().split("[$]")[0]))) {
            this.detailChangeListeners.add(delegate);
        }
    }

    private void fireDetailChangeListeners(BiometricsExceptionDetail biometricsExceptionDetail) {
        this.detailChangeListeners.forEach(detail -> detail.accept(biometricsExceptionDetail));
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtx = ctxt;
    }
}

