/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.biox;

import in.gov.uidai.ec.ui.enrol.biox.IBioxField;
import in.gov.uidai.swing.fontman.FontManager;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class BioxToggleField
extends JComponent
implements IBioxField {
    private final Cursor handCursor = new Cursor(12);
    private final Cursor defaultCursor = new Cursor(0);
    private Rectangle hotSpot;
    private ImageIcon bioPic;
    private ImageIcon missingBioPic;
    private boolean bioPresent = true;
    private String title;

    protected BioxToggleField() {
        MouseAdapter pointClickHandler = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BioxToggleField.this.doMouseClicked(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                BioxToggleField.this.doMouseMoved(evt);
            }
        };
        this.addMouseListener(pointClickHandler);
        this.addMouseMotionListener(pointClickHandler);
        this.setFont(FontManager.getInst().getScreenFont("broadside.ttf", 1, 14));
    }

    protected final void setBioPic(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.bioPic = new ImageIcon(cl.getResource(path));
    }

    protected final void setMissingBioPic(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        this.missingBioPic = new ImageIcon(cl.getResource(path));
    }

    protected final void setHotSpot(int x, int y, int width, int height) {
        this.hotSpot = new Rectangle(x, y, width, height);
    }

    protected final boolean isBioPresent() {
        return this.bioPresent;
    }

    protected final void setBioPresent(boolean flag) {
        this.bioPresent = flag;
        this.repaint();
    }

    protected final void toggleBioPresent() {
        this.bioPresent = !this.bioPresent;
        this.repaint();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public final void reset() {
        this.bioPresent = true;
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.bioPic == null) {
            return new Dimension(1, 1);
        }
        int titleHeight = 0;
        if (this.title != null && this.getFont() != null) {
            Font compFont = this.getFont();
            FontMetrics fm = this.getFontMetrics(compFont);
            titleHeight = fm.getHeight() + 5;
        }
        return new Dimension(this.bioPic.getIconWidth(), this.bioPic.getIconHeight() + titleHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font compFont;
        FontMetrics fm;
        int textWidth;
        if (this.bioPic == null) {
            return;
        }
        Dimension dim = this.getSize();
        if (dim.height < this.bioPic.getIconHeight()) {
            return;
        }
        if (dim.width < this.bioPic.getIconWidth()) {
            return;
        }
        if (this.bioPresent && this.bioPic != null) {
            g.drawImage(this.bioPic.getImage(), 0, 0, this);
        } else if (this.missingBioPic != null) {
            g.drawImage(this.missingBioPic.getImage(), 0, 0, this);
        }
        if (this.title != null && this.getFont() != null && (textWidth = (fm = this.getFontMetrics(compFont = this.getFont())).stringWidth(this.title)) < this.getWidth()) {
            int posx = this.getWidth() / 2 - textWidth / 2;
            int posy = this.getHeight() - 5;
            g.setFont(compFont);
            g.drawString(this.title, posx, posy);
        }
    }

    private void doMouseClicked(MouseEvent evt) {
        if (this.hotSpot == null) {
            return;
        }
        if (evt.isAltDown() || evt.isControlDown() || evt.isShiftDown() || evt.isMetaDown() || evt.isPopupTrigger()) {
            return;
        }
        if (evt.getButton() != 1) {
            return;
        }
        if (this.hotSpot.contains(evt.getPoint())) {
            this.bioPresent = !this.bioPresent;
            this.repaint();
        }
    }

    private void doMouseMoved(MouseEvent evt) {
        if (this.hotSpot == null) {
            return;
        }
        Point loc = evt.getPoint();
        if (this.hotSpot.contains(loc)) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }
}

