/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.biox;

import in.gov.uidai.ec.ui.enrol.biox.BioxOverlayField;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class RightHandField
extends BioxOverlayField {
    private static final String FINGER_1 = "finger1";
    private static final String FINGER_2 = "finger2";
    private static final String FINGER_3 = "finger3";
    private static final String FINGER_4 = "finger4";
    private static final String THUMB = "thumb";

    public RightHandField() {
        this.setTitle("Right Hand");
        this.setBioPic("res/images/hand-right.png");
        this.addHotSpot(FINGER_4, 7, 53, 24, 24);
        this.addHotSpot(FINGER_3, 39, 16, 24, 24);
        this.addHotSpot(FINGER_2, 75, 5, 24, 24);
        this.addHotSpot(FINGER_1, 125, 23, 24, 24);
        this.addHotSpot(THUMB, 168, 110, 24, 24);
        this.enableEvents(8L);
        HierarchyListener hl = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                RightHandField.this.createKeyboardBinding(RightHandField.FINGER_1, "control F1");
                RightHandField.this.createKeyboardBinding(RightHandField.FINGER_2, "control F2");
                RightHandField.this.createKeyboardBinding(RightHandField.FINGER_3, "control F3");
                RightHandField.this.createKeyboardBinding(RightHandField.FINGER_4, "control F4");
                RightHandField.this.createKeyboardBinding(RightHandField.THUMB, "control F5");
            }
        };
        this.addHierarchyListener(hl);
    }

    @Override
    public List<BiometricPosition> available(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (this.isBioPresent(FINGER_1)) {
            result.add(BiometricPosition.RIGHT_INDEX);
        }
        if (this.isBioPresent(FINGER_2)) {
            result.add(BiometricPosition.RIGHT_MIDDLE);
        }
        if (this.isBioPresent(FINGER_3)) {
            result.add(BiometricPosition.RIGHT_RING);
        }
        if (this.isBioPresent(FINGER_4)) {
            result.add(BiometricPosition.RIGHT_LITTLE);
        }
        if (this.isBioPresent(THUMB)) {
            result.add(BiometricPosition.RIGHT_THUMB);
        }
        return result;
    }

    @Override
    public List<BiometricPosition> missing(List<BiometricPosition> posList) {
        List<BiometricPosition> result = posList;
        if (result == null) {
            result = new ArrayList<BiometricPosition>();
        }
        if (!this.isBioPresent(FINGER_1)) {
            result.add(BiometricPosition.RIGHT_INDEX);
        }
        if (!this.isBioPresent(FINGER_2)) {
            result.add(BiometricPosition.RIGHT_MIDDLE);
        }
        if (!this.isBioPresent(FINGER_3)) {
            result.add(BiometricPosition.RIGHT_RING);
        }
        if (!this.isBioPresent(FINGER_4)) {
            result.add(BiometricPosition.RIGHT_LITTLE);
        }
        if (!this.isBioPresent(THUMB)) {
            result.add(BiometricPosition.RIGHT_THUMB);
        }
        return result;
    }

    @Override
    public void setMissing(List<BiometricPosition> posList) {
        this.reset();
        if (posList.contains(BiometricPosition.RIGHT_INDEX)) {
            this.setBioPresent(FINGER_1, false);
        }
        if (posList.contains(BiometricPosition.RIGHT_MIDDLE)) {
            this.setBioPresent(FINGER_2, false);
        }
        if (posList.contains(BiometricPosition.RIGHT_RING)) {
            this.setBioPresent(FINGER_3, false);
        }
        if (posList.contains(BiometricPosition.RIGHT_LITTLE)) {
            this.setBioPresent(FINGER_4, false);
        }
        if (posList.contains(BiometricPosition.RIGHT_THUMB)) {
            this.setBioPresent(THUMB, false);
        }
    }

    private void createKeyboardBinding(final String name, String shortcut) {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root == null) {
            return;
        }
        root.getInputMap().put(KeyStroke.getKeyStroke(shortcut), "right-" + name);
        AbstractAction axn = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RightHandField.this.toggleBioPresent(name);
            }
        };
        root.getActionMap().put("right-" + name, axn);
    }
}

