/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.confirmbioauth;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.ecmpapi.RequestEncryptionHelper;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.oauthapi.json.bioauth.BioAuthTokenData;
import in.gov.uidai.ec.rd.device.xml.PidData;
import in.gov.uidai.ec.rd.device.xml.additional_info;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.ConfirmerDetails;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.biologin.BiometricType;
import in.gov.uidai.ec.ui.biologin.pid.AdditionalInfo;
import in.gov.uidai.ec.ui.biologin.pid.Data;
import in.gov.uidai.ec.ui.biologin.pid.DeviceInfo;
import in.gov.uidai.ec.ui.biologin.pid.Info;
import in.gov.uidai.ec.ui.biologin.pid.PidAuthWrapper;
import in.gov.uidai.ec.ui.biologin.pid.Resp;
import in.gov.uidai.ec.ui.biologin.pid.Skey;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth16Request;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth16Response;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioAuth25Request;
import in.gov.uidai.ec.ui.enrol.confirmbioauth.BioConfirmViewPeer;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioConfirmController
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BioConfirmController.class);
    private final BioConfirmViewPeer view;
    private final ISessionService sessionService;
    private final boolean isEnrolmentWithRdBiometric;
    private final ConfirmerDetails confirmerDetails;
    private final Map<RDCaptureType, Boolean> isSignatureVerified = new HashMap<RDCaptureType, Boolean>();
    private final ActionListener eventListener;
    private static final String TID = "registered";

    BioConfirmController(BioConfirmViewPeer viewElements) {
        super(viewElements.getView(), viewElements.enrollmentService, -1, -1);
        this.view = viewElements;
        this.sessionService = viewElements.sessionService;
        this.isEnrolmentWithRdBiometric = viewElements.isRDBasedUpdate;
        this.confirmerDetails = this.enrollmentService.getConfirmerDetails();
        this.eventListener = this.enrollmentService.isSupervisorAuthRequired() ? (ActionListener)this.view.getEventCtx().getEventListener("supervisorAuth", ActionListener.class) : (ActionListener)this.view.getEventCtx().getEventListener("HID_ACK_SLIP_PANEL_DISPLAY", ActionListener.class);
        this.initView();
    }

    private void initView() {
        this.addStartCaptureListener(this.view.opFingerField, this::onStartCapture);
        this.addStartCaptureListener(this.view.opIrisField, this::onStartCapture);
        this.addBiometricsListener(this.view.opFingerField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.opIrisField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        if (this.isEnrolmentWithRdBiometric) {
            this.addRDBiometricsListener(this.view.bioPanel.getRDBioField(AuthParamType.OPERATOR, this.view.authTypeIsFinger() ? DeviceType.FINGERPRINT_AUTH : DeviceType.IRIS_AUTH), e -> this.enableSaveButton());
            this.view.bioPanel.getVerifyButton().entrySet().iterator().next().getValue().setVisible(false);
            this.view.biometricsAuthService.addBiometricsVerifiedListener(this::onRDSignatureCapture);
        }
        this.addActionListener(this.view.saveButton, this::updateBiometricsDataToModelAndLoadNextScreen);
    }

    private void onStartCapture(String fieldLabel) {
        LOGGER.info("Started new biometric capture for " + fieldLabel);
        this.view.saveButton.setEnabled(false);
    }

    private void enableSaveButton() {
        this.view.saveButton.setEnabled(true);
        this.view.savePanel.setBackground(new Color(19, 126, 178));
        this.view.enable = true;
    }

    private void updateBiometricsDataToModelAndLoadNextScreen(ActionEvent evt) {
        IVisualExecutionContext veCtxt = this.view.getView().getVisualExecutionContext();
        Utils.showProgressBar(veCtxt, "Authenticating ... ");
        ThreadPool.commonPool().submit(() -> {
            boolean isSuccess = false;
            try {
                BioAuth16Response response = null;
                if (this.isEnrolmentWithRdBiometric) {
                    BioAuth25Request request = this.prepareConfirmBioAuth25Request();
                    this.enableBiometricFields(false);
                    response = this.enrollmentService.bioRDAuthConfirmEnrol(request);
                } else {
                    BioAuth16Request request = this.prepareConfirmBioAuthRequest();
                    this.enableBiometricFields(false);
                    response = this.enrollmentService.bioAuthConfirmEnrol(request);
                }
                if (response.success()) {
                    if (response.isAuthSuccess()) {
                        this.enrollmentService.operatorConfirmationSucess();
                        this.view.cancelButton.doClick();
                        isSuccess = true;
                        Thread.sleep(1000L);
                        this.eventListener.actionPerformed(evt);
                    } else {
                        Utils.cancelProgressBar(veCtxt);
                        LOGGER.error("{} for sid : {} while confirm transaction", (Object)CommonUtilsUC.getErrorMessage((UosResponse)response), (Object)this.enrollmentService.getSid());
                        L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage((UosResponse)response), (Component)this.view.getContentPane(), CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), (String)this.enrollmentService.getOauthGwApiService().getTransactionId(), (String)CommonUtilsUC.getErrorMessage((UosResponse)response), (Exception)new Exception(CommonUtilsUC.getErrorMessage((UosResponse)response)))), CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), new String[0]);
                    }
                } else {
                    Utils.cancelProgressBar(veCtxt);
                    LOGGER.error("{} for sid {}", (Object)CommonUtilsUC.getErrorMessage((UosResponse)response), (Object)this.enrollmentService.getSid());
                    L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage((UosResponse)response), (Component)this.view.getContentPane(), CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                    TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), (String)CommonUtilsUC.getErrorMessage((UosResponse)response), (String)this.enrollmentService.getOauthGwApiService().getTransactionId(), (Exception)new Exception(CommonUtilsUC.getErrorMessage((UosResponse)response)))), CommonUtilsUC.getErrorCode((UosResponse)response, ErrorCodes.UC_GEN_001.getErrorCode()), new String[0]);
                }
            }
            catch (OnlineGatewayException e) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error connecting to BioAuth16 server for sid : {} while confirm transaction", (Object)this.enrollmentService.getSid());
                L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)this.view.getContentPane(), e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
                LOGGER.error("Failed to update capture attempt in model", (Throwable)e);
                this.enableBiometricFields(true);
            }
            catch (InterruptedException e) {
                Utils.cancelProgressBar(veCtxt);
                LOGGER.error("Error while sleeping the thread for sid: {}", (Object)this.enrollmentService.getSid());
                L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)this.view.getContentPane(), ErrorCodes.UC_NET_002.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_NET_002.getErrorCode(), new String[0]);
                LOGGER.error("Failed to update capture attempt in model", (Throwable)e);
                this.enableBiometricFields(true);
            }
            finally {
                Utils.cancelProgressBar(veCtxt);
                if (!isSuccess) {
                    this.view.cancelButton.doClick();
                }
            }
        });
    }

    private void enableBiometricFields(boolean enable) {
        this.enableBioField(this.view.opFingerField, enable);
        this.enableBioField(this.view.opIrisField, enable);
    }

    private void enableBioField(BiometricsNonRDField biometricsNonRDField, boolean enable) {
        if (biometricsNonRDField != null) {
            biometricsNonRDField.setEnabled(enable);
        }
    }

    private void onRDSignatureCapture(RDCaptureType captureType, Signature signature, CaptureAttempt captureAttempt) {
        boolean isOperatorBioVerified;
        this.isSignatureVerified.putIfAbsent(captureType, true);
        BodyPart bodyPart = captureType.getDeviceType() == DeviceType.FINGERPRINT_AUTH ? BodyPart.THUMB_LEFT : BodyPart.IRIS_LEFT;
        BiometricsCapture bioCapture = this.confirmerDetails.getBioCapture(captureAttempt, bodyPart);
        if (captureType.getUserType() == AuthParamType.OPERATOR) {
            UserDetails userDetails = this.populateOperatorDemoDetails();
            userDetails.setSignature(signature);
            userDetails.setBiometrics(bioCapture);
            this.confirmerDetails.setOperator(userDetails);
        }
        boolean bl = isOperatorBioVerified = this.confirmerDetails.getOperator().getSignature() != null;
        if (this.view.authTypeIsFinger()) {
            isOperatorBioVerified = isOperatorBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(AuthParamType.OPERATOR, DeviceType.FINGERPRINT_AUTH), false) != false;
        } else {
            boolean bl2 = isOperatorBioVerified = isOperatorBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(AuthParamType.OPERATOR, DeviceType.IRIS_AUTH), false) != false;
            if (!isOperatorBioVerified) {
                // empty if block
            }
            this.view.saveButton.setEnabled(true);
        }
    }

    private boolean validateBiometrics() {
        boolean status = true;
        status = this.view.authTypeIsFinger() ? this.validateBiometrics(this.view.opFingerField) : (status &= this.validateBiometrics(this.view.opIrisField));
        if (status) {
            this.view.savePanel.setBackground(new Color(19, 126, 178));
            this.view.enable = true;
        }
        return status;
    }

    private boolean isBioCapturedAndValid(BiometricsNonRDField confirmField) {
        return true;
    }

    private CaptureAttempt getCaptureAttempt(BiometricsNonRDField biometricsNonRDField) throws Exception {
        CaptureAttempt captureAttempt = biometricsNonRDField.getCaptureAttempt();
        if (!this.isBioCapturedAndValid(biometricsNonRDField)) {
            String message = "Failed to process " + biometricsNonRDField.getLabel() + " data. Please capture again.";
            this.showError((JComponent)biometricsNonRDField, message);
            throw new Exception(message);
        }
        return captureAttempt;
    }

    private boolean validateBiometrics(BiometricsNonRDField opConfirmField) {
        this.view.savePanel.setBackground(new Color(19, 126, 178));
        this.view.enable = true;
        return true;
    }

    private void populateOperatorDetails() throws Exception {
        UserDetails userDetails = this.populateOperatorDemoDetails();
        if (this.view.authTypeIsFinger()) {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.opFingerField), BodyPart.THUMB_LEFT));
        } else {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.opIrisField), BodyPart.IRIS_LEFT));
        }
        this.populateLVSDetails(userDetails, false);
        this.confirmerDetails.setOperator(userDetails);
    }

    private UserDetails populateOperatorDemoDetails() {
        UserDetails userDetails = new UserDetails(this.enrollmentService);
        userDetails.setUserId(this.sessionService.getOperatorCredentials().getOperatorId());
        userDetails.setUid(this.sessionService.getOperatorCredentials().getUid());
        userDetails.setFullName(this.sessionService.getOperatorCredentials().getFullName());
        return userDetails;
    }

    public void populateLVSDetails(UserDetails ud, boolean isIntroducer) {
        try {
            OnBoardingStatus obStat = LVSLocator.instance().getStatus(ud.getUid());
            String allowedStatus = OnBoardingStatus.ONBOARD.name() + "|" + OnBoardingStatus.PARTIALLY_BOARDED + "|" + OnBoardingStatus.NOT_BOARDED;
            ud.setAllowedLvsStatus(isIntroducer ? allowedStatus : OnBoardingStatus.ONBOARD.name());
            ud.setCurrentLvsStatus(obStat == null ? OnBoardingStatus.NOT_BOARDED.name() : obStat.name());
            ud.setLvsCheck(true);
        }
        catch (Exception e) {
            ud.setLvsCheck(false);
        }
    }

    private BioAuth16Request prepareConfirmBioAuthRequest() {
        BioAuth16Request request = new BioAuth16Request();
        request.setUid(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOpUid());
        request.setIsBio(true);
        byte[] data = null;
        if (this.view.authTypeIsFinger()) {
            data = this.view.opFingerField.getCaptureAttempt().getImage().getOriginalData();
            this.view.opFingerField.getCaptureAttempt().delete();
            request.setBiometricType(String.valueOf(BiometricType.FIR));
        } else {
            data = this.view.opIrisField.getCaptureAttempt().getImage().getOriginalData();
            this.view.opIrisField.getCaptureAttempt().delete();
            request.setBiometricType(String.valueOf(BiometricType.IIR));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
        try {
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] encData = RequestEncryptionHelper.encryptRequest((ByteArrayOutputStream)baos, null);
        request.setBiometric(Base64.getEncoder().encodeToString(encData));
        request.setBioEncrypted(true);
        return request;
    }

    private BioAuth25Request prepareConfirmBioAuth25Request() {
        PidData pidData = this.view.bioPanel.getRDBioField(AuthParamType.OPERATOR, this.view.authTypeIsFinger() ? DeviceType.FINGERPRINT_AUTH : DeviceType.IRIS_AUTH).getPidData();
        this.view.bioPanel.getRDBioField(AuthParamType.OPERATOR, this.view.authTypeIsFinger() ? DeviceType.FINGERPRINT_AUTH : DeviceType.IRIS_AUTH).getCaptureAttempt().delete();
        BioAuthTokenData bioAuthTokenData = this.view.getTokenData();
        PidAuthWrapper pidAuthWrapper = new PidAuthWrapper();
        Data data = new Data();
        data.setType(this.view.authTypeIsFinger() ? "FMR" : "IIR");
        data.setValue(Base64.getEncoder().encodeToString(pidData.getData()));
        Resp resp = new Resp();
        resp.setErrorCode(this.stringToInt(pidData.getResp().getErrCode()));
        resp.setErrorInfo(pidData.getResp().getErrInfo());
        resp.setfCount(this.stringToInt(pidData.getResp().getfCount()));
        resp.setfType(this.stringToInt(pidData.getResp().getfType()));
        resp.setiCount(this.stringToInt(pidData.getResp().getiCount()));
        resp.setiType(0);
        resp.setpCount(this.stringToInt(pidData.getResp().getpCount()));
        resp.setpType(0);
        resp.setNmPoints(this.stringToInt(pidData.getResp().getNmPoints()));
        resp.setqScore(this.stringToInt(pidData.getResp().getqScore()));
        Skey skey = new Skey();
        skey.setCi(pidData.getSkey().getCi());
        skey.setValue(Base64.getEncoder().encodeToString(pidData.getSkey().getValue()));
        List infoList = ((additional_info)pidData.getDeviceInfo().getAdditional_info().get(0)).getParam().stream().map(o -> new Info(o.getName())).collect(Collectors.toList());
        AdditionalInfo additionalInfo = new AdditionalInfo();
        additionalInfo.setInfo(infoList);
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDc(pidData.getDeviceInfo().getDc());
        deviceInfo.setDpId(pidData.getDeviceInfo().getDpId());
        deviceInfo.setMc(pidData.getDeviceInfo().getMc());
        deviceInfo.setMi(pidData.getDeviceInfo().getMi());
        deviceInfo.setRdsId(pidData.getDeviceInfo().getRdsId());
        deviceInfo.setRdsVer(pidData.getDeviceInfo().getRdsVer());
        deviceInfo.setAdditionalInfo(additionalInfo);
        pidAuthWrapper.setData(data);
        pidAuthWrapper.setResp(resp);
        pidAuthWrapper.setHmac(Base64.getEncoder().encodeToString(pidData.getHmac()));
        pidAuthWrapper.setsKey(skey);
        pidAuthWrapper.setDeviceInfo(deviceInfo);
        BioAuth25Request request = new BioAuth25Request();
        request.setUid(this.enrollmentService.getOAuthSessionService().getOperatorDetails().getOpUid());
        request.setIsBio(true);
        request.setTid(TID);
        request.setRdPidData(pidAuthWrapper);
        return request;
    }

    private int stringToInt(String num) {
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

