/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.consent;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.sun.javafx.webkit.WebConsoleListener;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.token.AuthCodeListener;
import in.gov.uidai.ec.oauthapi.token.TokenManager;
import in.gov.uidai.ec.oauthapi.token.TokenUtils;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.biologin.BioAuthType;
import in.gov.uidai.ec.ui.biologin.UserType;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.consent.ConsentViewPeer;
import in.gov.uidai.ec.ui.enrol.consent.IConsentConstants;
import in.gov.uidai.ec.ui.oponlinelogin.IOperatorOnlineLoginConstants;
import in.gov.uidai.ec.ui.oponlinelogin.OAuthAlert;
import in.gov.uidai.ec.ui.oponlinelogin.gps.WebViewWrapper;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.ec.util.WebviewLocalProxy;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.input.KeyCode;
import javafx.scene.web.WebView;
import javax.swing.JButton;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsentController
extends ControllerBase
implements IConsentConstants,
IOperatorOnlineLoginConstants,
INavigationConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsentController.class);
    private final ConsentViewPeer viewElements;
    private final EnrollmentService enrollmentService;
    private final AuthCodeListener authCodeListener;
    private final TokenManager consentTokenManager;
    private final TokenManager hofConsentTokenManager;
    private final TokenManager opTokenManager;
    private final JButton initBioCaptureButton;
    private String codeVerifier;
    private boolean isConsentPageLoaded;
    private boolean isClosePopup;
    IVisualExecutionContext veCtxt;

    public ConsentController(ConsentViewPeer viewElements, AuthCodeListener consentAuthCodeListener, TokenManager consentTokenManager, TokenManager hofConsentTokenManager, TokenManager opTokenManager) {
        super(viewElements.getView());
        this.viewElements = viewElements;
        this.enrollmentService = viewElements.enrollmentService;
        this.consentTokenManager = consentTokenManager;
        this.hofConsentTokenManager = hofConsentTokenManager;
        this.opTokenManager = opTokenManager;
        this.authCodeListener = consentAuthCodeListener;
        this.initBioCaptureButton = new JButton("test");
        this.initBioCaptureButton.addActionListener((ActionListener)viewElements.evtCtxt.getEventListener("showResBioLoginPopup", ActionListener.class));
        this.enrollmentService.addOnBioLoginFailureListener(s -> this.closePopup((String)s, ErrorCodes.UC_CST_002.getErrorCode()));
        this.veCtxt = viewElements.getView().getVisualExecutionContext();
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> {
            LOGGER.trace("Inside platform run later call");
            WebviewLocalProxy.startLocalProxyServer();
            this.renderResidentConsentPage();
        });
    }

    public void renderResidentConsentPage() {
        String uri;
        if (this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isHofEnrollment() && !this.enrollmentService.isChildEnrollment()) {
            this.onConsentSuccess();
            return;
        }
        LOGGER.info("Initiating Consent Login screen");
        WebView webView = WebViewWrapper.getWebViewWrapper().getWebView();
        WebConsoleListener wc = (webView1, message, lineNumber, sourceId) -> LOGGER.debug("Console: [" + message + ":" + lineNumber + "] " + sourceId);
        WebConsoleListener.setDefaultListener((WebConsoleListener)wc);
        String codeVerifier = TokenUtils.randomString();
        this.setCodeVerifier(codeVerifier);
        try {
            uri = this.createUri(codeVerifier, this.enrollmentService.getSid());
        }
        catch (JsonProcessingException | URISyntaxException | NoSuchAlgorithmException e) {
            LOGGER.error("Error creating URI", e);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)e, ErrorCodes.UC_CST_003.getErrorCode(), new String[0]);
            this.showSimpleError(this.viewElements.getContentPane(), "Error occurred while trying to log in: Please contact support team", new Object[0]);
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!ConsentController.this.isConsentPageLoaded) {
                    LOGGER.info("Closing Consent Screen Now after waiting for 1 minute");
                    try {
                        ConsentController.this.closePopup("Page Load Failure", ErrorCodes.UC_CST_001.getErrorCode());
                    }
                    catch (Exception exception) {
                        LOGGER.info("Exception while calling closing popup");
                    }
                }
            }
        }, 60000L);
        Utils.showProgressBar(this.veCtxt, "Loading Consent Login Page");
        LOGGER.debug("Webview Location : {}", (Object)webView.getEngine().getLocation());
        CookieManager manager = new CookieManager();
        CookieHandler.setDefault(manager);
        manager.getCookieStore().removeAll();
        webView.getEngine().setOnAlert(stringWebEvent -> this.parseAlertAndCall((String)stringWebEvent.getData()));
        webView.getEngine().load(uri);
        this.viewElements.getJfxPanel().setScene(WebViewWrapper.getWebViewWrapper().getScene());
        this.viewElements.getJfxPanel().getScene().setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE || keyEvent.getCode() == KeyCode.F4 && keyEvent.isAltDown()) {
                LOGGER.debug("Closing Consent Login Javafx Engine through ESC press");
                if (WebViewWrapper.getWebViewWrapper().getWebView() != null) {
                    String path = this.getClass().getResource("/res/ecmp/html/blank.html").toExternalForm();
                    LOGGER.debug("Loaded consent blank page");
                    WebViewWrapper.getWebViewWrapper().getWebView().getEngine().load(path);
                }
            }
        });
    }

    private void closeJavaFxEngine() {
        LOGGER.debug("Closing Consent Javafx Engine through Close popup");
        WebviewLocalProxy.stopLocalProxyServer();
        Utils.cancelProgressBar(this.veCtxt);
        Platform.runLater(() -> {
            if (WebViewWrapper.getWebViewWrapper().getWebView() != null) {
                String path = this.getClass().getResource("/res/ecmp/html/blank.html").toExternalForm();
                LOGGER.debug("Loaded consent blank page");
                WebViewWrapper.getWebViewWrapper().getWebView().getEngine().load(path);
            }
        });
    }

    private String createUri(String codeVerifier, String sid) throws URISyntaxException, NoSuchAlgorithmException, JsonProcessingException {
        URIBuilder uriBuilder = new URIBuilder(this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthGWServicesUrl());
        uriBuilder.setPath("/consent/oauth/authorize");
        uriBuilder.setParameter("client_id", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getConsentOAuthClientId());
        uriBuilder.setParameter("grant_type", this.enrollmentService.getOauthGwApiService().getGatewayPreference().getOAuthGrantType());
        uriBuilder.setParameter("response_type", "code");
        uriBuilder.setParameter("scope", "READ");
        uriBuilder.setParameter("code_challenge_method", "S256");
        uriBuilder.setParameter("SID", sid);
        uriBuilder.setParameter("code_challenge", TokenUtils.getCodeChallenge((String)codeVerifier));
        uriBuilder.setParameter("authorization", this.opTokenManager.getAccessToken());
        if (this.enrollmentService.isHofEnrollment() && (this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isUpdateUC() && Strings.isNullOrEmpty((String)this.hofConsentTokenManager.getAccessToken()))) {
            uriBuilder.setParameter("is_hof", "true");
        }
        LOGGER.debug(uriBuilder.toString());
        return uriBuilder.toString();
    }

    private void parseAlertAndCall(String jsonString) {
        OAuthAlert oAuthAlert;
        try {
            oAuthAlert = (OAuthAlert)new ObjectMapper().readValue(jsonString, OAuthAlert.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String funcName = oAuthAlert.getEvent();
        HashMap<String, String> params = oAuthAlert.getParams();
        this.callFrontendUtil(funcName, params);
    }

    private void callFrontendUtil(String funcName, HashMap<String, String> params) {
        switch (funcName) {
            case "setCodeVerifier": {
                this.setCodeVerifier(params.get("codeVerifier"));
                break;
            }
            case "startBioAuth": {
                this.startBioAuth(params.get("token"), params.get("bioAuthType"));
                break;
            }
            case "closePopup": {
                this.closePopup(params.get("errorMessage"), null);
                break;
            }
            case "reLoginClosePopup": {
                this.reLoginClosePopup();
                break;
            }
            case "onSuccess": {
                this.onSuccess(params.get("authCode"));
                break;
            }
            case "pageLoaded": {
                this.pageLoaded(params.get("isLoadSuccess"));
                break;
            }
            default: {
                LOGGER.info("Failed to call FE function");
            }
        }
    }

    public void reLoginClosePopup() {
        LOGGER.info("Consent re-login initiated");
        WebViewWrapper.getWebViewWrapper().getWebView().getEngine().reload();
    }

    private void onConsentSuccess() {
        Utils.cancelProgressBar(this.veCtxt);
        this.viewElements.eventContext.fireGenericEvent("consent success", new Object[0]);
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public String getSid() {
        return this.enrollmentService.getSid();
    }

    public void startBioAuth(String token, String bioAuthType) {
        LOGGER.debug("Calling Resident Bio Auth through javafx " + token + " " + bioAuthType);
        if (this.enrollmentService.isHofEnrollment() && (this.enrollmentService.isNewEnrollmentUC() || this.enrollmentService.isHofConsentGoingOn())) {
            this.authCodeListener.acceptBioAuth(token, bioAuthType, UserType.HOF, this.enrollmentService.getOauthGwApiService().getTransactionId());
        } else {
            this.authCodeListener.acceptBioAuth(token, bioAuthType, UserType.RESIDENT, this.enrollmentService.getOauthGwApiService().getTransactionId());
        }
        if (!bioAuthType.equalsIgnoreCase(BioAuthType.face.name())) {
            this.initBioCaptureButton.doClick();
        }
    }

    public void closePopup(String errorMessage, String errorCode) {
        if (this.isClosePopup) {
            return;
        }
        if (errorMessage == null) {
            errorMessage = "";
        }
        ActionEvent jButtonEvent = new ActionEvent(this.viewElements.dummyActionListenerComp, 1001, "Anything", System.currentTimeMillis(), 0);
        this.closeJavaFxEngine();
        if (errorCode != null) {
            this.showErrorUC(this.viewElements.getContentPane(), "Consent Page Error: " + errorMessage, errorCode, this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
        }
        for (ActionListener listener : this.viewElements.dummyActionListenerComp.getActionListeners()) {
            listener.actionPerformed(jButtonEvent);
        }
        this.isClosePopup = true;
    }

    public void onSuccess(String authCode) {
        Utils.showProgressBar(this.veCtxt, "Processing consent request");
        try {
            if (this.enrollmentService.isHofConsentGoingOn()) {
                this.hofConsentTokenManager.accept(authCode, this.codeVerifier);
            } else {
                this.consentTokenManager.accept(authCode, this.codeVerifier);
            }
            LOGGER.info("Consent login successful");
        }
        catch (OnlineGatewayException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Utils.cancelProgressBar(this.veCtxt);
            this.showError(this.viewElements.getContentPane(), e.getMessage());
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
        finally {
            Utils.cancelProgressBar(this.veCtxt);
            this.closePopup(null, null);
            this.viewElements.dummyActionListenerComp.doClick();
            if (this.enrollmentService.isHofConsentGoingOn() && this.hofConsentTokenManager.getAccessToken() != null || this.consentTokenManager.getAccessToken() != null) {
                this.onConsentSuccess();
            }
        }
    }

    public void pageLoaded(String isLoadSuccess) {
        if (isLoadSuccess.equalsIgnoreCase("true")) {
            Utils.cancelProgressBar(this.veCtxt);
            LOGGER.info("Consent Page Loaded Successfully");
        }
        this.isConsentPageLoaded = isLoadSuccess.equalsIgnoreCase("true");
    }
}

