/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.PinCodeDetail;
import in.gov.uidai.ec.service.enrollment.model.PinCodeElement;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.demographics.LastSavedAddress;
import in.gov.uidai.ec.ui.opsync.IOpSyncFormConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressNormalizeControl
implements IOnScreenDisplayAware,
IDemoTabConstants,
IOpSyncFormConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressNormalizeControl.class);
    private static final String ENG_TLIT_LOCALE = "en_in";
    private IOnScreenDisplay osd;
    private IPinCodeService offlinePinCodeService;
    private IPinCodeService onlinePinCodeService;
    private IResourceBundleContext resBundleCtxt;
    private boolean pincodePopupMenuVisible;
    private IUIPreference uiPref;
    private boolean pinPropogate;
    private EnrollmentService enrollmentService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setOfflinePinCodeService(IPinCodeService _postOfficeDataService) {
        this.offlinePinCodeService = _postOfficeDataService;
    }

    public void setOnlinePinCodeService(IPinCodeService onlinePinCodeService) {
        this.onlinePinCodeService = onlinePinCodeService;
    }

    public void setResourceBundleContext(IResourceBundleContext rbc) {
        this.resBundleCtxt = rbc;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setEnrolmentService(EnrollmentService enrolmentService) {
        this.enrollmentService = enrolmentService;
    }

    @EventHandler(name="hID_DemoTab_PostOfficePropagate", method="focusLost")
    public void onPostOfficePropagate(ILiteEvent event) {
        Map eMap = this.osd.getView(event.getViewId()).getElementMap();
        IPinCodeService pinCodeService = this.getPinCodeService();
        if (pinCodeService == null || ((FocusEvent)event.getEvent()).isTemporary() || eMap.get("eID_DemoTab_PostOff") == null) {
            return;
        }
        PostOffice postOffice = (PostOffice)((IViewElement)eMap.get("eID_DemoTab_PostOff")).get("selectedOption");
        if (postOffice != null) {
            this.populateLocalPO(eMap, postOffice.getName());
        }
        SwingUtilities.invokeLater(() -> this.enrollmentService.firePOCodeLoaded());
    }

    @EventHandler(name="hID_DemoTab_PostOfficePropagate", method="focusGained")
    public void onPostOfficeFocusGain(ILiteEvent event) {
        if (this.isEnglishLocalLanguage() || ((FocusEvent)event.getEvent()).isTemporary()) {
            return;
        }
        ILiteView view = this.osd.getView(event.getViewId());
        Map eMap = view.getElementMap();
        String selectedPostOffice = (String)((IViewElement)eMap.get("eID_DemoTab_PostOff")).get("text");
        if (!selectedPostOffice.isEmpty()) {
            return;
        }
        String lastSelectedPo = (String)view.getExtraDataMap().get("last_selected_post_office");
        if (StringUtils.isNotBlank((String)lastSelectedPo)) {
            ((IViewElement)eMap.get("eID_DemoTab_TPostOff")).set("textDirect", (Object)"");
        }
        view.getExtraDataMap().put("last_selected_post_office", selectedPostOffice);
    }

    private void setPostOfficeValue(ILiteEvent event, IViewElement postOfficeElement, List<PostOffice> options) {
        postOfficeElement.set("options", options);
        if (options.isEmpty()) {
            this.showWarningMessage(event, postOfficeElement);
        } else {
            postOfficeElement.set("text", (Object)options.get(0).getName());
            postOfficeElement.set("selectedOption", (Object)options.get(0));
            ILiteView view = this.osd.getView(event.getViewId());
            if (!this.isEnglishLocalLanguage()) {
                ((IViewElement)view.getElementMap().get("eID_DemoTab_TPostOff")).set("text", (Object)"");
                view.getExtraDataMap().put("last_selected_post_office", "");
            }
        }
    }

    private void showWarningMessage(ILiteEvent event, IViewElement postOfficeElement) {
        Component comp = (Component)event.getEvent().getSource();
        L10nOptionPaneBuilder.getInstance().showWarning((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.ADDR_POSTOFFICE, new Object[0]), comp);
        postOfficeElement.set("text", (Object)"");
    }

    private void populatePostOffice(ILiteEvent event) {
        if (this.isValidVTC(event)) {
            this.populatePostOfficeList(event);
        } else {
            this.populatePostOfficeListNoVTC(event);
        }
    }

    private void populatePostOfficeList(ILiteEvent event) {
        ILiteView view = this.osd.getView(event.getViewId());
        IViewElement pinCodeElement = (IViewElement)view.getElementMap().get("eID_DemoTab_SPinCode");
        IViewElement postOfficeElement = (IViewElement)view.getElementMap().get("eID_DemoTab_PostOff");
        postOfficeElement.set("options", null);
        String pincode = (String)pinCodeElement.get("text");
        PostalAddress postAddr = (PostalAddress)pinCodeElement.get("selectedOption");
        if (StringUtils.isNotBlank((String)pincode)) {
            IPinCodeService pinCodeService = this.getPinCodeService();
            List options = pinCodeService.findPostOffices(Integer.parseInt(pincode), postAddr.getVtc());
            if (options != null && options.size() > 1) {
                PostOffice select = new PostOffice();
                select.setName("Select");
                options.add(0, select);
            }
            this.setPostOfficeValue(event, postOfficeElement, options);
            if (this.pinPropogate) {
                view.getExtraDataMap().put("default_po_list", options);
            }
            if (options != null && !options.isEmpty() && options.get(0) != null) {
                this.populateLocalPO(view.getElementMap(), ((PostOffice)options.get(0)).getName());
            }
        }
    }

    private void populateLocalPO(Map<String, IViewElement> eMap, String poName) {
        if (this.isEnglishLocalLanguage()) {
            return;
        }
        PostalAddress postAddr = (PostalAddress)eMap.get("eID_DemoTab_SPinCode").get("selectedOption");
        String pincode = (String)eMap.get("eID_DemoTab_SPinCode").get("text");
        if (postAddr == null) {
            return;
        }
        String vtcCode = "";
        if (postAddr.getVtc() != null) {
            vtcCode = postAddr.getVtc().getAddressCode();
        }
        try {
            IPinCodeService pinCodeService = this.getPinCodeService();
            eMap.get("eID_DemoTab_TPostOff").set("text", (Object)"");
            eMap.get("eID_DemoTab_TPostOff").set("enable", (Object)false);
            PostOffice locPO = pinCodeService.findLocalePostOffice(pincode, vtcCode, poName, this.enrollmentService.getEnrollmentLangCode());
            if (locPO != null) {
                boolean validateLocPo = this.validateTlitAddress(locPO.getLocaleName());
                if (validateLocPo) {
                    eMap.get("eID_DemoTab_TPostOff").set("textDirect", (Object)locPO.getLocaleName());
                } else {
                    L10nOptionPaneBuilder.getInstance().showError((Object)"Local PO Name is not valid", null, new Object[0]);
                }
            } else {
                eMap.get("eID_DemoTab_TPostOff").set("text", (Object)poName);
                eMap.get("eID_DemoTab_TPostOff").set("enable", (Object)true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in populateLocalPO", (Throwable)e);
        }
    }

    private boolean validateTlitAddress(String taddress) {
        boolean isAddressValid = true;
        if (taddress != null) {
            isAddressValid = !taddress.matches(".*[ ]{2,}.*");
            isAddressValid &= !taddress.matches(".*[\\.]{2,}.*");
            isAddressValid &= !taddress.matches(".*[#]{2,}.*");
            isAddressValid &= !taddress.matches(".*[-]{2,}.*");
            isAddressValid &= !taddress.matches(".*[,]{2,}.*");
        } else {
            isAddressValid = false;
        }
        return isAddressValid;
    }

    private boolean isValidVTC(ILiteEvent event) {
        IViewElement vtcListView;
        ILiteView view = this.osd.getView(event.getViewId());
        IViewElement iViewElement = vtcListView = view.getElementMap().get("eID_DemoTab_SVtc") != null ? (IViewElement)view.getElementMap().get("eID_DemoTab_SVtc") : (IViewElement)view.getElementMap().get("eId_OpSync_Svtc");
        if (vtcListView != null) {
            return (Boolean)vtcListView.get("enable") == false;
        }
        return false;
    }

    private void populatePostOfficeListNoVTC(ILiteEvent event) {
        ILiteView view = this.osd.getView(event.getViewId());
        IViewElement pinCodeElement = (IViewElement)view.getElementMap().get("eID_DemoTab_SPinCode");
        String pincode = (String)pinCodeElement.get("text");
        IViewElement postOfficeElement = (IViewElement)view.getElementMap().get("eID_DemoTab_PostOff");
        postOfficeElement.set("options", null);
        List<Object> options = new ArrayList<PostOffice>();
        try {
            IPinCodeService pinCodeService = this.getPinCodeService();
            options = pinCodeService.findHeadAndSubPostOffices(Integer.parseInt(pincode));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPostOfficeValue(event, postOfficeElement, options);
        if (options.get(0) != null) {
            this.populateLocalPO(view.getElementMap(), ((PostOffice)options.get(0)).getName());
        }
        SwingUtilities.invokeLater(() -> this.enrollmentService.firePOCodeLoaded());
    }

    @EventHandler(name="hID_DemoTab_SPinCodePopup", method="popupMenuWillBecomeVisible")
    public void onPinCodePopupTrigger(ILiteEvent event) {
        this.pincodePopupMenuVisible = true;
        IPinCodeService pinCodeService = this.getPinCodeService();
        if (pinCodeService == null) {
            return;
        }
        ILiteView view = this.osd.getView(event.getViewId());
        IViewElement pinCodeElement = view.getElementMap().get("eID_DemoTab_SPinCode") != null ? (IViewElement)view.getElementMap().get("eID_DemoTab_SPinCode") : (IViewElement)view.getElementMap().get("eId_OpSync_SPinCode");
        pinCodeElement.set("options", null);
        String partialValue = (String)pinCodeElement.get("text");
        List options = pinCodeService.findByPinCode(Integer.parseInt(partialValue), true);
        pinCodeElement.set("options", (Object)options);
    }

    @EventHandler(name="hID_DemoTab_SPinCodePopup", method="popupMenuWillBecomeInvisible")
    public void onpinCodePopupHidden(ILiteEvent event) {
        this.pincodePopupMenuVisible = false;
    }

    @EventHandler(name="hID_DemoTab_SPinCodePropagate", method="focusLost")
    public void onStrictPinCodePropagate(ILiteEvent event) {
        this.pinPropogate = true;
        IPinCodeService pinCodeService = this.getPinCodeService();
        if (pinCodeService == null || ((FocusEvent)event.getEvent()).isTemporary()) {
            return;
        }
        ILiteView view = this.osd.getView(event.getViewId());
        Map eMap = view.getElementMap();
        if (eMap == null) {
            return;
        }
        this.populatePincodeDetails(event);
        this.populateLocAddressDetails(event);
        SwingUtilities.invokeLater(() -> this.enrollmentService.firePincodeLoaded());
    }

    private void populateLocAddressDetails(ILiteEvent event) {
        ILiteView view = this.osd.getView(event.getViewId());
        Map eMap = view.getElementMap();
        String house = (String)((IViewElement)eMap.get("eID_DemoTab_House")).get("text");
        String street = (String)((IViewElement)eMap.get("eID_DemoTab_Street")).get("text");
        String landmark = (String)((IViewElement)eMap.get("eID_DemoTab_Landmark")).get("text");
        String locality = (String)((IViewElement)eMap.get("eID_DemoTab_Locality")).get("text");
        if (!((Boolean)((IViewElement)eMap.get("eID_DemoTab_THouse")).get("showing")).booleanValue()) {
            ((IViewElement)eMap.get("eID_DemoTab_THouse")).set("text", (Object)house);
        }
        if (!((Boolean)((IViewElement)eMap.get("eID_DemoTab_TStreet")).get("showing")).booleanValue()) {
            ((IViewElement)eMap.get("eID_DemoTab_TStreet")).set("text", (Object)street);
        }
        if (!((Boolean)((IViewElement)eMap.get("eID_DemoTab_TLandmark")).get("showing")).booleanValue()) {
            ((IViewElement)eMap.get("eID_DemoTab_TLandmark")).set("text", (Object)landmark);
        }
        if (!((Boolean)((IViewElement)eMap.get("eID_DemoTab_TLocality")).get("showing")).booleanValue()) {
            ((IViewElement)eMap.get("eID_DemoTab_TLocality")).set("text", (Object)locality);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePincodeDetails(ILiteEvent event) {
        ILiteView view = this.osd.getView(event.getViewId());
        Map eMap = view.getElementMap();
        IViewElement stateField = (IViewElement)eMap.get("eID_DemoTab_SState");
        IViewElement distField = (IViewElement)eMap.get("eID_DemoTab_SDist");
        IViewElement subDistField = (IViewElement)eMap.get("eID_DemoTab_SubDist");
        IViewElement postOffField = (IViewElement)eMap.get("eID_DemoTab_PostOff");
        IViewElement vtcField = (IViewElement)eMap.get("eID_DemoTab_SVtc");
        IViewElement locStateField = (IViewElement)eMap.get("eID_DemoTab_TState");
        IViewElement locDistField = (IViewElement)eMap.get("eID_DemoTab_TDist");
        IViewElement locSubDistField = (IViewElement)eMap.get("eID_DemoTab_TSubDist");
        IViewElement locPostOffField = (IViewElement)eMap.get("eID_DemoTab_TPostOff");
        IViewElement locVtcField = (IViewElement)eMap.get("eID_DemoTab_TVtc");
        IViewElement pinCodeField = (IViewElement)eMap.get("eID_DemoTab_SPinCode");
        PostalAddress postAddr = (PostalAddress)pinCodeField.get("selectedOption");
        if (postAddr != null) {
            String nState = postAddr.getState().getAddressValue();
            String cvState = (String)stateField.get("text");
            if (!StringUtils.equalsIgnoreCase((String)cvState, (String)nState)) {
                stateField.set("text", (Object)nState);
                locStateField.set("textDirect", (Object)nState);
            }
            String nDist = postAddr.getDistrict().getAddressValue();
            String cvDist = (String)distField.get("text");
            if (!StringUtils.equalsIgnoreCase((String)cvDist, (String)nDist)) {
                distField.set("text", (Object)nDist);
                locDistField.set("textDirect", (Object)nDist);
            }
            String nSDist = postAddr.getSubDistrict().getAddressValue();
            String cvSDist = (String)subDistField.get("text");
            if (!StringUtils.equalsIgnoreCase((String)cvSDist, (String)nSDist)) {
                subDistField.set("text", (Object)nSDist);
                locSubDistField.set("textDirect", (Object)nSDist);
            }
            String nVtc = postAddr.getVtc().getAddressValue();
            String cvVtc = (String)vtcField.get("text");
            String nPincode = postAddr.getPinCode().getAddressCode();
            String cvPincode = (String)view.getExtraDataMap().get("CV_PINCODE");
            if (!StringUtils.equalsIgnoreCase((String)cvPincode, (String)nPincode) || !StringUtils.equalsIgnoreCase((String)cvVtc, (String)nVtc)) {
                vtcField.set("text", (Object)nVtc);
                locVtcField.set("text", (Object)nVtc);
                view.getExtraDataMap().put("CV_PINCODE", ((IViewElement)eMap.get("eID_DemoTab_SPinCode")).get("text"));
                this.populatePostOffice(event);
            }
            this.populateLocaleFields(postAddr, eMap);
            return;
        }
        stateField.set("text", (Object)"");
        distField.set("text", (Object)"");
        subDistField.set("text", (Object)"");
        postOffField.set("text", (Object)"");
        vtcField.set("text", (Object)"");
        locStateField.set("textDirect", (Object)"");
        locDistField.set("textDirect", (Object)"");
        locSubDistField.set("textDirect", (Object)"");
        locPostOffField.set("textDirect", (Object)"");
        locVtcField.set("textDirect", (Object)"");
        if (this.pincodePopupMenuVisible) {
            return;
        }
        String pinCodeStr = (String)pinCodeField.get("text");
        try {
            IPinCodeService pinCodeService = this.getPinCodeService();
            List postAddrList = new ArrayList();
            if (StringUtils.isNotBlank((String)pinCodeStr)) {
                postAddrList = pinCodeService.findByPinCode(Integer.parseInt(pinCodeStr), false);
            }
            Component comp = (Component)event.getEvent().getSource();
            if (postAddrList == null || postAddrList.isEmpty()) {
                if (this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_UPDATE) || this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_ENROLLMENT)) {
                    L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.ADDR_PIN, new Object[0]), comp, new Object[0]);
                } else {
                    L10nOptionPaneBuilder.getInstance().showError((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.ADDR_PIN, new Object[0]), comp, new Object[0]);
                }
                return;
            }
            if (postAddrList.size() > 1) {
                if (this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_UPDATE) || this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_ENROLLMENT)) {
                    L10nOptionPaneBuilder.getInstance().showInfoUC((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.SELECT_VTC_PO, new Object[0]));
                } else {
                    L10nOptionPaneBuilder.getInstance().showInfo((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.SELECT_VTC_PO, new Object[0]), comp, new Object[0]);
                }
                pinCodeField.call("grabFocus");
                return;
            }
            postAddr = (PostalAddress)postAddrList.get(0);
            pinCodeField.set("selectedOption", (Object)postAddr);
            stateField.set("text", (Object)postAddr.getState().getAddressValue());
            distField.set("text", (Object)postAddr.getDistrict().getAddressValue());
            subDistField.set("text", (Object)postAddr.getSubDistrict().getAddressValue());
            vtcField.set("text", (Object)postAddr.getVtc().getAddressValue());
            this.populatePostOffice(event);
            this.populateLocaleFields(postAddr, eMap);
        }
        finally {
            this.pinPropogate = false;
        }
    }

    private void populateLocaleFields(PostalAddress postAddr, Map<String, IViewElement> eMap) {
        PostalAddress locPOA = null;
        if (postAddr != null) {
            try {
                IPinCodeService pinCodeService = this.getPinCodeService();
                if (!this.isEnglishLocalLanguage()) {
                    locPOA = pinCodeService.findLocalePostalAddress(postAddr.getPinCode().getAddressCode(), postAddr.getVtc().getAddressCode(), postAddr.getSubDistrict().getAddressCode(), postAddr.getDistrict().getAddressCode(), postAddr.getState().getAddressCode(), this.enrollmentService.getEnrollmentLangCode());
                }
                if (locPOA != null) {
                    eMap.get("eID_DemoTab_TState").set("textDirect", (Object)locPOA.getState().getAddressValue());
                    eMap.get("eID_DemoTab_TDist").set("textDirect", (Object)locPOA.getDistrict().getAddressValue());
                    eMap.get("eID_DemoTab_TVtc").set("textDirect", (Object)locPOA.getVtc().getAddressValue());
                    eMap.get("eID_DemoTab_LastLocVtc").set("textDirect", (Object)locPOA.getVtc().getAddressValue());
                    eMap.get("eID_DemoTab_TSubDist").set("textDirect", (Object)locPOA.getSubDistrict().getAddressValue());
                    this.enablePOElements(eMap, false);
                } else {
                    eMap.get("eID_DemoTab_LastLocVtc").set("text", (Object)"");
                    this.enablePOElements(eMap, true);
                    eMap.get("eID_DemoTab_TState").set("text", (Object)postAddr.getState().getAddressValue());
                    eMap.get("eID_DemoTab_TDist").set("text", (Object)postAddr.getDistrict().getAddressValue());
                    eMap.get("eID_DemoTab_TVtc").set("text", (Object)postAddr.getVtc().getAddressValue());
                    eMap.get("eID_DemoTab_TSubDist").set("text", (Object)postAddr.getSubDistrict().getAddressValue());
                }
            }
            catch (Exception e) {
                LOGGER.debug("Error while getting Local Pincode Details: " + e.getMessage());
            }
        }
    }

    private void enablePOElements(Map<String, IViewElement> eMap, boolean enableFlag) {
        eMap.get("eID_DemoTab_TState").set("enable", (Object)enableFlag);
        eMap.get("eID_DemoTab_TDist").set("enable", (Object)enableFlag);
        eMap.get("eID_DemoTab_TSubDist").set("enable", (Object)enableFlag);
        eMap.get("eID_DemoTab_TVtc").set("enable", (Object)enableFlag);
        eMap.get("eID_DemoTab_TPostOff").set("enable", (Object)enableFlag);
    }

    private boolean isEnglishLocalLanguage() {
        String localeStr = this.uiPref.getTransliterationLocale("hi_IN");
        return localeStr.equalsIgnoreCase(ENG_TLIT_LOCALE);
    }

    @EventHandler(name="hID_DemoTab_LastSavedAddr", method="actionPerformed")
    public void onLastSavedAddress(ILiteEvent event) {
        Address lastSavedAddress = this.enrollmentService.getDemoContactDetails().getLastSavedAddress();
        LastSavedAddress savedAddr = this.getLastSavedAddress(lastSavedAddress);
        if (savedAddr == null || !lastSavedAddress.isMandatory() || !lastSavedAddress.isValid()) {
            return;
        }
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        PostalAddress pa = savedAddr.getPincode();
        address.setCareOfName(lastSavedAddress.getCareOfName());
        address.setCareOfNameLocal(lastSavedAddress.getCareOfNameLocal());
        address.setBuilding(lastSavedAddress.getBuilding());
        address.setBuildingLocal(lastSavedAddress.getBuildingLocal());
        address.setStreet(lastSavedAddress.getStreet());
        address.setStreetLocal(lastSavedAddress.getStreetLocal());
        address.setLandmark(lastSavedAddress.getLandmark());
        address.setLandmarkLocal(lastSavedAddress.getLandmarkLocal());
        address.setLocality(lastSavedAddress.getLocality());
        address.setLocalityLocal(lastSavedAddress.getLocalityLocal());
        address.setPinCodeDetail(lastSavedAddress.getPinCodeDetail());
        ILiteView view = this.osd.getView(event.getViewId());
        Map eMap = view.getElementMap();
        ((IViewElement)eMap.get("eID_DemoTab_CareOf")).set("text", (Object)savedAddr.getCareOfName());
        ((IViewElement)eMap.get("eID_DemoTab_TCareOf")).set("text", (Object)savedAddr.getCareOfName());
        ((IViewElement)eMap.get("eID_DemoTab_House")).set("text", (Object)savedAddr.getHouse());
        ((IViewElement)eMap.get("eID_DemoTab_Street")).set("text", (Object)savedAddr.getStreet());
        ((IViewElement)eMap.get("eID_DemoTab_Landmark")).set("text", (Object)savedAddr.getLandmark());
        ((IViewElement)eMap.get("eID_DemoTab_Locality")).set("text", (Object)savedAddr.getLocality());
        ((IViewElement)eMap.get("eID_DemoTab_THouse")).set("textDirect", (Object)savedAddr.getLocHouse());
        ((IViewElement)eMap.get("eID_DemoTab_TStreet")).set("textDirect", (Object)savedAddr.getLocStreet());
        ((IViewElement)eMap.get("eID_DemoTab_TLandmark")).set("textDirect", (Object)savedAddr.getLocLandmark());
        ((IViewElement)eMap.get("eID_DemoTab_TLocality")).set("textDirect", (Object)savedAddr.getLocLocality());
        if (pa != null) {
            ((IViewElement)eMap.get("eID_DemoTab_SPinCode")).set("text", (Object)pa.getPinCode().getAddressCode());
            ((IViewElement)eMap.get("eID_DemoTab_SPinCode")).set("selectedOption", (Object)pa);
            address.setPinCode(pa.getPinCode());
            address.setPinCodeLocal(pa.getPinCode().getAddressCode());
            try {
                SwingUtilities.invokeLater(() -> {
                    this.populatePincodeDetails(event);
                    ((IViewElement)eMap.get("eID_DemoTab_SVtc")).set("text", (Object)pa.getVtc().getAddressValue());
                    ((IViewElement)eMap.get("eID_DemoTab_SDist")).set("text", (Object)pa.getDistrict().getAddressValue());
                    ((IViewElement)eMap.get("eID_DemoTab_SState")).set("text", (Object)pa.getState().getAddressValue());
                    ((IViewElement)eMap.get("eID_DemoTab_TVtc")).set("textDirect", (Object)savedAddr.getLocVtc());
                    ((IViewElement)eMap.get("eID_DemoTab_TDist")).set("textDirect", (Object)savedAddr.getLocDistrict());
                    ((IViewElement)eMap.get("eID_DemoTab_TState")).set("textDirect", (Object)savedAddr.getLocState());
                    address.setVTC(pa.getVtc());
                    address.setDistrict(pa.getDistrict());
                    address.setSubDistrict(pa.getSubDistrict());
                    address.setState(pa.getState());
                    address.setVTCLocal(lastSavedAddress.getVTCLocal());
                    address.setDistrictLocal(lastSavedAddress.getDistrictLocal());
                    address.setSubDistrictLocal(lastSavedAddress.getSubDistrictLocal());
                    address.setStateLocal(lastSavedAddress.getStateLocal());
                    IViewElement postOfficeElement = (IViewElement)view.getElementMap().get("eID_DemoTab_PostOff");
                    Object options = postOfficeElement.get("options");
                    if (options instanceof List) {
                        try {
                            List postOffices = (List)options;
                            for (PostOffice postOffice : postOffices) {
                                if (!StringUtils.equals((String)postOffice.getName(), (String)savedAddr.getPostOffice())) continue;
                                ((IViewElement)eMap.get("eID_DemoTab_PostOff")).set("text", (Object)postOffice.getName());
                                ((IViewElement)eMap.get("eID_DemoTab_PostOff")).set("selectedOption", (Object)postOffice);
                                address.setPostOffice(postOffice);
                                break;
                            }
                            ((IViewElement)eMap.get("eID_DemoTab_TPostOff")).set("textDirect", (Object)savedAddr.getLocPostOffice());
                            address.setPostOfficeLocal(lastSavedAddress.getPoNameLocal());
                            address.setDefaultPo(lastSavedAddress.getDefaultPoName());
                        }
                        catch (Exception ignore) {
                            LOGGER.debug("error occured while getting postoffice details.");
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.debug("error occured while getting pincode details.");
            }
        }
    }

    @EventHandler(name="hID_DemoTab_SPinCodePropagate_Operator", method="focusLost")
    public void onStrictPinCodePropagateForOperatorSync(ILiteEvent event) {
        this.pinPropogate = true;
        IPinCodeService pinCodeService = this.getPinCodeService();
        if (pinCodeService == null || ((FocusEvent)event.getEvent()).isTemporary()) {
            return;
        }
        this.populatePincodeDetailsForOperatorSync(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePincodeDetailsForOperatorSync(ILiteEvent event) {
        ILiteView view = this.osd.getView(event.getViewId());
        Map eMap = view.getElementMap();
        IViewElement stateField = eMap.get("eID_DemoTab_SState") != null ? (IViewElement)eMap.get("eID_DemoTab_SState") : (IViewElement)eMap.get("eId_OpSync_SState");
        IViewElement distField = eMap.get("eID_DemoTab_SDist") != null ? (IViewElement)eMap.get("eID_DemoTab_SState") : (IViewElement)eMap.get("eId_OpSync_SDist");
        IViewElement subDistField = eMap.get("eID_DemoTab_SubDist") != null ? (IViewElement)eMap.get("eID_DemoTab_SState") : (IViewElement)eMap.get("eId_OpSync_SubDist");
        IViewElement postOffField = eMap.get("eID_DemoTab_PostOff") != null ? (IViewElement)eMap.get("eID_DemoTab_SState") : (IViewElement)eMap.get("eId_OpSync_PostOff");
        IViewElement vtcField = eMap.get("eID_DemoTab_SVtc") != null ? (IViewElement)eMap.get("eID_DemoTab_SState") : (IViewElement)eMap.get("eId_OpSync_Svtc");
        IViewElement pinCodeField = eMap.get("eID_DemoTab_SPinCode") != null ? (IViewElement)eMap.get("eID_DemoTab_SState") : (IViewElement)eMap.get("eId_OpSync_SPinCode");
        PostalAddress postAddr = (PostalAddress)pinCodeField.get("selectedOption");
        if (postAddr != null) {
            String nState = postAddr.getState().getAddressValue();
            String cvState = (String)stateField.get("text");
            if (!StringUtils.equalsIgnoreCase((String)cvState, (String)nState)) {
                stateField.set("text", (Object)nState);
            }
            String nDist = postAddr.getDistrict().getAddressValue();
            String cvDist = (String)distField.get("text");
            if (!StringUtils.equalsIgnoreCase((String)cvDist, (String)nDist)) {
                distField.set("text", (Object)nDist);
            }
            String nSDist = postAddr.getSubDistrict().getAddressValue();
            String cvSDist = (String)subDistField.get("text");
            if (!StringUtils.equalsIgnoreCase((String)cvSDist, (String)nSDist)) {
                subDistField.set("text", (Object)nSDist);
            }
            String nVtc = postAddr.getVtc().getAddressValue();
            String cvVtc = (String)vtcField.get("text");
            String nPincode = postAddr.getPinCode().getAddressCode();
            String cvPincode = (String)view.getExtraDataMap().get("CV_PINCODE");
            IVisualExecutionContext vex = view.getVisualExecutionContext();
            if (vex != null) {
                vex.reset();
                vex.setMessage("Retrieving pincode details from pincode db. Please wait.");
            }
            try {
                if (!StringUtils.equalsIgnoreCase((String)cvPincode, (String)nPincode) || !StringUtils.equalsIgnoreCase((String)cvVtc, (String)nVtc)) {
                    vtcField.set("text", (Object)nVtc);
                    if (view.getTitle() == null || !view.getTitle().equals("Synchronize Operator Details")) {
                        view.getExtraDataMap().put("CV_PINCODE", ((IViewElement)eMap.get("eID_DemoTab_SPinCode")).get("text"));
                    }
                    this.populatePostOfficeForOperatorSync(event);
                }
            }
            finally {
                if (vex != null) {
                    vex.cancel();
                }
            }
            return;
        }
        stateField.set("text", (Object)"");
        distField.set("text", (Object)"");
        subDistField.set("text", (Object)"");
        postOffField.set("text", (Object)"");
        vtcField.set("text", (Object)"");
        if (this.pincodePopupMenuVisible) {
            return;
        }
        String pinCodeStr = (String)pinCodeField.get("text");
        if (StringUtils.isEmpty((String)pinCodeStr)) {
            return;
        }
        IVisualExecutionContext vex = view.getVisualExecutionContext();
        if (vex != null) {
            vex.reset();
            vex.setMessage("Retrieving pin code details from pincode db. Please wait.");
        }
        try {
            IPinCodeService pinCodeService = this.getPinCodeService();
            List postAddrList = pinCodeService.findByPinCode(Integer.parseInt(pinCodeStr), false);
            Component comp = (Component)event.getEvent().getSource();
            if (postAddrList == null || postAddrList.isEmpty()) {
                if (vex != null) {
                    vex.cancel();
                }
                L10nOptionPaneBuilder.getInstance().showError((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.ADDR_PIN, new Object[0]), comp, new Object[0]);
                return;
            }
            if (postAddrList.size() > 1) {
                if (vex != null) {
                    vex.cancel();
                }
                L10nOptionPaneBuilder.getInstance().showInfoUC((Object)this.resBundleCtxt.getMessage((Object)MsgKeysILV.SELECT_VTC_PO, new Object[0]));
                pinCodeField.call("grabFocus");
                return;
            }
            postAddr = (PostalAddress)postAddrList.get(0);
            pinCodeField.set("selectedOption", (Object)postAddr);
            stateField.set("text", (Object)postAddr.getState().getAddressValue());
            distField.set("text", (Object)postAddr.getDistrict().getAddressValue());
            subDistField.set("text", (Object)postAddr.getSubDistrict().getAddressValue());
            vtcField.set("text", (Object)postAddr.getVtc().getAddressValue());
            this.populatePostOfficeForOperatorSync(event);
        }
        finally {
            if (vex != null) {
                vex.cancel();
            }
            this.pinPropogate = false;
        }
    }

    private void populatePostOfficeForOperatorSync(ILiteEvent event) {
        if (this.isValidVTC(event)) {
            this.populatePostOfficeListForOperatorSync(event);
        } else {
            this.populatePostOfficeListNoVTCForOperatorSync(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePostOfficeListNoVTCForOperatorSync(ILiteEvent event) {
        ILiteView view = this.osd.getView(event.getViewId());
        IViewElement pinCodeElement = view.getElementMap().get("eID_DemoTab_SPinCode") != null ? (IViewElement)view.getElementMap().get("eID_DemoTab_SPinCode") : (IViewElement)view.getElementMap().get("eId_OpSync_SPinCode");
        String pincode = (String)pinCodeElement.get("text");
        IViewElement postOfficeElement = view.getElementMap().get("eID_DemoTab_PostOff") != null ? (IViewElement)view.getElementMap().get("eID_DemoTab_PostOff") : (IViewElement)view.getElementMap().get("eId_OpSync_PostOff");
        postOfficeElement.set("options", null);
        IVisualExecutionContext vex = null;
        if (!this.pinPropogate && (vex = this.osd.getView(event.getViewId()).getVisualExecutionContext()) != null) {
            vex.reset();
            vex.setMessage("Retrieving post office details from pincode db. Please wait.");
        }
        try {
            IPinCodeService pinCodeService = this.getPinCodeService();
            List options = pinCodeService.findHeadAndSubPostOffices(Integer.parseInt(pincode));
            this.setPostOfficeValue(event, postOfficeElement, options);
        }
        finally {
            if (vex != null) {
                vex.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePostOfficeListForOperatorSync(ILiteEvent event) {
        List options;
        ILiteView view = this.osd.getView(event.getViewId());
        IViewElement pinCodeElement = view.getElementMap().get("eID_DemoTab_SPinCode") != null ? (IViewElement)view.getElementMap().get("eID_DemoTab_SPinCode") : (IViewElement)view.getElementMap().get("eId_OpSync_SPinCode");
        IViewElement postOfficeElement = view.getElementMap().get("eID_DemoTab_PostOff") != null ? (IViewElement)view.getElementMap().get("eID_DemoTab_PostOff") : (IViewElement)view.getElementMap().get("eId_OpSync_PostOff");
        postOfficeElement.set("options", null);
        String pincode = (String)pinCodeElement.get("text");
        PostalAddress postAddr = (PostalAddress)pinCodeElement.get("selectedOption");
        IVisualExecutionContext vex = null;
        if (!this.pinPropogate && (vex = this.osd.getView(event.getViewId()).getVisualExecutionContext()) != null) {
            vex.reset();
            vex.setMessage("Retrieving post office details from master data. Please wait.");
        }
        try {
            IPinCodeService pinCodeService = this.getPinCodeService();
            options = pinCodeService.findPostOffices(Integer.parseInt(pincode), postAddr.getVtc());
            if (options != null) {
                PostOffice select = new PostOffice();
                select.setName("Select");
                options.add(0, select);
            }
        }
        finally {
            if (vex != null) {
                vex.cancel();
            }
        }
        this.setPostOfficeValueForOperator(event, postOfficeElement, options);
        if (this.pinPropogate) {
            view.getExtraDataMap().put("default_po_list", options);
        }
    }

    private void setPostOfficeValueForOperator(ILiteEvent event, IViewElement postOfficeElement, List<PostOffice> options) {
        postOfficeElement.set("options", options);
        if (options.isEmpty()) {
            this.showWarningMessage(event, postOfficeElement);
        } else {
            postOfficeElement.set("text", (Object)options.get(0).getName());
            postOfficeElement.set("selectedOption", (Object)options.get(0));
            ILiteView view = this.osd.getView(event.getViewId());
            if (this.isEnglishLocalLanguage()) {
                ((IViewElement)view.getElementMap().get("eID_DemoTab_PostOff")).set("text", (Object)"");
                view.getExtraDataMap().put("last_selected_post_office", "");
            }
        }
    }

    private LastSavedAddress getLastSavedAddress(Address lastSavedAddress) {
        if (lastSavedAddress == null) {
            return null;
        }
        LastSavedAddress lstSavedAddress = new LastSavedAddress();
        lstSavedAddress.setCareOfName(lastSavedAddress.getCareOfName());
        lstSavedAddress.setHouse(lastSavedAddress.getBuilding());
        lstSavedAddress.setLocHouse(lastSavedAddress.getBuildingLocal());
        lstSavedAddress.setStreet(lastSavedAddress.getStreet());
        lstSavedAddress.setLocStreet(lastSavedAddress.getStreetLocal());
        lstSavedAddress.setLandmark(lastSavedAddress.getLandmark());
        lstSavedAddress.setLocLandmark(lastSavedAddress.getLandmarkLocal());
        lstSavedAddress.setLocality(lastSavedAddress.getLocality());
        lstSavedAddress.setLocLocality(lastSavedAddress.getLocalityLocal());
        lstSavedAddress.setLocDistrict(lastSavedAddress.getDistrictLocal());
        lstSavedAddress.setPincode(this.getPostalAddress(lastSavedAddress));
        lstSavedAddress.setPostOffice(lastSavedAddress.getPoName());
        lstSavedAddress.setLocPostOffice(lastSavedAddress.getPoNameLocal());
        lstSavedAddress.setVtc(lastSavedAddress.getVTC());
        lstSavedAddress.setLocVtc(lastSavedAddress.getVTCLocal());
        lstSavedAddress.setLocState(lastSavedAddress.getStateLocal());
        return lstSavedAddress;
    }

    private PostalAddress getPostalAddress(Address lastSavedAddress) {
        PinCodeDetail pinCodeDetail = lastSavedAddress.getPinCodeDetail();
        PostalAddress postalAddress = new PostalAddress();
        postalAddress.setDistrict(this.getPostalAddressElement(pinCodeDetail.getDistrict()));
        postalAddress.setSubDistrict(this.getPostalAddressElement(pinCodeDetail.getSubDistrict()));
        postalAddress.setState(this.getPostalAddressElement(pinCodeDetail.getState()));
        postalAddress.setPinCode(this.getPostalAddressElement(pinCodeDetail.getPinCode()));
        postalAddress.setVtc(this.getPostalAddressElement(pinCodeDetail.getVtc()));
        return postalAddress;
    }

    private PostalAddressElement getPostalAddressElement(PinCodeElement pinCodeElement) {
        PostalAddressElement postalAddressElement = new PostalAddressElement();
        postalAddressElement.setAddressCode(pinCodeElement.getAddressCode());
        postalAddressElement.setAddressValue(pinCodeElement.getAddressValue());
        return postalAddressElement;
    }

    private IPinCodeService getPinCodeService() {
        if (!this.enrollmentService.isEnrolmentStateNull() && (this.enrollmentService.isDemoUpdate() || this.enrollmentService.isNewEnrollmentUC())) {
            return this.onlinePinCodeService;
        }
        return this.offlinePinCodeService;
    }
}

