/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrol.dynaddr.AddressField;
import in.gov.uidai.ec.service.enrol.dynaddr.AddressLabel;
import in.gov.uidai.ec.service.enrol.dynaddr.DynamicAddressLayout;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.service.pincode.PostalAddressElement;
import in.gov.uidai.ec.swing.combo.UidComboElementFactory;
import in.gov.uidai.ec.swing.combo.UidComboField;
import in.gov.uidai.ec.swing.tlit.DirectTranslitAssociation;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.demographics.PinCodeListRenderer;
import in.gov.uidai.ec.ui.enrol.demographics.PinCodeOptionHandler;
import in.gov.uidai.ec.ui.enrol.demographics.PostOfficeListRenderer;
import in.gov.uidai.ec.ui.enrol.demographics.PostOfficeOptionHandler;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.AutoSuggestDecorator;
import in.gov.uidai.swing.ExplicitFocusPath;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.fontman.FontManager;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.swing.translit.IMTranslitElementFactory;
import in.gov.uidai.swing.util.UidSwingUtilities;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;

public class AddressPanel
implements IDemoTabConstants,
IViewElementComposite {
    private static final String KEY_LOCK_ICON = "KEY_LOCK_ICON";
    private static final String KEY_UNLOCK_ICON = "KEY_UNLOCK_ICON";
    private static final String KEY_MANDATORY_ICON = "KEY_MANDATORY_ICON";
    private static final double[] COLS_SPEC_FORM = new double[]{-1.0, 5.0, 155.0, 5.0, 155.0};
    private final TransparentBox vtcPanel;
    private final TransparentBox addrArea;
    private final TransparentBox leftAddrArea;
    private final TransparentBox rightAddrArea;
    private final IResourceBundleContext rbCtxt;
    private final ExplicitFocusPath focusPath;
    private boolean isOnline;
    @ExportViewElement(as="eID_DemoTab_LastLocVtc", using=StandardSwingElementFactory.class)
    protected JTextField lastLocVtc;
    @ExportViewElement(as="eID_DemoTab_House", using=StandardSwingElementFactory.class)
    protected JTextField houseField;
    @ExportViewElement(as="eID_DemoTab_THouse", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locHouseField;
    @ExportViewElement(as="eID_DemoTab_Street", using=StandardSwingElementFactory.class)
    protected JTextField streetField;
    @ExportViewElement(as="eID_DemoTab_TStreet", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locStreetField;
    @ExportViewElement(as="eID_DemoTab_Landmark", using=StandardSwingElementFactory.class)
    protected JTextField landmarkField;
    @ExportViewElement(as="eID_DemoTab_TLandmark", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locLandmarkField;
    @ExportViewElement(as="eID_DemoTab_Locality", using=StandardSwingElementFactory.class)
    protected JTextField localityField;
    @ExportViewElement(as="eID_DemoTab_TLocality", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locLocalityField;
    @ExportViewElement(as="eID_DemoTab_SVtc", using=StandardSwingElementFactory.class)
    protected JTextField vtcField;
    @ExportViewElement(as="eID_DemoTab_TVtc", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locVtcField;
    @ExportViewElement(as="eID_DemoTab_PostOff", using=UidComboElementFactory.class)
    protected UidComboField postOffField;
    @ExportViewElement(as="eID_DemoTab_TPostOff", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locPostOffField;
    @ExportViewElement(as="eID_DemoTab_SDist", using=StandardSwingElementFactory.class)
    protected JTextField sDistrictField;
    @ExportViewElement(as="eID_DemoTab_TDist", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locDistrictField;
    @ExportViewElement(as="eID_DemoTab_SubDist", using=StandardSwingElementFactory.class)
    protected JTextField subDistField;
    @ExportViewElement(as="eID_DemoTab_TSubDist", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locSubDistField;
    @ExportViewElement(as="eID_DemoTab_SState", using=StandardSwingElementFactory.class)
    protected JTextField sStateField;
    @ExportViewElement(as="eID_DemoTab_TState", using=IMTranslitElementFactory.class)
    protected AbstractIMTranslitField locStateField;
    @ExportViewElement(as="eID_DemoTab_SPinCode", using=UidComboElementFactory.class)
    protected UidComboField sPinCodeField;
    protected DirectTranslitField locPinField;

    AddressPanel(IResourceBundleContext rbCtxt, IEventContext evtCtxt, IUIPreference uiPref, boolean isOnline, EnrollmentService enrollmentService) {
        this.rbCtxt = rbCtxt;
        this.isOnline = isOnline;
        this.createComponents(rbCtxt, evtCtxt, uiPref, enrollmentService);
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(uiPref, rbCtxt.getLocale().toString(), enrollmentService);
        this.vtcField = new JTextField();
        this.vtcField.setEnabled(false);
        this.lastLocVtc = new JTextField();
        InlineValidations ilv = new InlineValidations(rbCtxt);
        this.locVtcField = imb.createIMField(this.vtcField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        if (isOnline) {
            Font font = this.vtcField.getFont();
            this.vtcField.setFont(font);
            this.lastLocVtc.setFont(font);
            Font fontLoc = this.locVtcField.getFont();
            this.locVtcField.setFont(fontLoc);
        }
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locVtcField);
        this.locVtcField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locVtcField));
        TransparentBox vtcBox = new TransparentBox((LayoutManager)new CardLayout(0, 0));
        vtcBox.add((Component)this.vtcField, (Object)"strict");
        vtcBox.add((Component)this.lastLocVtc, (Object)"lastLocVtc");
        this.vtcPanel = new TransparentBox((LayoutManager)new BorderLayout(0, 0));
        this.vtcPanel.add((Component)vtcBox, (Object)"Center");
        double[][] mainGuides = new double[][]{{-1.0, 470.0, 5.0, 520.0, -1.0}, {-1.0}};
        this.addrArea = new TransparentBox((LayoutManager)new TableLayout((double[][])mainGuides));
        FocusListener handler = new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                JComponent comp = (JComponent)evt.getComponent();
                comp.setBorder(new LineBorder(Color.red));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                JComponent comp = (JComponent)evt.getComponent();
                comp.setBorder(null);
            }
        };
        this.addrArea.addFocusListener(handler);
        this.leftAddrArea = new TransparentBox();
        this.addrArea.add((Component)this.leftAddrArea, (Object)"1, 0, full, full");
        this.rightAddrArea = new TransparentBox();
        Locale locale = rbCtxt.getLocale();
        ComponentOrientation co = ComponentOrientation.getOrientation(locale);
        this.rightAddrArea.setComponentOrientation(co);
        this.addrArea.add((Component)this.rightAddrArea, (Object)"3, 0, full, full");
        this.setEnabled(false);
        this.focusPath = new ExplicitFocusPath("dynamic-address");
    }

    AddressPanel(IResourceBundleContext rbCtxt, IEventContext evtCtxt, IUIPreference uiPref, EnrollmentService enrollmentService) {
        this.rbCtxt = rbCtxt;
        this.createComponents(rbCtxt, evtCtxt, uiPref, enrollmentService);
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(uiPref, rbCtxt.getLocale().toString(), enrollmentService);
        this.vtcField = new JTextField();
        this.vtcField.setEnabled(false);
        this.lastLocVtc = new JTextField();
        InlineValidations ilv = new InlineValidations(rbCtxt);
        this.locVtcField = imb.createIMField(this.vtcField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locVtcField);
        this.locVtcField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locVtcField));
        TransparentBox vtcBox = new TransparentBox((LayoutManager)new CardLayout(0, 0));
        vtcBox.add((Component)this.vtcField, (Object)"strict");
        vtcBox.add((Component)this.lastLocVtc, (Object)"lastLocVtc");
        this.vtcPanel = new TransparentBox((LayoutManager)new BorderLayout(0, 0));
        this.vtcPanel.add((Component)vtcBox, (Object)"Center");
        double[][] mainGuides = new double[][]{{-1.0, 470.0, 5.0, 520.0, -1.0}, {-1.0}};
        this.addrArea = new TransparentBox((LayoutManager)new TableLayout((double[][])mainGuides));
        FocusListener handler = new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
                JComponent comp = (JComponent)evt.getComponent();
                comp.setBorder(new LineBorder(Color.red));
            }

            @Override
            public void focusLost(FocusEvent evt) {
                JComponent comp = (JComponent)evt.getComponent();
                comp.setBorder(null);
            }
        };
        this.addrArea.addFocusListener(handler);
        this.leftAddrArea = new TransparentBox();
        this.addrArea.add((Component)this.leftAddrArea, (Object)"1, 0, full, full");
        this.rightAddrArea = new TransparentBox();
        Locale locale = rbCtxt.getLocale();
        ComponentOrientation co = ComponentOrientation.getOrientation(locale);
        this.rightAddrArea.setComponentOrientation(co);
        this.addrArea.add((Component)this.rightAddrArea, (Object)"3, 0, full, full");
        this.setEnabled(false);
        this.focusPath = new ExplicitFocusPath("dynamic-address");
    }

    public JComponent toSwing() {
        return this.addrArea;
    }

    void doLayout(DynamicAddressLayout dal) {
        JComponent comp;
        AddressField pincodeLoc;
        AddressField poffLoc;
        AddressField subDistLoc;
        AddressField distLoc;
        AddressField vtcLoc;
        AddressField localityLoc;
        AddressField houseLoc;
        AddressField pincode;
        AddressField poff;
        AddressField subDist;
        AddressField dist;
        AddressField vtc;
        AddressField locality;
        LinkedHashMap<AddressField, JComponent> fcMap = new LinkedHashMap<AddressField, JComponent>();
        LinkedHashMap<AddressField, JComponent> lfcMap = new LinkedHashMap<AddressField, JComponent>();
        AddressField house = dal.getHouse();
        if (house != null) {
            fcMap.put(house, this.houseField);
            this.houseField.putClientProperty("xprop.visible", true);
        } else {
            this.houseField.putClientProperty("xprop.visible", false);
        }
        AddressField street = dal.getStreet();
        if (street != null) {
            fcMap.put(street, this.streetField);
            this.streetField.putClientProperty("xprop.visible", true);
        } else {
            this.streetField.putClientProperty("xprop.visible", false);
        }
        AddressField lmark = dal.getLandmark();
        if (lmark != null) {
            fcMap.put(lmark, this.landmarkField);
        }
        if ((locality = dal.getLocality()) != null) {
            fcMap.put(locality, this.localityField);
        }
        if ((vtc = dal.getVtc()) != null) {
            fcMap.put(vtc, (JComponent)this.vtcPanel);
        }
        if ((dist = dal.getDistrict()) != null) {
            fcMap.put(dist, this.sDistrictField);
        }
        if ((subDist = dal.getSubDistrict()) != null) {
            fcMap.put(subDist, this.subDistField);
            this.subDistField.putClientProperty("xprop.visible", true);
        } else {
            this.subDistField.putClientProperty("xprop.visible", false);
        }
        AddressField state = dal.getState();
        if (state != null) {
            fcMap.put(state, this.sStateField);
        }
        if ((poff = dal.getPo()) != null) {
            fcMap.put(poff, this.postOffField);
        }
        if ((pincode = dal.getPincode()) != null) {
            fcMap.put(pincode, this.sPinCodeField);
        }
        if ((houseLoc = dal.getHouseLocal()) != null) {
            lfcMap.put(houseLoc, (JComponent)this.locHouseField);
            this.locHouseField.putClientProperty((Object)"xprop.visible", (Object)true);
        } else {
            this.locHouseField.putClientProperty((Object)"xprop.visible", (Object)false);
        }
        AddressField streetLoc = dal.getStreetLocal();
        if (streetLoc != null) {
            lfcMap.put(streetLoc, (JComponent)this.locStreetField);
            this.locStreetField.putClientProperty((Object)"xprop.visible", (Object)true);
        } else {
            this.locStreetField.putClientProperty((Object)"xprop.visible", (Object)false);
        }
        AddressField lmarkLoc = dal.getLandmarkLocal();
        if (lmarkLoc != null) {
            lfcMap.put(lmarkLoc, (JComponent)this.locLandmarkField);
        }
        if ((localityLoc = dal.getLocalityLocal()) != null) {
            lfcMap.put(localityLoc, (JComponent)this.locLocalityField);
        }
        if ((vtcLoc = dal.getVtcLocal()) != null) {
            lfcMap.put(vtcLoc, (JComponent)this.locVtcField);
        }
        if ((distLoc = dal.getDistrictLocal()) != null) {
            lfcMap.put(distLoc, (JComponent)this.locDistrictField);
        }
        if ((subDistLoc = dal.getSubDistrictLocal()) != null) {
            lfcMap.put(subDistLoc, (JComponent)this.locSubDistField);
            this.locSubDistField.putClientProperty((Object)"xprop.visible", (Object)true);
        } else {
            this.locSubDistField.putClientProperty((Object)"xprop.visible", (Object)false);
        }
        AddressField stateLoc = dal.getStateLocal();
        if (stateLoc != null) {
            lfcMap.put(stateLoc, (JComponent)this.locStateField);
        }
        if ((poffLoc = dal.getPoLocal()) != null) {
            lfcMap.put(poffLoc, (JComponent)this.locPostOffField);
        }
        if ((pincodeLoc = dal.getPincodeLocal()) != null) {
            lfcMap.put(pincodeLoc, this.locPinField);
        }
        int numRows = Math.max(this.calculateNumRows(fcMap), this.calculateNumRows(lfcMap));
        double[] rowSpec = new double[numRows * 2];
        for (int i = 0; i < rowSpec.length; ++i) {
            rowSpec[i++] = 5.0;
            rowSpec[i] = 25.0;
        }
        TableLayout leftLayout = new TableLayout((double[][])new double[][]{COLS_SPEC_FORM, rowSpec});
        TableLayout rightLayout = new TableLayout((double[][])new double[][]{COLS_SPEC_FORM, rowSpec});
        this.leftAddrArea.removeAll();
        this.rightAddrArea.removeAll();
        this.addrArea.setFocusTraversalPolicy(null);
        this.leftAddrArea.setLayout((LayoutManager)leftLayout);
        this.rightAddrArea.setLayout((LayoutManager)rightLayout);
        for (int i = 1; i <= numRows; ++i) {
            List<AddressField> rfields;
            List<AddressField> lfields = this.getFieldsForRow(fcMap, i);
            if (!lfields.isEmpty()) {
                JLabel leftLab = this.createLabel(lfields, false);
                if (this.isOnline) {
                    Font font = leftLab.getFont();
                    leftLab.setFont(new Font(font.getName(), 0, 12));
                    leftLab.setForeground(new Color(19, 126, 178));
                }
                String lspec = "0, " + (i * 2 - 1) + ", right, full";
                this.leftAddrArea.add((Component)leftLab, (Object)lspec);
            }
            if ((rfields = this.getFieldsForRow(lfcMap, i)).isEmpty()) continue;
            JLabel rightLab = this.createLabel(rfields, true);
            if (this.isOnline) {
                Font font = rightLab.getFont();
                rightLab.setFont(new Font(font.getName(), 0, 15));
                rightLab.setForeground(new Color(19, 126, 178));
            }
            String rspec = "0, " + (i * 2 - 1) + ", right, full";
            this.rightAddrArea.add((Component)rightLab, (Object)rspec);
        }
        for (AddressField field : fcMap.keySet()) {
            comp = fcMap.get(field);
            this.layoutField(field, comp, false);
        }
        for (AddressField field : lfcMap.keySet()) {
            comp = lfcMap.get(field);
            this.layoutField(field, comp, true);
        }
        this.addrArea.validate();
        this.focusPath.clear();
        HashMap<AddressField, JComponent> fullMap = new HashMap<AddressField, JComponent>();
        fullMap.putAll(fcMap);
        fullMap.putAll(lfcMap);
        ArrayList fieldList = new ArrayList(fullMap.keySet());
        fieldList.sort(new FocusTraversalComparator());
        for (AddressField field : fieldList) {
            if (field == vtc) continue;
            JComponent comp2 = (JComponent)fullMap.get(field);
            this.focusPath.add((Component)comp2);
        }
    }

    public void addToFocusTraversalPolicy(ExplicitFocusTraversalPolicy eftp) {
        eftp.addNested(this.focusPath);
    }

    JComponent[] getActiveFields() {
        return new JComponent[]{this.houseField, this.locHouseField, this.streetField, this.locStreetField, this.landmarkField, this.locLandmarkField, this.localityField, this.locLocalityField, this.locSubDistField, this.locDistrictField, this.locStateField, this.postOffField, this.locPostOffField, this.sPinCodeField, this.locVtcField};
    }

    public void setEnabled(boolean flag) {
        JComponent[] fields;
        for (JComponent field : fields = this.getActiveFields()) {
            field.setEnabled(flag);
        }
    }

    private void createComponents(IResourceBundleContext rbCtxt, IEventContext evtCtxt, IUIPreference uiPref, EnrollmentService enrollmentService) {
        InlineValidations ilv = new InlineValidations(rbCtxt);
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(uiPref, rbCtxt.getLocale().toString(), enrollmentService);
        this.houseField = new JTextField();
        new AutoSuggestDecorator(this.houseField).name("address");
        ilv.applyFreeAddressILV(this.houseField);
        this.houseField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.houseField));
        this.locHouseField = imb.createIMField(this.houseField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locHouseField);
        this.locHouseField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locHouseField));
        this.streetField = new JTextField();
        new AutoSuggestDecorator(this.streetField).name("address");
        ilv.applyFreeAddressILV(this.streetField);
        this.streetField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.streetField));
        this.locStreetField = imb.createIMField(this.streetField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locStreetField);
        this.locStreetField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locStreetField));
        this.landmarkField = new JTextField();
        new AutoSuggestDecorator(this.landmarkField).name("address");
        ilv.applyFreeAddressILV(this.landmarkField);
        this.landmarkField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.landmarkField));
        this.locLandmarkField = imb.createIMField(this.landmarkField, TransliterationHints.ADDRESS, TransliterationHints.TRANSLATE);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locLandmarkField);
        this.locLandmarkField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locLandmarkField));
        this.localityField = new JTextField();
        new AutoSuggestDecorator(this.localityField).name("address");
        ilv.applyFreeAddressILV(this.localityField);
        this.localityField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.localityField));
        this.locLocalityField = imb.createIMField(this.localityField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locLocalityField);
        this.locLocalityField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locLocalityField));
        this.subDistField = new JTextField();
        this.subDistField.setEnabled(false);
        this.locSubDistField = imb.createIMField(this.subDistField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locSubDistField);
        this.locSubDistField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locSubDistField));
        this.sDistrictField = new JTextField();
        this.sDistrictField.setEnabled(false);
        this.locDistrictField = imb.createIMField(this.sDistrictField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locDistrictField);
        this.locDistrictField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locDistrictField));
        this.sStateField = new JTextField();
        this.sStateField.setEnabled(false);
        this.locStateField = imb.createIMField(this.sStateField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locStateField);
        this.locStateField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locStateField));
        if (this.isOnline) {
            Font font = new Font(this.houseField.getFont().getName(), 0, 12);
            Font fontLoc = new Font(this.locHouseField.getFont().getName(), 0, 14);
            this.houseField.setFont(font);
            this.locHouseField.setFont(fontLoc);
            this.streetField.setFont(font);
            this.locStreetField.setFont(fontLoc);
            this.landmarkField.setFont(font);
            this.locLandmarkField.setFont(fontLoc);
            this.localityField.setFont(font);
            this.locLocalityField.setFont(fontLoc);
            this.subDistField.setFont(font);
            this.locSubDistField.setFont(fontLoc);
            this.sDistrictField.setFont(font);
            this.locDistrictField.setFont(fontLoc);
            this.sStateField.setFont(font);
            this.locStateField.setFont(fontLoc);
        }
        this.postOffField = new UidComboField();
        this.postOffField.setEditable(false);
        this.postOffField.setListCellRenderer(new PostOfficeListRenderer());
        this.postOffField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.postOffField));
        this.postOffField.setOptionHandler(new PostOfficeOptionHandler());
        this.postOffField.enableAutoPopup(1000);
        this.postOffField.setLayout(new BorderLayout());
        this.postOffField.add((Component)this.getDownArrowLabel(this.postOffField), "East");
        this.locPostOffField = imb.createIMField(this.postOffField, TransliterationHints.ADDRESS, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFreeAddressILV((JTextField)this.locPostOffField);
        this.locPostOffField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locPostOffField));
        this.sPinCodeField = new UidComboField();
        this.sPinCodeField.setOptionHandler(new PinCodeOptionHandler());
        this.sPinCodeField.setMinTextLengthForPopup(5);
        FBNumericDocument sPinCodeDoc = new FBNumericDocument((JTextComponent)this.sPinCodeField);
        sPinCodeDoc.setMaxLength(6);
        this.sPinCodeField.setDocument((Document)sPinCodeDoc);
        this.sPinCodeField.setListCellRenderer(new PinCodeListRenderer());
        this.sPinCodeField.addPopupMenuListener((PopupMenuListener)evtCtxt.getEventListener("hID_DemoTab_SPinCodePopup", PopupMenuListener.class));
        this.sPinCodeField.addFocusListener((FocusListener)evtCtxt.getEventListener("hID_DemoTab_SPinCodePropagate", FocusListener.class));
        this.sPinCodeField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.sPinCodeField));
        this.sPinCodeField.enableAutoPopup(1000);
        this.sPinCodeField.setLayout(new BorderLayout());
        this.sPinCodeField.add((Component)this.getDownArrowLabel(this.sPinCodeField), "East");
        this.locPinField = new DirectTranslitField();
        this.locPinField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.locPinField.setResourceBundleContext(rbCtxt);
        this.locPinField.setLocale(uiPref.getTransliterationLocale("hi_IN"));
        new DirectTranslitAssociation(this.locPinField, this.sPinCodeField);
    }

    private JLabel getDownArrowLabel(JComponent comp) {
        JLabel arrowLabel = new JLabel();
        arrowLabel.setBorder(null);
        arrowLabel.setBackground(comp.getBackground());
        arrowLabel.setOpaque(true);
        arrowLabel.setIcon(UidSwingUtilities.loadIcon((String)"res/ecmp/images/dropDownArrow.png"));
        return arrowLabel;
    }

    private int calculateNumRows(HashMap<AddressField, JComponent> fcMap) {
        Set<AddressField> fields = fcMap.keySet();
        int numRows = 0;
        for (AddressField field : fields) {
            numRows = Math.max(field.getRow(), numRows);
        }
        return numRows;
    }

    private List<AddressField> getFieldsForRow(HashMap<AddressField, JComponent> fcMap, int row) {
        ArrayList<AddressField> result = new ArrayList<AddressField>();
        Set<AddressField> fields = fcMap.keySet();
        for (AddressField field : fields) {
            if (field.getRow() != row) continue;
            result.add(field);
        }
        return result;
    }

    private String getLabelText(AddressField field, boolean local) {
        AddressLabel label = field.getLabel();
        if (label == null) {
            return "";
        }
        String id = label.getId();
        String altId = label.getAltId();
        if (StringUtils.isNotBlank((String)id)) {
            String text = null;
            text = local ? this.rbCtxt.getLocaleMessage((Object)id, new Object[0]) : this.rbCtxt.getMessage((Object)id, new Object[0]);
            if (StringUtils.startsWith((String)text, (String)"!") && StringUtils.endsWith((String)text, (String)"!") && !StringUtils.isBlank((String)altId)) {
                text = local ? this.rbCtxt.getLocaleMessage((Object)altId, new Object[0]) : this.rbCtxt.getMessage((Object)altId, new Object[0]);
            }
            return text;
        }
        return label.getValue();
    }

    private JLabel createLabel(List<AddressField> fields, boolean local) {
        StringBuilder sb = new StringBuilder();
        boolean mandatory = false;
        for (AddressField field : fields) {
            sb.append(',').append(' ').append(this.getLabelText(field, local));
            if (!field.isMandatory()) continue;
            mandatory = true;
        }
        JLabel result = new JLabel(sb.toString().trim().substring(1).trim(), 2);
        if (mandatory) {
            result.setIcon(ImageIconCache.getInst().getIcon(KEY_MANDATORY_ICON));
        }
        if (local) {
            Font f = FontManager.getInst().getScreenFontForLocale(this.rbCtxt.getLocale());
            result.setFont(f);
        }
        result.setHorizontalTextPosition(2);
        return result;
    }

    private void layoutField(AddressField field, JComponent comp, boolean local) {
        int col = field.getCol();
        boolean colspan = field.isColspan();
        int lrow = field.getRow() * 2 - 1;
        String spec = null;
        if (col == 1) {
            spec = colspan ? "2, " + lrow + ", 4, " + lrow + ", full, full" : "2, " + lrow + ", full, full";
        } else if (col == 2) {
            spec = "4, " + lrow + ", full, full";
        }
        if (StringUtils.isNotBlank(spec)) {
            if (local) {
                this.rightAddrArea.add((Component)comp, (Object)spec);
            } else {
                this.leftAddrArea.add((Component)comp, (Object)spec);
            }
        }
    }

    void setAddressFields(Address address) {
        this.streetField.setText(address.getDisplayStreet());
        this.locStreetField.setText(address.getDisplayStreetLocal());
        this.houseField.setText(address.getDisplayBuilding());
        this.locHouseField.setText(address.getDisplayBuildingLocal());
        this.landmarkField.setText(address.getDisplayLandmark());
        this.locLandmarkField.setText(address.getDisplayLandmarkLocal());
        this.localityField.setText(address.getDisplayLocality());
        this.locLocalityField.setText(address.getDisplayLocalityLocal());
        this.sStateField.setText(address.getDisplayState());
        this.locStateField.setText(address.getDisplayStateLocal());
        this.sPinCodeField.setText(address.getDisplayPinCodeValue());
        this.locPinField.setText(address.getDisplayPinCodeLocal());
        this.sDistrictField.setText(address.getDisplayDistrict());
        this.locDistrictField.setText(address.getDisplayDistrictLocal());
        this.subDistField.setText(address.getDisplaySubDistrict());
        this.locSubDistField.setText(address.getDisplaySubDistrictLocal());
        List postOfficeList = address.getPinCodeDetail().getPostOfficeList();
        if (postOfficeList != null && !postOfficeList.isEmpty()) {
            this.postOffField.setOptions(postOfficeList);
            this.postOffField.setText(((PostOffice)postOfficeList.get(0)).getName());
        } else {
            this.postOffField.setText(address.getDisplayPoName());
        }
        this.locPostOffField.setText(address.getDisplayPoNameLocal());
        this.vtcField.setText(address.getDisplayVTC());
        this.locVtcField.setText(address.getDisplayVTCLocal());
        ArrayList<PostalAddress> postalAddresses = this.makePostalAddresses(address);
        this.sPinCodeField.setOptions(postalAddresses);
        this.sPinCodeField.setSelectedOption(postalAddresses.get(0));
    }

    private ArrayList<PostalAddress> makePostalAddresses(Address address) {
        final PostalAddress pa = new PostalAddress();
        PostalAddressElement district = new PostalAddressElement();
        district.setAddressValue(address.getDistrict());
        district.setAddressCode(address.getDistrictCode());
        pa.setDistrict(district);
        PostalAddressElement subDistrict = new PostalAddressElement();
        subDistrict.setAddressValue(address.getSubDistrict());
        subDistrict.setAddressCode(address.getSubDistrictCode());
        pa.setSubDistrict(subDistrict);
        PostalAddressElement vtc = new PostalAddressElement();
        vtc.setAddressValue(address.getVTC());
        vtc.setAddressCode(address.getVTCCode());
        pa.setVtc(vtc);
        PostalAddressElement pinCode = new PostalAddressElement();
        pinCode.setAddressValue(address.getPinCodeValue());
        pinCode.setAddressCode(address.getPinCodeValue());
        pa.setPinCode(pinCode);
        PostalAddressElement state = new PostalAddressElement();
        state.setAddressValue(address.getState());
        state.setAddressCode(address.getStateCode());
        pa.setState(state);
        return new ArrayList<PostalAddress>(){
            {
                this.add(0, pa);
            }
        };
    }

    static {
        ImageIconCache.getInst().addIcon(KEY_MANDATORY_ICON, "res/images/star.png");
        ImageIconCache.getInst().addIcon(KEY_LOCK_ICON, "res/images/lock-on.png");
        ImageIconCache.getInst().addIcon(KEY_UNLOCK_ICON, "res/images/lock-off.png");
    }

    private static class FocusTraversalComparator
    implements Comparator<AddressField> {
        private FocusTraversalComparator() {
        }

        @Override
        public int compare(AddressField field1, AddressField field2) {
            int order1 = field1.getFocusTraversalOrder();
            int order2 = field2.getFocusTraversalOrder();
            return Integer.compare(order1, order2);
        }
    }
}

