/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.ToggleButtonAssociation;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.stream.IntStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AgeDobPanel
implements IDemoTabConstants,
IViewElementComposite {
    private final IResourceBundleContext rbc;
    private final IUIPreference pref;
    protected ButtonGroup ageDobGrp;
    protected JRadioButton ageOpt;
    protected JRadioButton dobOpt;
    protected JTextField ageField;
    protected JTextField dobDayField;
    protected JTextField dobMonthField;
    protected JTextField dobYearField;
    protected JCheckBox verifiedOptField;
    protected TransparentBox ageDobBox;
    protected DirectTranslitField locAgeDobField;
    @ExportViewElement(as="eID_DemoTab_AdobOpt", using=StandardSwingElementFactory.class)
    protected JCheckBox adobEditOpt;

    AgeDobPanel(IResourceBundleContext rbc, IUIPreference pref) {
        this.rbc = rbc;
        this.pref = pref;
    }

    public JComponent create(boolean isUpdateEnrollment, EnrollmentService enrollmentService) {
        double[][] guides;
        this.ageDobGrp = new ButtonGroup();
        this.ageOpt = new JRadioButton();
        this.ageField = new JTextField();
        boolean isPobRequired = enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isDobSelected();
        boolean isOnlineUcUpdate = !enrollmentService.isNewEnrollmentUC();
        boolean isOnline = enrollmentService.isOnlineUpdate();
        if (!isUpdateEnrollment && !isPobRequired) {
            this.ageOpt.setActionCommand("AGE");
            this.ageOpt.setName("age");
            this.ageOpt.setSelected(true);
            this.ageDobGrp.add(this.ageOpt);
            FBNumericDocument ageFieldDoc = new FBNumericDocument((JTextComponent)this.ageField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
            ageFieldDoc.setMaxLength(3);
            this.ageField.setDocument((Document)ageFieldDoc);
            ageFieldDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.ageField));
        }
        this.dobOpt = new JRadioButton();
        this.dobOpt.setActionCommand("DOB");
        this.dobOpt.setName("dob");
        this.ageDobGrp.add(this.dobOpt);
        this.dobDayField = new JTextField();
        FBNumericDocument dobDayDoc = new FBNumericDocument((JTextComponent)this.dobDayField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobDayDoc.setMaxLength(2);
        this.dobDayField.setDocument((Document)dobDayDoc);
        dobDayDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobDayField));
        this.dobDayField.putClientProperty("watermark-text", "DD");
        this.dobDayField.setEnabled(false);
        this.dobMonthField = new JTextField();
        FBNumericDocument dobMnthDoc = new FBNumericDocument((JTextComponent)this.dobMonthField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobMnthDoc.setMaxLength(2);
        this.dobMonthField.setDocument((Document)dobMnthDoc);
        dobMnthDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobMonthField));
        this.dobMonthField.putClientProperty("watermark-text", "MM");
        this.dobMonthField.setEnabled(false);
        this.dobYearField = new JTextField();
        FBNumericDocument dobYearDoc = new FBNumericDocument((JTextComponent)this.dobYearField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobYearDoc.setMaxLength(4);
        this.dobYearField.setDocument((Document)dobYearDoc);
        dobYearDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobYearField));
        this.dobYearField.putClientProperty("watermark-text", "YYYY");
        this.dobYearField.setEnabled(false);
        this.verifiedOptField = new JCheckBox("Verified");
        this.verifiedOptField.setEnabled(false);
        if (!isOnlineUcUpdate && !isPobRequired) {
            this.dobOpt.setVisible(false);
            this.dobDayField.setVisible(false);
            this.dobMonthField.setVisible(false);
            this.dobYearField.setVisible(false);
            this.verifiedOptField.setVisible(false);
            this.ageOpt.setVisible(false);
        }
        if (!isUpdateEnrollment && !isPobRequired) {
            new ToggleButtonAssociation(this.ageOpt).enable(this.ageField).disable(this.dobDayField, this.dobMonthField, this.dobYearField, this.verifiedOptField).reset(this.dobDayField, this.dobMonthField, this.dobYearField, this.verifiedOptField).deselect(this.verifiedOptField);
            new ToggleButtonAssociation(this.dobOpt).disable(this.ageField).reset(this.ageField);
        }
        new ToggleButtonAssociation(this.dobOpt).enable(this.dobDayField, this.dobMonthField, this.dobYearField, this.verifiedOptField);
        this.locAgeDobField = new DirectTranslitField();
        this.locAgeDobField.setResourceBundleContext(this.rbc);
        this.locAgeDobField.setLocale(this.pref.getTransliterationLocale("hi_IN"));
        if (isOnline) {
            Font font = new Font(this.ageField.getFont().getName(), 0, 12);
            this.dobDayField.setFont(font);
            this.dobMonthField.setFont(font);
            this.dobYearField.setFont(font);
            this.ageField.setFont(font);
            this.locAgeDobField.setFont(new Font(this.locAgeDobField.getFont().getName(), 0, 15));
        }
        if (!isUpdateEnrollment && !isPobRequired) {
            guides = new double[][]{{5.0, 15.0, 5.0, 40.0, 5.0, 15.0, 5.0, 25.0, 5.0, 25.0, 5.0, 50.0, 5.0, -1.0}, {22.0}};
            this.ageDobBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
            this.ageDobBox.add((Component)this.ageOpt, (Object)"1, 0, f, c");
            this.ageDobBox.add((Component)this.ageField, (Object)"3, 0, f, c");
            this.ageDobBox.add((Component)this.dobOpt, (Object)"5, 0, f, c");
            this.ageDobBox.add((Component)this.dobDayField, (Object)"7, 0, f, c");
            this.ageDobBox.add((Component)this.dobMonthField, (Object)"9, 0, f, c");
            this.ageDobBox.add((Component)this.dobYearField, (Object)"11, 0, f, c");
            this.ageDobBox.add((Component)this.verifiedOptField, (Object)"13, 0, f, c");
            this.updateLocField();
            if (isOnline) {
                return new PanelBuilder().createPanel(LabelKeysDemoTab.AGE.toString(), (JComponent)this.ageDobBox, "label-tlit:demotab.agedob", (JComponent)this.locAgeDobField, this.rbc);
            }
            return new PanelBuilder().createPanel(LabelKeysDemoTab.ADD_AGEDOB.toString(), (JComponent)this.ageDobBox, "label-tlit:demotab.agedob", (JComponent)this.locAgeDobField, true, this.rbc);
        }
        guides = new double[][]{{0.0, 28.0, 5.0, 28.0, 5.0, 50.0, 5.0, 100.0, 5.0, -1.0}, {22.0}};
        this.ageDobBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.ageDobBox.add((Component)this.dobDayField, (Object)"1, 0, f, c");
        this.ageDobBox.add((Component)this.dobMonthField, (Object)"3, 0, f, c");
        this.ageDobBox.add((Component)this.dobYearField, (Object)"5, 0, f, c");
        this.ageDobBox.add((Component)this.verifiedOptField, (Object)"7, 0, f, c");
        this.setDobEnabled(false);
        this.adobEditOpt = ViewUtils.createEditLabel(LabelKeysDemoTab.DOB.toString(), 2, this.rbc);
        if (isOnlineUcUpdate && isOnline) {
            return new PanelBuilder().createPanel(LabelKeysDemoTab.DOB.toString(), (JComponent)this.ageDobBox, new LocaleLabel(this.rbc, "label-tlit:demotab.dob"), (JComponent)this.locAgeDobField, this.rbc, enrollmentService.getFieldsUpdateCount().getDob().hasToBeUpdated());
        }
        if (isPobRequired && isOnline) {
            return new PanelBuilder().createPanel(LabelKeysDemoTab.DOB.toString(), (JComponent)this.ageDobBox, "label-tlit:demotab.agedob", (JComponent)this.locAgeDobField, this.rbc);
        }
        return new PanelBuilder().createPanel(this.adobEditOpt, (JComponent)this.ageDobBox, new LocaleLabel(this.rbc, "label-tlit:demotab.dob"), (JComponent)this.locAgeDobField, this.rbc);
    }

    public JComponent create(boolean isUpdateEnrollment) {
        this.ageDobGrp = new ButtonGroup();
        this.ageOpt = new JRadioButton();
        if (!isUpdateEnrollment) {
            this.ageOpt.setActionCommand("AGE");
            this.ageOpt.setName("age");
            this.ageOpt.setSelected(true);
            this.ageDobGrp.add(this.ageOpt);
            this.ageField = new JTextField();
            FBNumericDocument ageFieldDoc = new FBNumericDocument((JTextComponent)this.ageField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
            ageFieldDoc.setMaxLength(3);
            this.ageField.setDocument((Document)ageFieldDoc);
            ageFieldDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.ageField));
        }
        this.dobOpt = new JRadioButton();
        this.dobOpt.setActionCommand("DOB");
        this.dobOpt.setName("dob");
        this.ageDobGrp.add(this.dobOpt);
        this.dobDayField = new JTextField();
        FBNumericDocument dobDayDoc = new FBNumericDocument((JTextComponent)this.dobDayField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobDayDoc.setMaxLength(2);
        this.dobDayField.setDocument((Document)dobDayDoc);
        dobDayDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobDayField));
        this.dobDayField.putClientProperty("watermark-text", "DD");
        this.dobDayField.setEnabled(false);
        this.dobMonthField = new JTextField();
        FBNumericDocument dobMnthDoc = new FBNumericDocument((JTextComponent)this.dobMonthField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobMnthDoc.setMaxLength(2);
        this.dobMonthField.setDocument((Document)dobMnthDoc);
        dobMnthDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobMonthField));
        this.dobMonthField.putClientProperty("watermark-text", "MM");
        this.dobMonthField.setEnabled(false);
        this.dobYearField = new JTextField();
        FBNumericDocument dobYearDoc = new FBNumericDocument((JTextComponent)this.dobYearField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobYearDoc.setMaxLength(4);
        this.dobYearField.setDocument((Document)dobYearDoc);
        dobYearDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobYearField));
        this.dobYearField.putClientProperty("watermark-text", "YYYY");
        this.dobYearField.setEnabled(false);
        this.verifiedOptField = new JCheckBox("Verified");
        this.verifiedOptField.setEnabled(false);
        if (!isUpdateEnrollment) {
            new ToggleButtonAssociation(this.ageOpt).enable(this.ageField).disable(this.dobDayField, this.dobMonthField, this.dobYearField, this.verifiedOptField).reset(this.dobDayField, this.dobMonthField, this.dobYearField, this.verifiedOptField).deselect(this.verifiedOptField);
            new ToggleButtonAssociation(this.dobOpt).disable(this.ageField).reset(this.ageField);
        }
        new ToggleButtonAssociation(this.dobOpt).enable(this.dobDayField, this.dobMonthField, this.dobYearField, this.verifiedOptField);
        this.locAgeDobField = new DirectTranslitField();
        this.locAgeDobField.setResourceBundleContext(this.rbc);
        this.locAgeDobField.setLocale(this.pref.getTransliterationLocale("hi_IN"));
        if (!isUpdateEnrollment) {
            double[][] guides = new double[][]{{5.0, 15.0, 5.0, 40.0, 5.0, 15.0, 5.0, 25.0, 5.0, 25.0, 5.0, 50.0, 5.0, -1.0}, {22.0}};
            this.ageDobBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
            this.ageDobBox.add((Component)this.ageOpt, (Object)"1, 0, f, c");
            this.ageDobBox.add((Component)this.ageField, (Object)"3, 0, f, c");
            this.ageDobBox.add((Component)this.dobOpt, (Object)"5, 0, f, c");
            this.ageDobBox.add((Component)this.dobDayField, (Object)"7, 0, f, c");
            this.ageDobBox.add((Component)this.dobMonthField, (Object)"9, 0, f, c");
            this.ageDobBox.add((Component)this.dobYearField, (Object)"11, 0, f, c");
            this.ageDobBox.add((Component)this.verifiedOptField, (Object)"13, 0, f, c");
            this.updateLocField();
            return new PanelBuilder().createPanel(LabelKeysDemoTab.ADD_AGEDOB.toString(), (JComponent)this.ageDobBox, "label-tlit:demotab.agedob", (JComponent)this.locAgeDobField, true, this.rbc);
        }
        double[][] guides = new double[][]{{0.0, 25.0, 5.0, 25.0, 5.0, 50.0, 5.0, 100.0, 5.0, -1.0}, {22.0}};
        this.ageDobBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.ageDobBox.add((Component)this.dobDayField, (Object)"1, 0, f, c");
        this.ageDobBox.add((Component)this.dobMonthField, (Object)"3, 0, f, c");
        this.ageDobBox.add((Component)this.dobYearField, (Object)"5, 0, f, c");
        this.ageDobBox.add((Component)this.verifiedOptField, (Object)"7, 0, f, c");
        this.setDobEnabled(false);
        this.adobEditOpt = ViewUtils.createEditLabel(LabelKeysDemoTab.DOB.toString(), 2, this.rbc);
        return new PanelBuilder().createPanel(this.adobEditOpt, (JComponent)this.ageDobBox, new LocaleLabel(this.rbc, "label-tlit:demotab.dob"), (JComponent)this.locAgeDobField, this.rbc);
    }

    void setDobFields(String day, String month, String year) {
        this.dobOpt.setSelected(true);
        this.dobDayField.setText(day);
        this.dobMonthField.setText(month);
        this.dobYearField.setText(year);
        if (day.equalsIgnoreCase("") || month.equalsIgnoreCase("") || year.equalsIgnoreCase("")) {
            this.locAgeDobField.setText("");
        } else {
            String locDobDate = day + "/" + month + "/" + year;
            this.locAgeDobField.setText(locDobDate);
        }
    }

    void setDobFields(Integer day, Integer month, Integer year) {
        if (day == -1 || month == -1 || year == -1) {
            this.setDobFields("", "", "");
            return;
        }
        this.setDobFields(day.toString(), month.toString(), year.toString());
    }

    void setDobEnabled(boolean flag) {
        this.dobDayField.setEnabled(flag);
        this.dobMonthField.setEnabled(flag);
        this.dobYearField.setEnabled(flag);
        this.verifiedOptField.setSelected(flag);
        this.verifiedOptField.setEnabled(false);
    }

    void setAgeField(int age) {
        this.ageOpt.setSelected(true);
        if (age > 0) {
            this.ageField.setText(String.valueOf(age));
        } else {
            this.ageField.setText("");
        }
    }

    void setDobVerified(boolean verified) {
        this.verifiedOptField.setSelected(verified);
        this.verifiedOptField.setEnabled(true);
    }

    public void addToFocusTraversalPolicy(ExplicitFocusTraversalPolicy eftp) {
        IntStream.range(0, this.ageDobBox.getComponentCount()).mapToObj(i -> this.ageDobBox.getComponent(i)).forEach(arg_0 -> ((ExplicitFocusTraversalPolicy)eftp).addComponent(arg_0));
    }

    private void updateLocField() {
        if (this.ageOpt.isSelected()) {
            String locText = this.ageField.getText() + " years";
            this.locAgeDobField.setText(locText);
        } else if (this.dobOpt.isSelected()) {
            String locText = this.dobDayField.getText() + "/" + this.dobMonthField.getText() + "/" + this.dobYearField.getText();
            this.locAgeDobField.setText(locText);
        }
    }
}

