/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.stream.IntStream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ConfirmDOBPanel
implements IDemoTabConstants,
IViewElementComposite {
    private final IResourceBundleContext rbc;
    protected DirectTranslitField locDobField;
    protected JTextField confirmDobField = new JTextField();
    private final IUIPreference pref;
    protected JTextField dobDayField;
    protected JTextField dobMonthField;
    protected JTextField dobYearField;
    protected JCheckBox verifiedOptField;
    protected TransparentBox confirmDobBox;
    protected DirectTranslitField locConfirmDobField;
    @ExportViewElement(as="eID_DemoTab_AdobOpt", using=StandardSwingElementFactory.class)
    protected JCheckBox cdobEditOpt;

    ConfirmDOBPanel(IResourceBundleContext rbc, IUIPreference pref) {
        this.rbc = rbc;
        this.pref = pref;
    }

    public JComponent create(EnrollmentService enrollmentService) {
        this.dobDayField = new JTextField();
        FBNumericDocument dobDayDoc = new FBNumericDocument((JTextComponent)this.dobDayField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobDayDoc.setMaxLength(2);
        this.dobDayField.setDocument((Document)dobDayDoc);
        dobDayDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobDayField));
        this.dobDayField.putClientProperty("watermark-text", "DD");
        this.dobDayField.setEnabled(true);
        this.dobMonthField = new JTextField();
        FBNumericDocument dobMnthDoc = new FBNumericDocument((JTextComponent)this.dobMonthField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobMnthDoc.setMaxLength(2);
        this.dobMonthField.setDocument((Document)dobMnthDoc);
        dobMnthDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobMonthField));
        this.dobMonthField.putClientProperty("watermark-text", "MM");
        this.dobMonthField.setEnabled(true);
        this.dobYearField = new JTextField();
        FBNumericDocument dobYearDoc = new FBNumericDocument((JTextComponent)this.dobYearField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobYearDoc.setMaxLength(4);
        this.dobYearField.setDocument((Document)dobYearDoc);
        dobYearDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobYearField));
        this.dobYearField.putClientProperty("watermark-text", "YYYY");
        this.dobYearField.setEnabled(true);
        this.verifiedOptField = new JCheckBox("Verified");
        this.verifiedOptField.setEnabled(false);
        this.locConfirmDobField = new DirectTranslitField();
        this.locConfirmDobField.setResourceBundleContext(this.rbc);
        this.locConfirmDobField.setLocale(this.pref.getTransliterationLocale("hi_IN"));
        if (enrollmentService.isOnlineUpdate()) {
            Font font = new Font(this.dobDayField.getFont().getName(), 0, 12);
            this.dobDayField.setFont(font);
            this.dobMonthField.setFont(font);
            this.dobYearField.setFont(font);
            this.locConfirmDobField.setFont(new Font(this.locConfirmDobField.getFont().getName(), 0, 17));
        }
        double[][] guides = new double[][]{{0.0, 28.0, 5.0, 28.0, 5.0, 50.0, 5.0, 100.0, 5.0, -1.0}, {22.0}};
        this.confirmDobBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.confirmDobBox.add((Component)this.dobDayField, (Object)"1, 0, f, c");
        this.confirmDobBox.add((Component)this.dobMonthField, (Object)"3, 0, f, c");
        this.confirmDobBox.add((Component)this.dobYearField, (Object)"5, 0, f, c");
        this.confirmDobBox.add((Component)this.verifiedOptField, (Object)"7, 0, f, c");
        this.cdobEditOpt = ViewUtils.createEditLabel(LabelKeysDemoTab.CONFIRM_DOB.toString(), 2, this.rbc);
        if (enrollmentService.isOnlineUpdate()) {
            Font font = this.dobDayField.getFont();
            this.dobDayField.setFont(new Font(font.getName(), 0, 12));
            this.dobMonthField.setFont(new Font(font.getName(), 0, 12));
            this.dobYearField.setFont(new Font(font.getName(), 0, 12));
            this.locConfirmDobField.setFont(new Font(font.getName(), 0, 15));
            if (enrollmentService.isNewEnrollmentUC()) {
                return new PanelBuilder().createPanel(LabelKeysDemoTab.CONFIRM_DOB.toString(), (JComponent)this.confirmDobBox, "label-tlit:demotab.confirm.dob", (JComponent)this.locConfirmDobField, this.rbc);
            }
            return new PanelBuilder().createPanel(LabelKeysDemoTab.CONFIRM_DOB.toString(), (JComponent)this.confirmDobBox, new LocaleLabel(this.rbc, "label-tlit:demotab.confirm.dob"), (JComponent)this.locConfirmDobField, this.rbc, enrollmentService.getFieldsUpdateCount().getDob().hasToBeUpdated());
        }
        return new PanelBuilder().createPanel(this.cdobEditOpt, (JComponent)this.confirmDobBox, new LocaleLabel(this.rbc, "label-tlit:demotab.confirm.dob"), (JComponent)this.locConfirmDobField, this.rbc);
    }

    public JComponent create() {
        this.dobDayField = new JTextField();
        FBNumericDocument dobDayDoc = new FBNumericDocument((JTextComponent)this.dobDayField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobDayDoc.setMaxLength(2);
        this.dobDayField.setDocument((Document)dobDayDoc);
        dobDayDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobDayField));
        this.dobDayField.putClientProperty("watermark-text", "DD");
        this.dobDayField.setEnabled(true);
        this.dobMonthField = new JTextField();
        FBNumericDocument dobMnthDoc = new FBNumericDocument((JTextComponent)this.dobMonthField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobMnthDoc.setMaxLength(2);
        this.dobMonthField.setDocument((Document)dobMnthDoc);
        dobMnthDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobMonthField));
        this.dobMonthField.putClientProperty("watermark-text", "MM");
        this.dobMonthField.setEnabled(true);
        this.dobYearField = new JTextField();
        FBNumericDocument dobYearDoc = new FBNumericDocument((JTextComponent)this.dobYearField, this.rbc.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        dobYearDoc.setMaxLength(4);
        this.dobYearField.setDocument((Document)dobYearDoc);
        dobYearDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.dobYearField));
        this.dobYearField.putClientProperty("watermark-text", "YYYY");
        this.dobYearField.setEnabled(true);
        this.verifiedOptField = new JCheckBox("Verified");
        this.verifiedOptField.setEnabled(false);
        this.locConfirmDobField = new DirectTranslitField();
        this.locConfirmDobField.setResourceBundleContext(this.rbc);
        this.locConfirmDobField.setLocale(this.pref.getTransliterationLocale("hi_IN"));
        double[][] guides = new double[][]{{0.0, 25.0, 5.0, 25.0, 5.0, 50.0, 5.0, 100.0, 5.0, -1.0}, {22.0}};
        this.confirmDobBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.confirmDobBox.add((Component)this.dobDayField, (Object)"1, 0, f, c");
        this.confirmDobBox.add((Component)this.dobMonthField, (Object)"3, 0, f, c");
        this.confirmDobBox.add((Component)this.dobYearField, (Object)"5, 0, f, c");
        this.confirmDobBox.add((Component)this.verifiedOptField, (Object)"7, 0, f, c");
        this.cdobEditOpt = ViewUtils.createEditLabel(LabelKeysDemoTab.CONFIRM_DOB.toString(), 2, this.rbc);
        return new PanelBuilder().createPanel(this.cdobEditOpt, (JComponent)this.confirmDobBox, new LocaleLabel(this.rbc, "label-tlit:demotab.confirm.dob"), (JComponent)this.locConfirmDobField, this.rbc);
    }

    void setDobFields(String day, String month, String year) {
        this.dobDayField.setText(day);
        this.dobMonthField.setText(month);
        this.dobYearField.setText(year);
        if (day.equalsIgnoreCase("") || month.equalsIgnoreCase("") || year.equalsIgnoreCase("")) {
            this.locConfirmDobField.setText("");
        } else {
            String locDobDate = day + "/" + month + "/" + year;
            this.locConfirmDobField.setText(locDobDate);
        }
    }

    void setDobFields(Integer day, Integer month, Integer year) {
        if (day == -1 || month == -1 || year == -1) {
            this.setDobFields("", "", "");
            return;
        }
        this.setDobFields(day.toString(), month.toString(), year.toString());
    }

    void setDobVerified(boolean verified) {
        this.verifiedOptField.setSelected(verified);
        this.verifiedOptField.setEnabled(true);
    }

    public void addToFocusTraversalPolicy(ExplicitFocusTraversalPolicy eftp) {
        IntStream.range(0, this.confirmDobBox.getComponentCount()).mapToObj(i -> this.confirmDobBox.getComponent(i)).forEach(arg_0 -> ((ExplicitFocusTraversalPolicy)eftp).addComponent(arg_0));
    }

    void setDobEnabled(boolean flag) {
        this.dobDayField.setEnabled(flag);
        this.dobMonthField.setEnabled(flag);
        this.dobYearField.setEnabled(flag);
        this.verifiedOptField.setSelected(flag);
        this.verifiedOptField.setEnabled(false);
    }
}

