/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.ButtonFactory;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ConsentPanel
implements IViewElementComposite {
    private final IResourceBundleContext rbc;
    private final IUIPreference uiPref;
    private final IEventContext evtCtxt;
    protected JButton nextBut;
    protected JCheckBox consentOpt = new JCheckBox();
    protected JButton bioExpBut;
    protected JButton mandatoryBioCheckButton;

    ConsentPanel(IResourceBundleContext rbc, IUIPreference uiPref, IEventContext evtCtxt) {
        this.rbc = rbc;
        this.uiPref = uiPref;
        this.evtCtxt = evtCtxt;
    }

    public JComponent create(boolean isUpdateEnrollment) {
        L10nDecorator ldeco = new L10nDecorator(this.rbc, this.uiPref.getApplicationLocalize(false));
        this.consentOpt.setEnabled(false);
        this.consentOpt.setSelected(true);
        this.mandatoryBioCheckButton = new JButton("Mandatory Biometric Check");
        this.mandatoryBioCheckButton.setPreferredSize(new Dimension(160, 28));
        this.mandatoryBioCheckButton.setEnabled(false);
        ButtonFactory butFac = new ButtonFactory(this.rbc);
        this.nextBut = butFac.createTabNextButton();
        this.bioExpBut = butFac.createBioExceptionButton();
        ldeco.localize((AbstractButton)this.bioExpBut, (Object)LabelKeysAction.BIOX, new Object[0]);
        ldeco.localize((AbstractButton)this.nextBut, (Object)LabelKeysAction.NEXT, new Object[0]);
        this.bioExpBut.addActionListener((ActionListener)this.evtCtxt.getEventListener(isUpdateEnrollment ? "hID_Uenrol_ShowBiox" : "hID_Enrol_ShowBiox", ActionListener.class));
        this.bioExpBut.setEnabled(!isUpdateEnrollment);
        TransparentBox navLeftPanel = new TransparentBox((LayoutManager)new BorderLayout());
        navLeftPanel.add((Component)this.consentOpt, (Object)"East");
        TransparentBox navRightPanel = new TransparentBox((LayoutManager)new FlowLayout(2, 5, 0));
        navRightPanel.add((Component)this.bioExpBut);
        navRightPanel.add((Component)this.mandatoryBioCheckButton);
        navRightPanel.add((Component)this.nextBut);
        TransparentBox navPanel = new TransparentBox((LayoutManager)new BorderLayout());
        navPanel.add((Component)navLeftPanel, (Object)"Center");
        navPanel.add((Component)navRightPanel, (Object)"East");
        navPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        return navPanel;
    }
}

