/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrol.dynaddr.DynamicAddressLayout;
import in.gov.uidai.ec.service.enrol.dynaddr.IDynaddrTemplateManager;
import in.gov.uidai.ec.swing.ToggleButtonAssociation;
import in.gov.uidai.ec.swing.TransparentToggleButton;
import in.gov.uidai.ec.swing.shared.SectionHeader;
import in.gov.uidai.ec.ui.enrol.demographics.AddressPanel;
import in.gov.uidai.ec.ui.enrol.demographics.CareOfPanel;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.combo.DropDownItem;
import in.gov.uidai.swing.combo.PropertiesListModel;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ContactHeaderPanel
implements IDemoTabConstants,
IViewElementComposite {
    private static final String KEY_DYNADDR_TPL_SEL_ICON = "KEY_DYNADDR_TPL_SEL_ICON";
    private static final String KEY_EDIT_OFF_ICON = "KEY_EDIT_OFF_ICON";
    private static final String KEY_EDIT_ON_ICON = "KEY_EDIT_ON_ICON";
    private static final Cursor HAND_CURSOR = new Cursor(12);
    private final AddressPanel addressPanel;
    private final IDynaddrTemplateManager tplMgr;
    private final IResourceBundleContext rbCtxt;
    private final IEventContext evtCtxt;
    private final L10nDecorator ldeco;
    private final CareOfPanel careOfPanel;
    protected TransparentToggleButton contactEditBut;
    JList tplList;
    JPopupMenu tplSelPopup;
    private JLabel tplNameField;
    private JButton cttSelBut;
    private boolean isOnline;

    ContactHeaderPanel(IResourceBundleContext rbCtxt, IEventContext evtCtxt, IDynaddrTemplateManager mgr, AddressPanel addressPanel, IUIPreference uiPref, CareOfPanel careOfPanel, boolean isOnline) {
        this.rbCtxt = rbCtxt;
        this.evtCtxt = evtCtxt;
        this.tplMgr = mgr;
        this.addressPanel = addressPanel;
        this.ldeco = new L10nDecorator(rbCtxt, uiPref.getApplicationLocalize(false));
        this.careOfPanel = careOfPanel;
        this.isOnline = isOnline;
    }

    ContactHeaderPanel(IResourceBundleContext rbCtxt, IEventContext evtCtxt, IDynaddrTemplateManager mgr, AddressPanel addressPanel, IUIPreference uiPref, CareOfPanel careOfPanel) {
        this.rbCtxt = rbCtxt;
        this.evtCtxt = evtCtxt;
        this.tplMgr = mgr;
        this.addressPanel = addressPanel;
        this.ldeco = new L10nDecorator(rbCtxt, uiPref.getApplicationLocalize(false));
        this.careOfPanel = careOfPanel;
    }

    public JComponent create() {
        SectionHeader contactHeader = new SectionHeader(this.ldeco, this.rbCtxt);
        contactHeader.setOnline(this.isOnline);
        contactHeader.setText(LabelKeysHeader.CONTACT.toString());
        contactHeader.add(Box.createHorizontalStrut(5));
        this.tplNameField = new JLabel();
        this.tplNameField.setFont(this.tplNameField.getFont().deriveFont(1));
        contactHeader.add(this.tplNameField);
        this.tplSelPopup = new JPopupMenu();
        PropertiesListModel tplListModel = new PropertiesListModel(this.tplMgr.listAll());
        this.tplList = new JList(tplListModel);
        int maxRows = Math.min(10, tplListModel.getSize());
        this.tplList.setVisibleRowCount(maxRows);
        this.tplSelPopup.setLayout(new BorderLayout());
        this.tplSelPopup.add((Component)new JScrollPane(this.tplList), "Center");
        MouseAdapter mouseClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ContactHeaderPanel.this.updateSelection();
            }
        };
        this.tplList.addMouseListener(mouseClick);
        AbstractAction listEnter = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContactHeaderPanel.this.updateSelection();
            }
        };
        this.tplList.getActionMap().put("lsh", listEnter);
        this.tplList.getInputMap().put(KeyStroke.getKeyStroke("enter"), "lsh");
        this.cttSelBut = new JButton(ImageIconCache.getInst().getIcon(KEY_DYNADDR_TPL_SEL_ICON));
        this.cttSelBut.setCursor(new Cursor(12));
        this.cttSelBut.setBorder(null);
        this.cttSelBut.setBorderPainted(false);
        this.cttSelBut.setContentAreaFilled(false);
        this.cttSelBut.addActionListener(new ListPopupHandler());
        contactHeader.add(this.cttSelBut);
        return contactHeader;
    }

    JComponent createWithCopyPreviousButton() {
        JComponent contactHeader = this.create();
        JButton savAddrBut = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.COPYPREV, new Object[0]));
        this.ldeco.localize((AbstractButton)savAddrBut, (Object)LabelKeysAction.COPYPREV, new Object[0]);
        savAddrBut.setFont(savAddrBut.getFont().deriveFont(1, 12.0f));
        savAddrBut.setContentAreaFilled(false);
        savAddrBut.setBorderPainted(true);
        savAddrBut.setBorder((Border)new SingleLineBorder().lineColor("#000000").drawEdges(false, false, true, false));
        savAddrBut.setSize(new Dimension(100, 12));
        savAddrBut.setCursor(Cursor.getPredefinedCursor(12));
        savAddrBut.addActionListener((ActionListener)this.evtCtxt.getEventListener("hID_DemoTab_LastSavedAddr", ActionListener.class));
        contactHeader.add((Component)savAddrBut, "right");
        DynamicAddressLayout dal = this.tplMgr.getCurrentLayout();
        this.tplNameField.setText("(" + dal.getDisplayName() + ")");
        this.addressPanel.doLayout(dal);
        return contactHeader;
    }

    JComponent createEditButtonView(boolean isOnlineUpdate) {
        JComponent contactHeader = this.create();
        this.ldeco.followDefaultFontParameters(true);
        this.contactEditBut = new TransparentToggleButton(this.ldeco, this.rbCtxt);
        this.contactEditBut.setPressParams(ImageIconCache.getInst().getIcon(KEY_EDIT_ON_ICON), LabelKeysAction.EDIT_CANCEL.toString(), LabelKeysAction.EDIT_CANCEL_TT.toString());
        this.contactEditBut.setReleaseParams(ImageIconCache.getInst().getIcon(KEY_EDIT_OFF_ICON), LabelKeysAction.EDIT.toString(), LabelKeysAction.EDIT_TT.toString());
        this.contactEditBut.setFont(this.contactEditBut.getFont().deriveFont(1));
        this.contactEditBut.setHorizontalAlignment(4);
        this.contactEditBut.setAlignmentX(4.0f);
        this.contactEditBut.setCursor(HAND_CURSOR);
        new ToggleButtonAssociation().forButton(this.contactEditBut, true).enable(this.addressPanel.getActiveFields());
        contactHeader.add((Component)this.contactEditBut, "right");
        if (isOnlineUpdate) {
            this.contactEditBut.setVisible(false);
        }
        DynamicAddressLayout dal = this.tplMgr.getCurrentLayout();
        this.tplNameField.setText("(" + dal.getDisplayName() + ")");
        this.addressPanel.doLayout(dal);
        return contactHeader;
    }

    JComponent createEditButtonView() {
        JComponent contactHeader = this.create();
        this.ldeco.followDefaultFontParameters(true);
        this.contactEditBut = new TransparentToggleButton(this.ldeco, this.rbCtxt);
        this.contactEditBut.setPressParams(ImageIconCache.getInst().getIcon(KEY_EDIT_ON_ICON), LabelKeysAction.EDIT_CANCEL.toString(), LabelKeysAction.EDIT_CANCEL_TT.toString());
        this.contactEditBut.setReleaseParams(ImageIconCache.getInst().getIcon(KEY_EDIT_OFF_ICON), LabelKeysAction.EDIT.toString(), LabelKeysAction.EDIT_TT.toString());
        this.contactEditBut.setFont(this.contactEditBut.getFont().deriveFont(1));
        this.contactEditBut.setHorizontalAlignment(4);
        this.contactEditBut.setAlignmentX(4.0f);
        this.contactEditBut.setCursor(HAND_CURSOR);
        new ToggleButtonAssociation().forButton(this.contactEditBut, true).enable(this.addressPanel.getActiveFields());
        contactHeader.add((Component)this.contactEditBut, "right");
        DynamicAddressLayout dal = this.tplMgr.getCurrentLayout();
        this.tplNameField.setText("(" + dal.getDisplayName() + ")");
        this.addressPanel.doLayout(dal);
        return contactHeader;
    }

    private void updateSelection() {
        DropDownItem ddi = (DropDownItem)this.tplList.getSelectedValue();
        if (ddi != null) {
            String tplId = ddi.getKey();
            this.tplMgr.setCurrentLayout(tplId);
            DynamicAddressLayout dal = this.tplMgr.getCurrentLayout();
            this.tplNameField.setText("(" + dal.getDisplayName() + ")");
            this.addressPanel.doLayout(dal);
        }
        this.tplSelPopup.setVisible(false);
    }

    static {
        ImageIconCache.getInst().addIcon(KEY_DYNADDR_TPL_SEL_ICON, "res/images/dynaddr-tpl-sel.png");
        ImageIconCache.getInst().addIcon(KEY_EDIT_OFF_ICON, "res/images/check-icon-edit-off.png");
        ImageIconCache.getInst().addIcon(KEY_EDIT_ON_ICON, "res/images/check-icon-edit-on.png");
    }

    private class ListPopupHandler
    implements ActionListener {
        private ListPopupHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Dimension dim = ContactHeaderPanel.this.cttSelBut.getSize();
            ContactHeaderPanel.this.tplSelPopup.show(ContactHeaderPanel.this.cttSelBut, 0, dim.height);
            ContactHeaderPanel.this.tplSelPopup.validate();
        }
    }
}

