/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.ecmpapi.json.mandatorybiometriccheck.MandatoryBiometricCheckResponse;
import in.gov.uidai.ec.ecmpapi.json.statuscheck.Id;
import in.gov.uidai.ec.ecmpapi.json.statuscheck.UidStatusCheckResponse;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.updateapi.Address;
import in.gov.uidai.ec.oauthapi.json.updateapi.Email;
import in.gov.uidai.ec.oauthapi.json.updateapi.Mobile;
import in.gov.uidai.ec.oauthapi.json.updateapi.UpdateDemographicsRequest;
import in.gov.uidai.ec.service.appointment.model.IAppointment;
import in.gov.uidai.ec.service.appointment.model.UpdateEnrolAppointment;
import in.gov.uidai.ec.service.appointment.model.UpdateEnrolment;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantConfirmGender;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.ConfirmDob;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.enrollment.util.EnrolHelper;
import in.gov.uidai.ec.service.isd.ISD;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.IEnrolConstants;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.demographics.AddressPanel;
import in.gov.uidai.ec.ui.enrol.demographics.AgeDobPanel;
import in.gov.uidai.ec.ui.enrol.demographics.ConfirmDOBPanel;
import in.gov.uidai.ec.ui.enrol.demographics.DemographicsTabViewPeer;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.demographics.MobilePanel;
import in.gov.uidai.ec.ui.enrol.demographics.UpdateTypeSelectionPanel;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysEnrol;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import in.gov.uidai.swing.combo.DropDownItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DemographicsController
extends EnrollmentControllerBase
implements IDemoTabConstants,
IEnrolConstants,
INavigationConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(DemographicsController.class);
    private final DemographicsTabViewPeer view;
    private final IVisualExecutionContext veCtxt;
    private final boolean isUpdateEnrollment;
    private final boolean isDocumentUpdate;
    private final boolean isOffLineDocUpdate;
    private PersonalDetail personalDetail;
    private final boolean isOnlineUpdate;
    private IEventContext eventContext;
    private boolean isReviewTabRendered;

    DemographicsController(DemographicsTabViewPeer view, IEventContext eventContext, int tabIndex) {
        super(view.liteView, view.enrollmentService, 0, tabIndex);
        this.view = view;
        this.enrollmentService.getDemographics().addValidityChangeListener(this::updateTabValidityState);
        this.veCtxt = view.liteView.getVisualExecutionContext();
        this.isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
        this.isDocumentUpdate = this.enrollmentService.isDocumentUpdate();
        this.isOffLineDocUpdate = this.enrollmentService.isOffLineDocumentUpdate();
        this.isOnlineUpdate = this.enrollmentService.isOnlineUpdate();
        this.eventContext = eventContext;
        this.initView();
    }

    private void initView() {
        this.view.residentTypePanel.isIndianOpt.addItemListener(this::residentTypeSelected);
        this.view.residentTypePanel.isNRIOpt.addItemListener(this::residentTypeSelected);
        this.view.appointmentPanel.appointmentIdField.setEnabled(this.enrollmentService.isAppointmentBasedFlow());
        super.addFocusListener(this.view.appointmentPanel.appointmentIdField, this::appointmentIdFocusLost);
        super.addFocusListener(this.view.namePanel.fullNameField, this::nameFocusLost);
        super.addFocusListener((JTextField)this.view.namePanel.locFullNameField, this::locNameFocusLost);
        super.addPopupMenuListener(this.view.genderPanel.genderField, this::onGenderChange);
        super.addKeyListener(this.view.genderPanel.genderField, Arrays.asList(Character.valueOf('S'), Character.valueOf('F'), Character.valueOf('M'), Character.valueOf('T')), this::onGenderChange);
        super.addPopupMenuListener(this.view.confirmGenderPanel.genderField, this::onConfirmGenderChange);
        super.addKeyListener(this.view.confirmGenderPanel.genderField, Arrays.asList(Character.valueOf('S'), Character.valueOf('F'), Character.valueOf('M'), Character.valueOf('T')), this::onConfirmGenderChange);
        super.addActionListener(this.view.ageDobPanel.ageOpt, (ActionEvent e) -> this.ageDobOptChanged(this.view.ageDobPanel.ageOpt));
        super.addActionListener(this.view.ageDobPanel.dobOpt, (ActionEvent e) -> this.ageDobOptChanged(this.view.ageDobPanel.dobOpt));
        super.addFocusListener(this.view.ageDobPanel.ageField, this::ageDobFocusLost);
        super.addFocusListener(this.view.ageDobPanel.dobDayField, this::ageDobFocusLost);
        super.addFocusListener(this.view.ageDobPanel.dobMonthField, this::ageDobFocusLost);
        super.addFocusListener(this.view.ageDobPanel.dobYearField, this::ageDobFocusLost);
        super.addFocusListener(this.view.confirmDOBPanel.dobDayField, this::confirmDobFocusLost);
        super.addFocusListener(this.view.confirmDOBPanel.dobMonthField, this::confirmDobFocusLost);
        super.addFocusListener(this.view.confirmDOBPanel.dobYearField, this::confirmDobFocusLost);
        this.view.ageDobPanel.verifiedOptField.addChangeListener(this::ageVerifiedChanged);
        super.addFocusListener(this.view.nprPanel.nprField, this::nprNumberFocusLost);
        super.addFocusListener(this.view.careOfPanel.careOfField, this::careOfNameFocusLost);
        super.addFocusListener((JTextField)this.view.careOfPanel.locCareOfField, this::careOfNameLocFocusLost);
        AddressPanel addressComposite = this.view.addressPanel;
        super.addMouseListener(this.view.contactHeaderPanel.tplList, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DemographicsController.this.setAddressType();
            }
        });
        this.enrollmentService.addOnPinCodeLoadedListeners(this::onPinCodeLoaded);
        this.enrollmentService.addOnPOListLoadedListeners(this::onPOCodeLoaded);
        super.addFocusListener(addressComposite.houseField, this::houseFocusLost);
        super.addFocusListener((JTextField)addressComposite.locHouseField, this::locHouseFocusLost);
        super.addFocusListener(addressComposite.streetField, this::streetFocusLost);
        super.addFocusListener((JTextField)addressComposite.locStreetField, this::streetLocalFocusLost);
        super.addFocusListener(addressComposite.landmarkField, this::landmarkFocusLost);
        super.addFocusListener((JTextField)addressComposite.locLandmarkField, this::landmarkLocalFocusLost);
        super.addFocusListener(addressComposite.localityField, this::localityFocusLost);
        super.addFocusListener((JTextField)addressComposite.locLocalityField, this::localityLocalFocusLost);
        addressComposite.postOffField.addFocusListener((FocusListener)this.view.evtCtxt.getEventListener("hID_DemoTab_PostOfficePropagate", FocusListener.class));
        super.addFocusListener((JTextField)addressComposite.locPostOffField, this::postOfficeLocalFocusLost);
        super.addFocusListener((JTextField)addressComposite.locVtcField, this::vtcLocalFocusLost);
        super.addFocusListener((JTextField)addressComposite.locDistrictField, this::districtLocalFocusLost);
        super.addFocusListener((JTextField)addressComposite.locSubDistField, this::subDistrictLocalFocusLost);
        super.addFocusListener((JTextField)addressComposite.locStateField, this::stateLocalFocusLost);
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        super.addFocusListener(MobilePanel.mobileField, this::mobileFocusLost);
        MobilePanel cfr_ignored_1 = this.view.mobilePanel;
        super.addItemListener(MobilePanel.isdCodeComboBox, this::onIsdCodeChange);
        super.addFocusListener(this.view.emailPanel.emailField, this::emailFocusLost);
        super.addActionListener(this.view.consentPanel.nextBut, this::onNextButtonClick);
        this.enrollmentService.addOnTabTransitionListeners(this::onTabTransition);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        this.addEventListenersForUpdateEnrollment();
        this.updateLocalResidentType();
        this.updateDisclaimer();
        if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.isDemoUpdate()) {
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            this.nameUpdateEnabled(fieldsUpdateCount.getName().hasToBeUpdated());
            this.addressUpdateEnabled(fieldsUpdateCount.getAddress().hasToBeUpdated());
            this.genderUpdateEnabled(fieldsUpdateCount.getGender().hasToBeUpdated());
            this.dobUpdateEnabled(fieldsUpdateCount.getDob().hasToBeUpdated());
            this.emailUpdateEnabled(fieldsUpdateCount.getEmail().hasToBeUpdated());
            this.mobileUpdateEnabled(fieldsUpdateCount.getMobile().hasToBeUpdated());
        }
    }

    private void nameUpdateEnabled(boolean enabled) {
        this.view.namePanel.nameCorrOpt.setSelected(enabled);
        this.view.namePanel.nameCorrOpt.setEnabled(enabled);
    }

    private void addressUpdateEnabled(boolean enabled) {
        this.view.contactHeaderPanel.contactEditBut.setSelected(enabled);
        this.view.contactHeaderPanel.contactEditBut.setEnabled(enabled);
        this.view.contactHeaderPanel.contactEditBut.setEnabled(enabled);
    }

    private void dobUpdateEnabled(boolean enabled) {
        this.view.ageDobPanel.adobEditOpt.setEnabled(enabled);
        this.view.ageDobPanel.adobEditOpt.setSelected(enabled);
        this.view.confirmDOBPanel.cdobEditOpt.setSelected(enabled);
        this.view.confirmDOBPanel.cdobEditOpt.setEnabled(enabled);
    }

    private void genderUpdateEnabled(boolean enabled) {
        this.view.genderPanel.genderEditOpt.setSelected(enabled);
        this.view.genderPanel.genderEditOpt.setEnabled(enabled);
        this.view.confirmGenderPanel.genderEditOpt.setSelected(enabled);
        this.view.confirmGenderPanel.genderEditOpt.setEnabled(enabled);
    }

    private void mobileUpdateEnabled(boolean enabled) {
        this.view.mobilePanel.mobileEditOpt.setSelected(enabled);
        this.view.mobilePanel.mobileEditOpt.setEnabled(enabled);
    }

    private void emailUpdateEnabled(boolean enabled) {
        this.view.emailPanel.emailEditOpt.setSelected(enabled);
        this.view.emailPanel.emailEditOpt.setEnabled(enabled);
    }

    private void addEventListenersForUpdateEnrollment() {
        if (!this.isUpdateEnrollment) {
            return;
        }
        if (this.isDocumentUpdate) {
            this.view.namePanel.nameCorrOpt.setEnabled(false);
            this.view.genderPanel.genderEditOpt.setEnabled(false);
            this.view.confirmGenderPanel.confirmGenderOpt.setEnabled(false);
            this.view.ageDobPanel.adobEditOpt.setEnabled(false);
            this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
            this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
            this.view.contactHeaderPanel.contactEditBut.setEnabled(false);
            this.view.careOfPanel.careOfField.setEnabled(false);
            this.view.mobilePanel.mobileEditOpt.setEnabled(false);
            this.view.emailPanel.emailEditOpt.setEnabled(false);
            this.view.updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
        } else if (this.isOffLineDocUpdate) {
            this.view.namePanel.nameCorrOpt.setEnabled(false);
            this.view.genderPanel.genderEditOpt.setEnabled(false);
            this.view.confirmGenderPanel.confirmGenderOpt.setEnabled(false);
            this.view.ageDobPanel.adobEditOpt.setEnabled(false);
            this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
            this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
            this.view.contactHeaderPanel.contactEditBut.setEnabled(false);
            this.view.careOfPanel.careOfField.setEnabled(false);
            this.view.mobilePanel.mobileEditOpt.setEnabled(false);
            this.view.emailPanel.emailEditOpt.setEnabled(false);
            this.view.consentPanel.mandatoryBioCheckButton.setEnabled(false);
            this.view.updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.setEnabled(false);
            super.addFocusListener((JTextField)this.view.namePanel.locNewNameField, this::locNewNameFocusLost);
            super.addFocusListener(this.view.aadhaarNoPanel.aadhaarNoField, this::aadhaarNoFocusLost);
            this.view.updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
            this.view.updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
        } else {
            super.addItemListener(this.view.namePanel.nameCorrOpt, this::newNameEdit);
            super.addFocusListener(this.view.namePanel.newNameField, this::newNameFocusLost);
            super.addFocusListener((JTextField)this.view.namePanel.locNewNameField, this::locNewNameFocusLost);
            super.addFocusListener(this.view.aadhaarNoPanel.aadhaarNoField, this::aadhaarNoFocusLost);
            super.addActionListener(this.view.consentPanel.mandatoryBioCheckButton, (ActionEvent ae) -> this.performMandatoryBiometricCheck(true));
            if (!this.enrollmentService.isChildEnrollment()) {
                super.addChangeListener(this.view.updateTypeSelectionPanel.childUpdateOption, (ItemEvent ie) -> this.updateTypeAgeChangeListener(ie, true, false, false));
            }
            if (!this.enrollmentService.isMinorEnrollment()) {
                super.addChangeListener(this.view.updateTypeSelectionPanel.minorUpdateOption, (ItemEvent ie) -> this.updateTypeAgeChangeListener(ie, false, true, false));
            }
            if (!this.enrollmentService.isAdultEnrollment()) {
                super.addChangeListener(this.view.updateTypeSelectionPanel.adultUpdateOption, (ItemEvent ie) -> this.updateTypeAgeChangeListener(ie, false, false, true));
            }
            super.addChangeListener(this.view.updateTypeSelectionPanel.bioUpdateOption, (ItemEvent ie) -> this.updateTypeChangeListener(ie, false, true, false));
            super.addChangeListener(this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption, (ItemEvent ie) -> this.updateTypeChangeListener(ie, false, false, true));
            super.addItemListener(this.view.genderPanel.genderEditOpt, this::genderEdit);
            super.addItemListener(this.view.confirmGenderPanel.genderEditOpt, this::confirmGenderEdit);
            super.addItemListener(this.view.ageDobPanel.adobEditOpt, this::ageDobEdit);
            super.addItemListener(this.view.confirmDOBPanel.cdobEditOpt, this::confirmDobEdit);
            super.addItemListener(this.view.contactHeaderPanel.contactEditBut, this::addressEdit);
            super.addItemListener(this.view.mobilePanel.mobileEditOpt, this::mobileEdit);
            super.addItemListener(this.view.emailPanel.emailEditOpt, this::emailEdit);
            this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateChange);
            this.enrollmentService.getDemoPersonalDetails().getAgeDob().addValidityChangeListener(this::onAgeDobValidityChange);
            this.enrollmentService.getDemoPersonalDetails().getConfirmDob().addValidityChangeListener(this::onConfirmDobValidityChange);
            if (this.enrollmentService.isOnlineUpdate() && !this.enrollmentService.isNewEnrollmentUC()) {
                MobilePanel cfr_ignored_0 = this.view.mobilePanel;
                if (MobilePanel.verifyMobileBtn != null) {
                    MobilePanel cfr_ignored_1 = this.view.mobilePanel;
                    MobilePanel.verifyMobileBtn.addActionListener((ActionListener)this.eventContext.getEventListener("residentMobileVerifyButton", ActionListener.class));
                }
                Optional<FieldsUpdateCount> fieldsUpdateCountOptional = Optional.ofNullable(this.enrollmentService.getFieldsUpdateCount());
                fieldsUpdateCountOptional.map(FieldsUpdateCount::getName).ifPresent(fuc -> fuc.addChangeListener(__ -> this.nameUpdateEnabled(fuc.hasToBeUpdated())));
                fieldsUpdateCountOptional.map(FieldsUpdateCount::getAddress).ifPresent(fuc -> fuc.addChangeListener(__ -> this.addressUpdateEnabled(fuc.hasToBeUpdated())));
                fieldsUpdateCountOptional.map(FieldsUpdateCount::getGender).ifPresent(fuc -> fuc.addChangeListener(__ -> this.genderUpdateEnabled(fuc.hasToBeUpdated())));
                fieldsUpdateCountOptional.map(FieldsUpdateCount::getDob).ifPresent(fuc -> fuc.addChangeListener(__ -> this.dobUpdateEnabled(fuc.hasToBeUpdated())));
                fieldsUpdateCountOptional.map(FieldsUpdateCount::getEmail).ifPresent(fuc -> fuc.addChangeListener(__ -> this.emailUpdateEnabled(fuc.hasToBeUpdated())));
                fieldsUpdateCountOptional.map(FieldsUpdateCount::getMobile).ifPresent(fuc -> fuc.addChangeListener(__ -> this.mobileUpdateEnabled(fuc.hasToBeUpdated())));
            }
            if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.isHofEnrollment()) {
                this.addressUpdateEnabled(false);
            }
            if (this.enrollmentService.isOnlineUpdate()) {
                this.view.updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                this.view.updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
                this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.setEnabled(false);
                AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
                AgeGroup ageGroup = ageDob.getOnlineAgeGroup();
                if (ageGroup.equals((Object)AgeGroup.ABOVE18)) {
                    this.view.updateTypeSelectionPanel.adultUpdateOption.setEnabled(true);
                    this.view.updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
                } else {
                    this.view.updateTypeSelectionPanel.minorUpdateOption.setEnabled(true);
                    this.view.updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
                }
            }
            if (this.enrollmentService.isUniversalClientTrnx()) {
                this.view.updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
                this.view.updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
            }
            if (this.enrollmentService.getSessionService().isNameValidationEnabled() && this.enrollmentService.isOnlineUpdate()) {
                this.view.namePanel.nameCorrOpt.setEnabled(false);
            }
            if (this.enrollmentService.getSessionService().isGenderValidationEnabled() && this.enrollmentService.isOnlineUpdate()) {
                this.view.genderPanel.genderEditOpt.setEnabled(false);
                this.view.confirmGenderPanel.genderEditOpt.setEnabled(false);
            }
            if (this.enrollmentService.getSessionService().isDobValidationEnabled() && this.enrollmentService.isOnlineUpdate()) {
                this.view.ageDobPanel.adobEditOpt.setEnabled(false);
                this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
            }
        }
    }

    private void onViewLoadComplete(Object o) {
        this.populateView();
        if (this.isUpdateEnrollment) {
            this.populateUpdateEnrollmentType();
            this.onBiometricUpdateChange(this.enrollmentService.isBiometricUpdate());
            if (!this.enrollmentService.isUniversalClientTrnx()) {
                this.performMandatoryBiometricCheck(false);
            }
        }
        this.setAddressType();
        this.updateTabValidityState(this.enrollmentService.getDemographics().isValid());
    }

    private void populateView() {
        this.populateResidentialDetails();
        this.populateAppointmentDetails();
        this.populatePersonalDetails();
        this.populateContactDetails();
    }

    private void onTabTransition(Object o) {
        int tabIndex = (Integer)o;
        if (tabIndex == 0) {
            this.updateFieldState();
        }
    }

    private void onBiometricUpdateChange(Boolean biometricUpdate) {
        this.view.consentPanel.bioExpBut.setEnabled(biometricUpdate);
        if (!biometricUpdate.booleanValue()) {
            this.view.evtCtxt.fireGenericEvent("eID_Biox_Reset", new Object[0]);
        }
    }

    private void addressEdit(ItemEvent ie) {
        boolean edited = ie.getStateChange() == 1;
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        address.setUpdated(edited);
        if (this.enrollmentService.isOnlineUpdate() && edited) {
            address.setToExistingAddress();
            if (StringUtils.isNotBlank((String)address.getCareOfNameForDisplay())) {
                this.view.careOfPanel.careOfField.setEnabled(false);
                this.view.careOfPanel.locCareOfField.setEnabled(false);
                address.setUpdated(true);
            }
        }
        if (!edited) {
            address.reset();
            this.view.careOfPanel.careOfField.setText(address.getCareOfNameForDisplay());
            this.view.careOfPanel.locCareOfField.setText(address.getCareOfNameLocaleForDisplay());
            this.view.careOfPanel.careOfField.setEnabled(false);
            this.view.careOfPanel.locCareOfField.setEnabled(false);
            this.view.addressPanel.setAddressFields(address);
        }
    }

    private void mobileEdit(ItemEvent ie) {
        MobilePanel mobilePanel = this.view.mobilePanel;
        boolean edited = ie.getStateChange() == 1;
        Mobile mobile = this.enrollmentService.getDemographics().getContact().getMobile();
        mobile.setUpdated(edited);
        if (StringUtils.isBlank((String)mobile.number())) {
            mobile.setNumber(mobile.getExistingNumber());
        }
        MobilePanel.isdCodeComboBox.setEnabled(!this.enrollmentService.isDemoUpdate());
        MobilePanel.mobileField.setEnabled(edited);
        if (!edited) {
            mobile.setNumber("");
            MobilePanel.isdCodeComboBox.setSelectedItem(this.enrollmentService.getIsdService().getISDByCode("+91"));
            MobilePanel.mobileField.setText(mobile.getNumberForDisplay());
        }
    }

    private void emailEdit(ItemEvent ie) {
        boolean edited = ie.getStateChange() == 1;
        Email email = this.enrollmentService.getDemoContactDetails().getEmail();
        email.setUpdated(edited);
        if (StringUtils.isBlank((String)email.email())) {
            email.setEmail(email.getExistingEmail());
        }
        this.view.emailPanel.emailField.setEnabled(edited);
        if (!edited) {
            email.setEmail("");
            this.view.emailPanel.emailField.setText(email.getEmailForDisplay());
        }
    }

    private void ageDobEdit(ItemEvent ie) {
        AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
        boolean edited = ie.getStateChange() == 1;
        ageDob.setUpdated(edited);
        if (ageDob.getDay() <= 0 || ageDob.getMonth() <= 0 || ageDob.getYear() <= 0) {
            ageDob.resetToExistingDate();
        }
        this.view.ageDobPanel.setDobEnabled(edited);
        this.view.ageDobPanel.verifiedOptField.setEnabled(false);
        this.view.ageDobPanel.verifiedOptField.setSelected(edited);
        this.view.ageDobPanel.setDobFields(ageDob.getDayForDisplay(), ageDob.getMonthForDisplay(), ageDob.getYearForDisplay());
        if (!edited) {
            ageDob.setDob("", "", "");
            this.view.ageDobPanel.setDobFields(ageDob.getDayForDisplay(), ageDob.getMonthForDisplay(), ageDob.getYearForDisplay());
        }
    }

    private void confirmDobEdit(ItemEvent ie) {
        ConfirmDob confirmDob = this.enrollmentService.getDemographics().getPersonalDetail().getConfirmDob();
        boolean edited = ie.getStateChange() == 1;
        confirmDob.setUpdated(edited);
        if (confirmDob.getDay() <= 0 || confirmDob.getMonth() <= 0 || confirmDob.getYear() <= 0) {
            confirmDob.resetToExistingDate();
        }
        this.view.confirmDOBPanel.setDobEnabled(edited);
        this.view.confirmDOBPanel.verifiedOptField.setEnabled(false);
        this.view.confirmDOBPanel.verifiedOptField.setSelected(edited);
        this.view.confirmDOBPanel.setDobFields(confirmDob.getDayForDisplay(), confirmDob.getMonthForDisplay(), confirmDob.getYearForDisplay());
        if (!edited) {
            confirmDob.setDob("", "", "");
            this.view.confirmDOBPanel.setDobFields(confirmDob.getDayForDisplay(), confirmDob.getMonthForDisplay(), confirmDob.getYearForDisplay());
        }
    }

    private void genderEdit(ItemEvent ie) {
        boolean edited = ie.getStateChange() == 1;
        ApplicantGender gender = this.enrollmentService.getDemographics().getPersonalDetail().getApplicantGender();
        gender.setUpdated(edited);
        if (gender.getGender() == Gender.NOT_GIVEN) {
            gender.setGender(gender.getExistingGender());
        }
        JComboBox<Object> genderField = this.view.genderPanel.genderField;
        genderField.setEnabled(edited);
        if (!edited) {
            gender.setGender(Gender.NOT_GIVEN);
            gender.setGenderLocal("");
            Gender displayGender = gender.getDisplayGender();
            if (displayGender == Gender.NOT_GIVEN) {
                genderField.setSelectedIndex(0);
            } else {
                genderField.setSelectedItem(displayGender);
            }
            this.view.genderPanel.locGenderField.setText(String.valueOf(displayGender));
        }
    }

    private void confirmGenderEdit(ItemEvent ie) {
        boolean edited = ie.getStateChange() == 1;
        ApplicantConfirmGender gender = this.enrollmentService.getDemographics().getPersonalDetail().getApplicantConfirmGender();
        gender.setUpdated(edited);
        if (gender.getGender() == Gender.NOT_GIVEN) {
            gender.setGender(gender.getExistingGender());
        }
        JComboBox<Object> genderField = this.view.confirmGenderPanel.genderField;
        genderField.setEnabled(edited);
        this.clearFieldError(this.view.confirmGenderPanel.genderField);
        if (!edited) {
            gender.setGender(Gender.NOT_GIVEN);
            gender.setGenderLocal("");
            Gender displayGender = gender.getDisplayGender();
            if (displayGender == Gender.NOT_GIVEN) {
                genderField.setSelectedIndex(0);
            } else {
                genderField.setSelectedItem(displayGender);
            }
            this.view.confirmGenderPanel.locGenderField.setText(String.valueOf(displayGender));
        }
    }

    private void updateTypeChangeListener(ItemEvent ie, boolean childEnrolOptSelected, boolean bioUpdateOptSelected, boolean mandatoryBioUpdateOptSelected) {
        boolean selected;
        UpdateTypeSelectionPanel updateTypeSelectionPanel = this.view.updateTypeSelectionPanel;
        boolean bl = selected = ie.getStateChange() == 1;
        if (selected) {
            this.enrollmentService.setChildEnrollment(childEnrolOptSelected);
            this.enrollmentService.setBiometricUpdate(bioUpdateOptSelected);
            if (this.enrollmentService.isBiometricUpdate()) {
                this.view.updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
            }
            this.enrollmentService.setMandatoryBiometricUpdate(mandatoryBioUpdateOptSelected);
        } else {
            this.enrollmentService.setChildEnrollment(updateTypeSelectionPanel.childUpdateOption.isSelected());
            this.enrollmentService.setBiometricUpdate(updateTypeSelectionPanel.bioUpdateOption.isSelected());
            this.enrollmentService.setMandatoryBiometricUpdate(updateTypeSelectionPanel.mandatoryBioUpdateOption.isSelected());
            if (!this.enrollmentService.isBiometricUpdate()) {
                this.view.updateTypeSelectionPanel.childUpdateOption.setEnabled(true);
            }
        }
        this.refreshUpdateTypeUIState();
    }

    private void updateTypeAgeChangeListener(ItemEvent ie, boolean childEnrolOptSelected, boolean minorOptSelected, boolean adultOptSelected) {
        boolean selected;
        UpdateTypeSelectionPanel updateTypeSelectionPanel = this.view.updateTypeSelectionPanel;
        References references = this.enrollmentService.getReferences();
        boolean bl = selected = ie.getStateChange() == 1;
        if (selected) {
            this.enrollmentService.setChildEnrollment(childEnrolOptSelected);
            this.enrollmentService.setMinorEnrollment(minorOptSelected);
            this.enrollmentService.setAdultEnrollment(adultOptSelected);
            if (childEnrolOptSelected) {
                updateTypeSelectionPanel.mandatoryBioUpdateOption.setEnabled(false);
                updateTypeSelectionPanel.bioUpdateOption.setSelected(false);
                updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
                updateTypeSelectionPanel.minorUpdateOption.setSelected(false);
                updateTypeSelectionPanel.adultUpdateOption.setSelected(false);
                this.enrollmentService.setMinorEnrollment(false);
                this.enrollmentService.setAdultEnrollment(false);
                references.reEvaluateReferences(this.enrollmentService.isNRIEnrolment(), AgeGroup.BELOW5);
                this.addEventListenersForUpdateEnrollment();
            }
            if (minorOptSelected) {
                if (!this.enrollmentService.isOnlineUpdate()) {
                    updateTypeSelectionPanel.bioUpdateOption.setEnabled(true);
                }
                references.reEvaluateReferences(this.enrollmentService.isNRIEnrolment(), AgeGroup.BETWEEN5TO18);
                this.enrollmentService.setAdultEnrollment(false);
                this.enrollmentService.setChildEnrollment(false);
                updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
                updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                if (this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.isSelected()) {
                    updateTypeSelectionPanel.childUpdateOption.setSelected(false);
                    updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                    this.enrollmentService.setMandatoryBiometricUpdate(true);
                }
                if (this.view.updateTypeSelectionPanel.bioUpdateOption.isSelected()) {
                    updateTypeSelectionPanel.childUpdateOption.setSelected(false);
                    updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                    this.enrollmentService.setBiometricUpdate(true);
                }
                if (!this.enrollmentService.isOnlineUpdate()) {
                    updateTypeSelectionPanel.bioUpdateOption.setEnabled(true);
                    updateTypeSelectionPanel.adultUpdateOption.setSelected(false);
                } else {
                    updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
                    updateTypeSelectionPanel.adultUpdateOption.setEnabled(false);
                    updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                }
                updateTypeSelectionPanel.adultUpdateOption.setSelected(false);
                if (this.enrollmentService.isOnlineUpdate()) {
                    if (this.enrollmentService.getSessionService().isNameValidationEnabled() && this.enrollmentService.getSessionService().isGenderValidationEnabled() && this.enrollmentService.getSessionService().isDobValidationEnabled()) {
                        this.view.namePanel.nameCorrOpt.setEnabled(false);
                        this.view.genderPanel.genderEditOpt.setEnabled(false);
                        this.view.confirmGenderPanel.genderEditOpt.setEnabled(false);
                        this.view.ageDobPanel.adobEditOpt.setEnabled(false);
                        this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
                    }
                } else {
                    this.view.namePanel.nameCorrOpt.setEnabled(true);
                    this.view.genderPanel.genderEditOpt.setEnabled(true);
                    this.view.confirmGenderPanel.genderEditOpt.setEnabled(true);
                    this.view.ageDobPanel.adobEditOpt.setEnabled(true);
                    this.view.confirmDOBPanel.cdobEditOpt.setEnabled(true);
                }
            }
            if (adultOptSelected) {
                this.view.namePanel.newNameField.setEnabled(false);
                this.view.namePanel.nameCorrOpt.setEnabled(false);
                this.view.namePanel.locNewNameField.setEnabled(false);
                this.view.genderPanel.genderEditOpt.setEnabled(false);
                this.view.confirmGenderPanel.genderEditOpt.setEnabled(false);
                this.view.ageDobPanel.adobEditOpt.setEnabled(false);
                this.view.ageDobPanel.adobEditOpt.setSelected(false);
                this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
                this.view.confirmDOBPanel.cdobEditOpt.setSelected(false);
                if (!this.enrollmentService.isOnlineUpdate()) {
                    updateTypeSelectionPanel.bioUpdateOption.setEnabled(true);
                    updateTypeSelectionPanel.minorUpdateOption.setSelected(false);
                    this.enrollmentService.setMinorEnrollment(false);
                } else {
                    updateTypeSelectionPanel.bioUpdateOption.setEnabled(false);
                    updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
                    updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                }
                JComboBox<Object> genderField = this.view.genderPanel.genderField;
                ApplicantGender gender = this.enrollmentService.getDemographics().getPersonalDetail().getApplicantGender();
                gender.setGender(Gender.NOT_GIVEN);
                gender.setGenderLocal("");
                Gender displayGender = gender.getDisplayGender();
                if (displayGender == Gender.NOT_GIVEN) {
                    genderField.setSelectedIndex(0);
                } else {
                    genderField.setSelectedItem(displayGender);
                }
                if (this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.isSelected()) {
                    updateTypeSelectionPanel.childUpdateOption.setSelected(false);
                    updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                    this.enrollmentService.setMandatoryBiometricUpdate(true);
                }
                if (this.view.updateTypeSelectionPanel.bioUpdateOption.isSelected()) {
                    updateTypeSelectionPanel.childUpdateOption.setSelected(false);
                    updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                    this.enrollmentService.setBiometricUpdate(true);
                }
                this.view.genderPanel.genderField.setEnabled(false);
                this.view.genderPanel.locGenderField.setText(String.valueOf(displayGender));
                updateTypeSelectionPanel.minorUpdateOption.setEnabled(false);
                updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
                Name name = this.enrollmentService.getDemoPersonalDetails().getName();
                this.view.namePanel.newNameField.setText("");
                this.view.namePanel.locNewNameField.setText("");
                name.setNewName("");
                name.setNewNameLocal("");
                JComboBox<Object> confirmGenderField = this.view.confirmGenderPanel.genderField;
                gender.setGender(Gender.NOT_GIVEN);
                gender.setGenderLocal("");
                Gender displayConfirmGender = gender.getDisplayGender();
                if (displayGender == Gender.NOT_GIVEN) {
                    confirmGenderField.setSelectedIndex(0);
                } else {
                    confirmGenderField.setSelectedItem(displayConfirmGender);
                }
                this.view.confirmGenderPanel.locGenderField.setText(String.valueOf(displayConfirmGender));
                this.view.confirmGenderPanel.genderField.setEnabled(false);
                AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
                this.view.ageDobPanel.setDobFields(ageDob.getDayForDisplay(), ageDob.getMonthForDisplay(), ageDob.getYearForDisplay());
                ConfirmDob confirmDob = this.enrollmentService.getDemographics().getPersonalDetail().getConfirmDob();
                this.view.confirmDOBPanel.setDobFields(confirmDob.getDayForDisplay(), confirmDob.getMonthForDisplay(), confirmDob.getYearForDisplay());
                references.reEvaluateReferences(this.enrollmentService.isNRIEnrolment(), AgeGroup.ABOVE18);
            }
        } else if (this.enrollmentService.isOnlineUpdate()) {
            AgeDob ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
            AgeGroup ageGroup = ageDob.getOnlineAgeGroup();
            if (!updateTypeSelectionPanel.minorUpdateOption.isSelected() && this.enrollmentService.isOnlineUpdate() && ageGroup.equals((Object)AgeGroup.BETWEEN5TO18)) {
                this.enrollmentService.setMinorEnrollment(updateTypeSelectionPanel.minorUpdateOption.isSelected());
                if (this.enrollmentService.getSessionService().isNameValidationEnabled() && this.enrollmentService.getSessionService().isGenderValidationEnabled() && this.enrollmentService.getSessionService().isDobValidationEnabled() && this.enrollmentService.isOnlineUpdate()) {
                    this.view.namePanel.nameCorrOpt.setEnabled(false);
                    this.view.genderPanel.genderEditOpt.setEnabled(false);
                    this.view.confirmGenderPanel.genderEditOpt.setEnabled(false);
                    this.view.ageDobPanel.adobEditOpt.setEnabled(false);
                    this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
                } else {
                    this.view.namePanel.nameCorrOpt.setEnabled(true);
                    this.view.genderPanel.genderEditOpt.setEnabled(true);
                    this.view.confirmGenderPanel.genderEditOpt.setEnabled(true);
                    this.view.ageDobPanel.adobEditOpt.setEnabled(true);
                    this.view.confirmDOBPanel.cdobEditOpt.setEnabled(true);
                }
            } else if (!updateTypeSelectionPanel.adultUpdateOption.isSelected()) {
                if (this.enrollmentService.getSessionService().isNameValidationEnabled() && this.enrollmentService.getSessionService().isGenderValidationEnabled() && this.enrollmentService.getSessionService().isDobValidationEnabled() && this.enrollmentService.isOnlineUpdate()) {
                    this.view.namePanel.nameCorrOpt.setEnabled(false);
                    this.view.genderPanel.genderEditOpt.setEnabled(false);
                    this.view.confirmGenderPanel.genderEditOpt.setEnabled(false);
                    this.view.ageDobPanel.adobEditOpt.setEnabled(false);
                    this.view.confirmDOBPanel.cdobEditOpt.setEnabled(false);
                } else {
                    this.view.namePanel.newNameField.setEnabled(true);
                    this.view.namePanel.nameCorrOpt.setEnabled(true);
                    this.view.namePanel.locNewNameField.setEnabled(true);
                    this.view.genderPanel.genderEditOpt.setEnabled(true);
                    this.view.confirmGenderPanel.genderEditOpt.setEnabled(true);
                    this.view.ageDobPanel.adobEditOpt.setEnabled(true);
                    this.view.ageDobPanel.adobEditOpt.setSelected(true);
                    this.view.confirmDOBPanel.cdobEditOpt.setEnabled(true);
                    this.view.confirmDOBPanel.cdobEditOpt.setSelected(true);
                }
                this.enrollmentService.setAdultEnrollment(updateTypeSelectionPanel.adultUpdateOption.isSelected());
            }
        } else {
            this.enrollmentService.setMinorEnrollment(updateTypeSelectionPanel.minorUpdateOption.isSelected());
            updateTypeSelectionPanel.minorUpdateOption.setEnabled(true);
            this.enrollmentService.setAdultEnrollment(updateTypeSelectionPanel.adultUpdateOption.isSelected());
            updateTypeSelectionPanel.adultUpdateOption.setEnabled(true);
            this.enrollmentService.setChildEnrollment(updateTypeSelectionPanel.childUpdateOption.isSelected());
            updateTypeSelectionPanel.childUpdateOption.setEnabled(true);
            this.view.namePanel.nameCorrOpt.setEnabled(true);
            this.view.genderPanel.genderEditOpt.setEnabled(true);
            this.view.confirmGenderPanel.genderEditOpt.setEnabled(true);
            this.view.ageDobPanel.adobEditOpt.setEnabled(true);
            this.view.confirmDOBPanel.cdobEditOpt.setEnabled(true);
            if (updateTypeSelectionPanel.bioUpdateOption.isSelected() || updateTypeSelectionPanel.mandatoryBioUpdateOption.isSelected()) {
                updateTypeSelectionPanel.childUpdateOption.setEnabled(false);
            }
        }
        this.refreshUpdateAgeTypeUIState();
    }

    private void refreshUpdateTypeUIState() {
        UpdateTypeSelectionPanel updateTypeSelectionPanel = this.view.updateTypeSelectionPanel;
        updateTypeSelectionPanel.childUpdateOption.setSelected(this.enrollmentService.isChildEnrollment());
        updateTypeSelectionPanel.bioUpdateOption.setSelected(this.enrollmentService.isBiometricUpdate() && !this.enrollmentService.isMandatoryBiometricUpdate());
        updateTypeSelectionPanel.mandatoryBioUpdateOption.setSelected(this.enrollmentService.isMandatoryBiometricUpdate());
    }

    private void refreshUpdateAgeTypeUIState() {
        UpdateTypeSelectionPanel updateTypeSelectionPanel = this.view.updateTypeSelectionPanel;
        updateTypeSelectionPanel.childUpdateOption.setSelected(this.enrollmentService.isChildEnrollment());
        updateTypeSelectionPanel.adultUpdateOption.setSelected(this.enrollmentService.isAdultEnrollment());
        updateTypeSelectionPanel.minorUpdateOption.setSelected(this.enrollmentService.isMinorEnrollment());
    }

    private void populateUpdateEnrollmentType() {
        if (this.enrollmentService.isChildEnrollment()) {
            this.view.updateTypeSelectionPanel.childUpdateOption.setSelected(true);
        } else if (this.enrollmentService.isMandatoryBiometricUpdate()) {
            this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.setSelected(true);
        } else if (this.enrollmentService.isBiometricUpdate()) {
            this.view.updateTypeSelectionPanel.bioUpdateOption.setSelected(true);
        }
    }

    private void populateResidentialDetails() {
        ResidentialStatus demoResidentialStatus = this.enrollmentService.getDemoResidentialStatus();
        this.view.residentTypePanel.setResidentTypeSelection(demoResidentialStatus.isNRI());
        this.updateLocalResidentType();
    }

    private void populateAppointmentDetails() {
        String appointmentId = StringUtils.trimToEmpty((String)this.enrollmentService.getAppointmentId());
        this.view.appointmentPanel.appointmentIdField.setText(appointmentId);
    }

    private void populatePersonalDetails() {
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        Name name = demoPersonalDetails.getName();
        this.view.namePanel.fullNameField.setText(name.english());
        this.view.namePanel.locFullNameField.setText(name.local());
        ApplicantGender gender = demoPersonalDetails.getApplicantGender();
        this.view.genderPanel.genderField.insertItemAt(Gender.getDefaultSelect(), 0);
        if (gender.getDisplayGender() == Gender.NOT_GIVEN) {
            this.view.genderPanel.genderField.setSelectedIndex(0);
        } else {
            this.view.genderPanel.genderField.setSelectedItem(gender.getDisplayGender());
            this.view.genderPanel.locGenderField.setText(gender.getDisplayGender().toString());
        }
        if (gender.isUpdated()) {
            this.view.genderPanel.genderEditOpt.setSelected(true);
        }
        if (this.isUpdateEnrollment || this.enrollmentService.isOnlineUpdate()) {
            ApplicantConfirmGender confirmGender = demoPersonalDetails.getApplicantConfirmGender();
            this.view.confirmGenderPanel.genderField.insertItemAt(Gender.getDefaultSelect(), 0);
            if (confirmGender.getDisplayGender() == Gender.NOT_GIVEN) {
                this.view.confirmGenderPanel.genderField.setSelectedIndex(0);
            } else {
                this.view.confirmGenderPanel.genderField.setSelectedItem(confirmGender.getDisplayGender());
                this.view.confirmGenderPanel.locGenderField.setText(confirmGender.getDisplayGender().toString());
            }
            if (confirmGender.isUpdated()) {
                this.view.confirmGenderPanel.genderEditOpt.setSelected(true);
            }
        }
        this.populateAgeDob();
        this.populateConfirmDob();
        if (this.isUpdateEnrollment) {
            if (StringUtils.isNotBlank((String)name.getNewNameForDisplay())) {
                this.view.namePanel.newNameField.setText(name.getNewNameForDisplay());
                this.view.namePanel.locNewNameField.setText(name.getNewNameForDisplay());
            }
            this.enrollmentService.getDemoPersonalDetails().getName().setNewNameLocal(this.view.namePanel.locNewNameField.getText());
            String aadhaarNumber = demoPersonalDetails.getAadhaarNumber().getAadhaarNumber();
            this.view.aadhaarNoPanel.aadhaarNoField.setValue(StringUtils.isBlank((String)aadhaarNumber) ? null : aadhaarNumber);
            if (name.isUpdated()) {
                this.view.namePanel.nameCorrOpt.setSelected(true);
            }
        }
    }

    private void populateAgeDob() {
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        AgeDobPanel adob = this.view.ageDobPanel;
        if (ageDob.isUpdated()) {
            this.view.ageDobPanel.adobEditOpt.setSelected(true);
        }
        if (ageDob.isDobSelected()) {
            adob.setDobVerified(ageDob.isVerified());
            adob.setDobFields(ageDob.getDayForDisplay(), ageDob.getMonthForDisplay(), ageDob.getYearForDisplay());
            boolean isValidDoB = !ageDob.isEmpty();
            adob.dobDayField.setEnabled(isValidDoB);
            adob.dobMonthField.setEnabled(isValidDoB);
            adob.dobYearField.setEnabled(isValidDoB);
        } else {
            adob.setAgeField(ageDob.getAge());
        }
        this.view.ageDobPanel.verifiedOptField.setEnabled(this.enrollmentService.getDemoPersonalDetails().getAgeDob().isVerified());
        this.updateLocalAgeField();
    }

    private void populateConfirmDob() {
        if (this.isUpdateEnrollment) {
            ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
            ConfirmDOBPanel cdob = this.view.confirmDOBPanel;
            if (confirmDob.isUpdated()) {
                this.view.confirmDOBPanel.cdobEditOpt.setSelected(true);
            }
            if (confirmDob.isDobSelected()) {
                cdob.setDobVerified(confirmDob.isVerified());
                cdob.setDobFields(confirmDob.getDayForDisplay(), confirmDob.getMonthForDisplay(), confirmDob.getYearForDisplay());
                boolean isValidDoB = !confirmDob.isEmpty();
                cdob.dobDayField.setEnabled(isValidDoB);
                cdob.dobMonthField.setEnabled(isValidDoB);
                cdob.dobYearField.setEnabled(isValidDoB);
            }
            this.view.confirmDOBPanel.verifiedOptField.setEnabled(this.enrollmentService.getDemoPersonalDetails().getConfirmDob().isVerified());
            this.updateLocalConfirmField();
        }
    }

    private void populateContactDetails() {
        if (this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_UPDATE) || this.enrollmentService.isHofEnrollment()) {
            this.populateAddressOnlineUpdate();
        } else {
            this.populateAddress();
        }
        this.populateMobile();
        this.populateEmail();
    }

    private void populateMobile() {
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        if (mobile.isUpdated()) {
            this.view.mobilePanel.mobileEditOpt.setSelected(true);
        }
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        MobilePanel.mobileField.setText(mobile.getNumberForDisplay());
        ISD isd = this.enrollmentService.getIsdService().getISDByCode(mobile.isdCode());
        MobilePanel cfr_ignored_1 = this.view.mobilePanel;
        MobilePanel.isdCodeComboBox.setSelectedItem(isd);
    }

    private void populateEmail() {
        Contact demoContactDetails = this.enrollmentService.getDemoContactDetails();
        Email email = demoContactDetails.getEmail();
        this.view.emailPanel.emailField.setText(email.getEmailForDisplay());
        if (email.isUpdated()) {
            this.view.emailPanel.emailEditOpt.setSelected(true);
        }
    }

    private void populateAddress() {
        Contact demoContactDetails = this.enrollmentService.getDemoContactDetails();
        Address address = demoContactDetails.getAddress();
        if (address.isUpdated()) {
            this.view.contactHeaderPanel.contactEditBut.setSelected(true);
        }
        boolean enabledCareOf = !this.isUpdateEnrollment || StringUtils.isNotBlank((String)address.getCareOfNameForDisplay());
        this.view.careOfPanel.careOfField.setEnabled(false);
        this.view.careOfPanel.locCareOfField.setEnabled(false);
        this.view.careOfPanel.careOfField.setText(address.getCareOfNameForDisplay());
        this.view.careOfPanel.locCareOfField.setText(address.getCareOfNameLocaleForDisplay());
        this.view.addressPanel.setEnabled(!this.isUpdateEnrollment || address.isUpdated());
        this.view.addressPanel.setAddressFields(address);
    }

    private void populateAddressOnlineUpdate() {
        Contact demoContactDetails = this.enrollmentService.getDemoContactDetails();
        Address address = demoContactDetails.getAddress();
        if (address.isUpdated()) {
            this.view.contactHeaderPanel.contactEditBut.setSelected(true);
        }
        this.view.careOfPanel.careOfField.setEnabled(false);
        this.view.careOfPanel.locCareOfField.setEnabled(false);
        this.view.careOfPanel.careOfField.setText(address.getCareOfNameForDisplay());
        this.view.careOfPanel.locCareOfField.setText(address.getCareOfNameLocaleForDisplay());
        this.view.addressPanel.setEnabled(address.isUpdated());
        this.view.addressPanel.setAddressFields(address);
        if (this.enrollmentService.isHofEnrollment()) {
            this.enrollmentService.getDemographics().getContact().getAddress().setToExistingAddress();
        }
    }

    private void residentTypeSelected(ItemEvent ie) {
        if (ie.getStateChange() != 1) {
            return;
        }
        boolean isNriSelected = this.view.residentTypePanel.isNRIOpt.isSelected();
        this.enrollmentService.setIsNRIEnrolment(isNriSelected);
        if (this.isUpdateEnrollment) {
            this.view.emailPanel.emailEditOpt.setEnabled(!isNriSelected);
            this.view.emailPanel.emailEditOpt.setSelected(isNriSelected);
        }
        this.updateEmailFieldState();
        this.updateLocalResidentType();
        this.updateDisclaimer();
    }

    private void updateLocalResidentType() {
        IResourceBundleContext resourceBundleContext = this.view.enrolRbctx;
        if (this.enrollmentService.getDemoResidentialStatus().isNRI()) {
            this.view.residentTypePanel.locResidentTypeField.setText(resourceBundleContext, "label-tlit:demotab.non.resident.indian");
        } else {
            this.view.residentTypePanel.locResidentTypeField.setText(resourceBundleContext, "label-tlit:demotab.indian.resident");
        }
    }

    private void updateDisclaimer() {
        IResourceBundleContext resourceBundleContext = this.view.enrolRbctx;
        LabelKeysDemoTab consentKey = this.enrollmentService.getDemoResidentialStatus().isNRI() ? (this.isUpdateEnrollment ? LabelKeysDemoTab.NRI_DISCLAIMER : LabelKeysDemoTab.NRI_DISCLAIMER_UPDATE) : (this.isUpdateEnrollment ? LabelKeysDemoTab.DISCLAIMER : LabelKeysDemoTab.DISCLAIMER_UPDATE);
        this.view.consentPanel.consentOpt.setText(resourceBundleContext.getMessage((Object)consentKey, new Object[0]));
    }

    private void appointmentIdFocusLost(FocusEvent focusEvent) {
        if (focusEvent != null && focusEvent.isTemporary()) {
            return;
        }
        UpdateEnrolment updateEnrolment = new UpdateEnrolment();
        updateEnrolment.setAppointmentId(this.view.appointmentPanel.appointmentIdField.getText());
        UpdateEnrolAppointment appointmentUpdateEntity = new UpdateEnrolAppointment();
        appointmentUpdateEntity.setUpdateEnrolment(updateEnrolment);
        this.enrollmentService.setAppointment((IAppointment)appointmentUpdateEntity);
    }

    private void nameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().setFullName(this.view.namePanel.fullNameField.getText());
        this.enrollmentService.getDemoPersonalDetails().setFullNameLocal(this.view.namePanel.locFullNameField.getText());
        this.updateNameFieldState();
    }

    private void newNameEdit(ItemEvent ie) {
        boolean edited = ie.getStateChange() == 1;
        Name name = this.enrollmentService.getDemoPersonalDetails().getName();
        name.setUpdated(edited);
        this.view.namePanel.newNameField.setEnabled(edited);
        this.view.namePanel.locNewNameField.setEnabled(edited);
        if (!edited) {
            this.view.namePanel.newNameField.setText("");
            this.view.namePanel.locNewNameField.setText("");
            name.setNewName("");
            name.setNewNameLocal("");
        }
    }

    private void newNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().setNewName(this.view.namePanel.newNameField.getText());
        this.enrollmentService.getDemoPersonalDetails().setNewNameLocal(this.view.namePanel.locNewNameField.getText());
        this.updateNewNameFieldState();
    }

    private void locNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        demoPersonalDetails.setFullNameLocal(this.view.namePanel.locFullNameField.getText());
        this.updateNameFieldState();
    }

    private void locNewNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        demoPersonalDetails.setNewNameLocal(this.view.namePanel.locNewNameField.getText());
        this.updateNewNameFieldState();
    }

    private void updateNameFieldState() {
        this.clearFieldError(this.view.namePanel.fullNameField);
        this.clearFieldError((JComponent)this.view.namePanel.locFullNameField);
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        Name name = demoPersonalDetails.getName();
        if (!name.isValid()) {
            this.showFieldError(this.view.namePanel.fullNameField, name.nameError());
            this.showFieldError((JComponent)this.view.namePanel.locFullNameField, name.nameLocalError());
            if (name.nameError() != null && name.nameError().equals(this.view.enrolRbctx.getMessage((Object)MsgKeysEnrol.NAME_TOOSHORT_WARNING, new Object[0]))) {
                this.showWarning(this.view.namePanel.fullNameField, name.nameError());
            }
        }
    }

    private void updateNewNameFieldState() {
        this.clearFieldError(this.view.namePanel.newNameField);
        this.clearFieldError((JComponent)this.view.namePanel.locNewNameField);
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        Name name = demoPersonalDetails.getName();
        if (!name.isValid()) {
            this.showFieldError(this.view.namePanel.newNameField, name.newNameError());
            this.showFieldError((JComponent)this.view.namePanel.locNewNameField, name.newNameLocalError());
            if (name.newNameError() != null && name.newNameError().equals(this.view.enrolRbctx.getMessage((Object)MsgKeysEnrol.NEWNAME_TOOSHORT_WARNING, new Object[0]))) {
                this.showWarning(this.view.namePanel.newNameField, name.newNameError());
            }
        }
    }

    private void aadhaarNoFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        String uid = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.view.aadhaarNoPanel.aadhaarNoField, (String)"000000000000");
        demoPersonalDetails.setAadhaarNumber(uid);
        this.updateAadhaarFieldState();
        if (this.enrollmentService.isOffLineDocumentUpdate()) {
            this.view.consentPanel.mandatoryBioCheckButton.setEnabled(false);
        } else if (!this.enrollmentService.isUniversalClientTrnx()) {
            this.performMandatoryBiometricCheck(false);
        }
    }

    private void performMandatoryBiometricCheck(boolean isButtonClickedManually) {
        if (!this.enrollmentService.getDemoPersonalDetails().getAadhaarNumber().isValid()) {
            return;
        }
        if (isButtonClickedManually && this.veCtxt != null) {
            this.veCtxt.reset();
            this.veCtxt.setMessage("Performing Mandatory Biometric Check. Please wait.");
        }
        JCheckBox mandatoryBioUpdateOption = this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption;
        JCheckBox childUpdateOption = this.view.updateTypeSelectionPanel.childUpdateOption;
        JButton checkButton = this.view.consentPanel.mandatoryBioCheckButton;
        String uid = this.enrollmentService.getDemoPersonalDetails().getAadhaarNumber().getAadhaarNumber();
        if (this.enrollmentService.isBiometricUpdateAllowed()) {
            mandatoryBioUpdateOption.setSelected(false);
        }
        new Thread(() -> {
            try {
                Id id1 = new Id();
                id1.setType("uid");
                id1.setValue(uid);
                Integer residentName = null;
                Integer dob = null;
                Integer gender = null;
                MandatoryBiometricCheckResponse response = this.enrollmentService.performMandatoryBiometricCheck("uid", uid);
                UidStatusCheckResponse statusCountResponse = this.enrollmentService.performMandatoryCountCheck(id1);
                Map updateCounts = statusCountResponse.getUpdateCounts();
                if (updateCounts != null) {
                    residentName = (Integer)updateCounts.get("residentName");
                    dob = (Integer)updateCounts.get("dob");
                    gender = (Integer)updateCounts.get("gender");
                } else {
                    LOGGER.info("updateCounts is null.");
                }
                String status = response.getStatus();
                LOGGER.info("MBU Response From the APi:-" + response.getStatus() + " .. " + response.getFreeUpdate() + " .. " + response.getErrorMessage());
                if (response.getFreeUpdate() == null && response.getStatus().equalsIgnoreCase("NA") || response.getStatus().equalsIgnoreCase("NO")) {
                    response.setFreeUpdate("No");
                }
                this.showPopupMessageForMBU(response.getMbu(), response.getFreeUpdate(), response.getBioCapture());
                this.showPopupMessageForNameGendeDobUpdate(residentName, dob, gender);
                if (StringUtils.isBlank((String)status)) {
                    if (isButtonClickedManually) {
                        this.showError(checkButton, "Mandatory biometric check failed due to server side error. Please retry.");
                    }
                    LOGGER.error("Mandatory biometric check failed due to server side error. " + response);
                    if (isButtonClickedManually && this.veCtxt != null) {
                        this.veCtxt.cancel();
                    }
                    return;
                }
                checkButton.setEnabled(false);
                if (status.equalsIgnoreCase("yes")) {
                    if (this.enrollmentService.isBiometricUpdateAllowed()) {
                        this.showInfo(checkButton, "This Aadhaar is due for mandatory biometric update");
                        mandatoryBioUpdateOption.setEnabled(true);
                        mandatoryBioUpdateOption.setSelected(true);
                        childUpdateOption.setEnabled(false);
                        childUpdateOption.setSelected(false);
                        this.view.updateTypeSelectionPanel.childUpdateOption.setSelected(false);
                    } else if (this.enrollmentService.getSessionService().isBiometricUpdateDisabledForStation()) {
                        this.showError(checkButton, "This Aadhaar is due for mandatory biometric update. Please request the resident/NRI to visit a nearby center where biometric update is possible.");
                    } else {
                        this.showError(checkButton, "This Aadhaar is due for mandatory biometric update. Please switch to offline update to perform mandatory biometric update.");
                    }
                } else {
                    this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.view.updateTypeSelectionPanel.mandatoryBioUpdateOption.setEnabled(false);
                checkButton.setEnabled(false);
                String message = "Mandatory biometric check failed due to network issue. ";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error(message, (Throwable)e);
                } else {
                    LOGGER.error(message + e.getMessage());
                }
                if (isButtonClickedManually) {
                    this.showError(checkButton, "Mandatory Biometric Check failed. Please check your internet connectivity and try again.");
                }
            }
            finally {
                if (isButtonClickedManually && this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
            }
        }).start();
    }

    private void showPopupMessageForMBU(String mbu, String freeUpdate, String bioCapture) {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Please consider the Mandatory Biometric Response for Resident. <br>");
        message.append("MBU: ").append(mbu).append("<br>");
        message.append("FreeUpdate: ").append(freeUpdate).append("<br>");
        message.append("BioCapture: ").append(bioCapture).append("<br>");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 1);
    }

    private void showPopupMessageForNameGendeDobUpdate(Integer residentName, Integer dob, Integer gender) {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Please consider the restrictions on updating Name, Gender, and Date of Birth (DOB). <br>");
        message.append("Residents can update their Name twice, but DOB and Gender can only be updated once. <br>");
        message.append("If the limit is exceeded, the packet may be rejected. <br>");
        message.append("In such cases, you may reach out to the Regional Office (RO) for guidance");
        message.append("<br>");
        message.append("<br>");
        message.append("Dear resident your Updated count for Name,Gender and DOB as follow <br>");
        message.append("Name: ").append(residentName).append("<br>");
        message.append("DOB: ").append(dob).append("<br>");
        message.append("Gender: ").append(gender).append("<br>");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar Message", 2);
    }

    private void updateGenderFieldState() {
        this.clearFieldError(this.view.genderPanel.genderField);
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        ApplicantGender applicantGender = demoPersonalDetails.getApplicantGender();
        if (!demoPersonalDetails.getApplicantGender().isValid()) {
            this.showFieldError(this.view.genderPanel.genderField, applicantGender.englishError());
        }
    }

    private void updateConfirmGenderFieldState() {
        this.clearFieldError(this.view.confirmGenderPanel.genderField);
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        ApplicantConfirmGender applicantConfirmGender = demoPersonalDetails.getApplicantConfirmGender();
        if (!demoPersonalDetails.getApplicantConfirmGender().isValid()) {
            this.showFieldError(this.view.confirmGenderPanel.genderField, applicantConfirmGender.englishError());
        }
    }

    private void onGenderChange(Object event) {
        String msg;
        Gender gender;
        PersonalDetail personalDetails = this.enrollmentService.getDemoPersonalDetails();
        ApplicantConfirmGender applicantConfirmGender = personalDetails.getApplicantConfirmGender();
        Gender gender2 = gender = this.view.genderPanel.genderField.getSelectedItem() instanceof Gender ? (Gender)this.view.genderPanel.genderField.getSelectedItem() : Gender.NOT_GIVEN;
        if (this.hasGenderChanged(personalDetails, gender)) {
            msg = String.format("You have selected %s as gender for resident", gender.toString().toUpperCase());
            this.showInfo(this.view.genderPanel.genderField.getRootPane(), msg);
        }
        if (this.isUpdateEnrollment && !gender.equals(this.view.confirmGenderPanel.genderField.getSelectedItem())) {
            msg = String.format("Please enter Confirm Gender", new Object[0]);
            this.showError(this.view.confirmGenderPanel.genderField.getRootPane(), msg);
            JComboBox<Object> genderField = this.view.confirmGenderPanel.genderField;
            applicantConfirmGender.setGender(Gender.NOT_GIVEN);
            applicantConfirmGender.setGenderLocal("");
            this.showFieldError(this.view.confirmGenderPanel.genderField, applicantConfirmGender.englishError());
            Gender displayGender = applicantConfirmGender.getDisplayGender();
            if (displayGender == Gender.NOT_GIVEN) {
                genderField.setSelectedIndex(0);
                genderField.setSelectedItem("");
                applicantConfirmGender.setGenderLocal("");
            }
            this.updateConfirmGenderFieldState();
        }
        this.view.genderPanel.locGenderField.setText(gender != Gender.NOT_GIVEN ? gender.toString() : "");
        if (personalDetails.getApplicantGender().isUpdated() || !this.isUpdateEnrollment) {
            personalDetails.setApplicantGender(gender.toShorthand());
            personalDetails.setGenderLocal(this.view.genderPanel.locGenderField.getText());
        }
        this.updateGenderFieldState();
        this.setPersonalDetail(personalDetails);
    }

    private void onConfirmGenderChange(Object event) {
        PersonalDetail personalDetails = this.getPersonalDetail();
        if (personalDetails != null) {
            String msg;
            Gender gender;
            ApplicantConfirmGender applicantConfirmGender = personalDetails.getApplicantConfirmGender();
            Gender gender2 = gender = this.view.confirmGenderPanel.genderField.getSelectedItem() instanceof Gender ? (Gender)this.view.confirmGenderPanel.genderField.getSelectedItem() : Gender.NOT_GIVEN;
            if (this.hasConfirmGenderChanged(personalDetails, gender)) {
                msg = String.format("You have selected %s as gender for resident", gender.toString().toUpperCase());
                this.showInfo(this.view.confirmGenderPanel.genderField.getRootPane(), msg);
            }
            if (this.isUpdateEnrollment && !gender.equals(this.view.genderPanel.genderField.getSelectedItem())) {
                msg = String.format("Both Gender and Confirm Gender should be same", new Object[0]);
                this.showError(this.view.confirmGenderPanel.genderField.getRootPane(), msg);
                JComboBox<Object> genderField = this.view.confirmGenderPanel.genderField;
                applicantConfirmGender.setGender(Gender.NOT_GIVEN);
                applicantConfirmGender.setGenderLocal("");
                gender = Gender.NOT_GIVEN;
                this.showFieldError(this.view.confirmGenderPanel.genderField, applicantConfirmGender.englishError());
                Gender displayGender = applicantConfirmGender.getDisplayGender();
                if (displayGender == Gender.NOT_GIVEN) {
                    genderField.setSelectedIndex(0);
                    genderField.setSelectedItem("");
                    applicantConfirmGender.setGenderLocal("");
                }
            }
            this.view.confirmGenderPanel.locGenderField.setText(gender != Gender.NOT_GIVEN ? gender.toString() : "");
            if (personalDetails != null) {
                if (personalDetails.getApplicantGender().isUpdated() || !this.isUpdateEnrollment) {
                    personalDetails.setApplicantGender(gender.toShorthand());
                    personalDetails.setGenderLocal(this.view.genderPanel.locGenderField.getText());
                }
                if (personalDetails.getApplicantConfirmGender().isUpdated() || !this.isUpdateEnrollment) {
                    personalDetails.setApplicantConfirmGender(gender.toShorthand());
                    personalDetails.setConfirmGenderLocal(this.view.confirmGenderPanel.locGenderField.getText());
                }
                this.updateConfirmGenderFieldState();
                this.updateGenderFieldState();
            }
        }
    }

    private boolean hasGenderChanged(PersonalDetail personalDetails, Gender gender) {
        return gender != Gender.NOT_GIVEN && gender != personalDetails.getApplicantGender().getGender() && gender != personalDetails.getApplicantGender().getExistingGender();
    }

    private boolean hasConfirmGenderChanged(PersonalDetail personalDetails, Gender gender) {
        return gender != Gender.NOT_GIVEN && gender != personalDetails.getApplicantConfirmGender().getGender() && gender != personalDetails.getApplicantConfirmGender().getExistingGender();
    }

    private void nprNumberFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        demoPersonalDetails.setNpr(this.view.nprPanel.nprField.getText());
        this.updateNprFieldState();
    }

    private void updateNprFieldState() {
        this.clearFieldError(this.view.nprPanel.nprField);
        PersonalDetail demoPersonalDetails = this.enrollmentService.getDemoPersonalDetails();
        if (!demoPersonalDetails.getNpr().isValid()) {
            this.showFieldError(this.view.nprPanel.nprField, demoPersonalDetails.getNpr().getNprError());
        }
    }

    private void ageDobOptChanged(JRadioButton opt) {
        if (!opt.isSelected()) {
            return;
        }
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().setDobSelected(this.view.ageDobPanel.dobOpt.isSelected());
        this.updateLocalAgeField();
    }

    private void updateLocalAgeField() {
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        if (!ageDob.isDobSelected()) {
            int age = ageDob.getAge();
            String locText = ageDob.isValid() ? age + " years" : "years";
            this.view.ageDobPanel.locAgeDobField.setText(locText);
        } else if (ageDob.isValid() && ageDob.isMandatory() && !ageDob.isEmpty()) {
            String locText = ageDob.getDayForDisplay() + "/" + ageDob.getMonthForDisplay() + "/" + ageDob.getYearForDisplay();
            this.view.ageDobPanel.locAgeDobField.setText(locText);
        } else if (!ageDob.isValid()) {
            this.view.ageDobPanel.locAgeDobField.setText("");
        }
        ageDob.setAgeDobLocal(this.view.ageDobPanel.locAgeDobField.getText());
    }

    private void updateLocalConfirmField() {
        if (this.isUpdateEnrollment) {
            ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
            if (confirmDob.isValid() && confirmDob.isMandatory() && !confirmDob.isEmpty()) {
                String locText = confirmDob.getDayForDisplay() + "/" + confirmDob.getMonthForDisplay() + "/" + confirmDob.getYearForDisplay();
                this.view.confirmDOBPanel.locConfirmDobField.setText(locText);
            } else if (!confirmDob.isValid()) {
                this.view.confirmDOBPanel.locConfirmDobField.setText("");
            }
            confirmDob.setAgeDobLocal(this.view.confirmDOBPanel.locConfirmDobField.getText());
        }
    }

    private void ageDobFocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
        if (ageDob.isDobSelected()) {
            String day = this.view.ageDobPanel.dobDayField.getText();
            String month = this.view.ageDobPanel.dobMonthField.getText();
            String year = this.view.ageDobPanel.dobYearField.getText();
            ageDob.setDob(day, month, year);
            if (this.isUpdateEnrollment) {
                if (!year.isEmpty()) {
                    String msg = String.format("Please enter Confirm Dob", new Object[0]);
                    this.showError(this.view.ageDobPanel.dobYearField.getRootPane(), msg);
                    if (!(ageDob.getDay().equals(confirmDob.getDay()) && ageDob.getMonth().equals(confirmDob.getMonth()) && ageDob.getYear().equals(confirmDob.getYear()))) {
                        confirmDob.setDob("", "", "");
                        this.view.confirmDOBPanel.setDobFields(confirmDob.getDayForDisplay(), confirmDob.getMonthForDisplay(), confirmDob.getYearForDisplay());
                        this.updateConfirmDobFieldState();
                    }
                }
            } else if (ageDob.getAgeGroup().equals((Object)AgeGroup.BELOW5)) {
                this.showDocUpdatePopMsg();
            }
        } else {
            ageDob.setAge(this.view.ageDobPanel.ageField.getText());
        }
        if (!ageDob.isValid()) {
            String ageError = ageDob.getAgeError();
            if (ageError != null && ageError.equals(this.view.enrolRbctx.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0]))) {
                this.showFieldError(this.view.ageDobPanel.ageField, ageError);
            } else if (ageError != null) {
                this.showWarning((JComponent)this.view.ageDobPanel.ageDobBox, ageError);
            }
        }
        if (ageDob.hasAgeWarning()) {
            this.showWarning((JComponent)this.view.ageDobPanel.ageDobBox, ageDob.getAgeWarning());
        }
        this.updateLocalAgeField();
        this.updateAgeDobFieldState();
    }

    private void showDocUpdatePopMsg() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Please select DOB as Verified.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "DOB VERIFIED", 1);
    }

    private void confirmDobFocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
        if (confirmDob.isDobSelected()) {
            String day = this.view.confirmDOBPanel.dobDayField.getText();
            String month = this.view.confirmDOBPanel.dobMonthField.getText();
            String year = this.view.confirmDOBPanel.dobYearField.getText();
            confirmDob.setDob(day, month, year);
            if (!(year.isEmpty() || ageDob.getDay().equals(confirmDob.getDay()) && ageDob.getMonth().equals(confirmDob.getMonth()) && ageDob.getYear().equals(confirmDob.getYear()))) {
                String msg = String.format("Confirm Dob should match with Dob", new Object[0]);
                this.showError(this.view.confirmDOBPanel.dobYearField.getRootPane(), msg);
                confirmDob.setDob("", "", "");
                this.view.confirmDOBPanel.setDobFields(confirmDob.getDayForDisplay(), confirmDob.getMonthForDisplay(), confirmDob.getYearForDisplay());
            }
        }
        this.updateLocalConfirmField();
        this.updateConfirmDobFieldState();
    }

    private void onAgeDobValidityChange(boolean valid) {
        this.updateAgeDobFieldState();
    }

    private void onConfirmDobValidityChange(boolean valid) {
        this.updateConfirmDobFieldState();
    }

    private void updateAgeDobFieldState() {
        this.clearFieldError(this.view.ageDobPanel.dobDayField);
        this.clearFieldError(this.view.ageDobPanel.dobMonthField);
        this.clearFieldError(this.view.ageDobPanel.dobYearField);
        this.clearFieldError(this.view.ageDobPanel.ageField);
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        if (!ageDob.isValid()) {
            if (ageDob.isDobSelected()) {
                this.showFieldError(this.view.ageDobPanel.dobDayField, ageDob.getDayError());
                this.showFieldError(this.view.ageDobPanel.dobMonthField, ageDob.getMonthError());
                this.showFieldError(this.view.ageDobPanel.dobYearField, ageDob.getYearError());
            } else {
                this.showFieldError(this.view.ageDobPanel.ageField, ageDob.getAgeError());
            }
        }
    }

    private void updateConfirmDobFieldState() {
        this.clearFieldError(this.view.confirmDOBPanel.dobDayField);
        this.clearFieldError(this.view.confirmDOBPanel.dobMonthField);
        this.clearFieldError(this.view.confirmDOBPanel.dobYearField);
        ConfirmDob confirmDob = this.enrollmentService.getDemoPersonalDetails().getConfirmDob();
        if (!confirmDob.isValid() && confirmDob.isDobSelected()) {
            this.showFieldError(this.view.confirmDOBPanel.dobDayField, confirmDob.getDayError());
            this.showFieldError(this.view.confirmDOBPanel.dobMonthField, confirmDob.getMonthError());
            this.showFieldError(this.view.confirmDOBPanel.dobYearField, confirmDob.getYearError());
        }
    }

    private void ageVerifiedChanged(ChangeEvent changeEvent) {
        boolean verified = this.view.ageDobPanel.verifiedOptField.isSelected();
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().setVerified(verified);
    }

    private void setAddressType() {
        DropDownItem addressTypeList = (DropDownItem)this.view.contactHeaderPanel.tplList.getSelectedValue();
        if (addressTypeList != null) {
            Address address = this.enrollmentService.getDemoContactDetails().getAddress();
            address.setAddressType(addressTypeList.getKey());
        }
    }

    private void careOfNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        address.setCareOfName(this.view.careOfPanel.careOfField.getText());
        address.setCareOfNameLocal(this.view.careOfPanel.locCareOfField.getText());
        this.updateAddressFieldState();
    }

    private void careOfNameLocFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        address.setCareOfNameLocal(this.view.careOfPanel.locCareOfField.getText());
        this.updateAddressFieldState();
    }

    private void updateCareOfNameFieldState() {
        this.clearFieldError(this.view.careOfPanel.careOfField);
        this.clearFieldError((JComponent)this.view.careOfPanel.locCareOfField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        if (!address.isValid()) {
            this.showFieldError(this.view.careOfPanel.careOfField, address.getCareOfNameError());
            this.showFieldError((JComponent)this.view.careOfPanel.locCareOfField, address.getCareOfNameLocalError());
        }
    }

    private void houseFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String houseBuilding = addressComposite.houseField.getText();
        contact.getAddress().setBuilding(houseBuilding);
        contact.getAddress().setBuildingLocal(addressComposite.locHouseField.getText());
        this.updateAddressFieldState();
    }

    private void locHouseFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setBuildingLocal(addressComposite.locHouseField.getText());
        this.updateAddressFieldState();
    }

    private void updateHouseFieldState() {
        Contact contact = this.enrollmentService.getDemoContactDetails();
        this.clearFieldError(this.view.addressPanel.houseField);
        this.clearFieldError((JComponent)this.view.addressPanel.locHouseField);
        this.showFieldError(this.view.addressPanel.houseField, contact.getAddress().getBuildingError());
        this.showFieldError((JComponent)this.view.addressPanel.locHouseField, contact.getAddress().getBuildingLocalError());
    }

    private void streetFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String street = addressComposite.streetField.getText();
        contact.getAddress().setStreet(street);
        contact.getAddress().setStreetLocal(addressComposite.locStreetField.getText());
        this.updateAddressFieldState();
    }

    private void streetLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setStreetLocal(addressComposite.locStreetField.getText());
        this.updateAddressFieldState();
    }

    private void updateStreetFieldState() {
        this.clearFieldError(this.view.addressPanel.streetField);
        this.clearFieldError((JComponent)this.view.addressPanel.locStreetField);
        Contact contact = this.enrollmentService.getDemoContactDetails();
        this.showFieldError(this.view.addressPanel.streetField, contact.getAddress().getStreetError());
        this.showFieldError((JComponent)this.view.addressPanel.locStreetField, contact.getAddress().getStreetLocalError());
    }

    private void landmarkFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String landmark = addressComposite.landmarkField.getText();
        contact.getAddress().setLandmark(landmark);
        contact.getAddress().setLandmarkLocal(addressComposite.locLandmarkField.getText());
        this.updateAddressFieldState();
    }

    private void landmarkLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String landmarkLocal = addressComposite.locLandmarkField.getText();
        contact.getAddress().setLandmarkLocal(landmarkLocal);
        this.updateAddressFieldState();
    }

    private void updateLandmarkFieldState() {
        this.clearFieldError(this.view.addressPanel.landmarkField);
        this.clearFieldError((JComponent)this.view.addressPanel.locLandmarkField);
        Contact contact = this.enrollmentService.getDemoContactDetails();
        this.showFieldError(this.view.addressPanel.landmarkField, contact.getAddress().getLandmarkError());
        this.showFieldError((JComponent)this.view.addressPanel.locLandmarkField, contact.getAddress().getLandmarkLocalError());
    }

    private void localityFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        String areaLocality = addressComposite.localityField.getText();
        contact.getAddress().setLocality(areaLocality);
        contact.getAddress().setLocalityLocal(addressComposite.locLocalityField.getText());
        this.updateAddressFieldState();
    }

    private void localityLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setLocalityLocal(addressComposite.locLocalityField.getText());
        this.updateAddressFieldState();
    }

    private void updateLocalityFieldState() {
        super.clearFieldError(this.view.addressPanel.localityField);
        super.clearFieldError((JComponent)this.view.addressPanel.locLocalityField);
        Contact contact = this.enrollmentService.getDemoContactDetails();
        super.showFieldError(this.view.addressPanel.localityField, contact.getAddress().getLocalityError());
        super.showFieldError((JComponent)this.view.addressPanel.locLocalityField, contact.getAddress().getLocalityLocalError());
    }

    private synchronized void onPOCodeLoaded(Object o) {
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        if (addressComposite.postOffField.getSelectedOption() instanceof PostOffice) {
            PostOffice postOffice = (PostOffice)addressComposite.postOffField.getSelectedOption();
            postOffice.setLocaleName(addressComposite.locPostOffField.getText());
            contact.getAddress().setPostOffice(postOffice);
            contact.getAddress().setPostOfficeLocal(postOffice.getLocaleName());
            List<Object> poListOptions = addressComposite.postOffField.getOptions();
            long poListCount = poListOptions.size();
            contact.getAddress().setDefaultPo(poListCount == 1L ? ((PostOffice)poListOptions.get(0)).getName() : ((PostOffice)poListOptions.get(1)).getName());
        } else {
            contact.getAddress().setPostOffice(null);
            contact.getAddress().setPinCodeLocal(null);
        }
        this.updateAddressFieldState();
    }

    private void postOfficeLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setPostOfficeLocal(addressComposite.locPostOffField.getText());
        this.updatePostOfficeLocalFieldState();
    }

    private void updatePostOfficeLocalFieldState() {
        super.clearFieldError(this.view.addressPanel.postOffField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        super.showFieldError(this.view.addressPanel.postOffField, address.getPostOfficeLocalError());
    }

    private synchronized void onPinCodeLoaded(Object o) {
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        if (addressComposite.sPinCodeField.getSelectedOption() instanceof PostalAddress) {
            PostalAddress postalAddress = (PostalAddress)addressComposite.sPinCodeField.getSelectedOption();
            if (addressComposite.postOffField.getSelectedOption() instanceof PostOffice) {
                PostOffice postOffice = (PostOffice)addressComposite.postOffField.getSelectedOption();
                postOffice.setLocaleName(addressComposite.locPostOffField.getText());
                contact.getAddress().setPostOffice(postOffice);
                List<Object> poListOptions = addressComposite.postOffField.getOptions();
                long poListCount = poListOptions.size();
                contact.getAddress().setDefaultPo(poListCount == 1L ? ((PostOffice)poListOptions.get(0)).getName() : ((PostOffice)poListOptions.get(1)).getName());
                contact.getAddress().setPostalAddress(postalAddress);
                contact.getAddress().setPinCodeLocal(postalAddress.getPincode());
                contact.getAddress().setStateLocal(addressComposite.locStateField.getText());
                contact.getAddress().setDistrictLocal(addressComposite.locDistrictField.getText());
                contact.getAddress().setSubDistrictLocal(addressComposite.locSubDistField.getText());
                contact.getAddress().setVTCLocal(addressComposite.locVtcField.getText());
            }
        } else {
            contact.getAddress().setPostOffice(null);
            contact.getAddress().setPostalAddress(null);
            contact.getAddress().setPinCodeLocal("");
            contact.getAddress().setStateLocal("");
            contact.getAddress().setDistrictLocal("");
            contact.getAddress().setSubDistrictLocal("");
            contact.getAddress().setVTCLocal("");
        }
        this.updateAddressFieldState();
    }

    private void stateLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setStateLocal(addressComposite.locStateField.getText());
        this.updateAddressFieldState();
    }

    private void updateStateLocalFieldState() {
        super.clearFieldError((JComponent)this.view.addressPanel.locStateField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        super.showFieldError((JComponent)this.view.addressPanel.locStateField, address.getStateLocalError());
    }

    private void subDistrictLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setSubDistrictLocal(addressComposite.locSubDistField.getText());
        this.updateAddressFieldState();
    }

    private void updateDistrictLocalFieldState() {
        super.clearFieldError((JComponent)this.view.addressPanel.locDistrictField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        this.showFieldError((JComponent)this.view.addressPanel.locDistrictField, address.getDistrictLocalError());
    }

    private void districtLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setDistrictLocal(addressComposite.locDistrictField.getText());
        this.updateAddressFieldState();
    }

    private void updateSubDistrictFieldLocalState() {
        super.clearFieldError((JComponent)this.view.addressPanel.locSubDistField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        super.showFieldError((JComponent)this.view.addressPanel.locSubDistField, address.getSubDistrictLocalError());
    }

    private void vtcLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        AddressPanel addressComposite = this.view.addressPanel;
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.getAddress().setVTCLocal(addressComposite.locVtcField.getText());
        this.updateAddressFieldState();
    }

    private void updateVTCLocalFieldState() {
        super.clearFieldError((JComponent)this.view.addressPanel.locVtcField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        super.showFieldError((JComponent)this.view.addressPanel.locVtcField, address.getVTCLocalError());
    }

    private void mobileFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        mobile.setNumber(MobilePanel.mobileField.getText());
        MobilePanel cfr_ignored_1 = this.view.mobilePanel;
        Object isd = MobilePanel.isdCodeComboBox.getSelectedItem();
        if (isd instanceof ISD) {
            mobile.setIsdCode(((ISD)isd).getISDCode());
        }
        if (this.enrollmentService.isUpdateUC()) {
            mobile.setMobileVerified(false);
            this.updateMobileFieldStateUC();
        } else {
            this.updateMobileFieldState();
        }
    }

    private void onIsdCodeChange(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        MobilePanel.mobileField.setText("");
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        mobile.setNumber("");
        MobilePanel cfr_ignored_1 = this.view.mobilePanel;
        Object isd = MobilePanel.isdCodeComboBox.getSelectedItem();
        if (isd instanceof ISD) {
            mobile.setIsdCode(((ISD)isd).getISDCode());
        }
        if (this.enrollmentService.isOnlineUpdate()) {
            this.updateMobileFieldStateUC();
        } else {
            this.updateMobileFieldState();
        }
    }

    private void updateMobileFieldStateNext() {
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        this.clearFieldError(MobilePanel.mobileField);
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        if (!mobile.isValid()) {
            MobilePanel cfr_ignored_1 = this.view.mobilePanel;
            super.showFieldError(MobilePanel.mobileField, mobile.numberError());
        }
    }

    private void updateMobileFieldState() {
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        this.clearFieldError(MobilePanel.mobileField);
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        if (!mobile.isValid()) {
            MobilePanel cfr_ignored_1 = this.view.mobilePanel;
            super.showFieldError(MobilePanel.mobileField, mobile.numberError());
        }
    }

    private void updateMobileFieldStateUC() {
        MobilePanel cfr_ignored_0 = this.view.mobilePanel;
        this.clearFieldError(MobilePanel.mobileField);
        Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
        if (!mobile.isValid()) {
            MobilePanel cfr_ignored_1 = this.view.mobilePanel;
            super.showFieldError(MobilePanel.mobileField, mobile.numberError());
        } else {
            MobilePanel cfr_ignored_2 = this.view.mobilePanel;
            MobilePanel.verifyMobileBtn.setEnabled(true);
        }
    }

    private void emailFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getDemoContactDetails().getEmail().setEmail(this.view.emailPanel.emailField.getText());
        this.updateEmailFieldState();
    }

    private void updateEmailFieldState() {
        super.clearFieldError(this.view.emailPanel.emailField);
        Email email = this.enrollmentService.getDemoContactDetails().getEmail();
        if (!email.isValid()) {
            super.showFieldError(this.view.emailPanel.emailField, email.getEmailError());
        }
    }

    @Override
    public void onNextButtonClick(ActionEvent e) {
        this.updateFieldState();
        if (!super.showTransliterationDiffWarning(this.view.enrolRbctx.getMessage((Object)LabelAndMsgKeys.MSG_TITLE, new Object[0]), this.view.addressPanel.houseField)) {
            return;
        }
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        Contact contact = demographics.getContact();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            if (!this.enrollmentService.isNewEnrollmentUC()) {
                if (this.enrollmentService.isDemoUpdate()) {
                    if (!personalDetail.isValid() || !contact.isValid()) {
                        this.showWarningUC(String.format("Please fill the missing field(s).", new Object[0]), this.view.addressPanel.houseField);
                    } else {
                        Utils.showProgressBar(this.veCtxt, "Uploading demographics data");
                        ThreadPool.commonPool().submit(() -> {
                            try {
                                this.saveDemographicsToBackend();
                                Utils.cancelProgressBar(this.veCtxt);
                                this.renderNextTab();
                                super.onNextButtonClick(e);
                            }
                            catch (OnlineGatewayException ex) {
                                LOGGER.error("Error occurred while uploading demographic data to server", (Throwable)ex);
                                Utils.cancelProgressBar(this.veCtxt);
                                if (ex.getMessage() != null && ex.getMessage().contains("New Mobile number")) {
                                    this.showErrorUC((JComponent)e.getSource(), ex.getMessage(), ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), ". Please retry by clicking on the 'Verify' button");
                                }
                                this.showErrorUC((JComponent)e.getSource(), ex.getMessage(), ex.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), ". Please retry by clicking on the 'Next' button");
                            }
                        });
                    }
                } else {
                    this.renderNextTab();
                    super.onNextButtonClick(e);
                }
            }
        } else {
            super.onNextButtonClick(e);
        }
    }

    private void renderNextTab() {
        if (!this.isReviewTabRendered) {
            this.view.reviewTab.renderReviewTab();
            this.isReviewTabRendered = true;
        }
    }

    private void saveDemographicsToBackend() throws OnlineGatewayException {
        if (this.enrollmentService.isDemoUpdate()) {
            UpdateDemographicsRequest updateDemoRequest = this.createUpdateDemoRequest();
            this.enrollmentService.getOauthGwApiService().updateDemographics(updateDemoRequest);
        }
    }

    private UpdateDemographicsRequest createUpdateDemoRequest() {
        UpdateDemographicsRequest.Builder builder = UpdateDemographicsRequest.Builder.anUpdateDemographicsRequest();
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        Contact contact = demographics.getContact();
        Address address = contact.getAddress();
        if (fieldsUpdateCount.getName().hasToBeUpdated() && personalDetail.getName().isUpdated()) {
            builder.name(personalDetail.getName().newEnglish()).localName(personalDetail.getName().newNameLocal());
        }
        if (fieldsUpdateCount.getAddress().hasToBeUpdated() && address.isUpdated()) {
            Address.Builder addressBuilder = Address.Builder.anAddress();
            addressBuilder.careof(StringUtils.isNotBlank((String)address.getCareOfName()) ? String.format("%s: %s", address.getCareOf(), address.getCareOfName()) : "").house(address.getBuilding()).street(address.getStreet()).landmark(address.getLandmark()).locality(address.getLocality()).vtc(address.getVTC()).villageCode(address.getVTCCode()).district(address.getDistrict()).districtCode(address.getDistrictCode()).state(address.getState()).stateCode(address.getStateCode()).pincode(address.getPinCodeValue()).po(address.isMandatory() ? address.getPoName() : null).localCo(StringUtils.isNotBlank((String)address.getCareOfName()) ? String.format("%s: %s", address.getCareOfLocal(), address.getCareOfNameLocal()) : "").localHouse(address.getBuildingLocal()).localStreet(address.getStreetLocal()).localLandmark(address.getLandmarkLocal()).localLocality(address.getLocalityLocal()).localVtc(address.getVTCLocal()).localDistrict(address.getDistrictLocal()).localState(address.getStateLocal()).localPo(address.getPoNameLocal()).languageCode(this.enrollmentService.getEnrollmentLangCode());
            builder.address(addressBuilder.build());
        }
        if (fieldsUpdateCount.getGender().hasToBeUpdated() && personalDetail.getApplicantGender().isUpdated()) {
            builder.gender(personalDetail.getApplicantGender().getGender().toShorthand());
        }
        if (fieldsUpdateCount.getDob().hasToBeUpdated() && personalDetail.getAgeDob().isUpdated()) {
            builder.dob(personalDetail.getAgeDob().getAgeDobFormattedUC());
        }
        if (fieldsUpdateCount.getMobile().hasToBeUpdated()) {
            Mobile.Builder mobileBuilder = Mobile.Builder.aMobile();
            mobileBuilder.mobileNumber(contact.getMobile().number()).isdCode(contact.getMobile().isdCode()).validated(contact.getMobile().isMobileVerified());
            builder.mobile(mobileBuilder.build());
        }
        if (fieldsUpdateCount.getEmail().hasToBeUpdated()) {
            Email.Builder emailBuilder = Email.Builder.anEmail();
            emailBuilder.emailUpdated(contact.getEmail().email()).validated(false);
            builder.email(emailBuilder.build());
        }
        builder.languageCode(Integer.parseInt(this.enrollmentService.getEnrollmentLangCode())).isChild(Boolean.toString(personalDetail.getAgeDob().isChild())).sid(this.enrollmentService.getSid());
        return builder.build();
    }

    private void updateAddressFieldState() {
        this.updateCareOfNameFieldState();
        this.updateHouseFieldState();
        this.updateStreetFieldState();
        this.updateLandmarkFieldState();
        this.updateLocalityFieldState();
        this.updateVTCLocalFieldState();
        this.updateDistrictLocalFieldState();
        this.updateSubDistrictFieldLocalState();
        this.updateStateLocalFieldState();
        this.updatePOCodeFieldState();
        this.updatePincodeFieldState();
    }

    private void updateFieldState() {
        if (this.isUpdateEnrollment) {
            this.updateAadhaarFieldState();
        }
        this.updateNameFieldState();
        this.updateNprFieldState();
        this.updateNewNameFieldState();
        this.updateGenderFieldState();
        this.updateConfirmGenderFieldState();
        this.updateAgeDobFieldState();
        this.updateConfirmDobFieldState();
        this.updateAddressFieldState();
        this.updateMobileFieldStateNext();
        this.updateEmailFieldState();
    }

    private void updateAadhaarFieldState() {
        this.clearFieldError(this.view.aadhaarNoPanel.aadhaarNoField);
        SwingUtilities.invokeLater(() -> this.showFieldError(this.view.aadhaarNoPanel.aadhaarNoField, this.enrollmentService.getDemoPersonalDetails().getAadhaarNumber().getAadhaarNumberError()));
    }

    private void updatePincodeFieldState() {
        super.clearFieldError(this.view.addressPanel.sPinCodeField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        super.showFieldError(this.view.addressPanel.sPinCodeField, address.getPinCodeDetail().getPinCode().getAddressValueError());
    }

    private void updatePOCodeFieldState() {
        super.clearFieldError(this.view.addressPanel.postOffField);
        super.clearFieldError((JComponent)this.view.addressPanel.locPostOffField);
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        String error = (String)ObjectUtils.defaultIfNull((Object)address.getPostOfficeError(), (Object)address.getDefaultPostOfficeError());
        String localError = (String)ObjectUtils.defaultIfNull((Object)address.getPostOfficeLocalError(), (Object)address.getDefaultPostOfficeLocalError());
        super.showFieldError(this.view.addressPanel.postOffField, error);
        super.showFieldError((JComponent)this.view.addressPanel.locPostOffField, localError);
    }

    public PersonalDetail getPersonalDetail() {
        return this.personalDetail;
    }

    public void setPersonalDetail(PersonalDetail personalDetail) {
        this.personalDetail = personalDetail;
    }
}

