/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrol.dynaddr.IDynaddrTemplateManager;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Demographics;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.swing.FixedWidthTopDownTile;
import in.gov.uidai.ec.swing.shared.HeaderPanel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.demographics.AadhaarNoPanel;
import in.gov.uidai.ec.ui.enrol.demographics.AddressPanel;
import in.gov.uidai.ec.ui.enrol.demographics.AgeDobPanel;
import in.gov.uidai.ec.ui.enrol.demographics.AppointmentPanel;
import in.gov.uidai.ec.ui.enrol.demographics.CareOfPanel;
import in.gov.uidai.ec.ui.enrol.demographics.ConfirmDOBPanel;
import in.gov.uidai.ec.ui.enrol.demographics.ConfirmGenderPanel;
import in.gov.uidai.ec.ui.enrol.demographics.ConsentPanel;
import in.gov.uidai.ec.ui.enrol.demographics.ContactHeaderPanel;
import in.gov.uidai.ec.ui.enrol.demographics.DemographicsController;
import in.gov.uidai.ec.ui.enrol.demographics.EmailPanel;
import in.gov.uidai.ec.ui.enrol.demographics.GenderPanel;
import in.gov.uidai.ec.ui.enrol.demographics.MobilePanel;
import in.gov.uidai.ec.ui.enrol.demographics.NamePanel;
import in.gov.uidai.ec.ui.enrol.demographics.NprPanel;
import in.gov.uidai.ec.ui.enrol.demographics.ResidentTypePanel;
import in.gov.uidai.ec.ui.enrol.demographics.UpdateTypeSelectionPanel;
import in.gov.uidai.ec.ui.enrol.fingerprint.FingerPrintTabViewPeer;
import in.gov.uidai.ec.ui.enrol.iris.IrisTabViewPeer;
import in.gov.uidai.ec.ui.enrol.photograph.PhotographTabViewPeer;
import in.gov.uidai.ec.ui.enrol.references.ReferenceTabViewPeer;
import in.gov.uidai.ec.ui.enrol.review.ReviewTabViewPeer;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class DemographicsTabViewPeer
implements IViewElementComposite {
    protected final ILiteView liteView;
    private final IDynaddrTemplateManager addressTemplateManager;
    private final boolean isUpdateEnrollment;
    protected EnrollmentService enrollmentService;
    protected IResourceBundleContext enrolRbctx;
    protected IEventContext evtCtxt;
    protected IUIPreference uiPref;
    protected GenderPanel genderPanel;
    protected ConfirmGenderPanel confirmGenderPanel;
    protected AgeDobPanel ageDobPanel;
    protected ConfirmDOBPanel confirmDOBPanel;
    protected NprPanel nprPanel;
    protected ResidentTypePanel residentTypePanel;
    protected NamePanel namePanel;
    protected CareOfPanel careOfPanel;
    protected MobilePanel mobilePanel;
    protected AppointmentPanel appointmentPanel;
    protected AddressPanel addressPanel;
    protected EmailPanel emailPanel;
    protected ConsentPanel consentPanel;
    protected AadhaarNoPanel aadhaarNoPanel;
    protected UpdateTypeSelectionPanel updateTypeSelectionPanel;
    protected ContactHeaderPanel contactHeaderPanel;
    private JComponent demoPanel;
    protected PhotographTabViewPeer photoTab;
    protected FingerPrintTabViewPeer fingerTab;
    protected IrisTabViewPeer irisTab;
    protected ReviewTabViewPeer reviewTab;
    protected JTabbedPane tabbedPane;
    protected ReferenceTabViewPeer refTab;
    private int tabIndex;
    private IEventContext eventContext;

    public DemographicsTabViewPeer(EnrolViewPeer enrolViewPeer, IEventContext eventContext) {
        this.refTab = enrolViewPeer.getRefTab();
        this.reviewTab = enrolViewPeer.getReviewTab();
        this.photoTab = enrolViewPeer.getPhotoTab();
        this.fingerTab = enrolViewPeer.getFingerTab();
        this.irisTab = enrolViewPeer.getIrisTab();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.eventContext = eventContext;
        this.liteView = enrolViewPeer.getView();
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.enrolRbctx = enrolViewPeer.enrolRbCtxt;
        this.evtCtxt = enrolViewPeer.evtCtxt;
        this.uiPref = enrolViewPeer.uiPref;
        this.addressTemplateManager = enrolViewPeer.daTplMgr;
        this.isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
    }

    public void prepare() {
        this.residentTypePanel = new ResidentTypePanel(this.enrolRbctx);
        this.appointmentPanel = new AppointmentPanel(this.enrolRbctx);
        this.namePanel = new NamePanel(this.enrolRbctx, this.uiPref);
        this.aadhaarNoPanel = new AadhaarNoPanel(this.enrolRbctx);
        this.consentPanel = new ConsentPanel(this.enrolRbctx, this.uiPref, this.evtCtxt);
        this.updateTypeSelectionPanel = new UpdateTypeSelectionPanel(this.enrolRbctx);
        this.genderPanel = new GenderPanel(this.enrolRbctx);
        this.confirmGenderPanel = new ConfirmGenderPanel(this.enrolRbctx);
        this.ageDobPanel = new AgeDobPanel(this.enrolRbctx, this.uiPref);
        this.confirmDOBPanel = new ConfirmDOBPanel(this.enrolRbctx, this.uiPref);
        this.nprPanel = new NprPanel(this.enrolRbctx, this.enrollmentService);
        HeaderPanel headerPanel = null;
        this.addressPanel = this.enrollmentService.isDemoUpdate() ? new AddressPanel(this.enrolRbctx, this.evtCtxt, this.uiPref, this.enrollmentService.isOnlineUpdate(), this.enrollmentService) : new AddressPanel(this.enrolRbctx, this.evtCtxt, this.uiPref, this.enrollmentService);
        this.careOfPanel = new CareOfPanel(this.enrolRbctx, this.uiPref);
        JComponent careOfPanel = this.enrollmentService.isDemoUpdate() ? this.careOfPanel.create(true, !this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.getFieldsUpdateCount().getAddress().hasToBeUpdated(), this.enrollmentService) : this.careOfPanel.create(this.enrollmentService);
        this.contactHeaderPanel = this.enrollmentService.isDemoUpdate() ? new ContactHeaderPanel(this.enrolRbctx, this.evtCtxt, this.addressTemplateManager, this.addressPanel, this.uiPref, this.careOfPanel, this.enrollmentService.isDemoUpdate()) : new ContactHeaderPanel(this.enrolRbctx, this.evtCtxt, this.addressTemplateManager, this.addressPanel, this.uiPref, this.careOfPanel);
        this.mobilePanel = new MobilePanel(this.enrolRbctx, this.enrollmentService);
        this.emailPanel = new EmailPanel(this.enrolRbctx, this.enrollmentService);
        headerPanel = this.enrollmentService.isDemoUpdate() ? new HeaderPanel(this.enrolRbctx, this.uiPref, this.enrollmentService.isDemoUpdate()) : new HeaderPanel(this.enrolRbctx, this.uiPref);
        FixedWidthTopDownTile mainTile = new FixedWidthTopDownTile();
        mainTile.setWidth(1000);
        mainTile.setScrollable(true);
        mainTile.setPadding(5, 0, 5, 0);
        mainTile.prepare();
        if (!this.enrollmentService.isNewEnrollmentUC()) {
            mainTile.addTopComponent(Box.createVerticalStrut(10));
            mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.RESIDENT_DETAILS.toString()));
            mainTile.addTopComponent(this.residentTypePanel.create(this.enrollmentService.isDemoUpdate()));
        }
        mainTile.addTopComponent(Box.createVerticalStrut(10));
        mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.APPOINTMENT.toString()));
        mainTile.addTopComponent(this.appointmentPanel.create(this.enrollmentService.isDemoUpdate()));
        mainTile.addTopComponent(Box.createVerticalStrut(10));
        mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.PERSONAL.toString()));
        mainTile.addTopComponent(this.namePanel.create(this.enrollmentService.isDemoUpdate(), this.enrollmentService));
        if (!this.isUpdateEnrollment) {
            mainTile.addTopComponent(this.genderPanel.create(this.enrollmentService.isNewEnrollmentUC()));
            if (this.enrollmentService.isNewEnrollmentUC()) {
                mainTile.addTopComponent(this.confirmGenderPanel.create(this.enrollmentService.isNewEnrollmentUC()));
            }
            if (this.enrollmentService.isDemoUpdate()) {
                mainTile.addTopComponent(this.ageDobPanel.create(false, this.enrollmentService));
            } else {
                mainTile.addTopComponent(this.ageDobPanel.create(false));
            }
            if (this.enrollmentService.isDemoUpdate() && this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isDobSelected()) {
                mainTile.addTopComponent(this.confirmDOBPanel.create(this.enrollmentService));
            }
            mainTile.addTopComponent(this.nprPanel.create());
        } else {
            if (this.enrollmentService.isDemoUpdate()) {
                mainTile.addTopComponent(this.aadhaarNoPanel.create(this.enrollmentService.isOnlineUpdate()));
            } else {
                mainTile.addTopComponent(this.aadhaarNoPanel.create());
            }
            mainTile.addTopComponent(this.nprPanel.create());
            if (this.enrollmentService.isDemoUpdate()) {
                mainTile.addTopComponent(this.namePanel.createNewName(true, this.enrollmentService.getFieldsUpdateCount().getName().hasToBeUpdated(), this.enrollmentService));
            } else {
                mainTile.addTopComponent(this.namePanel.createNewName(this.enrollmentService));
            }
            mainTile.addTopComponent(this.updateTypeSelectionPanel.create());
            if (this.enrollmentService.isDemoUpdate()) {
                mainTile.addTopComponent(this.genderPanel.createEditView(true, this.enrollmentService.getFieldsUpdateCount().getGender().hasToBeUpdated()));
                mainTile.addTopComponent(this.confirmGenderPanel.createEditView(true, this.enrollmentService.getFieldsUpdateCount().getGender().hasToBeUpdated()));
            } else {
                mainTile.addTopComponent(this.genderPanel.createEditView(false, false));
                mainTile.addTopComponent(this.confirmGenderPanel.createEditView(false, false));
            }
            if (this.enrollmentService.isDemoUpdate()) {
                mainTile.addTopComponent(this.ageDobPanel.create(true, this.enrollmentService));
            } else {
                mainTile.addTopComponent(this.ageDobPanel.create(true));
            }
            if (this.enrollmentService.isDemoUpdate()) {
                mainTile.addTopComponent(this.confirmDOBPanel.create(this.enrollmentService));
            } else {
                mainTile.addTopComponent(this.confirmDOBPanel.create());
            }
            this.namePanel.fullNameField.setEnabled(this.enrollmentService.isNameFieldEnable());
            this.namePanel.locFullNameField.setEnabled(this.enrollmentService.isNameFieldEnable());
            this.aadhaarNoPanel.aadhaarNoField.setEnabled(this.enrollmentService.isAadhaarFieldEnable());
        }
        mainTile.addTopComponent(Box.createVerticalStrut(10));
        if (!this.isUpdateEnrollment) {
            mainTile.addTopComponent(this.contactHeaderPanel.createWithCopyPreviousButton());
        } else if (this.enrollmentService.isDemoUpdate()) {
            mainTile.addTopComponent(this.contactHeaderPanel.createEditButtonView(this.enrollmentService.isOnlineUpdate()));
        } else {
            mainTile.addTopComponent(this.contactHeaderPanel.createEditButtonView());
        }
        mainTile.addTopComponent(careOfPanel);
        mainTile.addTopComponent(this.addressPanel.toSwing());
        mainTile.addTopComponent(Box.createVerticalStrut(10));
        mainTile.addTopComponent(headerPanel.createDivider());
        mainTile.addTopComponent(this.mobilePanel.create(this.isUpdateEnrollment));
        mainTile.addTopComponent(this.emailPanel.create(this.isUpdateEnrollment));
        mainTile.setBottomComponent(this.consentPanel.create(this.isUpdateEnrollment));
        this.demoPanel = mainTile.toSwing();
        if (this.isUpdateEnrollment) {
            this.addTraversalUE();
        } else {
            this.addTraversal();
        }
        new DemographicsController(this, this.eventContext, this.tabIndex);
    }

    public JComponent toSwing() {
        return this.demoPanel;
    }

    private void addTraversal() {
        ExplicitFocusTraversalPolicy eftp = new ExplicitFocusTraversalPolicy((Container)this.demoPanel).addComponent((Component)this.namePanel.fullNameField).addComponent((Component)this.namePanel.locFullNameField).addComponent(this.genderPanel.genderField).addComponent(this.confirmGenderPanel.genderField);
        this.ageDobPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent((Component)this.nprPanel.nprField).addComponent((Component)this.careOfPanel.careOfField).addComponent((Component)this.careOfPanel.locCareOfField);
        this.addressPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent(MobilePanel.isdCodeComboBox).addComponent((Component)MobilePanel.mobileField).addComponent((Component)this.emailPanel.emailField).addComponent((Component)this.consentPanel.consentOpt).addComponent((Component)this.consentPanel.bioExpBut).addComponent((Component)this.consentPanel.nextBut);
    }

    private void addTraversalUE() {
        ExplicitFocusTraversalPolicy eftp = new ExplicitFocusTraversalPolicy((Container)this.demoPanel).addComponent((Component)this.namePanel.fullNameField).addComponent((Component)this.namePanel.locFullNameField).addComponent((Component)this.aadhaarNoPanel.aadhaarNoField).addComponent((Component)this.nprPanel.nprField).addComponent((Component)this.namePanel.nameCorrOpt).addComponent((Component)this.namePanel.newNameField).addComponent((Component)this.namePanel.locNewNameField).addComponent((Component)this.updateTypeSelectionPanel.childUpdateOption).addComponent((Component)this.updateTypeSelectionPanel.bioUpdateOption).addComponent((Component)this.updateTypeSelectionPanel.mandatoryBioUpdateOption).addComponent((Component)this.genderPanel.genderEditOpt).addComponent(this.genderPanel.genderField).addComponent(this.confirmGenderPanel.genderField).addComponent((Component)this.ageDobPanel.adobEditOpt).addComponent((Component)this.confirmDOBPanel.cdobEditOpt);
        this.ageDobPanel.addToFocusTraversalPolicy(eftp);
        this.confirmDOBPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent((Component)this.contactHeaderPanel.contactEditBut).addComponent((Component)this.careOfPanel.careOfField).addComponent((Component)this.careOfPanel.locCareOfField);
        this.addressPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent((Component)this.mobilePanel.mobileEditOpt).addComponent(MobilePanel.isdCodeComboBox).addComponent((Component)MobilePanel.mobileField).addComponent((Component)this.emailPanel.emailEditOpt).addComponent((Component)this.emailPanel.emailField).addComponent((Component)this.consentPanel.consentOpt).addComponent((Component)this.consentPanel.bioExpBut).addComponent((Component)this.consentPanel.nextBut);
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public void renderDemographicsTab() {
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.DEMO, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createDemographicsLabel());
    }

    private JLabel createDemographicsLabel() {
        Demographics demographics = this.enrollmentService.getDemographics();
        PersonalDetail personalDetail = demographics.getPersonalDetail();
        Contact contact = demographics.getContact();
        String ICON_PATH = personalDetail.isValid() && contact.isValid() ? "res/images/tab-ok.png" : "res/images/tab-error.png";
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH);
        JLabel label = new JLabel(this.enrolRbctx.getMessage((Object)LabelKeysTab.DEMO, new Object[0]));
        new L10nDecorator(this.enrolRbctx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.DEMO, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }
}

