/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.AutoSuggestDecorator;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class EmailPanel
implements IViewElementComposite {
    private final IResourceBundleContext rbCtxt;
    protected JTextField emailField;
    protected JCheckBox emailEditOpt;
    private final EnrollmentService enrollmentService;

    public EmailPanel(IResourceBundleContext rbc, EnrollmentService enrollmentService) {
        this.rbCtxt = rbc;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create(boolean isUpdateEnrollment) {
        this.emailField = new JTextField();
        if (isUpdateEnrollment) {
            this.emailEditOpt = ViewUtils.createEditLabel(LabelKeysDemoTab.EMAIL.toString(), 2, this.rbCtxt);
            this.emailField.setEnabled(false);
        }
        if (this.enrollmentService.isDemoUpdate()) {
            Font font = this.emailField.getFont();
            this.emailField.setFont(new Font(font.getName(), 0, 14));
        }
        InlineValidations ilv = new InlineValidations(this.rbCtxt);
        new AutoSuggestDecorator(this.emailField).name("email").delimiters("@");
        ilv.applyEmailILV(this.emailField);
        this.emailField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.emailField));
        if (this.enrollmentService.isDemoUpdate() && this.enrollmentService.getDemographics().getContact().getEmail().getEmailForDisplay().isEmpty()) {
            return new PanelBuilder().createPanel("", this.emailField, this.rbCtxt);
        }
        if (this.enrollmentService.isDemoUpdate()) {
            return new PanelBuilder().createPanel(LabelKeysDemoTab.EMAIL.toString(), this.emailField, this.rbCtxt);
        }
        if (!isUpdateEnrollment) {
            return new PanelBuilder().createPanel(LabelKeysDemoTab.EMAIL.toString(), this.emailField, false, this.rbCtxt);
        }
        return new PanelBuilder().createPanel(this.emailEditOpt, this.emailField);
    }
}

