/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.service.isd.ISD;
import in.gov.uidai.ec.ui.enrol.IEnrolConstants;
import in.gov.uidai.swing.border.DashedBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ISDCodeListRenderer
extends DefaultListCellRenderer
implements IEnrolConstants {
    private final JComboBox<ISD> combo;
    private final JLabel tip;
    private final FontMetrics fm;
    private int lastIndex;
    private Popup popup;
    private boolean shouldPaint;

    public ISDCodeListRenderer(JComboBox<ISD> combo, int defaultSelectIndex) {
        this.combo = combo;
        this.tip = new JLabel();
        this.tip.setBackground(Color.decode("#f5f5b5"));
        this.tip.setOpaque(true);
        this.tip.setBorder((Border)new DashedBorder().dashInterval("1.2, 1.2").lineColor("#baba45").lineThickness(1.0f));
        this.lastIndex = defaultSelectIndex;
        this.fm = this.getFontMetrics(this.getFont());
        PopupMenuListener pml = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                ISDCodeListRenderer.this.hideToolTip();
                ISDCodeListRenderer.this.setSelected(false, ISDCodeListRenderer.this.lastIndex);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ISDCodeListRenderer.this.hideToolTip();
                ISDCodeListRenderer.this.combo.setSelectedIndex(ISDCodeListRenderer.this.lastIndex);
                ISDCodeListRenderer.this.setSelected(true, ISDCodeListRenderer.this.lastIndex);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                ISDCodeListRenderer.this.hideToolTip();
                ISDCodeListRenderer.this.setSelected(false, ISDCodeListRenderer.this.lastIndex);
            }
        };
        combo.addPopupMenuListener(pml);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.shouldPaint = true;
        if (isSelected && value != null && index != this.lastIndex) {
            this.hideToolTip();
            int width = this.fm.stringWidth(value.toString());
            if (width > list.getVisibleRect().width) {
                this.showTooltip(value, index, list);
            }
            this.setSelected(false, index);
            this.lastIndex = index;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    @Override
    public void paint(Graphics g) {
        if (this.shouldPaint) {
            super.paint(g);
        }
    }

    private void hideToolTip() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void setSelected(boolean selected, int index) {
        ISD selectedItem = this.combo.getItemAt(index);
        if (selectedItem != null) {
            selectedItem.setSelected(selected);
        }
    }

    private void showTooltip(Object value, int index, JList list) {
        this.tip.setText(value.toString());
        Rectangle rect = list.getCellBounds(index, index);
        Point pt = list.getLocationOnScreen();
        this.popup = PopupFactory.getSharedInstance().getPopup(list, this.tip, pt.x + rect.x, pt.y + rect.y);
        this.popup.show();
        this.shouldPaint = false;
    }
}

