/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.isd.ISD;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.demographics.ISDCodeListRenderer;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class MobilePanel
implements IViewElementComposite {
    private final IResourceBundleContext rbc;
    private final EnrollmentService enrollmentService;
    @ExportViewElement(as="resMobile", using=StandardSwingElementFactory.class)
    public static JTextField mobileField;
    @ExportViewElement(as="check_sid", using=StandardSwingElementFactory.class)
    public static JComboBox<ISD> isdCodeComboBox;
    JCheckBox mobileEditOpt;
    @ExportViewElement(as="eID_Otp", using=StandardSwingElementFactory.class)
    public static JTextField otpField;
    public static JButton verifyOtp;
    TransparentBox mobileArea;
    @ExportViewElement(as="residentMobileVerifyButton", using=StandardSwingElementFactory.class)
    public static JButton verifyMobileBtn;

    MobilePanel(IResourceBundleContext rbc, EnrollmentService enrollmentService) {
        this.rbc = rbc;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create(boolean isUpdateEnrollment) {
        mobileField = new JTextField();
        isdCodeComboBox = new JComboBox();
        if (isUpdateEnrollment || this.enrollmentService.isNewEnrollmentUC()) {
            Font font = mobileField.getFont();
            mobileField.setFont(new Font(font.getName(), 0, 14));
            this.mobileEditOpt = ViewUtils.createEditLabel(LabelKeysDemoTab.ISDMOBILE.toString(), 2, this.rbc);
            isdCodeComboBox.setEnabled(false);
            mobileField.setEnabled(false);
        }
        if (this.enrollmentService.isDemoUpdate()) {
            isdCodeComboBox.setEnabled(false);
        }
        InlineValidations ilv = new InlineValidations(this.rbc);
        isdCodeComboBox.setRenderer(new ISDCodeListRenderer(isdCodeComboBox, this.enrollmentService.getIsdService().getDefaultSelectIndex()));
        isdCodeComboBox.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.enrollmentService.getIsdService().getISDCodes().forEach(isdCode -> isdCodeComboBox.addItem((ISD)isdCode));
        isdCodeComboBox.setSelectedItem(this.enrollmentService.getIsdService().getDefaultSelect());
        ilv.applyMobileILV(mobileField, isdCodeComboBox);
        mobileField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)mobileField));
        if (this.enrollmentService.isNewEnrollmentUC()) {
            otpField = new JTextField();
            Font font = otpField.getFont();
            otpField.setDocument((Document)new FBNumericDocument((JTextComponent)otpField, 6));
            otpField.setFont(new Font(font.getName(), 0, 14));
            otpField.setEnabled(false);
            verifyOtp = new JButton("Verify");
            verifyOtp.setEnabled(false);
        }
        if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.getDemographics().getContact().getMobile().number().isEmpty()) {
            mobileField.setVisible(false);
            isdCodeComboBox.setVisible(false);
            otpField.setVisible(false);
            verifyOtp.setVisible(false);
        }
        double[][] formGuides = new double[][]{{155.0, 5.0, 155.0}, {22.0}};
        TransparentBox isdMobilePanel = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuides));
        isdMobilePanel.add(isdCodeComboBox, (Object)"0, 0, full, full");
        isdMobilePanel.add((Component)mobileField, (Object)"2, 0, full, full");
        if (this.enrollmentService.isDemoUpdate() && !this.enrollmentService.isNewEnrollmentUC()) {
            verifyMobileBtn = new JButton("Verify");
            double[][] formGuidesOnlineUpdate = new double[][]{{128.0, 4.0, 128.0, 4.0, 51.0}, {22.0}};
            isdMobilePanel = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuidesOnlineUpdate));
            isdMobilePanel.add(isdCodeComboBox, (Object)"0, 0, full, full");
            isdMobilePanel.add((Component)mobileField, (Object)"2, 0, full, full");
            isdMobilePanel.add((Component)verifyMobileBtn, (Object)"4, 0, full, full");
        } else if (this.enrollmentService.isNewEnrollmentUC()) {
            double[][] formGuidesOnlineUpdate = new double[][]{{100.0, 4.0, 120.0, 4.0, 90.0}, {22.0}};
            isdMobilePanel = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuidesOnlineUpdate));
            isdMobilePanel.add(isdCodeComboBox, (Object)"0, 0, right, full");
            isdMobilePanel.add((Component)mobileField, (Object)"2, 0, full, full");
            this.mobileArea = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuidesOnlineUpdate));
            this.mobileArea.add((Component)otpField, (Object)"0, 0, full, full");
            this.mobileArea.add((Component)verifyOtp, (Object)"2, 0, full, full");
        }
        if (this.enrollmentService.isNewEnrollmentUC() && this.enrollmentService.getDemographics().getContact().getMobile().number().isEmpty()) {
            return new PanelBuilder().createPanel("", (JComponent)isdMobilePanel, null, null, this.rbc);
        }
        if (this.enrollmentService.isDemoUpdate()) {
            return new PanelBuilder().createPanel(LabelKeysDemoTab.ISDMOBILE.toString(), (JComponent)isdMobilePanel, null, null, this.rbc);
        }
        if (!isUpdateEnrollment) {
            return new PanelBuilder().createPanel(LabelKeysDemoTab.ISDMOBILE.toString(), (JComponent)isdMobilePanel, false, this.rbc);
        }
        return new PanelBuilder().createPanel(this.mobileEditOpt, (JComponent)isdMobilePanel);
    }
}

